/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.discord;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInjectConfigurationSection;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import java.awt.Color;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class DiscordHandler {
    private final VotingPluginMain plugin;
    private final HashMap<TopVoter, Long> topVoterMessageIds = new HashMap();
    private final AtomicBoolean discordReady = new AtomicBoolean(false);

    public DiscordHandler(VotingPluginMain plugin) {
        this.plugin = plugin;
        for (TopVoter top : TopVoter.values()) {
            long savedId = plugin.getServerData().getTopVoterMessageId(top);
            this.topVoterMessageIds.put(top, savedId);
        }
    }

    public void load() {
        DiscordSRV.api.subscribe((Object)this);
        this.plugin.getLogger().info("DiscordHandler loaded; awaiting Discord readiness.");
        if (DiscordUtil.getJda().getStatus() == JDA.Status.CONNECTED) {
            this.discordReady.set(true);
            this.plugin.getLogger().info("DiscordSRV was already ready; manual update now available.");
        }
        this.plugin.getRewardHandler().addInjectedReward(new RewardInjectConfigurationSection("DiscordSRV"){

            @Override
            public String onRewardRequested(Reward arg0, AdvancedCoreUser user, ConfigurationSection section, HashMap<String, String> placeholders) {
                if (section.getBoolean("Enabled")) {
                    String msg = PlaceholderUtils.replacePlaceHolder(section.getString("Message", "Please set a message"), placeholders);
                    msg = PlaceholderUtils.replacePlaceHolders(user.getOfflinePlayer(), msg);
                    DiscordHandler.this.sendRewardMessage(msg, section.getString("ChannelID", "0"));
                }
                return null;
            }
        });
    }

    @Subscribe
    public void onDiscordReady(DiscordReadyEvent event) {
        this.discordReady.set(true);
        this.plugin.getLogger().info("DiscordSRV is ready; manual update now available.");
    }

    public void updateDiscordLeaderboard() {
        if (!this.discordReady.get()) {
            this.plugin.getLogger().warning("DiscordSRV not ready yet; cannot update Top Voters.");
            return;
        }
        for (TopVoter top : TopVoter.values()) {
            if (!this.plugin.getConfigFile().isDiscordSRVTopVoterEnabled(top)) continue;
            this.plugin.debug("Updating Discord Top Voter: " + top.toString());
            this.updateTopVoterMessageId(top);
        }
    }

    public void updateTopVoterMessageId(TopVoter top) {
        TextChannel channel;
        long channelId = this.plugin.getConfigFile().getDiscordSRVTopVoterChannel(top);
        LinkedHashMap<TopVoterPlayer, Integer> topVoters = this.plugin.getTopVoter(top);
        String title = this.plugin.getConfigFile().getDiscordSRVTopVoterTitle(top);
        String rankDisplay = this.plugin.getConfigFile().getDiscordSRVTopVoterRankDisplay(top);
        EmbedBuilder eb = new EmbedBuilder().setTitle(title).setColor(Color.CYAN).setTimestamp((TemporalAccessor)Instant.now());
        int rank = 1;
        for (Map.Entry<TopVoterPlayer, Integer> entry : topVoters.entrySet()) {
            if (rank > 10) break;
            String line = rankDisplay.replace("%rank%", String.valueOf(rank)).replace("%player%", entry.getKey().getPlayerName()).replace("%votes%", String.valueOf(entry.getValue()));
            eb.addField("", line, false);
            ++rank;
        }
        if ((channel = DiscordUtil.getJda().getTextChannelById(channelId)) == null) {
            this.plugin.getLogger().warning("Discord channel ID " + channelId + " not found: " + top.toString());
            return;
        }
        if (this.topVoterMessageIds.get((Object)top) <= 0L) {
            channel.sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue(msg -> {
                long newId = msg.getIdLong();
                this.topVoterMessageIds.put(top, newId);
                this.plugin.getServerData().setTopVoterMessageId(top, newId);
                this.plugin.getLogger().info("Posted new Top Voters  " + top.toString() + " (ID: " + newId + ")");
            }, err -> this.plugin.getLogger().warning("Error sending Top Voters " + top.toString() + ": " + err.getMessage()));
        } else {
            channel.editMessageEmbedsById(this.topVoterMessageIds.get((Object)top).longValue(), new MessageEmbed[]{eb.build()}).queue(m -> this.plugin.getLogger().info("Edited Top Voters " + top.toString() + " (ID: " + this.topVoterMessageIds.get((Object)top) + ")"), err -> this.plugin.getLogger().warning("Error editing Top Voters" + top.toString() + ": " + err.getMessage()));
        }
    }

    public void sendRewardMessage(String message, String channelId) {
        TextChannel channel = DiscordUtil.getJda().getTextChannelById(channelId);
        if (channel != null) {
            channel.sendMessage((CharSequence)message).queue();
        } else {
            this.plugin.getLogger().warning("Discord channel ID " + channelId + " not found for reward message.");
        }
    }

    @Generated
    public HashMap<TopVoter, Long> getTopVoterMessageIds() {
        return this.topVoterMessageIds;
    }
}

