/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.data;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.signs.SignHandler;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.timequeue.VoteTimeQueue;
import com.bencodez.votingplugin.topvoter.TopVoter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class ServerData {
    private VotingPluginMain plugin = VotingPluginMain.plugin;

    public ServerData(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void addAutoCachedPlaceholder(String placeholder) {
        List<String> p = this.getAutoCachedPlaceholder();
        if (!ArrayUtils.containsIgnoreCase(p, placeholder)) {
            p.add(placeholder);
            this.setAutoCachedPlaceholder(p);
        }
    }

    public synchronized void addServiceSite(String site) {
        ArrayList<String> l = this.getServiceSites();
        if (!this.getServiceSites().contains(site)) {
            l.add(site);
        }
        this.setServiceSites(ArrayUtils.removeDuplicates(l));
    }

    public void addSign(Location location, String data, int position) {
        int count = this.nextSignNumber();
        this.getData().set("Signs." + count + ".World", (Object)location.getWorld().getName());
        this.getData().set("Signs." + count + ".X", (Object)location.getBlockX());
        this.getData().set("Signs." + count + ".Y", (Object)location.getBlockY());
        this.getData().set("Signs." + count + ".Z", (Object)location.getBlockZ());
        this.getData().set("Signs." + count + ".Data", (Object)data);
        this.getData().set("Signs." + count + ".Position", (Object)position);
        this.saveData();
        this.plugin.getSigns().getSigns().add(new SignHandler(this.plugin, "" + count, this.getSignLocation("" + count), this.getSignSkullLocation("" + count), this.getSignData("" + count), this.getSignPosition("" + count)));
    }

    public void addTimeVoted(int num, VoteTimeQueue vote) {
        this.getData().set("TimedVoteCache." + num + ".Name", (Object)vote.getName());
        this.getData().set("TimedVoteCache." + num + ".Service", (Object)vote.getService());
        this.getData().set("TimedVoteCache." + num + ".Time", (Object)vote.getTime());
        this.saveData();
    }

    public void addVoteShopPurchase(String ident) {
        this.setVoteShopPurchases(ident, this.getVoteShopPurchases(ident) + 1);
    }

    public void clearTimedVoteCache() {
        this.getData().set("TimedVoteCache", null);
        this.saveData();
    }

    public List<String> getAutoCachedPlaceholder() {
        return this.getData().getStringList("AutoCachePlaceholders");
    }

    public int getBungeeVotePartyCurrent() {
        return this.getData().getInt("BungeeVotePartyCurrent");
    }

    public int getBungeeVotePartyRequired() {
        return this.getData().getInt("BungeeVotePartyRequired");
    }

    public ConfigurationSection getData() {
        ConfigurationSection data = this.plugin.getServerDataFile().getData().getConfigurationSection("VotingPlugin");
        if (data == null) {
            this.plugin.getServerDataFile().getData().createSection("VotingPlugin");
            data = this.plugin.getServerDataFile().getData().getConfigurationSection("VotingPlugin");
        }
        return data;
    }

    public List<String> getDisabledReminders() {
        return this.getData().getStringList("DisabledReminders");
    }

    public ArrayList<String> getServiceSites() {
        return (ArrayList)this.getData().getList("ServiceSites", new ArrayList());
    }

    public String getSignData(String sign) {
        return this.getData().getString("Signs." + sign + ".Data");
    }

    public Location getSignLocation(String sign) {
        return new Location(Bukkit.getWorld((String)this.getData().getString("Signs." + sign + ".World")), this.getData().getDouble("Signs." + sign + ".X"), this.getData().getDouble("Signs." + sign + ".Y"), this.getData().getDouble("Signs." + sign + ".Z"));
    }

    public int getSignPosition(String sign) {
        return this.getData().getInt("Signs." + sign + ".Position");
    }

    public Set<String> getSigns() {
        try {
            return this.getData().getConfigurationSection("Signs").getKeys(false);
        }
        catch (Exception ex) {
            return new HashSet<String>();
        }
    }

    public Location getSignSkullLocation(String sign) {
        if (this.getData().getString("Signs." + sign + ".Skull.World", "").isEmpty()) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)this.getData().getString("Signs." + sign + ".Skull.World")), this.getData().getDouble("Signs." + sign + ".Skull.X"), this.getData().getDouble("Signs." + sign + ".Skull.Y"), this.getData().getDouble("Signs." + sign + ".Skull.Z"));
    }

    public Set<String> getTimedVoteCacheKeys() {
        if (this.getData().isConfigurationSection("TimedVoteCache")) {
            return this.getData().getConfigurationSection("TimedVoteCache").getKeys(false);
        }
        return new HashSet<String>();
    }

    public ConfigurationSection getTimedVoteCacheSection(String num) {
        return this.getData().getConfigurationSection("TimedVoteCache." + num);
    }

    public int getVotePartyExtraRequired() {
        return this.getData().getInt("VotePartyExtraRequired", 0);
    }

    public int getVoteShopPurchases(String ident) {
        return this.getData().getInt("VoteShopPurchases." + ident);
    }

    public boolean isLastVotePartySameDay() {
        int num = this.getData().getInt("LastVoteParty", 0);
        return num == this.plugin.getTimeChecker().getTime().getDayOfYear();
    }

    public boolean isLastVotePartySameWeek() {
        int num = this.getData().getInt("LastVotePartyWeek", -1);
        return num == this.plugin.getTimeChecker().getTime().get(WeekFields.of(Locale.getDefault()).weekOfYear()) && num != -1;
    }

    public boolean isVoteShopConverted() {
        return this.getData().getBoolean("VoteShopConverted");
    }

    public int nextSignNumber() {
        Set<String> signs = this.getSigns();
        if (signs != null) {
            for (int i = 0; i < 100000; ++i) {
                if (signs.contains(Integer.toString(i))) continue;
                return i;
            }
        }
        return 0;
    }

    public void reloadData() {
        this.plugin.getServerDataFile().reloadData();
    }

    public long getTopVoterMessageId(TopVoter top) {
        return this.getData().getLong("DiscordSRV.TopVoterMessageId." + top.toString(), 0L);
    }

    public void setTopVoterMessageId(TopVoter top, long messageId) {
        this.getData().set("DiscordSRV.TopVoterMessageId." + top.toString(), (Object)messageId);
        this.saveData();
    }

    public void removeSign(String sign) {
        this.getData().set("Signs." + sign + ".World", null);
        this.getData().set("Signs." + sign + ".X", null);
        this.getData().set("Signs." + sign + ".Y", null);
        this.getData().set("Signs." + sign + ".Z", null);
        this.getData().set("Signs." + sign + ".Data", null);
        this.getData().set("Signs." + sign + ".Position", null);
        this.getData().set("Signs." + sign, null);
        this.getData().set("Signs." + sign + ".Skull.World", null);
        this.getData().set("Signs." + sign + ".Skull.X", null);
        this.getData().set("Signs." + sign + ".Skull.Y", null);
        this.getData().set("Signs." + sign + ".Skull.Z", null);
        this.saveData();
    }

    public synchronized void saveData() {
        this.plugin.getServerDataFile().saveData();
    }

    public void saveDisabledReminders(ArrayList<UUID> disabledReminders) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (UUID uuid : disabledReminders) {
            uuids.add(uuid.toString());
        }
        this.getData().set("DisabledReminders", uuids);
        this.saveData();
    }

    public void setAutoCachedPlaceholder(List<String> placeholders) {
        this.getData().set("AutoCachePlaceholders", placeholders);
        this.saveData();
    }

    public void setBungeeVotePartyCurrent(int current) {
        this.getData().set("BungeeVotePartyCurrent", (Object)current);
        this.saveData();
    }

    public void setBungeeVotePartyRequired(int required) {
        this.getData().set("BungeeVotePartyRequired", (Object)required);
        this.saveData();
    }

    public void setServiceSites(ArrayList<String> list) {
        this.getData().set("ServiceSites", list);
        this.saveData();
    }

    public void setShopConverted(boolean value) {
        this.getData().set("VoteShopConverted", (Object)value);
        this.saveData();
    }

    public void setSign(String count, Location location, Location skullLocation, String data, int position) {
        this.getData().set("Signs." + count + ".World", (Object)location.getWorld().getName());
        this.getData().set("Signs." + count + ".X", (Object)((int)location.getX()));
        this.getData().set("Signs." + count + ".Y", (Object)((int)location.getY()));
        this.getData().set("Signs." + count + ".Z", (Object)((int)location.getZ()));
        this.getData().set("Signs." + count + ".Data", (Object)data);
        this.getData().set("Signs." + count + ".Position", (Object)position);
        if (skullLocation != null) {
            this.getData().set("Signs." + count + ".Skull.World", (Object)skullLocation.getWorld().getName());
            this.getData().set("Signs." + count + ".Skull.X", (Object)((int)skullLocation.getX()));
            this.getData().set("Signs." + count + ".Skull.Y", (Object)((int)skullLocation.getY()));
            this.getData().set("Signs." + count + ".Skull.Z", (Object)((int)skullLocation.getZ()));
        }
        this.saveData();
    }

    public void setSkullLocation(String count, Location skullLocation) {
        if (skullLocation != null) {
            this.getData().set("Signs." + count + ".Skull.World", (Object)skullLocation.getWorld().getName());
            this.getData().set("Signs." + count + ".Skull.X", (Object)((int)skullLocation.getX()));
            this.getData().set("Signs." + count + ".Skull.Y", (Object)((int)skullLocation.getY()));
            this.getData().set("Signs." + count + ".Skull.Z", (Object)((int)skullLocation.getZ()));
        }
    }

    public void setVersion() {
        this.getData().set("Version", (Object)Bukkit.getVersion());
        this.saveData();
    }

    public void setVotePartyExtraRequired(int value) {
        this.getData().set("VotePartyExtraRequired", (Object)value);
        this.saveData();
    }

    public void setVoteShopPurchases(String ident, int amount) {
        this.getData().set("VoteShopPurchases." + ident, (Object)amount);
        this.saveData();
    }

    public void updateLastVoteParty() {
        this.getData().set("LastVoteParty", (Object)this.plugin.getTimeChecker().getTime().getDayOfYear());
        this.saveData();
    }

    public void updateLastVotePartyWeek() {
        this.getData().set("LastVotePartyWeek", (Object)this.plugin.getTimeChecker().getTime().get(WeekFields.of(Locale.getDefault()).weekOfYear()));
        this.saveData();
    }

    public void updatePlaceholders() {
        boolean data = this.getData().getBoolean("AutoCacheUpdated", false);
        if (!data) {
            List<String> placeholders = this.getAutoCachedPlaceholder();
            for (int i = 0; i < placeholders.size(); ++i) {
                placeholders.set(i, placeholders.get(i).toLowerCase());
            }
            this.setAutoCachedPlaceholder(placeholders);
            this.getData().set("AutoCacheUpdated", (Object)true);
            this.saveData();
        }
    }

    public void updateValues() {
        this.setVersion();
    }
}

