/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.cooldown;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserStartup;
import com.bencodez.votingplugin.events.PlayerVoteCoolDownEndEvent;
import com.bencodez.votingplugin.events.PlayerVoteSiteCoolDownEndEvent;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class CoolDownCheck
implements Listener {
    private VotingPluginMain plugin;
    private HashMap<UUID, ScheduledFuture<?>> perSiteTasks = new HashMap();
    private HashMap<UUID, ScheduledFuture<?>> allSiteTasks = new HashMap();
    private ScheduledExecutorService timer;
    private boolean cooldownCheckEnabled = false;

    public CoolDownCheck(VotingPluginMain plugin) {
        this.plugin = plugin;
        this.timer = Executors.newScheduledThreadPool(1);
    }

    public void check(UUID uuid) {
        VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid);
        if (!user.isOnline()) {
            user.dontCache();
        }
        this.check(user);
    }

    public synchronized void check(VotingPluginUser user) {
        boolean coolDownCheck = user.getCoolDownCheck();
        if (coolDownCheck) {
            if (user.canVoteAll()) {
                user.setCoolDownCheck(false);
                PlayerVoteCoolDownEndEvent event = new PlayerVoteCoolDownEndEvent(user);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                this.allSiteTasks.remove(user.getJavaUUID());
            } else {
                this.schedulePerSite(user, false);
            }
        }
    }

    public void checkAllVoteSite(VoteSite site) {
        this.plugin.getLogger().info("Checking vote cooldown rewards for all players: " + site.getKey());
        HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
        for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
            String uuid = playerData.getKey().toString();
            if (this.plugin == null || !this.plugin.isEnabled() || uuid == null || uuid.isEmpty()) continue;
            VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), false);
            user.dontCache();
            user.updateTempCacheWithColumns(playerData.getValue());
            cols.put(playerData.getKey(), null);
            this.checkPerSite(user);
            user.clearTempCache();
            user = null;
        }
        cols.clear();
        cols = null;
        this.plugin.getLogger().info("Finished checking vote cooldown rewards for all players: " + site.getKey());
    }

    public void checkEnabled() {
        this.cooldownCheckEnabled = !this.plugin.getConfigFile().isDisableCoolDownCheck() && this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), "VoteCoolDownEndedReward");
    }

    public void checkPerSite(UUID uuid) {
        VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid);
        if (!user.isOnline()) {
            user.dontCache();
        }
        this.checkPerSite(user);
    }

    public synchronized void checkPerSite(VotingPluginUser user) {
        if (this.plugin.getConfigFile().isPerSiteCoolDownEvents()) {
            HashMap<String, Boolean> coolDownChecks = user.getCoolDownCheckSiteList();
            boolean changed = false;
            for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
                if (coolDownChecks.containsKey(site.getKey()) && coolDownChecks.get(site.getKey()).booleanValue() || !user.canVoteSite(site)) continue;
                coolDownChecks.put(site.getKey(), Boolean.TRUE);
                changed = true;
                this.plugin.extraDebug("Triggering votesitecooldownend event for " + user.getUUID());
                PlayerVoteSiteCoolDownEndEvent event = new PlayerVoteSiteCoolDownEndEvent(user, site);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
            }
            if (changed) {
                user.setCoolDownCheckSite(coolDownChecks);
            }
            this.schedulePerSite(user, false);
        }
    }

    public void load() {
        this.plugin.addUserStartup(new UserStartup(){

            @Override
            public void onFinish() {
            }

            @Override
            public void onStart() {
            }

            @Override
            public void onStartUp(AdvancedCoreUser advancedcoreUser) {
                VotingPluginUser user = CoolDownCheck.this.plugin.getVotingPluginUserManager().getVotingPluginUser(advancedcoreUser);
                user.dontCache();
                if (CoolDownCheck.this.cooldownCheckEnabled) {
                    CoolDownCheck.this.check(user);
                }
                if (CoolDownCheck.this.plugin.getConfigFile().isPerSiteCoolDownEvents()) {
                    CoolDownCheck.this.checkPerSite(user);
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCoolDownEnd(PlayerVoteCoolDownEndEvent event) {
        this.plugin.getRewardHandler().giveReward(event.getPlayer(), (ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), "VoteCoolDownEndedReward", new RewardOptions());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCoolDownEnd(PlayerVoteSiteCoolDownEndEvent event) {
        this.plugin.getRewardHandler().giveReward(event.getPlayer(), event.getSite().getSiteData(), "CoolDownEndRewards", new RewardOptions().addPlaceholder("sitename", event.getSite().getDisplayName()).addPlaceholder("url", event.getSite().getVoteURL(false)));
    }

    public void schedule(VotingPluginUser user, boolean force) {
        if (user.getSitesVotedOn() > 0 || force) {
            final UUID uuid = UUID.fromString(user.getUUID());
            long time = user.getNextTimeAllSitesAvailable();
            if (this.allSiteTasks.containsKey(uuid)) {
                this.allSiteTasks.get(uuid).cancel(false);
                this.allSiteTasks.remove(uuid);
            }
            if (time > 0L) {
                user.setCoolDownCheck(true);
                ScheduledFuture<?> scheduledFuture = this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (CoolDownCheck.this.plugin != null && CoolDownCheck.this.plugin.isEnabled()) {
                            CoolDownCheck.this.check(uuid);
                        }
                    }
                }, time + 2L, TimeUnit.SECONDS);
                this.allSiteTasks.put(uuid, scheduledFuture);
            } else {
                this.plugin.extraDebug(user.getUUID() + "/" + user.getPlayerName() + " not scheduling cooldown check");
            }
        }
    }

    public void schedulePerSite(VotingPluginUser user, boolean force) {
        if (user.getSitesVotedOn() > 0 || force) {
            final UUID uuid = UUID.fromString(user.getUUID());
            long time = user.getNextTimeFirstSiteAvailable();
            if (this.perSiteTasks.containsKey(uuid)) {
                this.perSiteTasks.get(uuid).cancel(false);
                this.perSiteTasks.remove(uuid);
            }
            if (time > 0L) {
                this.plugin.devDebug("PerSiteCoolDownEvent schedule time: " + time + " seconds");
                ScheduledFuture<?> scheduledFuture = this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (CoolDownCheck.this.plugin != null && CoolDownCheck.this.plugin.isEnabled()) {
                            CoolDownCheck.this.checkPerSite(uuid);
                        }
                    }
                }, time + 2L, TimeUnit.SECONDS);
                this.perSiteTasks.put(uuid, scheduledFuture);
            } else {
                this.plugin.extraDebug(user.getUUID() + "/" + user.getPlayerName() + " not scheduling cooldown check");
            }
        }
    }

    public void vote(VotingPluginUser user, VoteSite site) {
        if (this.cooldownCheckEnabled) {
            this.schedule(user, true);
        }
        if (this.plugin.getConfigFile().isPerSiteCoolDownEvents()) {
            user.setCoolDownCheckSite(site, Boolean.FALSE);
            this.schedulePerSite(user, true);
        }
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }
}

