/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.config;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.simpleapi.file.YMLFile;
import com.bencodez.votingplugin.simpleapi.file.annotation.AnnotationHandler;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataBoolean;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataDouble;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataInt;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataKeys;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataListInt;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataListString;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataString;
import com.bencodez.votingplugin.topvoter.TopVoter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class SpecialRewardsConfig
extends YMLFile {
    private String allSitesRewardPath = "AllSites";
    private String almostAllSitesRewardPath = "AlmostAllSites";
    private String anySiteRewardsPath = "AnySiteRewards";
    @ConfigDataBoolean(path="EnableDailyRewards")
    private boolean enableDailyRewards = false;
    @ConfigDataBoolean(path="EnableMonthlyAwards")
    private boolean enableMonthlyAwards = true;
    @ConfigDataBoolean(path="EnableWeeklyAwards")
    private boolean enableWeeklyAwards = false;
    @ConfigDataBoolean(path="OnlyOneCumulative")
    private boolean onlyOneCumulative = false;
    private String firstVoteRewardsPath = "FirstVote";
    private String firstVoteTodayRewardsPath = "FirstVoteToday";
    private VotingPluginMain plugin;
    @ConfigDataBoolean(path="VoteParty.GiveOnlinePlayersOnly")
    private boolean votePartyGiveOnlinePlayersOnly = false;
    @ConfigDataBoolean(path="VoteParty.ResetCount")
    private boolean votePartyResetCount = true;
    @ConfigDataBoolean(path="VoteParty.ResetExtraVotesMonthly")
    private boolean votePartyResetExtraVotesMonthly = false;
    @ConfigDataBoolean(path="VoteParty.ResetExtraVotesWeekly")
    private boolean votePartyResetExtraVotesWeekly = false;
    @ConfigDataString(path="VoteParty.VoteReminderBroadcast")
    private String votePartyVoteReminderBroadcast = "%votesrequired% left to go, go vote!";
    @ConfigDataListInt(path="VoteParty.VoteReminderAtVotes")
    private ArrayList<Integer> votePartyVoteReminderAtVotes = new ArrayList();
    @ConfigDataListString(path="VoteParty.GlobalRandomCommand")
    private ArrayList<String> votePartyGlobalRandomCommand = new ArrayList();
    private String votePartyRewardsPath = "VoteParty.Rewards";
    @ConfigDataDouble(path="VoteStreak.Requirement.Day")
    private double voteStreakRequirementDay = 50.0;
    @ConfigDataDouble(path="VoteStreak.Requirement.Month")
    private double voteStreakRequirementMonth = 50.0;
    @ConfigDataBoolean(path="VoteStreak.Requirement.UsePercentage")
    private boolean voteStreakRequirementUsePercentage = false;
    @ConfigDataDouble(path="VoteStreak.Requirement.Week")
    private double voteStreakRequirementWeek = 50.0;
    @ConfigDataKeys(path="Cumulative")
    private Set<String> cumulativeVotes = new HashSet<String>();
    @ConfigDataKeys(path="DailyAwards")
    private Set<String> dailyPossibleRewardPlaces = new HashSet<String>();
    @ConfigDataKeys(path="MileStones")
    private Set<String> milestoneVotes = new HashSet<String>();
    @ConfigDataBoolean(path="ResetMilestonesMonthly")
    private boolean resetMilestonesMonthly = false;
    @ConfigDataString(path="VoteParty.Broadcast")
    private String votePartyBroadcast = "";
    @ConfigDataListString(path="VoteParty.GlobalCommands", secondPath="VoteParty.Commands")
    private ArrayList<String> votePartyGlobalCommands = new ArrayList();
    @ConfigDataBoolean(path="VoteParty.CountFakeVotes")
    private boolean votePartyCountFakeVotes = true;
    @ConfigDataBoolean(path="VoteParty.CountOfflineVotes")
    private boolean votePartyCountOfflineVotes = true;
    @ConfigDataBoolean(path="VoteParty.Enabled")
    private boolean votePartyEnabled = false;
    @ConfigDataBoolean(path="VoteParty.GiveAllPlayers")
    private boolean votePartyGiveAllPlayers = false;
    @Deprecated
    @ConfigDataInt(path="VoteParty.IncreaseVotesRquired")
    private int votePartyIncreaseVotesRquired = 0;
    @ConfigDataInt(path="VoteParty.IncreaseVotesRequired")
    private int votePartyIncreaseVotesRequired = 0;
    @ConfigDataBoolean(path="VoteParty.OnlyOncePerDay")
    private boolean votePartyOnlyOncePerDay = false;
    @ConfigDataBoolean(path="VoteParty.OnlyOncePerWeek")
    private boolean votePartyOnlyOncePerWeek = false;
    @ConfigDataBoolean(path="VoteParty.ResetEachDay")
    private boolean votePartyResetEachDay = false;
    @ConfigDataBoolean(path="VoteParty.ResetMonthly")
    private boolean votePartyResetMonthly = false;
    @ConfigDataBoolean(path="VoteParty.ResetWeekly")
    private boolean votePartyResetWeekly = false;
    @ConfigDataInt(path="VoteParty.UserVotesRequired")
    private int votePartyUserVotesRequired = 0;
    @ConfigDataInt(path="VoteParty.VotesRequired")
    private int votePartyVotesRequired = 0;
    @ConfigDataKeys(path="WeeklyAwards")
    private Set<String> weeklyPossibleRewardPlaces = new HashSet<String>();

    public SpecialRewardsConfig(VotingPluginMain plugin) {
        super(plugin, new File(plugin.getDataFolder(), "SpecialRewards.yml"));
        this.plugin = plugin;
    }

    public List<Integer> getCumulativeBlackList(int cumulative) {
        return this.getData().getIntegerList("Cumulative." + cumulative + ".BlackList");
    }

    public boolean getCumulativeRecurring(int cumulative) {
        return this.getData().getBoolean("Cumulative." + cumulative + ".Recurring", true);
    }

    public boolean getCumulativeRewardEnabled(int cumulative) {
        return this.getData().getBoolean("Cumulative." + cumulative + ".Enabled");
    }

    public String getCumulativeRewardsPath(int cumulative) {
        return "Cumulative." + cumulative + ".Rewards";
    }

    @Deprecated
    public boolean getCumulativeVotesInSameDay(int cumulative) {
        return this.getData().getBoolean("Cumulative." + cumulative + ".VotesInSameDay");
    }

    @Deprecated
    public boolean getCumulativeVotesInSameMonth(int cumulative) {
        return this.getData().getBoolean("Cumulative." + cumulative + ".VotesInSameMonth");
    }

    @Deprecated
    public boolean getCumulativeVotesInSameWeek(int cumulative) {
        return this.getData().getBoolean("Cumulative." + cumulative + ".VotesInSameWeek");
    }

    public String getCumulativeVotesTotal(int cumulative) {
        String str = this.getData().getString("Cumulative." + cumulative + ".TotalToUse", "");
        if (str.isEmpty()) {
            if (this.getCumulativeVotesInSameMonth(cumulative)) {
                return TopVoter.Monthly.toString();
            }
            if (this.getCumulativeVotesInSameWeek(cumulative)) {
                return TopVoter.Weekly.toString();
            }
            if (this.getCumulativeVotesInSameDay(cumulative)) {
                return TopVoter.Daily.toString();
            }
        }
        return str;
    }

    public String getDailyAwardRewardsPath(String path) {
        return "DailyAwards." + path + ".Rewards";
    }

    public boolean getMilestoneRewardEnabled(int milestones) {
        return this.getData().getBoolean("MileStones." + milestones + ".Enabled");
    }

    public String getMilestoneRewardsPath(int milestones) {
        return "MileStones." + milestones + ".Rewards";
    }

    public String getMonthlyAwardRewardsPath(String path) {
        return "MonthlyAwards." + path + ".Rewards";
    }

    public Set<String> getMonthlyPossibleRewardPlaces() {
        try {
            return this.getData().getConfigurationSection("MonthlyAwards").getKeys(false);
        }
        catch (Exception ex) {
            return new HashSet<String>();
        }
    }

    public int getVotePartyIncreaseVotesRequiredWithTypo() {
        int increase = this.getVotePartyIncreaseVotesRequired();
        if (increase > 0) {
            return increase;
        }
        return this.getVotePartyIncreaseVotesRquired();
    }

    public boolean getVoteStreakRewardEnabled(String type, String s) {
        return this.getData().getBoolean("VoteStreak." + type + "." + s + ".Enabled");
    }

    public String getVoteStreakRewardsPath(String type, String string) {
        return "VoteStreak." + type + "." + string + ".Rewards";
    }

    public Set<String> getVoteStreakVotes(String type) {
        try {
            Set set = this.getData().getConfigurationSection("VoteStreak." + type).getKeys(false);
            if (set != null) {
                return set;
            }
            return new HashSet<String>();
        }
        catch (Exception ex) {
            return new HashSet<String>();
        }
    }

    public String getWeeklyAwardRewardsPath(String path) {
        return "WeeklyAwards." + path + ".Rewards";
    }

    @Override
    public void loadValues() {
        new AnnotationHandler().load((ConfigurationSection)this.getData(), this);
    }

    @Override
    public void onFileCreation() {
        this.plugin.saveResource("SpecialRewards.yml", true);
    }

    public void removeCumulative(String votes) {
        this.getData().set("Cumulative." + votes, null);
        this.saveData();
    }

    public void removeMilestone(String votes) {
        this.getData().set("MileStones." + votes, null);
        this.saveData();
    }

    public void setCumulative(int intValue) {
        this.getData().set("Cumulative." + intValue + ".Enabled", (Object)true);
        this.getData().set("Cumulative." + intValue + ".TotalToUse", (Object)"AllTime");
        this.getData().set("Cumulative." + intValue + ".Rewards.Messages.Player", (Object)"&aYou got %cumulative% cumulative votes!");
        this.saveData();
    }

    public void setMilestone(int intValue) {
        this.getData().set("MileStones." + intValue + ".Enabled", (Object)true);
        this.getData().set("MileStones." + intValue + ".Rewards.Messages.Player", (Object)"&aYou got %milestone% milestone votes!");
        this.saveData();
    }

    @Generated
    public String getAllSitesRewardPath() {
        return this.allSitesRewardPath;
    }

    @Generated
    public String getAlmostAllSitesRewardPath() {
        return this.almostAllSitesRewardPath;
    }

    @Generated
    public String getAnySiteRewardsPath() {
        return this.anySiteRewardsPath;
    }

    @Generated
    public boolean isEnableDailyRewards() {
        return this.enableDailyRewards;
    }

    @Generated
    public boolean isEnableMonthlyAwards() {
        return this.enableMonthlyAwards;
    }

    @Generated
    public boolean isEnableWeeklyAwards() {
        return this.enableWeeklyAwards;
    }

    @Generated
    public boolean isOnlyOneCumulative() {
        return this.onlyOneCumulative;
    }

    @Generated
    public String getFirstVoteRewardsPath() {
        return this.firstVoteRewardsPath;
    }

    @Generated
    public String getFirstVoteTodayRewardsPath() {
        return this.firstVoteTodayRewardsPath;
    }

    @Generated
    public boolean isVotePartyGiveOnlinePlayersOnly() {
        return this.votePartyGiveOnlinePlayersOnly;
    }

    @Generated
    public boolean isVotePartyResetCount() {
        return this.votePartyResetCount;
    }

    @Generated
    public boolean isVotePartyResetExtraVotesMonthly() {
        return this.votePartyResetExtraVotesMonthly;
    }

    @Generated
    public boolean isVotePartyResetExtraVotesWeekly() {
        return this.votePartyResetExtraVotesWeekly;
    }

    @Generated
    public String getVotePartyVoteReminderBroadcast() {
        return this.votePartyVoteReminderBroadcast;
    }

    @Generated
    public ArrayList<Integer> getVotePartyVoteReminderAtVotes() {
        return this.votePartyVoteReminderAtVotes;
    }

    @Generated
    public ArrayList<String> getVotePartyGlobalRandomCommand() {
        return this.votePartyGlobalRandomCommand;
    }

    @Generated
    public String getVotePartyRewardsPath() {
        return this.votePartyRewardsPath;
    }

    @Generated
    public double getVoteStreakRequirementDay() {
        return this.voteStreakRequirementDay;
    }

    @Generated
    public double getVoteStreakRequirementMonth() {
        return this.voteStreakRequirementMonth;
    }

    @Generated
    public boolean isVoteStreakRequirementUsePercentage() {
        return this.voteStreakRequirementUsePercentage;
    }

    @Generated
    public double getVoteStreakRequirementWeek() {
        return this.voteStreakRequirementWeek;
    }

    @Generated
    public Set<String> getCumulativeVotes() {
        return this.cumulativeVotes;
    }

    @Generated
    public Set<String> getDailyPossibleRewardPlaces() {
        return this.dailyPossibleRewardPlaces;
    }

    @Generated
    public Set<String> getMilestoneVotes() {
        return this.milestoneVotes;
    }

    @Generated
    public boolean isResetMilestonesMonthly() {
        return this.resetMilestonesMonthly;
    }

    @Generated
    public String getVotePartyBroadcast() {
        return this.votePartyBroadcast;
    }

    @Generated
    public ArrayList<String> getVotePartyGlobalCommands() {
        return this.votePartyGlobalCommands;
    }

    @Generated
    public boolean isVotePartyCountFakeVotes() {
        return this.votePartyCountFakeVotes;
    }

    @Generated
    public boolean isVotePartyCountOfflineVotes() {
        return this.votePartyCountOfflineVotes;
    }

    @Generated
    public boolean isVotePartyEnabled() {
        return this.votePartyEnabled;
    }

    @Generated
    public boolean isVotePartyGiveAllPlayers() {
        return this.votePartyGiveAllPlayers;
    }

    @Deprecated
    @Generated
    public int getVotePartyIncreaseVotesRquired() {
        return this.votePartyIncreaseVotesRquired;
    }

    @Generated
    public int getVotePartyIncreaseVotesRequired() {
        return this.votePartyIncreaseVotesRequired;
    }

    @Generated
    public boolean isVotePartyOnlyOncePerDay() {
        return this.votePartyOnlyOncePerDay;
    }

    @Generated
    public boolean isVotePartyOnlyOncePerWeek() {
        return this.votePartyOnlyOncePerWeek;
    }

    @Generated
    public boolean isVotePartyResetEachDay() {
        return this.votePartyResetEachDay;
    }

    @Generated
    public boolean isVotePartyResetMonthly() {
        return this.votePartyResetMonthly;
    }

    @Generated
    public boolean isVotePartyResetWeekly() {
        return this.votePartyResetWeekly;
    }

    @Generated
    public int getVotePartyUserVotesRequired() {
        return this.votePartyUserVotesRequired;
    }

    @Generated
    public int getVotePartyVotesRequired() {
        return this.votePartyVotesRequired;
    }

    @Generated
    public Set<String> getWeeklyPossibleRewardPlaces() {
        return this.weeklyPossibleRewardPlaces;
    }
}

