/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.config;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.simpleapi.file.YMLFile;
import com.bencodez.votingplugin.simpleapi.file.annotation.AnnotationHandler;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataBoolean;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataConfigurationSection;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataKeys;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataString;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class ShopFile
extends YMLFile {
    @ConfigDataConfigurationSection(path="ShopConfirmPurchase.NoItem")
    private ConfigurationSection shopConfirmPurchaseNoItem;
    @ConfigDataString(path="ShopConfirmPurchase.Title")
    private String shopConfirmPurchaseTitle = "Confirm Purchase?";
    @ConfigDataConfigurationSection(path="ShopConfirmPurchase.YesItem")
    private ConfigurationSection shopConfirmPurchaseYesItem;
    @ConfigDataString(path="VoteShop.Disabled")
    private String voteShopDisabled = "&cVote shop disabled";
    @ConfigDataBoolean(path="VoteShop.HideLimitedReached")
    private boolean voteShopHideLimitedReached = true;
    @ConfigDataString(path="VoteShop.LimitReached")
    private String voteShopLimitReached = "&aYou reached your limit";
    @ConfigDataBoolean(path="VoteShop.RequireConfirmation")
    private boolean voteShopRequireConfirmation = false;
    private VotingPluginMain plugin;
    @ConfigDataBoolean(path="VoteShop.BackButton")
    private boolean voteShopBackButton = true;
    @ConfigDataBoolean(path="VoteShop.ReopenGUIOnPurchase")
    private boolean voteShopReopenGUIOnPurchase = true;
    @ConfigDataBoolean(path="VoteShop.Enabled")
    private boolean voteShopEnabled = true;
    @ConfigDataString(path="VoteShop.Name")
    private String voteShopName = "VoteShop";
    @ConfigDataKeys(path="ExtraItems")
    private Set<String> voteShopExtraItems = new HashSet<String>();

    public ShopFile(VotingPluginMain plugin) {
        super(plugin, new File(plugin.getDataFolder(), "Shop.yml"));
        this.plugin = plugin;
    }

    public void convertFromGUIFile() {
        this.setValue("VoteShop.Enabled", this.plugin.getGui().getData().getBoolean("CHEST.VoteShopEnabled"));
        this.setValue("VoteShop.BackButton", this.plugin.getGui().getData().getBoolean("CHEST.VoteShopBackButton"));
        this.setValue("VoteShop.HideLimitReached", this.plugin.getGui().getData().getBoolean("CHEST.VoteShopHideLimitedReached"));
        this.setValue("VoteShop.RequireConfirmation", this.plugin.getGui().getData().getBoolean("CHEST.VoteShopRequireConfirmation"));
        this.setValue("VoteShop.ReopenGUIOnPurchase", this.plugin.getGui().getData().getBoolean("CHEST.VoteShopReopenGUIOnPurchase"));
        this.setValue("VoteShop.Name", this.plugin.getGui().getData().getString("CHEST.VoteShopName"));
        this.setValue("VoteShop.LimitReached", this.plugin.getGui().getData().getString("CHEST.VoteShopLimitReached"));
        this.setValue("VoteShop.Disabled", this.plugin.getGui().getData().getString("CHEST.VoteShopDisabled"));
        this.setValue("Shop", this.plugin.getGui().getData().getConfigurationSection("CHEST.Shop"));
        this.setValue("ExtraItems", this.plugin.getGui().getData().getConfigurationSection("CHEST.VoteShopExtraItems"));
        this.setValue("ShopConfirmPurchase", this.plugin.getGui().getData().getConfigurationSection("CHEST.ShopConfirmPurchase"));
        this.saveData();
    }

    public void createShop(String value) {
        ConfigurationSection shopData = this.getData().createSection("Shop." + value);
        shopData.set("Identifier_Name", (Object)value);
        shopData.set("Material", (Object)"STONE");
        shopData.set("Amount", (Object)1);
        shopData.set("Name", (Object)"&cPlaceholder item");
        shopData.set("Cost", (Object)1);
        shopData.set("Permission", (Object)"");
        shopData.set("CloseGUI", (Object)true);
        shopData.set("RequireConfirmation", (Object)false);
        shopData.set("Rewards.Items.Item1.Material", (Object)"STONE");
        shopData.set("Rewards.Items.Item1.Amount", (Object)1);
        this.saveData();
    }

    public ConfigurationSection getGUIVoteShopExtraItems(String item) {
        return this.getData().getConfigurationSection("ExtraItems." + item);
    }

    public int getShopIdentifierCost(String identifier) {
        return this.getData().getInt("Shop." + identifier + ".Cost");
    }

    public String getShopIdentifierIdentifierName(String identifier) {
        return this.getData().getString("Shop." + identifier + ".Identifier_Name", identifier);
    }

    public int getShopIdentifierLimit(String identifier) {
        return this.getData().getInt("Shop." + identifier + ".Limit", -1);
    }

    public String getShopIdentifierRewardsPath(String identifier) {
        return "Shop." + identifier + ".Rewards";
    }

    public Set<String> getShopIdentifiers() {
        ConfigurationSection shop = this.getData().getConfigurationSection("Shop");
        if (shop != null) {
            return shop.getKeys(false);
        }
        return new HashSet<String>();
    }

    public ConfigurationSection getShopIdentifierSection(String identifier) {
        return this.getData().getConfigurationSection("Shop." + identifier);
    }

    public boolean getVoteShopCloseGUI(String shop) {
        return this.getData().getBoolean("Shop." + shop + ".CloseGUI", true);
    }

    public boolean getVoteShopHideOnNoPermission(String shop) {
        return this.getData().getBoolean("Shop." + shop + ".HideOnNoPermission", true);
    }

    public boolean getVoteShopNotBuyable(String shop) {
        return this.getData().getBoolean("Shop." + shop + ".NotBuyable", false);
    }

    public String getVoteShopPermission(String ident) {
        return this.getData().getString("Shop." + ident + ".Permission", "");
    }

    public String getVoteShopPurchase(String identifier) {
        return this.getData().getString("Shop." + identifier + ".PurchaseMessage", this.plugin.getConfigFile().getFormatShopPurchaseMsg());
    }

    public boolean getVoteShopResetDaily(String shop) {
        return this.getData().getBoolean("Shop." + shop + ".Reset.Daily", false);
    }

    public boolean getVoteShopResetMonthly(String shop) {
        return this.getData().getBoolean("Shop." + shop + ".Reset.Monthly", false);
    }

    public boolean getVoteShopResetWeekly(String shop) {
        return this.getData().getBoolean("Shop." + shop + ".Reset.Weekly", false);
    }

    public boolean isVoteShopRequireConfirmation(String identifier) {
        return this.getData().getBoolean("Shop." + identifier + ".RequireConfirmation", this.isVoteShopRequireConfirmation());
    }

    @Override
    public void loadValues() {
        new AnnotationHandler().load((ConfigurationSection)this.getData(), this);
    }

    @Override
    public void onFileCreation() {
        this.plugin.saveResource("Shop.yml", true);
    }

    public void removeShop(String value) {
        this.getData().set("Shop." + value, null);
        this.saveData();
    }

    @Generated
    public ConfigurationSection getShopConfirmPurchaseNoItem() {
        return this.shopConfirmPurchaseNoItem;
    }

    @Generated
    public String getShopConfirmPurchaseTitle() {
        return this.shopConfirmPurchaseTitle;
    }

    @Generated
    public ConfigurationSection getShopConfirmPurchaseYesItem() {
        return this.shopConfirmPurchaseYesItem;
    }

    @Generated
    public String getVoteShopDisabled() {
        return this.voteShopDisabled;
    }

    @Generated
    public boolean isVoteShopHideLimitedReached() {
        return this.voteShopHideLimitedReached;
    }

    @Generated
    public String getVoteShopLimitReached() {
        return this.voteShopLimitReached;
    }

    @Generated
    public boolean isVoteShopRequireConfirmation() {
        return this.voteShopRequireConfirmation;
    }

    @Generated
    public boolean isVoteShopBackButton() {
        return this.voteShopBackButton;
    }

    @Generated
    public boolean isVoteShopReopenGUIOnPurchase() {
        return this.voteShopReopenGUIOnPurchase;
    }

    @Generated
    public boolean isVoteShopEnabled() {
        return this.voteShopEnabled;
    }

    @Generated
    public String getVoteShopName() {
        return this.voteShopName;
    }

    @Generated
    public Set<String> getVoteShopExtraItems() {
        return this.voteShopExtraItems;
    }
}

