/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.config;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.rewards.DirectlyDefinedReward;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.file.YMLFile;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ConfigVoteSites
extends YMLFile {
    private VotingPluginMain plugin;

    public ConfigVoteSites(VotingPluginMain plugin) {
        super(plugin, new File(plugin.getDataFolder(), "VoteSites.yml"));
        this.plugin = plugin;
    }

    public void generateVoteSite(String siteName) {
        if (this.plugin.getConfigFile().isAutoCreateVoteSites()) {
            String org = siteName;
            siteName = siteName.replace(".", "_").replace(" ", "_");
            this.plugin.getLogger().warning("VoteSite " + siteName + " does not exist with the servicesite '" + org + "', creating one, set AutoCreateVoteSites to false to prevent this");
            this.setEnabled(siteName, true);
            this.setServiceSite(siteName, org);
            this.setVoteURL(siteName, "VoteURL");
            this.setVoteDelay(siteName, 24.0);
            this.set(siteName, "DisplayItem.Material", "STONE");
            this.set(siteName, "DisplayItem.Amount", 1);
            this.set(siteName, "Rewards.Messages.Player", "&aThanks for voting on %ServiceSite%!");
            this.plugin.loadVoteSites();
            this.plugin.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteSites." + siteName + ".Rewards"){

                @Override
                public void createSection(String key) {
                    ConfigVoteSites.this.plugin.getConfigVoteSites().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return ConfigVoteSites.this.plugin.getConfigVoteSites().getData();
                }

                @Override
                public void save() {
                    ConfigVoteSites.this.plugin.getConfigVoteSites().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    ConfigVoteSites.this.plugin.getConfigVoteSites().setValue(path, value);
                }
            });
            this.plugin.addDirectlyDefinedRewards(new DirectlyDefinedReward("VoteSites." + siteName + ".CoolDownEndRewards"){

                @Override
                public void createSection(String key) {
                    ConfigVoteSites.this.plugin.getConfigVoteSites().createSection(key);
                }

                @Override
                public ConfigurationSection getFileData() {
                    return ConfigVoteSites.this.plugin.getConfigVoteSites().getData();
                }

                @Override
                public void save() {
                    ConfigVoteSites.this.plugin.getConfigVoteSites().saveData();
                }

                @Override
                public void setData(String path, Object value) {
                    ConfigVoteSites.this.plugin.getConfigVoteSites().setValue(path, value);
                }
            });
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.hasPermission("VotingPlugin.Admin.GenerateServiceSite") && !p.isOp()) continue;
                p.sendMessage(MessageAPI.colorize("&cGenerating votesite for service site " + siteName + ", please check console for details"));
            }
        }
    }

    public ConfigurationSection getData(String siteName) {
        if (!this.getData().isConfigurationSection("VoteSites." + siteName)) {
            this.plugin.getLogger().warning("VoteSites." + siteName + " is not a configuration section");
        }
        return this.getData().getConfigurationSection("VoteSites." + siteName);
    }

    public String getDisplayName(String site) {
        return this.getData(site).getString("Name");
    }

    public String getEverySiteRewardPath() {
        return "EverySiteReward";
    }

    public ConfigurationSection getItem(String site) {
        if (this.getData(site).isConfigurationSection("DisplayItem")) {
            return this.getData(site).getConfigurationSection("DisplayItem");
        }
        return this.getData(site).getConfigurationSection("Item");
    }

    public String getPermissionToView(String siteName) {
        return this.getData(siteName).getString("PermissionToView", "");
    }

    public int getPriority(String siteName) {
        return this.getData(siteName).getInt("Priority");
    }

    public String getRewardsPath(String siteName) {
        return "VoteSites." + siteName + ".Rewards";
    }

    public String getServiceSite(String siteName) {
        return this.getData(siteName).getString("ServiceSite");
    }

    public double getVoteDelay(String siteName) {
        return this.getData(siteName).getDouble("VoteDelay", 24.0);
    }

    public int getVoteDelayDailyHour(String siteName) {
        return this.getData(siteName).getInt("VoteDelayDailyHour", 0);
    }

    public double getVoteDelayMin(String siteName) {
        return this.getData(siteName).getDouble("VoteDelayMin", 0.0);
    }

    public boolean getVoteSiteEnabled(String siteName) {
        return this.getData(siteName).getBoolean("Enabled");
    }

    public File getVoteSiteFile(String siteName) {
        File dFile = new File(this.plugin.getDataFolder() + File.separator + "VoteSites", siteName + ".yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dFile);
        if (!dFile.exists()) {
            try {
                data.save(dFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe(ChatColor.RED + "Could not create VoteSites/" + siteName + ".yml!");
            }
        }
        return dFile;
    }

    public boolean getVoteSiteGiveOffline(String site) {
        return this.getData(site).getBoolean("ForceOffline", this.getData(site).getBoolean("GiveOffline"));
    }

    public boolean getVoteSiteHidden(String siteName) {
        return this.getData(siteName).getBoolean("Hidden");
    }

    public boolean getVoteSiteIgnoreCanVote(String siteName) {
        return this.getData(siteName).getBoolean("IgnoreCanVote");
    }

    public boolean getVoteSiteResetVoteDelayDaily(String siteName) {
        return this.getData(siteName).getBoolean("VoteDelayDaily");
    }

    public ArrayList<VoteSite> getVoteSitesLoad() {
        ArrayList<VoteSite> voteSites = new ArrayList<VoteSite>();
        ArrayList<String> voteSiteNames = this.getVoteSitesNames(true);
        if (voteSiteNames != null) {
            for (String site : voteSiteNames) {
                if (!this.getVoteSiteEnabled(site) || site.equalsIgnoreCase("null")) continue;
                if (!this.siteCheck(site)) {
                    this.plugin.getLogger().warning("Failed to load site " + site + ", see above");
                    continue;
                }
                VoteSite voteSite = new VoteSite(this.plugin, site);
                this.plugin.debug(voteSite.loadingDebug());
                voteSites.add(voteSite);
            }
        }
        Collections.sort(voteSites, new Comparator<VoteSite>(){

            @Override
            public int compare(VoteSite v1, VoteSite v2) {
                int v2P;
                int v1P = v1.getPriority();
                if (v1P < (v2P = v2.getPriority())) {
                    return 1;
                }
                if (v1P > v2P) {
                    return -1;
                }
                return 0;
            }
        });
        return voteSites;
    }

    public ArrayList<String> getVoteSitesNames(boolean checkEnabled) {
        ArrayList<String> siteNames = new ArrayList();
        if (this.getData().isConfigurationSection("VoteSites")) {
            siteNames = ArrayUtils.convert(this.getData().getConfigurationSection("VoteSites").getKeys(false));
        }
        for (int i = siteNames.size() - 1; i >= 0; --i) {
            if (!this.getData().isConfigurationSection("VoteSites." + siteNames.get(i))) {
                this.plugin.getLogger().warning("VoteSites." + siteNames.get(i) + " is not a configuration section, please remove");
                siteNames.remove(i);
                continue;
            }
            if (!siteNames.get(i).equalsIgnoreCase("null") && (this.getVoteSiteEnabled(siteNames.get(i)) || !checkEnabled) && this.siteCheck(siteNames.get(i))) continue;
            siteNames.remove(i);
        }
        return siteNames;
    }

    public String getVoteURL(String siteName) {
        return this.getData(siteName).getString("VoteURL", "");
    }

    public boolean getWaitUntilVoteDelay(String siteName) {
        return this.getData(siteName).getBoolean("WaitUntilVoteDelay", false);
    }

    public boolean isServiceSiteGood(String siteName) {
        return this.getServiceSite(siteName) != null && !this.getServiceSite(siteName).equals("");
    }

    public boolean isVoteURLGood(String siteName) {
        return this.getVoteURL(siteName) != null && !this.getVoteURL(siteName).equals("");
    }

    @Override
    public void onFileCreation() {
        this.plugin.saveResource("VoteSites.yml", true);
    }

    public boolean renameVoteSite(String siteName, String newName) {
        return this.getVoteSiteFile(siteName).renameTo(new File(this.plugin.getDataFolder() + File.separator + "VoteSites", newName + ".yml"));
    }

    public void set(String siteName, String path, Object value) {
        ConfigurationSection data = this.getData(siteName);
        if (data == null) {
            this.getData().createSection("VoteSites." + siteName);
            data = this.getData(siteName);
        }
        data.set(path, value);
        this.saveData();
    }

    public void setCumulativeRewards(String siteName, ArrayList<String> value) {
        this.set(siteName, "Cumulative.Rewards", value);
    }

    public void setCumulativeVotes(String siteName, int value) {
        this.set(siteName, "Cumulative.Votes", value);
    }

    public void setDisplayName(String siteName, String value) {
        this.set(siteName, "Name", value);
    }

    public void setEnabled(String siteName, boolean disabled) {
        this.set(siteName, "Enabled", disabled);
    }

    public void setForceOffline(String siteName, boolean value) {
        this.set(siteName, "ForceOffline", value);
    }

    public void setPriority(String siteName, int value) {
        this.set(siteName, "Priority", value);
    }

    public void setRewards(String siteName, ArrayList<String> value) {
        this.set(siteName, "Rewards", value);
    }

    public void setServiceSite(String siteName, String serviceSite) {
        this.set(siteName, "ServiceSite", serviceSite);
    }

    public void setVoteDelay(String siteName, double voteDelay) {
        this.set(siteName, "VoteDelay", voteDelay);
    }

    public void setVoteDelayDaily(String siteName, boolean value) {
        this.set(siteName, "VoteDelayDaily", value);
    }

    public void setVoteURL(String siteName, String url) {
        this.set(siteName, "VoteURL", url);
    }

    public boolean siteCheck(String siteName) {
        boolean pass = true;
        if (!this.isServiceSiteGood(siteName)) {
            this.plugin.getLogger().warning("Issue with ServiceSite in site " + siteName + ", votes may not work properly");
            pass = false;
        }
        if (!this.isVoteURLGood(siteName)) {
            this.plugin.getLogger().warning("Issue with VoteURL in site " + siteName);
        }
        return pass;
    }
}

