/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.config;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.placeholders.PlaceholderCacheLevel;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.file.YMLFile;
import com.bencodez.votingplugin.simpleapi.file.annotation.AnnotationHandler;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataBoolean;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataInt;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataKeys;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataListString;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataLong;
import com.bencodez.votingplugin.simpleapi.file.annotation.ConfigDataString;
import com.bencodez.votingplugin.topvoter.TopVoter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class Config
extends YMLFile {
    @ConfigDataBoolean(path="AddCustomCommands")
    private boolean addCustomCommands = false;
    @ConfigDataBoolean(path="AddTotals")
    private boolean addTotals = true;
    @ConfigDataBoolean(path="AddTotalsOffline")
    private boolean addTotalsOffline = true;
    @ConfigDataBoolean(path="LoadInteralExpansion")
    private boolean loadInteralExpansion = true;
    @ConfigDataBoolean(path="PerSiteCoolDownEvents")
    private boolean perSiteCoolDownEvents = false;
    @ConfigDataInt(path="LimitVotePoints")
    private int limitVotePoints = -1;
    @ConfigDataBoolean(path="QueueVotesDuringTimeChange")
    private boolean queueVotesDuringTimeChange = false;
    @ConfigDataBoolean(path="AdvancedServiceSiteHandling")
    private boolean advancedServiceSiteHandling = false;
    @ConfigDataBoolean(path="AllowUnjoined")
    private boolean allowUnjoined = false;
    @ConfigDataBoolean(path="PreloadSkulls")
    private boolean preloadSkulls = false;
    @ConfigDataBoolean(path="DiscordSRV.Enabled")
    private boolean discordSRVEnabled = false;
    @ConfigDataBoolean(path="DiscordSRV.TopVoter.AllTime.Enabled")
    private boolean discordSRVTopVoterAllTimeEnabled = false;
    @ConfigDataLong(path="DiscordSRV.TopVoter.AllTime.Channel")
    private long discordSRVTopVoterAllTimeChannel = 0L;
    @ConfigDataString(path="DiscordSRV.TopVoter.AllTime.Title")
    private String discordSRVTopVoterAllTimeTitle = "All Time Top Voters";
    @ConfigDataString(path="DiscordSRV.TopVoter.AllTime.RankDisplay")
    private String discordSRVTopVoterAllTimeRankDisplay = "%rank%: %player% - %votes% Votes";
    @ConfigDataBoolean(path="DiscordSRV.TopVoter.Monthly.Enabled")
    private boolean discordSRVTopVoterMonthlyEnabled = false;
    @ConfigDataLong(path="DiscordSRV.TopVoter.Monthly.Channel")
    private long discordSRVTopVoterMonthlyChannel = 0L;
    @ConfigDataString(path="DiscordSRV.TopVoter.Monthly.Title")
    private String discordSRVTopVoterMonthlyTitle = "Top Voters of the Month";
    @ConfigDataString(path="DiscordSRV.TopVoter.Monthly.RankDisplay")
    private String discordSRVTopVoterMonthlyRankDisplay = "%rank%: %player% - %votes% Votes";
    @ConfigDataBoolean(path="DiscordSRV.TopVoter.Weekly.Enabled")
    private boolean discordSRVTopVoterWeeklyEnabled = false;
    @ConfigDataLong(path="DiscordSRV.TopVoter.Weekly.Channel")
    private long discordSRVTopVoterWeeklyChannel = 0L;
    @ConfigDataString(path="DiscordSRV.TopVoter.Weekly.Title")
    private String discordSRVTopVoterWeeklyTitle = "Top Voters of the Week";
    @ConfigDataString(path="DiscordSRV.TopVoter.Weekly.RankDisplay")
    private String discordSRVTopVoterWeeklyRankDisplay = "%rank%: %player% - %votes% Votes";
    @ConfigDataBoolean(path="DiscordSRV.TopVoter.Daily.Enabled")
    private boolean discordSRVTopVoterDailyEnabled = false;
    @ConfigDataLong(path="DiscordSRV.TopVoter.Daily.Channel")
    private long discordSRVTopVoterDailyChannel = 0L;
    @ConfigDataString(path="DiscordSRV.TopVoter.Daily.Title")
    private String discordSRVTopVoterDailyTitle = "Top Voters of the Day";
    @ConfigDataString(path="DiscordSRV.TopVoter.Daily.RankDisplay")
    private String discordSRVTopVoterDailyRankDisplay = "%rank%: %player% - %votes% Votes";
    @ConfigDataBoolean(path="AllowUnJoinedCheckServer")
    private boolean allowUnJoinedCheckServer = true;
    @ConfigDataBoolean(path="AllowVotePointTransfers")
    private boolean allowVotePointTransfers = false;
    @ConfigDataBoolean(path="AlternateUUIDLookup")
    private boolean alternateUUIDLookup = false;
    @ConfigDataBoolean(path="AlwaysCloseInventory")
    private boolean alwaysCloseInventory = false;
    @ConfigDataBoolean(path="ExtraVoteShopCheck")
    private boolean extraVoteShopCheck = true;
    @ConfigDataBoolean(path="TrackShopPurchases")
    private boolean trackShopPurchases = false;
    @ConfigDataBoolean(path="AlwaysUpdate")
    private boolean alwaysUpdate = false;
    @ConfigDataBoolean(path="AutoCreateVoteSites")
    private boolean autoCreateVoteSites = true;
    @ConfigDataBoolean(path="Format.BroadcastVote")
    private boolean broadcastVotesEnabled = true;
    @ConfigDataBoolean(path="CountFakeVotes")
    private boolean countFakeVotes = true;
    @ConfigDataInt(path="DelayBetweenUpdates")
    private int delayBetweenUpdates = 3;
    @ConfigDataBoolean(path="DisableAdvancedTab")
    private boolean disableAdvancedTab = false;
    @ConfigDataBoolean(path="DisableCoolDownCheck")
    private boolean disableCoolDownCheck = false;
    @ConfigDataListString(path="DisabledCommands")
    private ArrayList<String> disabledCommands = new ArrayList();
    @ConfigDataListString(path="DisabledDefaultPermissions")
    private ArrayList<String> disabledDefaultPermissions = new ArrayList();
    @ConfigDataListString(path="CachedPlaceholders")
    private ArrayList<String> cachedPlaceholders = new ArrayList();
    @ConfigDataBoolean(path="DisableInteractEvent")
    private boolean disableInteractEvent = false;
    @ConfigDataBoolean(path="DisableNoServiceSiteMessage")
    private boolean disableNoServiceSiteMessage = false;
    @ConfigDataBoolean(path="DisableUpdateChecking")
    private boolean disableUpdateChecking = false;
    @ConfigDataBoolean(path="ExtraAllSitesCheck")
    private boolean extraAllSitesCheck = false;
    @ConfigDataBoolean(path="CloseInventoryOnVote")
    private boolean closeInventoryOnVote = true;
    @ConfigDataBoolean(path="ExtraBackgroundUpdate")
    private boolean extraBackgroundUpdate = false;
    @ConfigDataString(path="Format.AlternateBroadcast.Broadcast")
    private String formatAlternateBroadcastBroadcast = "&6[&4Broadcast&6] &2%numberofplayers% voted in the last half hour! /vote";
    @ConfigDataInt(path="Format.AlternateBroadcast.Delay")
    private int formatAlternateBroadcastDelay = 30;
    @ConfigDataBoolean(path="Format.AlternateBroadcast.Enabled")
    private boolean formatAlternateBroadcastEnabled = false;
    @ConfigDataBoolean(path="Format.OnlyOneOfflineBroadcast")
    private boolean formatOnlyOneOfflineBroadcast = false;
    @ConfigDataString(path="Format.OfflineBroadcast")
    private String formatOfflineBroadcast = "&6[&4Broadcast&6] &2Thanks &c%player% &2for voting on %numberofvotes% times!";
    @ConfigDataBoolean(path="Format.Commands.Vote.ForceLinks")
    private boolean formatCommandsVoteForceLinks = true;
    @ConfigDataString(path="Format.Commands.Vote.Last.LastVoted")
    private String formatCommandsVoteLastLastVoted = "%times% ago";
    @ConfigDataString(path="Format.Commands.Vote.GivePoints.NotEnoughPoints")
    private String formatCommandsVoteGivePointsNotEnoughPoints = "&cNot enough points";
    @ConfigDataString(path="Format.Commands.Vote.GivePoints.NotJoinedServer")
    private String formatCommandsVoteGivePointsNotJoinedServer = "&c%player% has not joined the server";
    @ConfigDataString(path="Format.Commands.Vote.GivePoints.NumberLowerThanZero")
    private String formatCommandsVoteGivePointsNumberLowerThanZero = "&cNumber of points needs to be greater than 0";
    @ConfigDataString(path="Format.Commands.Vote.GivePoints.TransferFrom")
    private String formatCommandsVoteGivePointsTransferFrom = "&c%transfer% points given to %touser%";
    @ConfigDataString(path="Format.Commands.Vote.GivePoints.TransferTo")
    private String formatCommandsVoteGivePointsTransferTo = "&cYou received %transfer points from %fromuser%";
    @ConfigDataString(path="Format.Commands.Vote.Last.Line", defaultValue="&3%SiteName%: &6%timeSince% ago")
    private String formatCommandsVoteLastLine;
    @ConfigDataString(path="Format.Commands.Vote.Last.NeverVoted", defaultValue="Never voted")
    private String formatCommandsVoteLastNeverVoted;
    @ConfigDataBoolean(path="Format.Commands.Vote.Last.IncludeSeconds")
    private boolean formatCommandsVoteLastIncludeSeconds = true;
    @ConfigDataString(path="Format.Commands.Vote.Last.TimeFormat", defaultValue="%amount% %TimeType%")
    private String formatCommandsVoteLastTimeFormat;
    @ConfigDataString(path="Format.Commands.Vote.Today.Line")
    private String formatCommandsVoteTodayLine = "&6%player% : %VoteSite% : %Time%";
    @ConfigDataListString(path="Format.Commands.Vote.Today.Title")
    private ArrayList<String> formatCommandsVoteTodayTitle = ArrayUtils.convert(new String[]{"&cToday's Votes %page%/%maxpage%", "&cPlayerName : VoteSite : Time"});
    @ConfigDataString(path="Format.Commands.Vote.ToggleBroadcasts.Disabled")
    private String formatCommandsVoteToggleBroadcastDisabled = "&cYou will no longer see vote broadcasts";
    @ConfigDataString(path="Format.Commands.Vote.ToggleBroadcasts.Enabled")
    private String formatCommandsVoteToggleBroadcastEnabled = "&cYou will now see vote broadcasts";
    @ConfigDataString(path="Format.Commands.Vote.ToggleReminders.Disabled")
    private String formatCommandsVoteToggleRemindersDisabled = "&cVote reminders disabled";
    @ConfigDataString(path="Format.Commands.Vote.ToggleReminders.Enabled")
    private String formatCommandsVoteToggleRemindersEnabled = "&cVote reminders enabled";
    private int formatPageSize = 10;
    @ConfigDataString(path="Format.TimeFormats.Day", defaultValue="Day")
    private String formatTimeFormatsDay;
    @ConfigDataString(path="Format.TimeFormats.Days", defaultValue="Days")
    private String formatTimeFormatsDays;
    @ConfigDataString(path="Format.TimeFormats.Hour", defaultValue="Hour")
    private String formatTimeFormatsHour;
    @ConfigDataString(path="Format.TimeFormats.Hours", defaultValue="Hours")
    private String formatTimeFormatsHours;
    @ConfigDataString(path="Format.TimeFormats.Minute", defaultValue="Minute")
    private String formatTimeFormatsMinute;
    @ConfigDataString(path="Format.TimeFormats.Minutes", defaultValue="Minutes")
    private String formatTimeFormatsMinutes;
    @ConfigDataString(path="Format.TimeFormats.Second", defaultValue="Second")
    private String formatTimeFormatsSecond;
    @ConfigDataString(path="Format.TimeFormats.Seconds", defaultValue="Seconds")
    private String formatTimeFormatsSeconds;
    @ConfigDataBoolean(path="LimitMonthlyVotes")
    private boolean limitMonthlyVotes = false;
    @ConfigDataBoolean(path="LoadCommandAliases")
    private boolean loadCommandAliases = true;
    @ConfigDataBoolean(path="LogVotesToFile")
    private boolean logVotesToFile = false;
    @ConfigDataInt(path="MaxiumNumberOfTopVotersToLoad")
    private int MaxiumNumberOfTopVotersToLoad = 1000;
    @ConfigDataBoolean(path="OverrideVersionDisable")
    private boolean overrideVersionDisable = false;
    @ConfigDataBoolean(path="PreventRepeatMilestones")
    private boolean preventRepeatMilestones = false;
    @ConfigDataBoolean(path="OfflineVotesLimit.Enabled")
    private boolean offlineVotesLimitEnabled = false;
    @ConfigDataInt(path="OfflineVotesLimit.Amount")
    private int offlineVotesLimitAmount = 5;
    @ConfigDataBoolean(path="UpdateWithPlayersOnlineOnly")
    private boolean updateWithPlayersOnlineOnly = false;
    @ConfigDataBoolean(path="UseHighestTotals")
    private boolean useHighestTotals = true;
    @ConfigDataBoolean(path="UseJavascriptPlaceholders")
    private boolean useJavascriptPlaceholders = false;
    @ConfigDataBoolean(path="UsePrimaryAccountForPlaceholders")
    private boolean usePrimaryAccountForPlaceholders = false;
    @ConfigDataBoolean(path="UseVoteGUIMainCommand")
    private boolean useVoteGUIMainCommand = false;
    @ConfigDataBoolean(path="UseVoteStreaks")
    private boolean useVoteStreaks = true;
    @ConfigDataListString(path="VotingBroadcastBlacklist")
    private ArrayList<String> votingBroadcastBlacklist = new ArrayList();
    @ConfigDataKeys(path="CustomCommands")
    private Set<String> customCommands = new HashSet<String>();
    @ConfigDataKeys(path="CustomPlaceholderReturns")
    private Set<String> customPlaceholderReturns = new HashSet<String>();
    @ConfigDataString(path="Format.BroadcastMsg")
    private String formatBroadCastMsg = "&6[&4Broadcast&6] &2Thanks &c%player% &2for voting on %SiteName%";
    @ConfigDataBoolean(path="Format.BroadcastWhenOnline")
    private boolean formatBroadcastWhenOnline = false;
    @ConfigDataBoolean(path="Format.Commands.Vote.AutoInputSites")
    private boolean formatCommandsVoteAutoInputSites = true;
    @ConfigDataBoolean(path="Format.Commands.Vote.OnlyShowSitesToVote")
    private boolean formatCommandsVoteOnlyShowSitesToVote = false;
    @ConfigDataListString(path="Format.Commands.Vote.Best.Lines")
    private ArrayList<String> formatCommandsVoteBestLines = new ArrayList();
    @ConfigDataString(path="Format.Commands.Vote.Best.Title")
    private String formatCommandsVoteBestTitle = "&3&l%player% Best Votes";
    @ConfigDataString(path="Format.Commands.Vote.Help.HoverColor")
    private String formatCommandsVoteHelpHoverColor = "AQUA";
    @ConfigDataString(path="Format.Commands.Vote.Help.Line")
    private String formatCommandsVoteHelpLine = "&6%Command% - &6%HelpMessage%";
    @ConfigDataBoolean(path="Format.Commands.Vote.Help.RequirePermission")
    private boolean formatCommandsVoteHelpRequirePermission = false;
    @ConfigDataString(path="Format.Commands.Vote.Help.Title")
    private String formatCommandsVoteHelpTitle = "&6Voting Player Help";
    @ConfigDataString(path="Format.Commands.Vote.Last.Title")
    private String formatCommandsVoteLastTitle = "&3&l%player% Last Vote Times:";
    @ConfigDataString(path="Format.Commands.Vote.Next.Info.CanVote")
    private String formatCommandsVoteNextInfoCanVote = "Go Vote!";
    @ConfigDataString(path="Format.Commands.Vote.Next.Info.Error")
    private String formatCommandsVoteNextInfoError = "";
    @ConfigDataString(path="Format.Commands.Vote.Next.Info.TimeUntilVote")
    private String formatCommandsVoteNextInfoTime = "&cCould not caculate time until next vote!";
    @ConfigDataString(path="Format.Commands.Vote.Next.Info.VoteDelayDaily")
    private String formatCommandsVoteNextInfoVoteDelayDaily = "%hours% Hours and %minutes% Minutes";
    @ConfigDataString(path="PlaceholderCacheLevel", options={"AUTO", "SPECIFIC", "NONE"})
    private String placeholderCacheLevelString = "AUTO";
    @ConfigDataString(path="Format.Commands.Vote.Next.Layout")
    private String formatCommandsVoteNextLayout = "&3%SiteName%: &6%info%";
    @ConfigDataString(path="Format.Commands.Vote.Next.Title")
    private String formatCommandsVoteNextTitle = "&3&l%player% Next Votes:";
    @ConfigDataString(path="Format.Commands.Vote.Streak.Title")
    private String formatCommandsVoteStreakTitle = "&3&l%player% Vote Streak";
    @ConfigDataString(path="Format.Commands.Vote.Sites")
    private String formatCommandsVoteURLS = "&4%num%: &c&l%SiteName% - &c%url%";
    @ConfigDataString(path="Format.Commands.Vote.Points")
    private String formatCommandsVotePoints = "&a%Player% currently has &a&l%Points%&a Points!";
    @ConfigDataString(path="Format.Commands.Vote.Top.Line")
    private String formatCommandsVoteTopLine = "&c%num%: &6%player%, %votes%";
    @ConfigDataString(path="Format.Commands.Vote.Top.Title")
    private String formatCommandVoteTopTitle = "&3Top %Top% Voters %page%/%maxpages%";
    @ConfigDataString(path="Format.NextPage")
    private String formatNextPage = "&aNext Page";
    @ConfigDataString(path="Format.NoPerms")
    private String formatNoPerms = "&cYou do not have enough permission!";
    @ConfigDataString(path="Format.NotNumber")
    private String formatNotNumber = "&cError on &6%arg%&c, number expected!";
    @ConfigDataString(path="Format.PrevPage")
    private String formatPrevPage = "&aPrevious Page";
    @ConfigDataString(path="Format.ShopFailed")
    private String formatShopFailedMsg = "&cYou do not have %Points% points to purhcase this!";
    @ConfigDataString(path="Format.ShopNotPurchasable")
    private String formatShopNotPurchasable = "&cThis item is not buyable!";
    @ConfigDataString(path="Format.ShopPurchase")
    private String formatShopPurchaseMsg = "&aYou bought the %Identifier% for %Points% Points!";
    @ConfigDataString(path="Format.Signs.TopVoterSign.Line1")
    private String formatSignTopVoterSignLine1 = "TopVoter: %SiteName%";
    @ConfigDataString(path="Format.Signs.TopVoterSign.Line2")
    private String formatSignTopVoterSignLine2 = "#%position%";
    @ConfigDataString(path="Format.Signs.TopVoterSign.Line3")
    private String formatSignTopVoterSignLine3 = "%player%";
    @ConfigDataString(path="Format.Signs.TopVoterSign.Line4")
    private String formatSignTopVoterSignLine4 = "%votes% Votes";
    @ConfigDataString(path="Format.Signs.RightClickMessage")
    private String formatSignTopVoterSignRightClickMessage = "&c&l%player% &cis &c&l%position% &cwith &c&l%votes% &cin &c&l%SiteName%";
    @ConfigDataString(path="Format.TimeFormat")
    private String formatTimeFormat = "EEE, d MMM yyyy HH:mm";
    @ConfigDataString(path="Format.TopVoter.AllTime")
    private String formatTopVoterAllTime = "AllTime";
    @ConfigDataString(path="Format.TopVoter.Daily")
    private String formatTopVoterDaily = "Daily";
    @ConfigDataString(path="Format.TopVoter.Monthly")
    private String formatTopVoterMonthly = "Monthly";
    @ConfigDataString(path="Format.TopVoterAwardMsg")
    private String formatTopVoterRewardMsg = "&aYou came in %place% in top voters of the month! Here is an award!";
    @ConfigDataString(path="Format.TopVoter.Weekly")
    private String formatTopVoterWeekly = "Weekly";
    @ConfigDataString(path="Format.UserNotExist")
    private String formatUserNotExist = "&cUser does not exist: %player%";
    @ConfigDataString(path="Format.InvalidCommand.Vote")
    private String formatInvalidCommandVote = "&4No valid arguments, see /vote help!";
    @ConfigDataString(path="Format.InvalidCommand.AdminVote")
    private String formatInvalidCommandAdminVote = "&4No valid arguments, see /adminvote help!";
    @ConfigDataBoolean(path="GiveDefaultPermission")
    private boolean giveDefaultPermission = true;
    @ConfigDataBoolean(path="LoadTopVoter.AllTime")
    private boolean loadTopVoterAllTime = true;
    @ConfigDataBoolean(path="LoadTopVoter.Monthly")
    private boolean loadTopVoterMonthly = true;
    @ConfigDataBoolean(path="LoadTopVoter.Daily")
    private boolean loadTopVoterDaily = false;
    @ConfigDataBoolean(path="LoadTopVoter.Weekly")
    private boolean loadTopVoterWeekly = false;
    @ConfigDataInt(path="PointsOnVote")
    private int pointsOnVote = 1;
    @ConfigDataBoolean(path="PurgeNoDataOnStartup")
    private boolean purgeNoDataOnStartup = false;
    @ConfigDataBoolean(path="StoreMonthTotalsWithDate")
    private boolean storeMonthTotalsWithDate = false;
    @ConfigDataBoolean(path="UseMonthDateTotalsAsPrimaryTotal")
    private boolean useMonthDateTotalsAsPrimaryTotal = false;
    @ConfigDataString(path="RequestAPI.DefaultMethod")
    private String requestAPIDefaultMethod = "ANVIL";
    @ConfigDataListString(path="RequestAPI.DisabledMethods")
    private ArrayList<String> requestAPIDisabledMethods = new ArrayList();
    @ConfigDataBoolean(path="StoreTopVoters.Daily")
    private boolean storeTopVotersDaily = false;
    @ConfigDataBoolean(path="StoreTopVoters.Weekly")
    private boolean storeTopVotersWeekly = false;
    @ConfigDataBoolean(path="TopVoterAwardsTies")
    private boolean topVoterAwardsTies = true;
    @ConfigDataBoolean(path="TopVoterIgnorePermission")
    private boolean topVoterIgnorePermission = false;
    @ConfigDataBoolean(path="VoteReminding.Enabled")
    private boolean voteRemindingEnabled = true;
    @ConfigDataInt(path="VoteReminding.RemindDelay")
    private int voteRemindingRemindDelay = 30;
    @ConfigDataBoolean(path="VoteReminding.RemindOnLogin")
    private boolean voteRemindingRemindOnLogin = false;
    @ConfigDataBoolean(path="VoteReminding.RemindOnlyOnce")
    private boolean voteRemindingRemindOnlyOnce = false;
    @ConfigDataString(path="VoteTopDefault")
    private String voteTopDefault = "Monthly";

    public boolean isDiscordSRVTopVoterEnabled(TopVoter topVoter) {
        switch (topVoter) {
            case AllTime: {
                return this.isDiscordSRVTopVoterAllTimeEnabled();
            }
            case Monthly: {
                return this.isDiscordSRVTopVoterMonthlyEnabled();
            }
            case Weekly: {
                return this.isDiscordSRVTopVoterWeeklyEnabled();
            }
            case Daily: {
                return this.isDiscordSRVTopVoterDailyEnabled();
            }
        }
        return false;
    }

    public long getDiscordSRVTopVoterChannel(TopVoter topVoter) {
        switch (topVoter) {
            case AllTime: {
                return this.getDiscordSRVTopVoterAllTimeChannel();
            }
            case Monthly: {
                return this.getDiscordSRVTopVoterMonthlyChannel();
            }
            case Weekly: {
                return this.getDiscordSRVTopVoterWeeklyChannel();
            }
            case Daily: {
                return this.getDiscordSRVTopVoterDailyChannel();
            }
        }
        return 0L;
    }

    public String getDiscordSRVTopVoterTitle(TopVoter topVoter) {
        switch (topVoter) {
            case AllTime: {
                return this.getDiscordSRVTopVoterAllTimeTitle();
            }
            case Monthly: {
                return this.getDiscordSRVTopVoterMonthlyTitle();
            }
            case Weekly: {
                return this.getDiscordSRVTopVoterWeeklyTitle();
            }
            case Daily: {
                return this.getDiscordSRVTopVoterDailyTitle();
            }
        }
        return "";
    }

    public String getDiscordSRVTopVoterRankDisplay(TopVoter topVoter) {
        switch (topVoter) {
            case AllTime: {
                return this.getDiscordSRVTopVoterAllTimeRankDisplay();
            }
            case Monthly: {
                return this.getDiscordSRVTopVoterMonthlyRankDisplay();
            }
            case Weekly: {
                return this.getDiscordSRVTopVoterWeeklyRankDisplay();
            }
            case Daily: {
                return this.getDiscordSRVTopVoterDailyRankDisplay();
            }
        }
        return "";
    }

    public Config(VotingPluginMain plugin) {
        super(plugin, new File(plugin.getDataFolder(), "Config.yml"));
    }

    public ArrayList<String> getBlackList() {
        return (ArrayList)this.getData().getList("BlackList", new ArrayList());
    }

    public ConfigurationSection getCustomCommands(String ident) {
        return this.getData().getConfigurationSection("CustomCommands." + ident);
    }

    public Set<String> getCustomPlaceholderReturns(String placeholder) {
        HashSet str = this.getData().getConfigurationSection("CustomPlaceholderReturns." + placeholder).getKeys(false);
        if (str == null) {
            str = new HashSet();
        }
        return str;
    }

    public String getCustomPlaceholderReturns(String placeholder, String returnString) {
        return this.getData().getString("CustomPlaceholderReturns." + placeholder + "." + returnString, "");
    }

    public ArrayList<String> getFormatCommandsVoteParty() {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("&cCurrently at &6%Votes%&c, &6%NeededVotes% &cmore votes to go to reach &6%VotesRequired%");
        return (ArrayList)this.getData().getList("Format.Commands.Vote.Party", msg);
    }

    public ArrayList<String> getFormatCommandsVoteStreakLines() {
        return (ArrayList)this.getData().getList("Format.Commands.Vote.Streak.Lines", new ArrayList());
    }

    public ArrayList<String> getFormatCommandsVoteText() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("&4&lVote for our server!");
        return (ArrayList)this.getData().getList("Format.Commands.Vote.Text", str);
    }

    public ArrayList<String> getFormatCommandsVoteTotal() {
        ArrayList list = (ArrayList)this.getData().getList("Format.Commands.Vote.Total", new ArrayList());
        if (list.isEmpty()) {
            list.add("&3&l%player% Total Votes:");
            list.add("&3&lDaily Total: &6&l%DailyTotal%");
            list.add("&3&lWeekly Total: &6&l%WeeklyTotal%");
            list.add("&3&lMonthly Total: &6&l%MonthlyTotal%");
            list.add("&3&lAllTime Total: &6&l%AllTimeTotal%");
        }
        return list;
    }

    public ArrayList<String> getFormatCommandsVoteTotalAll() {
        ArrayList list = (ArrayList)this.getData().getList("Format.Commands.Vote.TotalAll", new ArrayList());
        if (list.isEmpty()) {
            list.add("&3&lServer Total Votes:");
            list.add("&3&lDaily Total: &6&l%DailyTotal%");
            list.add("&3&lWeekly Total: &6&l%WeeklyTotal%");
            list.add("&3&lMonthly Total: &6&l%MonthlyTotal%");
            list.add("&3&lAllTime Total: &6&l%AllTimeTotal%");
        }
        return list;
    }

    public ArrayList<String> getFormatVoteHelp() {
        return (ArrayList)this.getData().getList("Format.Commands.Vote.Help.Lines", new ArrayList());
    }

    public boolean getLoadTopVoter(TopVoter top) {
        switch (top) {
            case AllTime: {
                return this.isLoadTopVoterAllTime();
            }
            case Daily: {
                return this.isLoadTopVoterDaily();
            }
            case Monthly: {
                return this.isLoadTopVoterMonthly();
            }
            case Weekly: {
                return this.isLoadTopVoterWeekly();
            }
        }
        return false;
    }

    public PlaceholderCacheLevel getPlaceholderCacheLevel() {
        return PlaceholderCacheLevel.getCache(this.getPlaceholderCacheLevelString());
    }

    public String getVoteRemindingRewardsPath() {
        return "VoteReminding.Rewards";
    }

    @Override
    public void loadValues() {
        new AnnotationHandler().load((ConfigurationSection)this.getData(), this);
    }

    @Override
    public void onFileCreation() {
        this.getPlugin().saveResource("Config.yml", true);
    }

    @Generated
    public boolean isAddCustomCommands() {
        return this.addCustomCommands;
    }

    @Generated
    public boolean isAddTotals() {
        return this.addTotals;
    }

    @Generated
    public boolean isAddTotalsOffline() {
        return this.addTotalsOffline;
    }

    @Generated
    public boolean isLoadInteralExpansion() {
        return this.loadInteralExpansion;
    }

    @Generated
    public boolean isPerSiteCoolDownEvents() {
        return this.perSiteCoolDownEvents;
    }

    @Generated
    public int getLimitVotePoints() {
        return this.limitVotePoints;
    }

    @Generated
    public boolean isQueueVotesDuringTimeChange() {
        return this.queueVotesDuringTimeChange;
    }

    @Generated
    public boolean isAdvancedServiceSiteHandling() {
        return this.advancedServiceSiteHandling;
    }

    @Generated
    public boolean isAllowUnjoined() {
        return this.allowUnjoined;
    }

    @Generated
    public boolean isPreloadSkulls() {
        return this.preloadSkulls;
    }

    @Generated
    public boolean isDiscordSRVEnabled() {
        return this.discordSRVEnabled;
    }

    @Generated
    public boolean isDiscordSRVTopVoterAllTimeEnabled() {
        return this.discordSRVTopVoterAllTimeEnabled;
    }

    @Generated
    public long getDiscordSRVTopVoterAllTimeChannel() {
        return this.discordSRVTopVoterAllTimeChannel;
    }

    @Generated
    public String getDiscordSRVTopVoterAllTimeTitle() {
        return this.discordSRVTopVoterAllTimeTitle;
    }

    @Generated
    public String getDiscordSRVTopVoterAllTimeRankDisplay() {
        return this.discordSRVTopVoterAllTimeRankDisplay;
    }

    @Generated
    public boolean isDiscordSRVTopVoterMonthlyEnabled() {
        return this.discordSRVTopVoterMonthlyEnabled;
    }

    @Generated
    public long getDiscordSRVTopVoterMonthlyChannel() {
        return this.discordSRVTopVoterMonthlyChannel;
    }

    @Generated
    public String getDiscordSRVTopVoterMonthlyTitle() {
        return this.discordSRVTopVoterMonthlyTitle;
    }

    @Generated
    public String getDiscordSRVTopVoterMonthlyRankDisplay() {
        return this.discordSRVTopVoterMonthlyRankDisplay;
    }

    @Generated
    public boolean isDiscordSRVTopVoterWeeklyEnabled() {
        return this.discordSRVTopVoterWeeklyEnabled;
    }

    @Generated
    public long getDiscordSRVTopVoterWeeklyChannel() {
        return this.discordSRVTopVoterWeeklyChannel;
    }

    @Generated
    public String getDiscordSRVTopVoterWeeklyTitle() {
        return this.discordSRVTopVoterWeeklyTitle;
    }

    @Generated
    public String getDiscordSRVTopVoterWeeklyRankDisplay() {
        return this.discordSRVTopVoterWeeklyRankDisplay;
    }

    @Generated
    public boolean isDiscordSRVTopVoterDailyEnabled() {
        return this.discordSRVTopVoterDailyEnabled;
    }

    @Generated
    public long getDiscordSRVTopVoterDailyChannel() {
        return this.discordSRVTopVoterDailyChannel;
    }

    @Generated
    public String getDiscordSRVTopVoterDailyTitle() {
        return this.discordSRVTopVoterDailyTitle;
    }

    @Generated
    public String getDiscordSRVTopVoterDailyRankDisplay() {
        return this.discordSRVTopVoterDailyRankDisplay;
    }

    @Generated
    public boolean isAllowUnJoinedCheckServer() {
        return this.allowUnJoinedCheckServer;
    }

    @Generated
    public boolean isAllowVotePointTransfers() {
        return this.allowVotePointTransfers;
    }

    @Generated
    public boolean isAlternateUUIDLookup() {
        return this.alternateUUIDLookup;
    }

    @Generated
    public boolean isAlwaysCloseInventory() {
        return this.alwaysCloseInventory;
    }

    @Generated
    public boolean isExtraVoteShopCheck() {
        return this.extraVoteShopCheck;
    }

    @Generated
    public boolean isTrackShopPurchases() {
        return this.trackShopPurchases;
    }

    @Generated
    public boolean isAlwaysUpdate() {
        return this.alwaysUpdate;
    }

    @Generated
    public boolean isAutoCreateVoteSites() {
        return this.autoCreateVoteSites;
    }

    @Generated
    public boolean isBroadcastVotesEnabled() {
        return this.broadcastVotesEnabled;
    }

    @Generated
    public boolean isCountFakeVotes() {
        return this.countFakeVotes;
    }

    @Generated
    public int getDelayBetweenUpdates() {
        return this.delayBetweenUpdates;
    }

    @Generated
    public boolean isDisableAdvancedTab() {
        return this.disableAdvancedTab;
    }

    @Generated
    public boolean isDisableCoolDownCheck() {
        return this.disableCoolDownCheck;
    }

    @Generated
    public ArrayList<String> getDisabledCommands() {
        return this.disabledCommands;
    }

    @Generated
    public ArrayList<String> getDisabledDefaultPermissions() {
        return this.disabledDefaultPermissions;
    }

    @Generated
    public ArrayList<String> getCachedPlaceholders() {
        return this.cachedPlaceholders;
    }

    @Generated
    public boolean isDisableInteractEvent() {
        return this.disableInteractEvent;
    }

    @Generated
    public boolean isDisableNoServiceSiteMessage() {
        return this.disableNoServiceSiteMessage;
    }

    @Generated
    public boolean isDisableUpdateChecking() {
        return this.disableUpdateChecking;
    }

    @Generated
    public boolean isExtraAllSitesCheck() {
        return this.extraAllSitesCheck;
    }

    @Generated
    public boolean isCloseInventoryOnVote() {
        return this.closeInventoryOnVote;
    }

    @Generated
    public boolean isExtraBackgroundUpdate() {
        return this.extraBackgroundUpdate;
    }

    @Generated
    public String getFormatAlternateBroadcastBroadcast() {
        return this.formatAlternateBroadcastBroadcast;
    }

    @Generated
    public int getFormatAlternateBroadcastDelay() {
        return this.formatAlternateBroadcastDelay;
    }

    @Generated
    public boolean isFormatAlternateBroadcastEnabled() {
        return this.formatAlternateBroadcastEnabled;
    }

    @Generated
    public boolean isFormatOnlyOneOfflineBroadcast() {
        return this.formatOnlyOneOfflineBroadcast;
    }

    @Generated
    public String getFormatOfflineBroadcast() {
        return this.formatOfflineBroadcast;
    }

    @Generated
    public boolean isFormatCommandsVoteForceLinks() {
        return this.formatCommandsVoteForceLinks;
    }

    @Generated
    public String getFormatCommandsVoteLastLastVoted() {
        return this.formatCommandsVoteLastLastVoted;
    }

    @Generated
    public String getFormatCommandsVoteGivePointsNotEnoughPoints() {
        return this.formatCommandsVoteGivePointsNotEnoughPoints;
    }

    @Generated
    public String getFormatCommandsVoteGivePointsNotJoinedServer() {
        return this.formatCommandsVoteGivePointsNotJoinedServer;
    }

    @Generated
    public String getFormatCommandsVoteGivePointsNumberLowerThanZero() {
        return this.formatCommandsVoteGivePointsNumberLowerThanZero;
    }

    @Generated
    public String getFormatCommandsVoteGivePointsTransferFrom() {
        return this.formatCommandsVoteGivePointsTransferFrom;
    }

    @Generated
    public String getFormatCommandsVoteGivePointsTransferTo() {
        return this.formatCommandsVoteGivePointsTransferTo;
    }

    @Generated
    public String getFormatCommandsVoteLastLine() {
        return this.formatCommandsVoteLastLine;
    }

    @Generated
    public String getFormatCommandsVoteLastNeverVoted() {
        return this.formatCommandsVoteLastNeverVoted;
    }

    @Generated
    public boolean isFormatCommandsVoteLastIncludeSeconds() {
        return this.formatCommandsVoteLastIncludeSeconds;
    }

    @Generated
    public String getFormatCommandsVoteLastTimeFormat() {
        return this.formatCommandsVoteLastTimeFormat;
    }

    @Generated
    public String getFormatCommandsVoteTodayLine() {
        return this.formatCommandsVoteTodayLine;
    }

    @Generated
    public ArrayList<String> getFormatCommandsVoteTodayTitle() {
        return this.formatCommandsVoteTodayTitle;
    }

    @Generated
    public String getFormatCommandsVoteToggleBroadcastDisabled() {
        return this.formatCommandsVoteToggleBroadcastDisabled;
    }

    @Generated
    public String getFormatCommandsVoteToggleBroadcastEnabled() {
        return this.formatCommandsVoteToggleBroadcastEnabled;
    }

    @Generated
    public String getFormatCommandsVoteToggleRemindersDisabled() {
        return this.formatCommandsVoteToggleRemindersDisabled;
    }

    @Generated
    public String getFormatCommandsVoteToggleRemindersEnabled() {
        return this.formatCommandsVoteToggleRemindersEnabled;
    }

    @Generated
    public int getFormatPageSize() {
        return this.formatPageSize;
    }

    @Generated
    public String getFormatTimeFormatsDay() {
        return this.formatTimeFormatsDay;
    }

    @Generated
    public String getFormatTimeFormatsDays() {
        return this.formatTimeFormatsDays;
    }

    @Generated
    public String getFormatTimeFormatsHour() {
        return this.formatTimeFormatsHour;
    }

    @Generated
    public String getFormatTimeFormatsHours() {
        return this.formatTimeFormatsHours;
    }

    @Generated
    public String getFormatTimeFormatsMinute() {
        return this.formatTimeFormatsMinute;
    }

    @Generated
    public String getFormatTimeFormatsMinutes() {
        return this.formatTimeFormatsMinutes;
    }

    @Generated
    public String getFormatTimeFormatsSecond() {
        return this.formatTimeFormatsSecond;
    }

    @Generated
    public String getFormatTimeFormatsSeconds() {
        return this.formatTimeFormatsSeconds;
    }

    @Generated
    public boolean isLimitMonthlyVotes() {
        return this.limitMonthlyVotes;
    }

    @Generated
    public boolean isLoadCommandAliases() {
        return this.loadCommandAliases;
    }

    @Generated
    public boolean isLogVotesToFile() {
        return this.logVotesToFile;
    }

    @Generated
    public int getMaxiumNumberOfTopVotersToLoad() {
        return this.MaxiumNumberOfTopVotersToLoad;
    }

    @Generated
    public boolean isOverrideVersionDisable() {
        return this.overrideVersionDisable;
    }

    @Generated
    public boolean isPreventRepeatMilestones() {
        return this.preventRepeatMilestones;
    }

    @Generated
    public boolean isOfflineVotesLimitEnabled() {
        return this.offlineVotesLimitEnabled;
    }

    @Generated
    public int getOfflineVotesLimitAmount() {
        return this.offlineVotesLimitAmount;
    }

    @Generated
    public boolean isUpdateWithPlayersOnlineOnly() {
        return this.updateWithPlayersOnlineOnly;
    }

    @Generated
    public boolean isUseHighestTotals() {
        return this.useHighestTotals;
    }

    @Generated
    public boolean isUseJavascriptPlaceholders() {
        return this.useJavascriptPlaceholders;
    }

    @Generated
    public boolean isUsePrimaryAccountForPlaceholders() {
        return this.usePrimaryAccountForPlaceholders;
    }

    @Generated
    public boolean isUseVoteGUIMainCommand() {
        return this.useVoteGUIMainCommand;
    }

    @Generated
    public boolean isUseVoteStreaks() {
        return this.useVoteStreaks;
    }

    @Generated
    public ArrayList<String> getVotingBroadcastBlacklist() {
        return this.votingBroadcastBlacklist;
    }

    @Generated
    public Set<String> getCustomCommands() {
        return this.customCommands;
    }

    @Generated
    public Set<String> getCustomPlaceholderReturns() {
        return this.customPlaceholderReturns;
    }

    @Generated
    public String getFormatBroadCastMsg() {
        return this.formatBroadCastMsg;
    }

    @Generated
    public boolean isFormatBroadcastWhenOnline() {
        return this.formatBroadcastWhenOnline;
    }

    @Generated
    public boolean isFormatCommandsVoteAutoInputSites() {
        return this.formatCommandsVoteAutoInputSites;
    }

    @Generated
    public boolean isFormatCommandsVoteOnlyShowSitesToVote() {
        return this.formatCommandsVoteOnlyShowSitesToVote;
    }

    @Generated
    public ArrayList<String> getFormatCommandsVoteBestLines() {
        return this.formatCommandsVoteBestLines;
    }

    @Generated
    public String getFormatCommandsVoteBestTitle() {
        return this.formatCommandsVoteBestTitle;
    }

    @Generated
    public String getFormatCommandsVoteHelpHoverColor() {
        return this.formatCommandsVoteHelpHoverColor;
    }

    @Generated
    public String getFormatCommandsVoteHelpLine() {
        return this.formatCommandsVoteHelpLine;
    }

    @Generated
    public boolean isFormatCommandsVoteHelpRequirePermission() {
        return this.formatCommandsVoteHelpRequirePermission;
    }

    @Generated
    public String getFormatCommandsVoteHelpTitle() {
        return this.formatCommandsVoteHelpTitle;
    }

    @Generated
    public String getFormatCommandsVoteLastTitle() {
        return this.formatCommandsVoteLastTitle;
    }

    @Generated
    public String getFormatCommandsVoteNextInfoCanVote() {
        return this.formatCommandsVoteNextInfoCanVote;
    }

    @Generated
    public String getFormatCommandsVoteNextInfoError() {
        return this.formatCommandsVoteNextInfoError;
    }

    @Generated
    public String getFormatCommandsVoteNextInfoTime() {
        return this.formatCommandsVoteNextInfoTime;
    }

    @Generated
    public String getFormatCommandsVoteNextInfoVoteDelayDaily() {
        return this.formatCommandsVoteNextInfoVoteDelayDaily;
    }

    @Generated
    public String getPlaceholderCacheLevelString() {
        return this.placeholderCacheLevelString;
    }

    @Generated
    public String getFormatCommandsVoteNextLayout() {
        return this.formatCommandsVoteNextLayout;
    }

    @Generated
    public String getFormatCommandsVoteNextTitle() {
        return this.formatCommandsVoteNextTitle;
    }

    @Generated
    public String getFormatCommandsVoteStreakTitle() {
        return this.formatCommandsVoteStreakTitle;
    }

    @Generated
    public String getFormatCommandsVoteURLS() {
        return this.formatCommandsVoteURLS;
    }

    @Generated
    public String getFormatCommandsVotePoints() {
        return this.formatCommandsVotePoints;
    }

    @Generated
    public String getFormatCommandsVoteTopLine() {
        return this.formatCommandsVoteTopLine;
    }

    @Generated
    public String getFormatCommandVoteTopTitle() {
        return this.formatCommandVoteTopTitle;
    }

    @Generated
    public String getFormatNextPage() {
        return this.formatNextPage;
    }

    @Generated
    public String getFormatNoPerms() {
        return this.formatNoPerms;
    }

    @Generated
    public String getFormatNotNumber() {
        return this.formatNotNumber;
    }

    @Generated
    public String getFormatPrevPage() {
        return this.formatPrevPage;
    }

    @Generated
    public String getFormatShopFailedMsg() {
        return this.formatShopFailedMsg;
    }

    @Generated
    public String getFormatShopNotPurchasable() {
        return this.formatShopNotPurchasable;
    }

    @Generated
    public String getFormatShopPurchaseMsg() {
        return this.formatShopPurchaseMsg;
    }

    @Generated
    public String getFormatSignTopVoterSignLine1() {
        return this.formatSignTopVoterSignLine1;
    }

    @Generated
    public String getFormatSignTopVoterSignLine2() {
        return this.formatSignTopVoterSignLine2;
    }

    @Generated
    public String getFormatSignTopVoterSignLine3() {
        return this.formatSignTopVoterSignLine3;
    }

    @Generated
    public String getFormatSignTopVoterSignLine4() {
        return this.formatSignTopVoterSignLine4;
    }

    @Generated
    public String getFormatSignTopVoterSignRightClickMessage() {
        return this.formatSignTopVoterSignRightClickMessage;
    }

    @Generated
    public String getFormatTimeFormat() {
        return this.formatTimeFormat;
    }

    @Generated
    public String getFormatTopVoterAllTime() {
        return this.formatTopVoterAllTime;
    }

    @Generated
    public String getFormatTopVoterDaily() {
        return this.formatTopVoterDaily;
    }

    @Generated
    public String getFormatTopVoterMonthly() {
        return this.formatTopVoterMonthly;
    }

    @Generated
    public String getFormatTopVoterRewardMsg() {
        return this.formatTopVoterRewardMsg;
    }

    @Generated
    public String getFormatTopVoterWeekly() {
        return this.formatTopVoterWeekly;
    }

    @Generated
    public String getFormatUserNotExist() {
        return this.formatUserNotExist;
    }

    @Generated
    public String getFormatInvalidCommandVote() {
        return this.formatInvalidCommandVote;
    }

    @Generated
    public String getFormatInvalidCommandAdminVote() {
        return this.formatInvalidCommandAdminVote;
    }

    @Generated
    public boolean isGiveDefaultPermission() {
        return this.giveDefaultPermission;
    }

    @Generated
    public boolean isLoadTopVoterAllTime() {
        return this.loadTopVoterAllTime;
    }

    @Generated
    public boolean isLoadTopVoterMonthly() {
        return this.loadTopVoterMonthly;
    }

    @Generated
    public boolean isLoadTopVoterDaily() {
        return this.loadTopVoterDaily;
    }

    @Generated
    public boolean isLoadTopVoterWeekly() {
        return this.loadTopVoterWeekly;
    }

    @Generated
    public int getPointsOnVote() {
        return this.pointsOnVote;
    }

    @Generated
    public boolean isPurgeNoDataOnStartup() {
        return this.purgeNoDataOnStartup;
    }

    @Generated
    public boolean isStoreMonthTotalsWithDate() {
        return this.storeMonthTotalsWithDate;
    }

    @Generated
    public boolean isUseMonthDateTotalsAsPrimaryTotal() {
        return this.useMonthDateTotalsAsPrimaryTotal;
    }

    @Generated
    public String getRequestAPIDefaultMethod() {
        return this.requestAPIDefaultMethod;
    }

    @Generated
    public ArrayList<String> getRequestAPIDisabledMethods() {
        return this.requestAPIDisabledMethods;
    }

    @Generated
    public boolean isStoreTopVotersDaily() {
        return this.storeTopVotersDaily;
    }

    @Generated
    public boolean isStoreTopVotersWeekly() {
        return this.storeTopVotersWeekly;
    }

    @Generated
    public boolean isTopVoterAwardsTies() {
        return this.topVoterAwardsTies;
    }

    @Generated
    public boolean isTopVoterIgnorePermission() {
        return this.topVoterIgnorePermission;
    }

    @Generated
    public boolean isVoteRemindingEnabled() {
        return this.voteRemindingEnabled;
    }

    @Generated
    public int getVoteRemindingRemindDelay() {
        return this.voteRemindingRemindDelay;
    }

    @Generated
    public boolean isVoteRemindingRemindOnLogin() {
        return this.voteRemindingRemindOnLogin;
    }

    @Generated
    public boolean isVoteRemindingRemindOnlyOnce() {
        return this.voteRemindingRemindOnlyOnce;
    }

    @Generated
    public String getVoteTopDefault() {
        return this.voteTopDefault;
    }
}

