/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.tabcompleter;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandler;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class AliasesTabCompleter
implements TabCompleter {
    private boolean adminCommand;
    public CommandHandler cmdHandle;
    VotingPluginMain plugin = VotingPluginMain.plugin;

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] argsIn) {
        ArrayList<String> msgArray = new ArrayList<String>();
        msgArray.add("");
        for (String arg : argsIn) {
            msgArray.add(arg);
        }
        String[] args = ArrayUtils.convert(msgArray);
        ArrayList<String> tab = new ArrayList<String>();
        HashSet<String> cmds = new HashSet<String>();
        ArrayList<CommandHandler> cmdHandlers = new ArrayList<CommandHandler>();
        if (this.adminCommand) {
            cmdHandlers.addAll(this.plugin.getAdminVoteCommand());
        } else {
            cmdHandlers.addAll(this.plugin.getVoteCommand());
        }
        ConcurrentHashMap<String, ArrayList<String>> tabCompletes = TabCompleteHandler.getInstance().getTabCompleteOptions();
        for (CommandHandler cmdHandle : cmdHandlers) {
            if (cmdHandle.getArgs().length < argsIn.length) continue;
            for (String arg : cmdHandle.getArgs()[0].split("&")) {
                if (!cmd.getName().equalsIgnoreCase("vote" + arg) && !cmd.getName().equalsIgnoreCase("adminvote" + arg)) continue;
                args[0] = arg;
                boolean argsMatch = true;
                for (int i = 0; i < argsIn.length; ++i) {
                    if (args.length < i || cmdHandle.argsMatch(args[i], i)) continue;
                    argsMatch = false;
                }
                if (!argsMatch) continue;
                cmds.addAll(cmdHandle.getTabCompleteOptions(sender, args, argsIn.length, tabCompletes));
            }
        }
        for (String str : cmds) {
            if (!MessageAPI.startsWithIgnoreCase(str, args[args.length - 1])) continue;
            tab.add(str);
        }
        Collections.sort(tab, String.CASE_INSENSITIVE_ORDER);
        return tab;
    }

    public AliasesTabCompleter setCMDHandle(CommandHandler cmd, boolean adminCommand) {
        this.cmdHandle = cmd;
        this.adminCommand = adminCommand;
        return this;
    }
}

