/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.commands.gui.player.VoteURL;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VoteURLVoteSite
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;
    private String voteSite;

    public VoteURLVoteSite(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, String voteSite) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.voteSite = voteSite;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        return null;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
    }

    @Override
    public void onChest(Player player) {
        if (!this.plugin.isVoteSite(this.voteSite)) {
            player.sendMessage("Not a valid votesite");
            return;
        }
        final VoteSite site = this.plugin.getVoteSite(this.voteSite, true);
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteURLSiteName());
        inv.addPlaceholder("site", site.getDisplayName());
        inv.setMeta(player, "VoteSite", site);
        if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
            inv.dontClose();
        }
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.BOW).setName("&4URL").addLoreLine("Click to see URL")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                VoteSite site = (VoteSite)clickEvent.getMeta("VoteSite");
                clickEvent.getWhoClicked().sendMessage(site.getVoteURL());
            }
        });
        inv.addButton(new UpdatingBInventoryButton(this.plugin, new ItemBuilder(Material.COMPASS).setName("&4Next Vote").addLoreLine(this.user.voteCommandNextInfo(site)), 1000L, 1000L){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new VoteURL(VoteURLVoteSite.this.plugin, (CommandSender)clickEvent.getPlayer(), VoteURLVoteSite.this.user, true).open();
            }

            @Override
            public ItemBuilder onUpdate(Player arg0) {
                return new ItemBuilder(Material.COMPASS).setName("&4Next Vote").addLoreLine(VoteURLVoteSite.this.user.voteCommandNextInfo(site));
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.CLOCK).setName("&4Last Vote").addLoreLine(this.user.voteCommandLastLine(site))){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new VoteURL(VoteURLVoteSite.this.plugin, (CommandSender)clickEvent.getPlayer(), VoteURLVoteSite.this.user, true).open();
            }
        });
        if (this.plugin.getGui().isChestVoteURLBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHEST);
    }
}

