/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.bookgui.BookWrapper;
import com.bencodez.votingplugin.advancedcore.api.bookgui.Layout;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.MessageBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.xyz.upperlevel.spigot.book.BookUtil;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class VoteURL
extends GUIHandler {
    private boolean json;
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteURL(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, boolean json) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.json = json;
        if (user == null && player instanceof Player) {
            this.user = plugin.getVotingPluginUserManager().getVotingPluginUser((Player)player);
        }
        if (player != null && user != null && player.getName().equals(user.getPlayerName()) && plugin.getConfigFile().isUsePrimaryAccountForPlaceholders() && user.hasPrimaryAccount()) {
            user = plugin.getVotingPluginUserManager().getVotingPluginUser(user.getPrimaryAccount());
        }
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        return this.getChat(sender, false);
    }

    public ArrayList<String> getChat(CommandSender sender, boolean bypassCanVote) {
        ArrayList<String> sites = new ArrayList<String>();
        ArrayList<String> title = this.plugin.getConfigFile().getFormatCommandsVoteText();
        if (title != null) {
            sites.addAll(title);
        }
        if (this.plugin.getConfigFile().isFormatCommandsVoteAutoInputSites()) {
            int counter = 0;
            for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
                if (voteSite.isHidden() || !voteSite.getPermissionToView().isEmpty() && !sender.hasPermission(voteSite.getPermissionToView()) || this.plugin.getConfigFile().isFormatCommandsVoteOnlyShowSitesToVote() && !this.user.canVoteSite(voteSite) && !bypassCanVote) continue;
                String voteURL = voteSite.getVoteURL(this.json);
                MessageBuilder message = new MessageBuilder(this.plugin.getConfigFile().getFormatCommandsVoteURLS());
                message.replacePlaceholder("num", Integer.toString(++counter)).replacePlaceholder("url", voteURL).replacePlaceholder("SiteName", voteSite.getDisplayName());
                if (this.user != null && this.user.getPlayerName() != null) {
                    message.replacePlaceholder("player", "" + this.user.getPlayerName()).replacePlaceholder("Next", "" + this.user.voteCommandNextInfo(voteSite));
                }
                sites.add(message.colorize().getText());
            }
        }
        if (this.user != null) {
            HashMap<String, String> phs = new HashMap<String, String>();
            phs.put("DailyTotal", "" + this.user.getTotal(TopVoter.Daily));
            phs.put("WeekTotal", "" + this.user.getTotal(TopVoter.Weekly));
            phs.put("MonthTotal", "" + this.user.getTotal(TopVoter.Monthly));
            phs.put("Total", "" + this.user.getTotal(TopVoter.AllTime));
            sites = PlaceholderUtils.replacePlaceHolder(sites, phs);
        }
        return ArrayUtils.colorize(sites);
    }

    private ItemBuilder getItemAll() {
        int slot;
        ItemBuilder builderAll = new ItemBuilder(this.plugin.getGui().getChestVoteURLAlreadyVotedAllUrlsButtonItemSection());
        if (this.plugin.getGui().isChestVoteURLAllUrlsButtonrequireAllSitesVoted()) {
            if (this.user.canVoteAny()) {
                builderAll = new ItemBuilder(this.plugin.getGui().getChestVoteURLCanVoteAllUrlsButtonItemSection());
            }
        } else if (this.user.canVoteAll()) {
            builderAll = new ItemBuilder(this.plugin.getGui().getChestVoteURLCanVoteAllUrlsButtonItemSection());
        }
        if (!builderAll.hasCustomDisplayName()) {
            builderAll.setName("&4All Voting Sites");
        }
        if (!builderAll.hasCustomLore()) {
            builderAll.setLore("&cClick Me");
        }
        if ((slot = this.plugin.getGui().getChestVoteURLAllUrlsButtonSlot()) >= 0) {
            builderAll.setSlot(slot);
        }
        return builderAll;
    }

    private ItemBuilder getItemVoteSite(VoteSite voteSite) {
        ItemBuilder builder = new ItemBuilder(this.plugin.getGui().getChestVoteURLAlreadyVotedItemSection());
        if (this.user.canVoteSite(voteSite)) {
            builder = new ItemBuilder(this.plugin.getGui().getChestVoteURLCanVoteItemSection());
            builder.setName(this.plugin.getGui().getChestVoteURLGUISiteNameCanVote());
        } else {
            builder.setName(this.plugin.getGui().getChestVoteURLGUISiteName());
            builder.addLoreLine(this.plugin.getGui().getChestVoteURLNextVote());
        }
        builder.addPlaceholder("ServiceSite", voteSite.getServiceSite());
        builder.addPlaceholder("Name", voteSite.getDisplayName());
        builder.addPlaceholder("VoteDelay", "" + voteSite.getVoteDelay());
        builder.addPlaceholder("VoteHour", "" + voteSite.getVoteDelayDailyHour());
        builder.addPlaceholder("Info", this.user.voteCommandNextInfo(voteSite));
        return builder;
    }

    @Override
    public void onBook(Player player) {
        BookWrapper book = new BookWrapper(this.plugin.getGui().getBookVoteURLBookGUITitle());
        if (this.plugin.getGui().isBookVoteURLBookGUIManual()) {
            Layout layout = new Layout(this.plugin.getGui().getBookVoteURLBookGUITopLayout());
            book.addLayout(layout);
        }
        int i = 1;
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (site.isHidden() || !site.getPermissionToView().isEmpty() && !player.hasPermission(site.getPermissionToView())) continue;
            Layout layout = new Layout(this.plugin.getGui().getBookVoteURLBookGUILayout()).addPlaceholder("sitename", site.getDisplayName()).addPlaceholder("num", "" + i);
            String text = this.plugin.getGui().getBookVoteURLBookGUIAlreadyVotedText();
            ChatColor color = ChatColor.valueOf((String)this.plugin.getGui().getBookVoteURLBookGUIAlreadyVotedColor());
            if (this.user.canVoteSite(site)) {
                color = ChatColor.valueOf((String)this.plugin.getGui().getBookVoteURLBookGUICanVoteColor());
                text = this.plugin.getGui().getBookVoteURLBookGUICanVoteText();
            }
            String url = PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(site.getVoteURLJsonStrip(), "player", this.user.getPlayerName()), "num", "" + i);
            layout.replaceTextComponent("[UrlText]", BookUtil.TextBuilder.of(text).color(color).onClick(BookUtil.ClickAction.openUrl(url)).onHover(BookUtil.HoverAction.showText(url)).build());
            book.addLayout(layout);
            ++i;
        }
        book.open(player);
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteURLName());
        if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
            inv.dontClose();
        }
        for (final String str : this.plugin.getGui().getChestVoteURLExtraItems()) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteURLExtraItemsItem(str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteURL.this.plugin.getGui().getData(), "CHEST.VoteURL.ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getGui().isChestVoteURLViewAllUrlsButtonEnabled()) {
            ItemBuilder builderAll = this.getItemAll();
            inv.addButton(new UpdatingBInventoryButton(this.plugin, builderAll, 5000L, 5000L){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    event.closeInventory();
                    VotingPluginUser user = VoteURL.this.plugin.getVotingPluginUserManager().getVotingPluginUser(event.getPlayer());
                    VoteURL.this.json = true;
                    if (event.getClick().equals((Object)ClickType.SHIFT_LEFT) || event.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                        user.sendMessage(VoteURL.this.getChat((CommandSender)player, true));
                    } else {
                        user.sendMessage(VoteURL.this.getChat((CommandSender)player, false));
                    }
                }

                @Override
                public ItemBuilder onUpdate(Player player2) {
                    return VoteURL.this.getItemAll();
                }
            });
        }
        int startSlot = this.plugin.getGui().getChestVoteURLAllUrlsButtonStartSlot();
        for (final VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            if (voteSite.isHidden() || !voteSite.getPermissionToView().isEmpty() && !player.hasPermission(voteSite.getPermissionToView())) continue;
            ItemBuilder builder = this.getItemVoteSite(voteSite);
            if (startSlot >= 0) {
                if (inv.isSlotTaken(startSlot)) {
                    boolean found = false;
                    while (!found) {
                        if (inv.isSlotTaken(++startSlot)) continue;
                        found = true;
                    }
                }
                builder.setSlot(startSlot);
                ++startSlot;
            }
            inv.addButton(new UpdatingBInventoryButton(this.plugin, builder, 5000L, 5000L){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    event.closeInventory();
                    Player player = event.getPlayer();
                    if (player != null) {
                        VotingPluginUser user = VoteURL.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("voteurl", voteSite.getVoteURL());
                        placeholders.put("sitename", voteSite.getDisplayName());
                        placeholders.put("player", player.getName());
                        placeholders.put("servicesite", voteSite.getServiceSite());
                        placeholders.put("VoteDelay", "" + voteSite.getVoteDelay());
                        placeholders.put("VoteHour", "" + voteSite.getVoteDelayDailyHour());
                        user.sendMessage(VoteURL.this.plugin.getGui().getChestVoteURLURLText(), placeholders);
                    }
                }

                @Override
                public ItemBuilder onUpdate(Player player) {
                    return VoteURL.this.getItemVoteSite(voteSite);
                }
            });
        }
        if (this.plugin.getGui().isChestVoteURLBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodURL().toUpperCase()));
    }
}

