/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteTotal
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteTotal(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        ArrayList<String> msg = new ArrayList<String>();
        int daily = this.user.getTotal(TopVoter.Daily);
        int weekly = this.user.getTotal(TopVoter.Weekly);
        int month = this.user.getTotal(TopVoter.Monthly);
        int all = this.user.getTotal(TopVoter.AllTime);
        for (String s : this.plugin.getConfigFile().getFormatCommandsVoteTotal()) {
            String str = MessageAPI.replaceIgnoreCase(s, "%DailyTotal%", "" + daily);
            str = MessageAPI.replaceIgnoreCase(str, "%WeeklyTotal%", "" + weekly);
            str = MessageAPI.replaceIgnoreCase(str, "%MonthlyTotal%", "" + month);
            str = MessageAPI.replaceIgnoreCase(str, "%AllTimeTotal%", "" + all);
            str = MessageAPI.replaceIgnoreCase(str, "%player%", this.user.getPlayerName());
            msg.add(str);
        }
        return ArrayUtils.colorize(msg);
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteTotalName());
        inv.addPlaceholder("player", this.user.getPlayerName());
        for (final TopVoter top : TopVoter.values()) {
            inv.addButton(new UpdatingBInventoryButton(this.plugin, new ItemBuilder(this.plugin.getGui().getChestVoteTotalItem(top)).addPlaceholder("Total", "" + this.user.getTotal(top)).addPlaceholder("topvoter", top.getName()), 1000L, 1000L){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                }

                @Override
                public ItemBuilder onUpdate(Player arg0) {
                    return new ItemBuilder(VoteTotal.this.plugin.getGui().getChestVoteTotalItem(top)).addPlaceholder("Total", "" + VoteTotal.this.user.getTotal(top)).addPlaceholder("topvoter", top.getName()).addPlaceholder("player", VoteTotal.this.user.getPlayerName());
                }
            });
        }
        final String guiPath = "VoteTotal";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteTotal.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getGui().isChestVoteTotalBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodTotal().toUpperCase()));
    }
}

