/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.commands.gui.player.VoteGUI;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class VoteTopVoterPreviousMonths
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;
    private int index = -1;

    public VoteTopVoterPreviousMonths(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, int index) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.index = index;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        return null;
    }

    public void next(int index) {
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
    }

    @Override
    public void onChest(final Player player) {
        Set<YearMonth> months = this.plugin.getPreviousMonthsTopVoters().keySet();
        List yearMonthList = months.stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        YearMonth yearMonth = null;
        if (this.index < 0) {
            if (!yearMonthList.isEmpty()) {
                yearMonth = (YearMonth)yearMonthList.get(0);
            }
            player.sendMessage(ChatColor.RED + "Can't open previous months, no data");
            return;
        }
        if (yearMonthList.size() <= this.index) {
            player.sendMessage(ChatColor.RED + "Can't open previous months, no data for requested index");
            return;
        }
        yearMonth = (YearMonth)yearMonthList.get(this.index);
        Set<Map.Entry<TopVoterPlayer, Integer>> users = null;
        if (!this.plugin.getPreviousMonthsTopVoters().containsKey(yearMonth)) {
            player.sendMessage(ChatColor.RED + "Can't open previous months, no data");
            return;
        }
        users = this.plugin.getPreviousMonthsTopVoters().get(yearMonth).entrySet();
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteTopName());
        inv.addPlaceholder("topvoter", yearMonth.toString());
        if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
            inv.dontClose();
        }
        int pos = 1;
        for (Map.Entry<TopVoterPlayer, Integer> entry : users) {
            ItemBuilder playerItem = this.plugin.getGui().isChestVoteTopUseSkull() ? new ItemBuilder(entry.getKey().getPlayerHead()) : new ItemBuilder(Material.valueOf((String)this.plugin.getGui().getChestVoteTopPlayerItemMaterial()));
            playerItem.setLore(new ArrayList<String>());
            inv.addButton(new BInventoryButton(playerItem.setName(this.plugin.getGui().getChestVoteTopItemName()).addLoreLine(this.plugin.getGui().getChestVoteTopItemLore()).addPlaceholder("position", "" + pos).addPlaceholder("player", entry.getKey().getPlayerName()).addPlaceholder("votes", "" + entry.getValue())){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    TopVoterPlayer user = (TopVoterPlayer)this.getData("User");
                    new VoteGUI(VoteTopVoterPreviousMonths.this.plugin, (CommandSender)player, user.getUser()).open(GUIMethod.valueOf(VoteTopVoterPreviousMonths.this.plugin.getGui().getGuiMethodGUI().toUpperCase()));
                }
            }.addData("player", entry.getKey().getPlayerName()).addData("User", entry.getKey()));
            ++pos;
        }
        inv.getPageButtons().add(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteTopSwitchItem()).addPlaceholder("Top", yearMonth.toString())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                if (!clickEvent.getClick().equals((Object)ClickType.RIGHT)) {
                    new VoteTopVoterPreviousMonths(VoteTopVoterPreviousMonths.this.plugin, (CommandSender)player, VoteTopVoterPreviousMonths.this.user, VoteTopVoterPreviousMonths.this.index + 1).open(GUIMethod.CHEST);
                } else {
                    new VoteTopVoterPreviousMonths(VoteTopVoterPreviousMonths.this.plugin, (CommandSender)player, VoteTopVoterPreviousMonths.this.user, VoteTopVoterPreviousMonths.this.index - 1).open(GUIMethod.CHEST);
                }
            }
        });
        if (this.plugin.getGui().isChestVoteTopBackButton()) {
            inv.getPageButtons().add(this.plugin.getCommandLoader().getBackButton(this.user).setSlot(1));
        }
        inv.setPages(true);
        inv.setMaxInvSize(this.plugin.getGui().getChestVoteTopSize());
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHEST);
    }
}

