/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.commands.gui.player.VoteGUI;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class VoteTopVoter
extends GUIHandler {
    private int page;
    private VotingPluginMain plugin;
    private TopVoter top;
    private VotingPluginUser user;

    public VoteTopVoter(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, TopVoter top, int page) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.top = top;
        this.page = page;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        switch (this.top) {
            case AllTime: {
                return ArrayUtils.convert(this.plugin.getTopVoterHandler().topVoterAllTime(this.page));
            }
            case Daily: {
                return ArrayUtils.convert(this.plugin.getTopVoterHandler().topVoterDaily(this.page));
            }
            case Monthly: {
                return ArrayUtils.convert(this.plugin.getTopVoterHandler().topVoterMonthly(this.page));
            }
            case Weekly: {
                return ArrayUtils.convert(this.plugin.getTopVoterHandler().topVoterWeekly(this.page));
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        try {
            if (this.top == null) {
                this.top = TopVoter.getDefault();
            }
            Set users = null;
            String topVoter = this.top.getName();
            LinkedHashMap topVotes = (LinkedHashMap)this.plugin.getTopVoter(this.top).clone();
            users = topVotes.entrySet();
            ConfigurationSection customization = this.plugin.getGui().getChestVoteTopCustomization();
            boolean customzationEnabled = false;
            ConcurrentLinkedQueue playerSlots = new ConcurrentLinkedQueue();
            if (customization != null) {
                customzationEnabled = customization.getBoolean("Enabled");
                List customizationPlayerSlots = customization.getIntegerList("PlayerSlots");
                playerSlots.addAll(customizationPlayerSlots);
            }
            BInventory inv = new BInventory(this.plugin.getGui().getChestVoteTopName());
            inv.addPlaceholder("topvoter", topVoter);
            if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
                inv.dontClose();
            }
            int pos = 1;
            for (Map.Entry entry : users) {
                Object playerItem = new ItemBuilder(Material.PAPER);
                playerItem = this.plugin.getGui().isChestVoteTopUseSkull() ? new ItemBuilder(((TopVoterPlayer)entry.getKey()).getPlayerHead()) : new ItemBuilder(Material.valueOf((String)this.plugin.getGui().getChestVoteTopPlayerItemMaterial()));
                ((ItemBuilder)playerItem).setLore(new ArrayList<String>());
                BInventoryButton button = new BInventoryButton(((ItemBuilder)playerItem).setName(this.plugin.getGui().getChestVoteTopItemName()).addLoreLine(this.plugin.getGui().getChestVoteTopItemLore()).addPlaceholder("position", "" + pos).addPlaceholder("player", ((TopVoterPlayer)entry.getKey()).getPlayerName()).addPlaceholder("votes", "" + entry.getValue())){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        if (VoteTopVoter.this.plugin.getGui().isChestVoteTopOpenMainGUIOnClick()) {
                            TopVoterPlayer user = (TopVoterPlayer)this.getData("User");
                            new VoteGUI(VoteTopVoter.this.plugin, (CommandSender)player, user.getUser()).open(GUIMethod.valueOf(VoteTopVoter.this.plugin.getGui().getGuiMethodGUI().toUpperCase()));
                        }
                    }
                }.addData("player", ((TopVoterPlayer)entry.getKey()).getPlayerName()).addData("User", entry.getKey());
                if (customzationEnabled && !playerSlots.isEmpty()) {
                    button.setSlot((Integer)playerSlots.remove());
                }
                inv.setCloseInv(this.plugin.getGui().isChestVoteTopCloseGUIOnClick());
                inv.addButton(button);
                ++pos;
            }
            TopVoter newTops = this.top;
            ArrayList<String> tops = this.plugin.getGui().getChestVoteTopSwitchItemTopVoters();
            if (!tops.isEmpty()) {
                for (String name : tops) {
                    newTops.getSwitchItems().add(TopVoter.getTopVoter(name));
                }
            }
            final TopVoter cur = newTops;
            if (!customzationEnabled) {
                inv.getPageButtons().add(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteTopSwitchItem()).addPlaceholder("Top", topVoter)){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        if (!clickEvent.getClick().equals((Object)ClickType.RIGHT)) {
                            new VoteTopVoter(VoteTopVoter.this.plugin, (CommandSender)player, VoteTopVoter.this.user, cur.next(), 0).open(GUIMethod.CHEST);
                        } else {
                            new VoteTopVoter(VoteTopVoter.this.plugin, (CommandSender)player, VoteTopVoter.this.user, cur.prev(), 0).open(GUIMethod.CHEST);
                        }
                    }
                });
            } else {
                inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteTopSwitchItem()).addPlaceholder("Top", topVoter)){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        if (!clickEvent.getClick().equals((Object)ClickType.RIGHT)) {
                            new VoteTopVoter(VoteTopVoter.this.plugin, (CommandSender)player, VoteTopVoter.this.user, cur.next(), 0).open(GUIMethod.CHEST);
                        } else {
                            new VoteTopVoter(VoteTopVoter.this.plugin, (CommandSender)player, VoteTopVoter.this.user, cur.prev(), 0).open(GUIMethod.CHEST);
                        }
                    }
                });
            }
            if (this.plugin.getGui().isChestVoteTopBackButton()) {
                if (customzationEnabled) {
                    inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user).setSlot(customization.getInt("BackButtonSlot", 0)));
                } else {
                    inv.getPageButtons().add(this.plugin.getCommandLoader().getBackButton(this.user).setSlot(1));
                }
            }
            final String guiPath = "VoteTop.Customization";
            for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
                inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        VoteTopVoter.this.plugin.getCommandLoader().processSlotClick(player, VoteTopVoter.this.user, str);
                        new RewardBuilder((ConfigurationSection)VoteTopVoter.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + ".Rewards").setGiveOffline(false).send(clickEvent.getPlayer());
                    }
                });
            }
            if (customization == null || !customzationEnabled || !customization.getBoolean("RemoveBottomBar")) {
                inv.setPages(true);
            }
            inv.setMaxInvSize(this.plugin.getGui().getChestVoteTopSize());
            inv.openInventory(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodTopVoter().toUpperCase()));
    }
}

