/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.commands.gui.player.VoteGUI;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.nms.NMSManager;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteToday
extends GUIHandler {
    private int page;
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteToday(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, int page) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.page = page;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        if (this.page < 1) {
            this.page = 1;
        }
        ArrayList<String> msg = new ArrayList<String>();
        String[] voteToday = this.voteToday();
        int maxPage = voteToday.length / pagesize;
        if (voteToday.length % pagesize != 0) {
            ++maxPage;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("page", "" + this.page);
        placeholders.put("maxpage", "" + maxPage);
        for (String m : this.plugin.getConfigFile().getFormatCommandsVoteTodayTitle()) {
            msg.add(m);
        }
        --this.page;
        for (int i = pagesize * this.page; i < voteToday.length && i < (this.page + 1) * pagesize; ++i) {
            msg.add(voteToday[i]);
        }
        return ArrayUtils.colorize(PlaceholderUtils.replacePlaceHolder(msg, placeholders));
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteTodayName());
        if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
            inv.dontClose();
        }
        for (TopVoterPlayer user : this.plugin.getVoteToday().keySet()) {
            for (VoteSite voteSite : this.plugin.getVoteToday().get(user).keySet()) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfigFile().getFormatTimeFormat());
                String timeString = this.plugin.getVoteToday().get(user).get(voteSite).format(formatter);
                String msg = this.plugin.getGui().getChestVoteTodayLine();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("VoteSite", voteSite.getDisplayName());
                placeholders.put("Time", timeString);
                msg = PlaceholderUtils.replacePlaceHolder(msg, placeholders);
                ItemBuilder item = null;
                item = this.plugin.getGui().isChestVoteTodayUseSkull() && !NMSManager.getInstance().isVersion("1.12") ? new ItemBuilder(user.getPlayerHead()) : new ItemBuilder(this.plugin.getGui().getChestVoteTodayPlayerItem());
                item.setName(PlaceholderUtils.replacePlaceHolder(this.plugin.getGui().getChestVoteTodayIconTitle(), "player", user.getPlayerName()));
                item.setLore(msg);
                final UUID uuid = user.getUuid();
                inv.addButton(inv.getNextSlot(), new BInventoryButton(item){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        VotingPluginUser user = VoteToday.this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid);
                        new VoteGUI(VoteToday.this.plugin, (CommandSender)player, user).open(GUIMethod.valueOf(VoteToday.this.plugin.getGui().getGuiMethodGUI().toUpperCase()));
                    }
                });
            }
        }
        final String guiPath = "VoteToday";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteToday.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getGui().isChestVoteTodayBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodToday().toUpperCase()));
    }

    public String[] voteToday() {
        ArrayList<String> msg = new ArrayList<String>();
        for (TopVoterPlayer user : this.plugin.getVoteToday().keySet()) {
            for (VoteSite voteSite : this.plugin.getVoteToday().get(user).keySet()) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfigFile().getFormatTimeFormat());
                String timeString = this.plugin.getVoteToday().get(user).get(voteSite).format(formatter);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", user.getPlayerName());
                placeholders.put("votesite", voteSite.getKey());
                placeholders.put("sitename", voteSite.getDisplayName());
                placeholders.put("time", timeString);
                msg.add(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteTodayLine(), placeholders));
            }
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] voteTodayGUI() {
        ArrayList<String> msg = new ArrayList<String>();
        for (TopVoterPlayer user : this.plugin.getVoteToday().keySet()) {
            LocalDateTime mostRecent = null;
            VoteSite mostRecentSite = null;
            for (Map.Entry<VoteSite, LocalDateTime> entry : this.plugin.getVoteToday().get(user).entrySet()) {
                if (mostRecent != null && !entry.getValue().isAfter(mostRecent)) continue;
                mostRecent = entry.getValue();
                mostRecentSite = entry.getKey();
            }
            if (mostRecent == null) continue;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfigFile().getFormatTimeFormat());
            String timeString = mostRecent.format(formatter);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", user.getPlayerName());
            placeholders.put("votesite", mostRecentSite.getKey());
            placeholders.put("sitename", mostRecentSite.getDisplayName());
            placeholders.put("time", timeString);
            msg.add(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteTodayLine(), placeholders));
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }
}

