/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteStreak
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteStreak(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add(this.plugin.getConfigFile().getFormatCommandsVoteStreakTitle());
        msg.addAll(this.plugin.getConfigFile().getFormatCommandsVoteStreakLines());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("DailyStreak", "" + this.user.getDayVoteStreak());
        placeholders.put("WeeklyStreak", "" + this.user.getWeekVoteStreak());
        placeholders.put("MonthlyStreak", "" + this.user.getMonthVoteStreak());
        placeholders.put("BestDailyStreak", "" + this.user.getBestDayVoteStreak());
        placeholders.put("BestWeeklyStreak", "" + this.user.getBestWeekVoteStreak());
        placeholders.put("BestMonthlyStreak", "" + this.user.getBestMonthVoteStreak());
        placeholders.put("player", this.user.getPlayerName());
        msg = PlaceholderUtils.replacePlaceHolder(msg, placeholders);
        return ArrayUtils.colorize(msg);
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteStreakName());
        inv.addPlaceholder("player", this.user.getPlayerName());
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteStreakCurrentDayStreakItem()).addPlaceholder("Streak", "" + this.user.getDayVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteStreakCurrentWeekStreakItem()).addPlaceholder("Streak", "" + this.user.getWeekVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteStreakCurrentMonthStreakItem()).addPlaceholder("Streak", "" + this.user.getMonthVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteStreakHighestDayStreakItem()).addPlaceholder("Streak", "" + this.user.getBestDayVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteStreakHighestWeekStreakItem()).addPlaceholder("Streak", "" + this.user.getBestWeekVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteStreakHighestMonthStreakItem()).addPlaceholder("Streak", "" + this.user.getBestMonthVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        final String guiPath = "VoteStreak";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteStreak.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getGui().isChestVoteStreakBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodStreak().toUpperCase()));
    }
}

