/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.commands.gui.player.VoteShop;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteShopConfirm
extends GUIHandler {
    private String identifier;
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteShopConfirm(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, String identifier) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.identifier = identifier;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        return null;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
    }

    @Override
    public void onChest(final Player player) {
        PlayerUtils.setPlayerMeta(this.plugin, player, "ident", this.identifier);
        BInventory inv = new BInventory(this.plugin.getShopFile().getShopConfirmPurchaseTitle());
        inv.dontClose();
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getShopFile().getShopConfirmPurchaseYesItem())){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                VoteShopConfirm.this.user.cache();
                int points = VoteShopConfirm.this.plugin.getShopFile().getShopIdentifierCost(VoteShopConfirm.this.identifier);
                int limit = VoteShopConfirm.this.plugin.getShopFile().getShopIdentifierLimit(VoteShopConfirm.this.identifier);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("identifier", VoteShopConfirm.this.identifier);
                placeholders.put("points", "" + points);
                placeholders.put("limit", "" + limit);
                if (VoteShopConfirm.this.user.removePoints(points, true)) {
                    VoteShopConfirm.this.plugin.getLogger().info("VoteShop: " + VoteShopConfirm.this.user.getPlayerName() + "/" + VoteShopConfirm.this.user.getUUID() + " bought " + VoteShopConfirm.this.identifier + " for " + points);
                    if (VoteShopConfirm.this.plugin.getConfigFile().isTrackShopPurchases()) {
                        VoteShopConfirm.this.plugin.getServerData().addVoteShopPurchase(VoteShopConfirm.this.identifier);
                    }
                    VoteShopConfirm.this.plugin.getRewardHandler().giveReward(VoteShopConfirm.this.user, (ConfigurationSection)VoteShopConfirm.this.plugin.getShopFile().getData(), VoteShopConfirm.this.plugin.getShopFile().getShopIdentifierRewardsPath(VoteShopConfirm.this.identifier), new RewardOptions().setPlaceholders(placeholders));
                    VoteShopConfirm.this.user.sendMessage(PlaceholderUtils.replacePlaceHolder(VoteShopConfirm.this.plugin.getShopFile().getVoteShopPurchase(VoteShopConfirm.this.identifier), placeholders));
                    if (limit > 0) {
                        VoteShopConfirm.this.user.setVoteShopIdentifierLimit(VoteShopConfirm.this.identifier, VoteShopConfirm.this.user.getVoteShopIdentifierLimit(VoteShopConfirm.this.identifier) + 1);
                    }
                } else {
                    VoteShopConfirm.this.user.sendMessage(PlaceholderUtils.replacePlaceHolder(VoteShopConfirm.this.plugin.getConfigFile().getFormatShopFailedMsg(), placeholders));
                }
                if (VoteShopConfirm.this.plugin.getShopFile().getVoteShopCloseGUI(VoteShopConfirm.this.identifier)) {
                    event.getButton().getInv().closeInv(player, null);
                } else {
                    new VoteShop(VoteShopConfirm.this.plugin, (CommandSender)event.getPlayer(), VoteShopConfirm.this.user).open();
                }
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getShopFile().getShopConfirmPurchaseNoItem())){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                if (VoteShopConfirm.this.plugin.getShopFile().getVoteShopCloseGUI(VoteShopConfirm.this.identifier)) {
                    event.getButton().getInv().closeInv(player, null);
                } else {
                    new VoteShop(VoteShopConfirm.this.plugin, (CommandSender)event.getPlayer(), VoteShopConfirm.this.user).open();
                }
            }
        });
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHEST);
    }
}

