/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.commands.gui.player.VoteShopConfirm;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VoteShop
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteShop(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        return null;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
    }

    @Override
    public void onChest(final Player player) {
        if (!this.plugin.getShopFile().isVoteShopEnabled()) {
            player.sendMessage(MessageAPI.colorize(this.plugin.getShopFile().getVoteShopDisabled()));
            return;
        }
        if (this.user == null) {
            this.user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
        }
        final VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
        BInventory inv = new BInventory(this.plugin.getShopFile().getVoteShopName());
        inv.addPlaceholder("points", "" + user.getPoints());
        inv.addPlaceholder("sitesavailable", "" + user.getSitesNotVotedOn());
        inv.dontClose();
        for (String identifier : this.plugin.getShopFile().getShopIdentifiers()) {
            ItemBuilder builder;
            String perm = this.plugin.getShopFile().getVoteShopPermission(identifier);
            boolean hasPerm = false;
            if (perm.isEmpty()) {
                hasPerm = true;
            } else {
                String p = "";
                if (perm.startsWith("!")) {
                    p = PlaceholderUtils.replacePlaceHolders(player, perm.substring(1));
                    hasPerm = !player.hasPermission(p);
                } else {
                    p = PlaceholderUtils.replacePlaceHolders(player, perm);
                    hasPerm = player.hasPermission(p);
                }
                if (!hasPerm) {
                    this.plugin.extraDebug("VoteShop: " + player.getName() + "/" + player.getUniqueId() + " does not have permission `" + p + "` for " + identifier);
                }
            }
            int limit = this.plugin.getShopFile().getShopIdentifierLimit(identifier);
            boolean limitPass = true;
            if (limit > 0 && user.getVoteShopIdentifierLimit(identifier) >= limit) {
                limitPass = false;
            }
            if (!this.plugin.getShopFile().getVoteShopNotBuyable(identifier)) {
                if (!hasPerm && this.plugin.getShopFile().getVoteShopHideOnNoPermission(identifier) || !limitPass && this.plugin.getShopFile().isVoteShopHideLimitedReached()) continue;
                builder = new ItemBuilder(this.plugin.getShopFile().getShopIdentifierSection(identifier));
                inv.addButton(new BInventoryButton(builder){

                    @Override
                    public void onClick(BInventory.ClickEvent event) {
                        final Player player = event.getWhoClicked();
                        final VotingPluginUser user = VoteShop.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
                        if (VoteShop.this.plugin.getConfigFile().isExtraVoteShopCheck()) {
                            user.cache();
                        }
                        final String identifier = (String)this.getData("identifier");
                        int limit = (Integer)this.getData("Limit");
                        int points = VoteShop.this.plugin.getShopFile().getShopIdentifierCost(identifier);
                        if (identifier != null) {
                            boolean limitPass = true;
                            if (limit > 0 && user.getVoteShopIdentifierLimit(identifier) >= limit) {
                                limitPass = false;
                            }
                            if (limitPass) {
                                if (!VoteShop.this.plugin.getShopFile().isVoteShopRequireConfirmation(identifier)) {
                                    HashMap<String, String> placeholders = new HashMap<String, String>();
                                    placeholders.put("identifier", VoteShop.this.plugin.getShopFile().getShopIdentifierIdentifierName(identifier));
                                    placeholders.put("points", "" + points);
                                    placeholders.put("limit", "" + limit);
                                    if (user.removePoints(points, true)) {
                                        VoteShop.this.plugin.getLogger().info("VoteShop: " + user.getPlayerName() + "/" + user.getUUID() + " bought " + identifier + " for " + points);
                                        if (VoteShop.this.plugin.getConfigFile().isTrackShopPurchases()) {
                                            VoteShop.this.plugin.getServerData().addVoteShopPurchase(identifier);
                                        }
                                        VoteShop.this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)VoteShop.this.plugin.getShopFile().getData(), VoteShop.this.plugin.getShopFile().getShopIdentifierRewardsPath(identifier), new RewardOptions().setPlaceholders(placeholders));
                                        user.sendMessage(PlaceholderUtils.replacePlaceHolder(VoteShop.this.plugin.getShopFile().getVoteShopPurchase(identifier), placeholders));
                                        if (limit > 0) {
                                            user.setVoteShopIdentifierLimit(identifier, user.getVoteShopIdentifierLimit(identifier) + 1);
                                        }
                                    } else {
                                        user.sendMessage(PlaceholderUtils.replacePlaceHolder(VoteShop.this.plugin.getConfigFile().getFormatShopFailedMsg(), placeholders));
                                    }
                                } else {
                                    VoteShop.this.plugin.getBukkitScheduler().runTask((Plugin)VoteShop.this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            new VoteShopConfirm(VoteShop.this.plugin, (CommandSender)player, user, identifier).open(GUIMethod.CHEST);
                                        }
                                    });
                                }
                            } else {
                                user.sendMessage(VoteShop.this.plugin.getShopFile().getVoteShopLimitReached());
                            }
                            VoteShop.this.plugin.getCommandLoader().processSlotClick(player, user, identifier);
                            if (VoteShop.this.plugin.getShopFile().isVoteShopReopenGUIOnPurchase()) {
                                VoteShop.this.plugin.getCommandLoader().processSlotClick(player, user, "shop");
                            }
                        }
                    }
                }.addData("identifier", identifier).addData("Limit", limit));
                continue;
            }
            if (!hasPerm) continue;
            builder = new ItemBuilder(this.plugin.getShopFile().getShopIdentifierSection(identifier));
            inv.addButton(new BInventoryButton(builder){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    user.sendMessage(VoteShop.this.plugin.getConfigFile().getFormatShopNotPurchasable());
                }
            }.addData("identifier", identifier).addData("Limit", limit));
        }
        for (final String str : this.plugin.getShopFile().getVoteShopExtraItems()) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getShopFile().getGUIVoteShopExtraItems(str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    VoteShop.this.plugin.getCommandLoader().processSlotClick(player, user, str);
                    new RewardBuilder((ConfigurationSection)VoteShop.this.plugin.getShopFile().getData(), "ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getShopFile().isVoteShopBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHEST);
    }
}

