/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.bookgui.BookWrapper;
import com.bencodez.votingplugin.advancedcore.api.bookgui.Layout;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.xyz.upperlevel.spigot.book.BookUtil;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteNext
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteNext(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        String playerName = this.user.getPlayerName();
        msg.add(MessageAPI.colorize(MessageAPI.replaceIgnoreCase(this.plugin.getConfigFile().getFormatCommandsVoteNextTitle(), "%player%", playerName)));
        for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            if (voteSite.isHidden()) continue;
            String msgLine = this.plugin.getConfigFile().getFormatCommandsVoteNextLayout();
            msgLine = MessageAPI.replaceIgnoreCase(msgLine, "%info%", this.user.voteCommandNextInfo(voteSite));
            msgLine = MessageAPI.replaceIgnoreCase(msgLine, "%SiteName%", voteSite.getDisplayName());
            msg.add(MessageAPI.colorize(msgLine));
        }
        return msg;
    }

    @Override
    public void onBook(Player player) {
        BookWrapper book = new BookWrapper(this.plugin.getGui().getBookVoteURLBookGUITitle());
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (site.isHidden()) continue;
            Layout nextLayout = new Layout(new ArrayList<String>(Arrays.asList("[Json]")));
            nextLayout.replaceTextComponent("[Json]", BookUtil.TextBuilder.of(book.colorize(site.getDisplayName())).onClick(BookUtil.ClickAction.openUrl(site.getVoteURLJsonStrip())).onHover(BookUtil.HoverAction.showText(this.user.voteCommandNextInfo(site))).build());
            book.addLayout(nextLayout);
        }
        book.addLine();
        book.open(player);
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteNextName());
        inv.addPlaceholder("player", this.user.getPlayerName());
        for (final VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (site.isHidden()) continue;
            String siteNameDisplay = this.plugin.getGui().getChestVoteNextCustomSiteNamesDisplays(site.getKey());
            if (siteNameDisplay.isEmpty()) {
                siteNameDisplay = site.getDisplayName();
            }
            inv.addButton(inv.getNextSlot(), new UpdatingBInventoryButton(this.plugin, site.getItem().setName(siteNameDisplay).setLore(PlaceholderUtils.replacePlaceHolder(this.plugin.getGui().getChestVoteNextLine(), "time", this.user.voteCommandNextInfo(site))).setAmountNone(1), 1000L, 1000L){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                }

                @Override
                public ItemBuilder onUpdate(Player player) {
                    return site.getItem().setName(site.getDisplayName()).setLore(VoteNext.this.user.voteCommandNextInfo(site)).setAmountNone(1).addPlaceholder("player", VoteNext.this.user.getPlayerName());
                }
            });
        }
        final String guiPath = "VoteNext";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteNext.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getGui().isChestVoteNextBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodNext().toUpperCase()));
    }
}

