/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteLast
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteLast(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        String playerName = this.user.getPlayerName();
        msg.add(MessageAPI.replaceIgnoreCase(this.plugin.getConfigFile().getFormatCommandsVoteLastTitle(), "%player%", playerName));
        for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            if (voteSite.isHidden()) continue;
            msg.add(this.user.voteCommandLastLine(voteSite));
        }
        return ArrayUtils.colorize(msg);
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteLastName());
        inv.addPlaceholder("player", this.user.getPlayerName());
        for (final VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (site.isHidden()) continue;
            inv.addButton(inv.getNextSlot(), new UpdatingBInventoryButton(this.plugin, site.getItem().setName(site.getDisplayName()).setLore(this.user.voteCommandLastGUILine(site)).setAmountNone(1), 1000L, 1000L){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    Player player;
                    if (VoteLast.this.plugin.getGui().isChestVoteLastClickableLinks() && (player = event.getPlayer()) != null) {
                        VotingPluginUser user = VoteLast.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
                        user.sendMessage(PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(VoteLast.this.plugin.getGui().getChestVoteURLURLText(), "voteurl", site.getVoteURL()), "sitename", site.getDisplayName()), "player", player.getName()));
                    }
                }

                @Override
                public ItemBuilder onUpdate(Player p) {
                    return site.getItem().setName(site.getDisplayName()).setLore(VoteLast.this.user.voteCommandLastGUILine(site)).setAmountNone(1);
                }
            });
        }
        final String guiPath = "VoteLast";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteLast.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        if (this.plugin.getGui().isChestVoteLastBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodLast().toUpperCase()));
    }
}

