/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.nms.NMSManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VoteHelp
extends GUIHandler {
    private int page;
    private VotingPluginMain plugin;

    public VoteHelp(VotingPluginMain plugin, CommandSender player, int page) {
        super(plugin, player);
        this.plugin = plugin;
        this.page = page;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        return null;
    }

    public ArrayList<TextComponent> helpText(CommandSender sender) {
        ArrayList<TextComponent> msg = new ArrayList<TextComponent>();
        HashMap<String, TextComponent> unsorted = new HashMap<String, TextComponent>();
        boolean requirePerms = this.plugin.getConfigFile().isFormatCommandsVoteHelpRequirePermission();
        String colorStr = this.plugin.getConfigFile().getFormatCommandsVoteHelpHoverColor();
        ChatColor hoverColor = null;
        try {
            hoverColor = ChatColor.of((String)colorStr);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get color for hover help message");
            e.printStackTrace();
            hoverColor = ChatColor.AQUA;
        }
        for (CommandHandler cmdHandle : this.plugin.getVoteCommand()) {
            if (requirePerms && !cmdHandle.hasPerm(sender)) continue;
            unsorted.put(cmdHandle.getHelpLineCommand("/vote"), cmdHandle.getHelpLine("/vote", this.plugin.getConfigFile().getFormatCommandsVoteHelpLine(), hoverColor));
        }
        ArrayList unsortedList = new ArrayList();
        unsortedList.addAll(unsorted.keySet());
        Collections.sort(unsortedList, String.CASE_INSENSITIVE_ORDER);
        for (String cmd : unsortedList) {
            msg.add((TextComponent)unsorted.get(cmd));
        }
        return msg;
    }

    public ArrayList<TextComponent> helpTextLegacy(CommandSender sender) {
        ArrayList<TextComponent> msg = new ArrayList<TextComponent>();
        HashMap<String, TextComponent> unsorted = new HashMap<String, TextComponent>();
        boolean requirePerms = this.plugin.getConfigFile().isFormatCommandsVoteHelpRequirePermission();
        for (CommandHandler cmdHandle : this.plugin.getVoteCommand()) {
            if (requirePerms && !cmdHandle.hasPerm(sender)) continue;
            unsorted.put(cmdHandle.getHelpLineCommand("/vote"), cmdHandle.getHelpLine("/vote", this.plugin.getConfigFile().getFormatCommandsVoteHelpLine()));
        }
        ArrayList unsortedList = new ArrayList();
        unsortedList.addAll(unsorted.keySet());
        Collections.sort(unsortedList, String.CASE_INSENSITIVE_ORDER);
        for (String cmd : unsortedList) {
            msg.add((TextComponent)unsorted.get(cmd));
        }
        return msg;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessageJson(this.voteHelpText(sender));
    }

    @Override
    public void onChest(Player player) {
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHAT);
    }

    public ArrayList<TextComponent> voteHelpText(CommandSender sender) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        ArrayList<TextComponent> msg = new ArrayList<TextComponent>();
        ArrayList<Object> text = new ArrayList();
        text = NMSManager.getInstance().isVersion("1.12") ? this.helpTextLegacy(sender) : this.helpText(sender);
        int maxPage = text.size() / pagesize;
        if (text.size() % pagesize != 0) {
            ++maxPage;
        }
        msg.add(MessageAPI.stringToComp(this.plugin.getConfigFile().getFormatCommandsVoteHelpTitle() + " " + this.page + "/" + maxPage));
        for (int i = pagesize * (this.page - 1); i < text.size() && i < this.page * pagesize; ++i) {
            msg.add((TextComponent)text.get(i));
        }
        return msg;
    }
}

