/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.UpdatingBInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.commands.gui.player.VoteLast;
import com.bencodez.votingplugin.commands.gui.player.VoteNext;
import com.bencodez.votingplugin.commands.gui.player.VoteToday;
import com.bencodez.votingplugin.commands.gui.player.VoteTotal;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteGUI
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteGUI(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender arg0) {
        return null;
    }

    private ItemBuilder getItemSlot(String slot, Player player) {
        ItemBuilder builder = new ItemBuilder(this.plugin.getGui().getChestVoteGUISlotSection(slot));
        String[] lore = new String[1];
        lore = ArrayUtils.convert(this.plugin.getGui().getChestVoteGUISlotLore(slot));
        String str = this.plugin.getConfigFile().getVoteTopDefault();
        if (lore.length == 0) {
            if (MessageAPI.startsWithIgnoreCase(slot, "url")) {
                lore = new String[]{"&aClick me"};
            } else if (MessageAPI.startsWithIgnoreCase(slot, "next")) {
                lore = ArrayUtils.convert(new VoteNext(this.plugin, (CommandSender)player, this.user).getChat((CommandSender)player));
            } else if (MessageAPI.startsWithIgnoreCase(slot, "last")) {
                lore = ArrayUtils.convert(new VoteLast(this.plugin, (CommandSender)player, this.user).getChat((CommandSender)player));
            } else if (MessageAPI.startsWithIgnoreCase(slot, "total")) {
                lore = ArrayUtils.convert(new VoteTotal(this.plugin, (CommandSender)player, this.user).getChat((CommandSender)player));
            } else if (MessageAPI.startsWithIgnoreCase(slot, "top")) {
                lore = str.equalsIgnoreCase("monthly") ? this.plugin.getTopVoterHandler().topVoterMonthly(1) : (str.equalsIgnoreCase("weekly") ? this.plugin.getTopVoterHandler().topVoterWeekly(1) : (str.equalsIgnoreCase("daily") ? this.plugin.getTopVoterHandler().topVoterDaily(1) : this.plugin.getTopVoterHandler().topVoterAllTime(1)));
            } else if (slot.equalsIgnoreCase("today")) {
                String[] today = new VoteToday(this.plugin, (CommandSender)player, this.user, 1).voteTodayGUI();
                ArrayList<String> list = new ArrayList<String>();
                if (today.length > 0) {
                    for (int i = today.length - 1; i < today.length && list.size() < 10 && i >= 0; --i) {
                        list.add(today[i]);
                    }
                }
                lore = ArrayUtils.convert(list);
            } else if (slot.equalsIgnoreCase("help")) {
                lore = new String[]{"Click to view help"};
            }
        }
        builder.setLore(ArrayUtils.convert(lore));
        return builder;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
    }

    @Override
    public void onChest(final Player player) {
        if (this.user == null) {
            this.user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
        }
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteGUIName());
        if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
            inv.dontClose();
        }
        if (player.getUniqueId().toString().equals(this.user.getUUID())) {
            inv.requirePermission("VotingPlugin.Commands.Vote.GUI");
        } else {
            inv.requirePermission("VotingPlugin.Commands.Vote.GUI.Other");
        }
        inv.addPlaceholder("points", "" + this.user.getPoints());
        inv.addPlaceholder("player", this.user.getPlayerName());
        inv.addPlaceholder("top", this.plugin.getConfigFile().getVoteTopDefault());
        inv.addPlaceholder("sitesavailable", "" + this.user.getSitesNotVotedOn());
        for (final String slot : this.plugin.getGui().getChestVoteGUISlots()) {
            ItemBuilder builder = this.getItemSlot(slot, player);
            inv.addButton(new UpdatingBInventoryButton(this.plugin, builder, 1000L, 1000L){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    final Player player = event.getWhoClicked();
                    final String cmd = VoteGUI.this.plugin.getGui().getChestVoteGUISlotCommand(slot);
                    if (cmd.equalsIgnoreCase("none")) {
                        return;
                    }
                    if (!cmd.equals("")) {
                        event.runSync(new Runnable(){

                            @Override
                            public void run() {
                                player.performCommand(cmd);
                            }
                        });
                    } else {
                        VoteGUI.this.plugin.getCommandLoader().processSlotClick(player, VoteGUI.this.user, slot);
                    }
                    String prefix = "";
                    if (event.getButton().getBuilder().isConditional()) {
                        prefix = "Item.";
                    }
                    if (VoteGUI.this.plugin.getRewardHandler().hasRewards(VoteGUI.this.plugin.getGui().getData(), VoteGUI.this.plugin.getGui().getChestVoteGUISlotRewardsPath(slot, prefix + event.getButton().getLastRewardsPath(player)))) {
                        VoteGUI.this.plugin.getRewardHandler().giveReward(VoteGUI.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player), (ConfigurationSection)VoteGUI.this.plugin.getGui().getData(), VoteGUI.this.plugin.getGui().getChestVoteGUISlotRewardsPath(slot, prefix + event.getButton().getLastRewardsPath(player)), new RewardOptions().addPlaceholder("identifier", slot));
                    }
                }

                @Override
                public ItemBuilder onUpdate(Player player) {
                    ItemBuilder item = VoteGUI.this.getItemSlot(slot, player);
                    VotingPluginUser user = VoteGUI.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
                    item.addPlaceholder("points", "" + user.getPoints());
                    item.addPlaceholder("player", user.getPlayerName());
                    item.addPlaceholder("top", VoteGUI.this.plugin.getConfigFile().getVoteTopDefault());
                    item.addPlaceholder("sitesavailable", "" + user.getSitesNotVotedOn());
                    return item;
                }
            });
        }
        final String guiPath = "VoteGUI";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteGUI.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodGUI().toUpperCase()));
    }
}

