/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.player;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteBest
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public VoteBest(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add(this.plugin.getConfigFile().getFormatCommandsVoteBestTitle());
        msg.addAll(this.plugin.getConfigFile().getFormatCommandsVoteBestLines());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("HighestDailyTotal", "" + this.user.getHighestDailyTotal());
        placeholders.put("HighestWeeklyTotal", "" + this.user.getHighestWeeklyTotal());
        placeholders.put("HighestMonthlyTotal", "" + this.user.getHighestMonthlyTotal());
        placeholders.put("player", this.user.getPlayerName());
        msg = PlaceholderUtils.replacePlaceHolder(msg, placeholders);
        return ArrayUtils.colorize(msg);
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessage(this.getChat(sender));
    }

    @Override
    public void onChest(final Player player) {
        BInventory inv = new BInventory(this.plugin.getGui().getChestVoteBestName());
        inv.addPlaceholder("player", this.user.getPlayerName());
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteBestDayBestItem()).addPlaceholder("Best", "" + this.user.getBestDayVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteBestWeekBestItem()).addPlaceholder("Best", "" + this.user.getBestWeekVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestVoteBestMonthBestItem()).addPlaceholder("Best", "" + this.user.getBestMonthVoteStreak())){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
            }
        });
        if (this.plugin.getGui().isChestVoteBestBackButton()) {
            inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user));
        }
        final String guiPath = "VoteBest";
        for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
            inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    new RewardBuilder((ConfigurationSection)VoteBest.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + "." + clickEvent.getButton().getLastRewardsPath(player)).setGiveOffline(false).send(clickEvent.getPlayer());
                }
            });
        }
        inv.openInventory(player);
    }

    @Override
    public void open() {
        this.open(GUIMethod.valueOf(this.plugin.getGui().getGuiMethodBest().toUpperCase()));
    }
}

