/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.admin;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.commands.gui.player.VoteGUI;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AdminVoteTopPoints
extends GUIHandler {
    private int page;
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public AdminVoteTopPoints(VotingPluginMain plugin, CommandSender player, VotingPluginUser user, int page) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
        this.page = page;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        return null;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
    }

    @Override
    public void onChest(final Player player) {
        try {
            Set<Map.Entry<TopVoterPlayer, Integer>> users = null;
            LinkedHashMap<TopVoterPlayer, Integer> topPoints1 = new LinkedHashMap<TopVoterPlayer, Integer>();
            for (String uuid : this.plugin.getVotingPluginUserManager().getAllUUIDs()) {
                VotingPluginUser vpUser = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid));
                vpUser.dontCache();
                int points = vpUser.getPoints();
                if (points <= 0) continue;
                topPoints1.put(vpUser.getTopVoterPlayer(), points);
            }
            LinkedHashMap<TopVoterPlayer, Integer> topPoints = this.plugin.getTopVoterHandler().sortByValues(topPoints1, false);
            users = topPoints.entrySet();
            ConfigurationSection customization = this.plugin.getGui().getChestVoteTopCustomization();
            boolean customzationEnabled = false;
            ConcurrentLinkedQueue playerSlots = new ConcurrentLinkedQueue();
            if (customization != null) {
                customzationEnabled = customization.getBoolean("Enabled");
                List customizationPlayerSlots = customization.getIntegerList("PlayerSlots");
                playerSlots.addAll(customizationPlayerSlots);
            }
            BInventory inv = new BInventory("Top Points");
            if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
                inv.dontClose();
            }
            int pos = 1;
            for (Map.Entry<TopVoterPlayer, Integer> entry : users) {
                ItemBuilder playerItem = new ItemBuilder(Material.PAPER);
                playerItem = this.plugin.getGui().isChestVoteTopUseSkull() ? new ItemBuilder(entry.getKey().getPlayerHead()) : new ItemBuilder(Material.valueOf((String)this.plugin.getGui().getChestVoteTopPlayerItemMaterial()));
                playerItem.setLore(new ArrayList<String>());
                BInventoryButton button = new BInventoryButton(playerItem.setName(this.plugin.getGui().getChestVoteTopItemName()).addLoreLine(this.plugin.getGui().getChestVoteTopItemLore()).addPlaceholder("position", "" + pos).addPlaceholder("player", entry.getKey().getPlayerName()).addPlaceholder("votes", "" + entry.getValue())){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        if (AdminVoteTopPoints.this.plugin.getGui().isChestVoteTopOpenMainGUIOnClick()) {
                            TopVoterPlayer user = (TopVoterPlayer)this.getData("User");
                            new VoteGUI(AdminVoteTopPoints.this.plugin, (CommandSender)player, user.getUser()).open(GUIMethod.valueOf(AdminVoteTopPoints.this.plugin.getGui().getGuiMethodGUI().toUpperCase()));
                        }
                    }
                }.addData("player", entry.getKey().getPlayerName()).addData("User", entry.getKey());
                if (customzationEnabled && !playerSlots.isEmpty()) {
                    button.setSlot((Integer)playerSlots.remove());
                }
                inv.setCloseInv(this.plugin.getGui().isChestVoteTopCloseGUIOnClick());
                inv.addButton(button);
                ++pos;
            }
            if (this.plugin.getGui().isChestVoteTopBackButton()) {
                if (customzationEnabled) {
                    inv.addButton(this.plugin.getCommandLoader().getBackButton(this.user).setSlot(customization.getInt("BackButtonSlot", 0)));
                } else {
                    inv.getPageButtons().add(this.plugin.getCommandLoader().getBackButton(this.user).setSlot(1));
                }
            }
            final String guiPath = "VoteTop.Customization";
            for (final String str : this.plugin.getGui().getChestGUIExtraItems(guiPath)) {
                inv.addButton(new BInventoryButton(new ItemBuilder(this.plugin.getGui().getChestGUIExtraItemsItem(guiPath, str))){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        AdminVoteTopPoints.this.plugin.getCommandLoader().processSlotClick(player, AdminVoteTopPoints.this.user, str);
                        new RewardBuilder((ConfigurationSection)AdminVoteTopPoints.this.plugin.getGui().getData(), "CHEST." + guiPath + ".ExtraItems." + str + ".Rewards").setGiveOffline(false).send(clickEvent.getPlayer());
                    }
                });
            }
            if (customization == null || !customzationEnabled || !customization.getBoolean("RemoveBottomBar")) {
                inv.setPages(true);
            }
            inv.setMaxInvSize(this.plugin.getGui().getChestVoteTopSize());
            inv.openInventory(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHEST);
    }
}

