/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.admin;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.bookgui.BookWrapper;
import com.bencodez.votingplugin.advancedcore.api.bookgui.Layout;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.placeholder.NonPlayerPlaceHolder;
import com.bencodez.votingplugin.advancedcore.api.placeholder.PlaceHolder;
import com.bencodez.votingplugin.advancedcore.xyz.upperlevel.spigot.book.BookUtil;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminVotePlaceholdersPlayer
extends GUIHandler {
    private VotingPluginMain plugin;
    private VotingPluginUser user;

    public AdminVotePlaceholdersPlayer(VotingPluginMain plugin, CommandSender player, VotingPluginUser user) {
        super(plugin, player);
        this.plugin = plugin;
        this.user = user;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        return null;
    }

    @Override
    public void onBook(Player player) {
        Layout layout;
        String msg;
        String value;
        String identifier;
        BookWrapper book = new BookWrapper("Placeholders");
        for (PlaceHolder<VotingPluginUser> placeHolder : this.plugin.getPlaceholders().getPlaceholders()) {
            identifier = placeHolder.getIdentifier().toLowerCase();
            if (identifier.endsWith("_")) {
                identifier = identifier + "1";
            }
            value = placeHolder.placeholderRequest(this.user, identifier);
            msg = identifier + " = " + value;
            layout = new Layout(new ArrayList<String>(Arrays.asList("[Json]")));
            layout.replaceTextComponent("[Json]", BookUtil.TextBuilder.of(msg).color(ChatColor.AQUA).onHover(BookUtil.HoverAction.showText(value)).build());
            book.addLayout(layout);
        }
        for (NonPlayerPlaceHolder nonPlayerPlaceHolder : this.plugin.getPlaceholders().getNonPlayerPlaceholders()) {
            identifier = nonPlayerPlaceHolder.getIdentifier().toLowerCase();
            if (identifier.endsWith("_")) {
                identifier = identifier + "1";
            }
            value = nonPlayerPlaceHolder.placeholderRequest(identifier);
            msg = identifier + " = " + value;
            layout = new Layout(new ArrayList<String>(Arrays.asList("[Json]")));
            layout.replaceTextComponent("[Json]", BookUtil.TextBuilder.of(msg).color(ChatColor.AQUA).onHover(BookUtil.HoverAction.showText(value)).build());
            book.addLayout(layout);
        }
        book.open(player);
    }

    @Override
    public void onChat(CommandSender sender) {
        String identifier;
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("&cPlaceholders:");
        VotingPluginUser placeholderUser = this.user;
        if (this.plugin.getConfigFile().isUsePrimaryAccountForPlaceholders() && this.user.hasPrimaryAccount()) {
            placeholderUser = this.plugin.getVotingPluginUserManager().getVotingPluginUser(this.user.getPrimaryAccount());
        }
        for (PlaceHolder<VotingPluginUser> placeHolder : this.plugin.getPlaceholders().getPlaceholders()) {
            identifier = placeHolder.getIdentifier().toLowerCase();
            if (identifier.endsWith("_")) {
                identifier = identifier + "1";
            }
            msg.add("votingplugin_" + identifier + " = " + placeHolder.placeholderRequest(placeholderUser, identifier));
        }
        for (NonPlayerPlaceHolder nonPlayerPlaceHolder : this.plugin.getPlaceholders().getNonPlayerPlaceholders()) {
            identifier = nonPlayerPlaceHolder.getIdentifier().toLowerCase();
            if (identifier.endsWith("_")) {
                identifier = identifier + "1";
            }
            msg.add("votingplugin_" + identifier + " = " + nonPlayerPlaceHolder.placeholderRequest(identifier));
        }
        this.sendMessage(msg);
    }

    @Override
    public void onChest(Player player) {
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHAT);
    }
}

