/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.admin;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class AdminVotePerms
extends GUIHandler {
    private int page;
    private String playerName;
    private VotingPluginMain plugin;

    public AdminVotePerms(VotingPluginMain plugin, CommandSender player, int page) {
        super(plugin, player);
        this.plugin = plugin;
        this.page = page;
    }

    public AdminVotePerms(VotingPluginMain plugin, CommandSender player, int page, String playerName) {
        super(plugin, player);
        this.plugin = plugin;
        this.page = page;
        this.playerName = playerName;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        return null;
    }

    public String[] listPerms(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        for (CommandHandler handle : this.plugin.getVoteCommand()) {
            if (sender instanceof Player) {
                if (handle.hasPerm(sender)) {
                    msg.add("&6" + handle.getHelpLineCommand("/vote") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &atrue");
                    continue;
                }
                msg.add("&6" + handle.getHelpLineCommand("/vote") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &cfalse");
                continue;
            }
            msg.add(handle.getHelpLineCommand("/vote") + " : " + handle.getPerm().split(Pattern.quote("|"))[0]);
        }
        for (CommandHandler handle : this.plugin.getAdminVoteCommand()) {
            if (sender instanceof Player) {
                if (handle.hasPerm(sender)) {
                    msg.add("&6" + handle.getHelpLineCommand("/av") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &atrue");
                    continue;
                }
                msg.add("&6" + handle.getHelpLineCommand("/av") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &cfalse");
                continue;
            }
            msg.add(handle.getHelpLineCommand("/av") + " : " + handle.getPerm().split(Pattern.quote("|"))[0]);
        }
        for (Permission perm : this.plugin.getDescription().getPermissions()) {
            if (sender instanceof Player) {
                Set child = perm.getChildren().keySet();
                if (child.size() > 0) {
                    if (sender.hasPermission(perm)) {
                        msg.add("&6" + perm.getName() + " : &atrue");
                        continue;
                    }
                    msg.add("&6" + perm.getName() + " : &cfalse");
                    continue;
                }
                if (sender.hasPermission(perm)) {
                    msg.add("&6" + perm.getName() + " : &atrue");
                    continue;
                }
                msg.add("&6" + perm.getName() + " : &cfalse");
                continue;
            }
            msg.add(perm.getName());
        }
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        int maxPage = msg.size() / pagesize;
        if (msg.size() % pagesize != 0) {
            ++maxPage;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add("&c&lCommand : Permissions " + this.page + "/" + maxPage);
        for (int i = pagesize * this.page - pagesize; i < msg.size() && i < pagesize * this.page; ++i) {
            text.add((String)msg.get(i));
        }
        text = ArrayUtils.colorize(text);
        return ArrayUtils.convert(text);
    }

    public ArrayList<String> listPerms(CommandSender sender, String player, int page) {
        Player p = Bukkit.getPlayer((String)player);
        ArrayList<String> text = new ArrayList<String>();
        if (p != null) {
            ArrayList<String> msg = new ArrayList<String>();
            for (CommandHandler handle : this.plugin.getVoteCommand()) {
                if (handle.hasPerm((CommandSender)p)) {
                    msg.add("&6" + handle.getHelpLineCommand("/vote") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &atrue");
                    continue;
                }
                msg.add("&6" + handle.getHelpLineCommand("/vote") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &cfalse");
            }
            for (CommandHandler handle : this.plugin.getAdminVoteCommand()) {
                if (handle.hasPerm((CommandSender)p)) {
                    msg.add("&6" + handle.getHelpLineCommand("/av") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &atrue");
                    continue;
                }
                msg.add("&6" + handle.getHelpLineCommand("/av") + " : " + handle.getPerm().split(Pattern.quote("|"))[0] + " : &cfalse");
            }
            for (Permission perm : this.plugin.getDescription().getPermissions()) {
                Set child = perm.getChildren().keySet();
                if (child.size() > 0) {
                    if (p.hasPermission(perm)) {
                        msg.add("&6" + perm.getName() + " : &atrue");
                        continue;
                    }
                    msg.add("&6" + perm.getName() + " : &cfalse");
                    continue;
                }
                if (p.hasPermission(perm)) {
                    msg.add("&6" + perm.getName() + " : &atrue");
                    continue;
                }
                msg.add("&6" + perm.getName() + " : &cfalse");
            }
            msg = ArrayUtils.colorize(msg);
            int pagesize = this.plugin.getConfigFile().getFormatPageSize();
            int maxPage = msg.size() / pagesize;
            if (msg.size() % pagesize != 0) {
                ++maxPage;
            }
            text.add("&c&lCommand : Permissions for " + player + " " + page + "/" + maxPage);
            for (int i = pagesize * page - pagesize; i < msg.size() && i < pagesize * page; ++i) {
                text.add(msg.get(i));
            }
        } else {
            text.add("&cPlayer not online: " + player);
        }
        return ArrayUtils.colorize(text);
    }

    public String[] listPermsDev(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Command");
        msg.add("  Permissions (seperated by |");
        msg.add("  Help messasge");
        msg.add("  ");
        for (CommandHandler handle : this.plugin.getVoteCommand()) {
            msg.add(handle.getHelpLineCommand("/vote"));
            msg.add("  " + handle.getPerm());
            msg.add("  " + handle.getHelpMessage());
        }
        for (CommandHandler handle : this.plugin.getAdminVoteCommand()) {
            msg.add(handle.getHelpLineCommand("/av"));
            msg.add("  " + handle.getPerm());
            msg.add("  " + handle.getHelpMessage());
        }
        for (Permission perm : this.plugin.getDescription().getPermissions()) {
            msg.add(perm.getName() + " : " + perm.getDescription());
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        if (this.playerName != null) {
            this.sendMessage(this.listPerms(sender, this.playerName, this.page));
        } else {
            this.sendMessage(this.listPerms(sender));
        }
    }

    @Override
    public void onChest(Player player) {
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHAT);
    }
}

