/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui.admin;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminVoteHelp
extends GUIHandler {
    private int page;
    private VotingPluginMain plugin;

    public AdminVoteHelp(VotingPluginMain plugin, CommandSender player, int page) {
        super(plugin, player);
        this.plugin = plugin;
        this.page = page;
    }

    public ArrayList<TextComponent> adminHelp(CommandSender sender, int page) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        ArrayList<TextComponent> msg = new ArrayList<TextComponent>();
        ArrayList<TextComponent> text = this.adminHelpText(sender);
        int maxPage = text.size() / pagesize;
        if (text.size() % pagesize != 0) {
            ++maxPage;
        }
        msg.add(MessageAPI.stringToComp("&6&lVotingPlugin Admin Help " + page + "/" + maxPage));
        msg.add(MessageAPI.stringToComp("&6&l() = Needed"));
        msg.add(MessageAPI.stringToComp("&6&lAliases: adminvote, av"));
        for (int i = pagesize * (page - 1); i < text.size() && i < page * pagesize; ++i) {
            msg.add(text.get(i));
        }
        return msg;
    }

    public ArrayList<TextComponent> adminHelpText(CommandSender sender) {
        ArrayList<TextComponent> msg = new ArrayList<TextComponent>();
        HashMap<String, TextComponent> unsorted = new HashMap<String, TextComponent>();
        boolean requirePerms = this.plugin.getConfigFile().isFormatCommandsVoteHelpRequirePermission();
        for (CommandHandler cmdHandle : this.plugin.getAdminVoteCommand()) {
            if (requirePerms && !cmdHandle.hasPerm(sender)) continue;
            unsorted.put(cmdHandle.getHelpLineCommand("/adminvote"), cmdHandle.getHelpLine("/adminvote"));
        }
        ArrayList unsortedList = new ArrayList();
        unsortedList.addAll(unsorted.keySet());
        Collections.sort(unsortedList, String.CASE_INSENSITIVE_ORDER);
        for (String cmd : unsortedList) {
            msg.add((TextComponent)unsorted.get(cmd));
        }
        return msg;
    }

    @Override
    public ArrayList<String> getChat(CommandSender sender) {
        return null;
    }

    @Override
    public void onBook(Player player) {
    }

    @Override
    public void onChat(CommandSender sender) {
        this.sendMessageJson(this.adminHelp(sender, this.page));
    }

    @Override
    public void onChest(Player player) {
    }

    @Override
    public void open() {
        this.open(GUIMethod.CHAT);
    }
}

