/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.gui;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUI;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueBoolean;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueList;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueNumber;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueString;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.InputMethod;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequest;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequestBuilder;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.StringListener;
import com.bencodez.votingplugin.advancedcore.api.yml.editor.ConfigEditor;
import com.bencodez.votingplugin.advancedcore.command.gui.RewardEditGUI;
import com.bencodez.votingplugin.commands.gui.admin.AdminVoteVoteParty;
import com.bencodez.votingplugin.commands.gui.admin.cumulative.AdminVoteCumulative;
import com.bencodez.votingplugin.commands.gui.admin.milestones.AdminVoteMilestones;
import com.bencodez.votingplugin.commands.gui.admin.voteshop.AdminVoteVoteShop;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class AdminGUI {
    private VotingPluginMain plugin;

    public AdminGUI(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public ArrayList<BInventoryButton> adminGUIButtons() {
        ArrayList<BInventoryButton> buttons = new ArrayList<BInventoryButton>();
        buttons.add(new BInventoryButton("&cVoteSites", new String[]{"&cOnly enabled sites are listed in this section", "&cMiddle Click to create"}, new ItemStack(Material.STONE)){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                Player player = event.getPlayer();
                if (event.getClick().equals((Object)ClickType.MIDDLE)) {
                    new ValueRequest().requestString(player, new StringListener(){

                        @Override
                        public void onInput(Player player, String value) {
                            AdminGUI.this.plugin.getConfigVoteSites().generateVoteSite(value);
                            player.sendMessage("Generated site");
                            AdminGUI.this.plugin.reload();
                            AdminGUI.this.openAdminGUIVoteSiteSite(player, AdminGUI.this.plugin.getVoteSite(value, true));
                        }
                    });
                } else {
                    AdminGUI.this.openAdminGUIVoteSites(player);
                }
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.CHEST, 1).setName("&cEdit VoteShop")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new AdminVoteVoteShop(AdminGUI.this.plugin, (CommandSender)clickEvent.getPlayer()).open(GUIMethod.CHEST);
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.DIAMOND_BLOCK, 1).setName("&cEdit Milestones")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new AdminVoteMilestones(AdminGUI.this.plugin, (CommandSender)clickEvent.getPlayer()).open(GUIMethod.CHEST);
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.COBBLESTONE, 1).setName("&cEdit Cumulative")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new AdminVoteCumulative(AdminGUI.this.plugin, (CommandSender)clickEvent.getPlayer()).open(GUIMethod.CHEST);
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit VoteParty")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new AdminVoteVoteParty(AdminGUI.this.plugin, (CommandSender)clickEvent.getPlayer()).open(GUIMethod.CHEST);
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit FirstVote reward")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("FirstVote"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit FirstVoteToday reward")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("FirstVoteToday"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit AllSites reward")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("AllSites"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit AlmostAllSites reward")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("AlmostAllSites"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit AnySiteRewards")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("AnySiteRewards"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit EverySiteReward")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("EverySiteReward"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cEdit BungeeVotePartyRewards")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("BungeeVotePartyRewards"));
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder("GRASS_BLOCK").setName("&cEdit BungeeSettings.yml").addLoreLine("&aCurrently WIP")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new ConfigEditor(AdminGUI.this.plugin, AdminGUI.this.plugin.getBungeeSettings()).open(clickEvent.getPlayer());
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder("GRASS_BLOCK").setName("&cEdit Config.yml").addLoreLine("&aCurrently WIP")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new ConfigEditor(AdminGUI.this.plugin, AdminGUI.this.plugin.getConfigFile(), AdminGUI.this.plugin.getOptions().getYmlConfig(), AdminGUI.this.plugin.getOptions().getClass()).open(clickEvent.getPlayer());
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.CHEST).setName("&cEdit GUI.yml").addLoreLine("&aCurrently WIP")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new ConfigEditor(AdminGUI.this.plugin, AdminGUI.this.plugin.getGui()).open(clickEvent.getPlayer());
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder("GRASS_BLOCK").setName("&cEdit SpecialRewards.yml").addLoreLine("&aCurrently WIP")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                new ConfigEditor(AdminGUI.this.plugin, AdminGUI.this.plugin.getSpecialRewardsConfig()).open(clickEvent.getPlayer());
            }
        });
        buttons.add(new BInventoryButton("&cReload Plugin", new String[0], new ItemStack(Material.BUCKET, 1)){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                AdminGUI.this.plugin.reload();
            }
        });
        buttons.add(new BInventoryButton(new ItemBuilder(Material.STONE, 1).setName("&cBackground task time").addLoreLine("&aClick to see")){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                event.getPlayer().sendMessage("Last background task time: " + AdminGUI.this.plugin.getLastBackgroundTaskTimeTaken());
            }
        });
        return buttons;
    }

    public void loadHook() {
        for (BInventoryButton b : this.adminGUIButtons()) {
            com.bencodez.votingplugin.advancedcore.command.gui.AdminGUI.getInstance().addButton(b);
        }
    }

    public void openAdminGUIVoteSites(Player player) {
        BInventory inv = new BInventory("VoteSites");
        int count = 0;
        for (final VoteSite voteSite : this.plugin.getVoteSites()) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("Enabled: " + voteSite.isEnabled());
            lore.add("Priority: " + voteSite.getPriority());
            lore.add("Name: " + voteSite.getDisplayName());
            lore.add("ServiceSite: " + voteSite.getServiceSite());
            lore.add("VoteURL: " + voteSite.getVoteURL());
            lore.add("VoteDelay: " + voteSite.getVoteDelay());
            lore.add("VoteDelayMin: " + voteSite.getVoteDelayMin());
            inv.addButton(count, new BInventoryButton(voteSite.getKey(), ArrayUtils.convert(lore), new ItemStack(Material.STONE)){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    Player player = event.getWhoClicked();
                    AdminGUI.this.openAdminGUIVoteSiteSite(player, voteSite);
                }
            });
            ++count;
        }
        inv.openInventory(player);
    }

    public void openAdminGUIVoteSiteSite(final Player player, final VoteSite voteSite) {
        EditGUI inv = new EditGUI("VoteSite: " + voteSite.getDisplayName());
        inv.setMeta(player, "VoteSite", voteSite);
        inv.addButton(new BInventoryButton(voteSite.getItem().setName("&cForce vote")){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                ArrayList<String> playerNames = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    playerNames.add(p.getName());
                }
                new ValueRequestBuilder(new StringListener(){

                    @Override
                    public void onInput(Player player, String value) {
                        Object ob = PlayerUtils.getPlayerMeta(AdminGUI.this.plugin, player, "VoteSite");
                        if (ob != null) {
                            VoteSite site = (VoteSite)ob;
                            final PlayerVoteEvent voteEvent = new PlayerVoteEvent(site, value, site.getServiceSite(), false);
                            AdminGUI.this.plugin.getVoteTimer().submit(new Runnable(){

                                @Override
                                public void run() {
                                    AdminGUI.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                                }
                            });
                        }
                    }
                }, ArrayUtils.convert(playerNames)).usingMethod(InputMethod.INVENTORY).allowCustomOption(true).request(event.getWhoClicked());
            }
        });
        inv.addButton(new EditGUIButton(new EditGUIValueNumber("Priority", voteSite.getPriority()){

            @Override
            public void setValue(Player player, Number num) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                AdminGUI.this.plugin.getConfigVoteSites().setPriority(voteSite.getKey(), num.intValue());
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueString("ServiceSite", voteSite.getServiceSite()){

            @Override
            public void setValue(Player player, String value) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setServiceSite(siteName, value);
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueString("Name", voteSite.getDisplayName()){

            @Override
            public void setValue(Player player, String value) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                AdminGUI.this.plugin.getConfigVoteSites().setDisplayName(voteSite.getKey(), value);
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueString("VoteURL", voteSite.getVoteURL()){

            @Override
            public void setValue(Player player, String value) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setVoteURL(siteName, value);
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueNumber("VoteDelay", voteSite.getVoteDelay()){

            @Override
            public void setValue(Player player, Number num) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setVoteDelay(siteName, num.intValue());
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueNumber("VoteDelayMin", voteSite.getVoteDelay()){

            @Override
            public void setValue(Player player, Number num) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setVoteDelay(siteName, num.intValue());
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueNumber("VoteDelayDailyHour", voteSite.getVoteDelayDailyHour()){

            @Override
            public void setValue(Player player, Number num) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setVoteDelay(siteName, num.intValue());
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueBoolean("Enabled", voteSite.isEnabled()){

            @Override
            public void setValue(Player player, boolean value) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setEnabled(siteName, value);
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueBoolean("ForceOffline", voteSite.isGiveOffline()){

            @Override
            public void setValue(Player player, boolean value) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setForceOffline(siteName, value);
                AdminGUI.this.plugin.reload();
            }
        }));
        inv.addButton(new EditGUIButton(new EditGUIValueBoolean("VoteDelayDaily", voteSite.isVoteDelayDaily()){

            @Override
            public void setValue(Player player, boolean value) {
                VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                String siteName = voteSite.getKey();
                AdminGUI.this.plugin.getConfigVoteSites().setVoteDelayDaily(siteName, value);
                AdminGUI.this.plugin.reload();
            }
        }));
        if (voteSite.getSiteData().isList("Rewards")) {
            inv.addButton(new EditGUIButton(new EditGUIValueList("Rewards", voteSite.getSiteData().getStringList("Rewards")){

                @Override
                public void setValue(Player p, ArrayList<String> rewards) {
                    VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                    AdminGUI.this.plugin.getConfigVoteSites().set(voteSite.getKey(), "Rewards", rewards);
                    AdminGUI.this.plugin.reload();
                }
            }));
        } else {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.DISPENSER, 1).setName("&cRewards")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("VoteSites." + voteSite.getKey() + ".Rewards"));
                }
            });
        }
        if (voteSite.getSiteData().isList("CoolDownEndRewards")) {
            inv.addButton(new EditGUIButton(new EditGUIValueList("CoolDownEndRewards", voteSite.getSiteData().getStringList("CoolDownEndRewards")){

                @Override
                public void setValue(Player p, ArrayList<String> rewards) {
                    VoteSite voteSite = (VoteSite)this.getInv().getMeta(player, "VoteSite");
                    AdminGUI.this.plugin.getConfigVoteSites().set(voteSite.getKey(), "CoolDownEndRewards", rewards);
                    AdminGUI.this.plugin.reload();
                }
            }));
        } else {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.DISPENSER, 1).setName("&cCoolDownEndRewards")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditGUI.getInstance().openRewardGUI(clickEvent.getPlayer(), AdminGUI.this.plugin.getRewardHandler().getDirectlyDefined("VoteSites." + voteSite.getKey() + ".CoolDownEndRewards"));
                }
            });
        }
        inv.openInventory(player);
    }
}

