/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands.executers;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandAliases
implements CommandExecutor {
    private boolean adminCommand;
    private CommandHandler cmdHandle;
    private VotingPluginMain plugin = VotingPluginMain.plugin;

    public CommandAliases(CommandHandler cmdHandle, boolean adminCommand) {
        this.cmdHandle = cmdHandle;
        this.adminCommand = adminCommand;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> argsNew = new ArrayList<String>();
        argsNew.add(this.cmdHandle.getArgs()[0]);
        for (String arg : args) {
            argsNew.add(arg);
        }
        this.plugin.debug("Attempting cmd...");
        this.plugin.debug("Inputed args: " + ArrayUtils.makeStringList(argsNew));
        ArrayList<CommandHandler> handles = new ArrayList<CommandHandler>();
        if (this.adminCommand) {
            handles.addAll(this.plugin.getAdminVoteCommand());
        } else {
            handles.addAll(this.plugin.getVoteCommand());
        }
        for (CommandHandler cmdHandle : handles) {
            if (cmdHandle.getArgs().length <= args.length) continue;
            for (String arg : cmdHandle.getArgs()[0].split("&")) {
                if (!cmd.getName().equalsIgnoreCase("vote" + arg) && !cmd.getName().equalsIgnoreCase("adminvote" + arg)) continue;
                argsNew.set(0, arg);
                boolean argsMatch = true;
                for (int i = 0; i < argsNew.size(); ++i) {
                    if (i >= cmdHandle.getArgs().length || cmdHandle.argsMatch(argsNew.get(i), i)) continue;
                    argsMatch = false;
                }
                if (!argsMatch || !cmdHandle.runCommand(sender, ArrayUtils.convert(argsNew))) continue;
                this.plugin.debug("cmd found, ran cmd");
                return true;
            }
        }
        if (this.adminCommand) {
            sender.sendMessage(MessageAPI.colorize(this.plugin.getConfigFile().getFormatInvalidCommandAdminVote()));
        } else {
            sender.sendMessage(MessageAPI.colorize(this.plugin.getConfigFile().getFormatInvalidCommandVote()));
        }
        return true;
    }
}

