/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.commands;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.command.CommandHandler;
import com.bencodez.votingplugin.advancedcore.api.command.PlayerCommandHandler;
import com.bencodez.votingplugin.advancedcore.api.gui.GUIMethod;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequest;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.BooleanListener;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.StringListener;
import com.bencodez.votingplugin.advancedcore.api.yml.editor.ConfigEditor;
import com.bencodez.votingplugin.advancedcore.command.gui.UserGUI;
import com.bencodez.votingplugin.commands.executers.CommandAliases;
import com.bencodez.votingplugin.commands.gui.AdminGUI;
import com.bencodez.votingplugin.commands.gui.admin.AdminVoteHelp;
import com.bencodez.votingplugin.commands.gui.admin.AdminVotePerms;
import com.bencodez.votingplugin.commands.gui.admin.AdminVotePlaceholders;
import com.bencodez.votingplugin.commands.gui.admin.AdminVotePlaceholdersPlayer;
import com.bencodez.votingplugin.commands.gui.admin.AdminVoteTopPoints;
import com.bencodez.votingplugin.commands.gui.admin.AdminVoteVoteParty;
import com.bencodez.votingplugin.commands.gui.admin.AdminVoteVotePlayer;
import com.bencodez.votingplugin.commands.gui.admin.cumulative.AdminVoteCumulative;
import com.bencodez.votingplugin.commands.gui.admin.milestones.AdminVoteMilestones;
import com.bencodez.votingplugin.commands.gui.admin.voteshop.AdminVoteVoteShop;
import com.bencodez.votingplugin.commands.gui.player.VoteBest;
import com.bencodez.votingplugin.commands.gui.player.VoteGUI;
import com.bencodez.votingplugin.commands.gui.player.VoteHelp;
import com.bencodez.votingplugin.commands.gui.player.VoteLast;
import com.bencodez.votingplugin.commands.gui.player.VoteNext;
import com.bencodez.votingplugin.commands.gui.player.VoteShop;
import com.bencodez.votingplugin.commands.gui.player.VoteStreak;
import com.bencodez.votingplugin.commands.gui.player.VoteToday;
import com.bencodez.votingplugin.commands.gui.player.VoteTopVoter;
import com.bencodez.votingplugin.commands.gui.player.VoteTopVoterLastMonth;
import com.bencodez.votingplugin.commands.gui.player.VoteTopVoterPreviousMonths;
import com.bencodez.votingplugin.commands.gui.player.VoteTotal;
import com.bencodez.votingplugin.commands.gui.player.VoteURL;
import com.bencodez.votingplugin.commands.gui.player.VoteURLVoteSite;
import com.bencodez.votingplugin.commands.tabcompleter.AliasesTabCompleter;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.events.PlayerVoteSiteCoolDownEndEvent;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandle;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandler;
import com.bencodez.votingplugin.simpleapi.debug.DebugLevel;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.updater.Updater;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class CommandLoader {
    private String adminPerm = "VotingPlugin.Admin";
    private HashMap<String, CommandHandler> commands;
    private String modPerm = "VotingPlugin.Mod";
    private String playerPerm = "VotingPlugin.Player";
    private VotingPluginMain plugin;
    private Object pointLock = new Object();

    public CommandLoader(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public String getAdminPerm() {
        return this.adminPerm;
    }

    public BInventoryButton getBackButton(final VotingPluginUser user) {
        ItemBuilder item;
        ConfigurationSection sec = this.plugin.getGui().getCHESTBackButton();
        boolean a = false;
        boolean exit = false;
        if (sec != null) {
            item = new ItemBuilder(sec);
            a = sec.getBoolean("OpenVoteURL", false);
            exit = sec.getBoolean("Exit");
        } else {
            item = new ItemBuilder(Material.BARRIER, 1).setName("&8Back to VoteGUI");
        }
        final boolean openVoteURL = a;
        final boolean exitGUI = exit;
        BInventoryButton b = new BInventoryButton(item){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                if (!exitGUI) {
                    if (!openVoteURL) {
                        new VoteGUI(CommandLoader.this.plugin, (CommandSender)event.getWhoClicked(), user).open(GUIMethod.valueOf(CommandLoader.this.plugin.getGui().getGuiMethodGUI().toUpperCase()));
                    } else {
                        new VoteURL(CommandLoader.this.plugin, (CommandSender)event.getWhoClicked(), user, true).open();
                    }
                } else {
                    event.closeInventory();
                }
            }
        };
        if (sec != null && sec.getBoolean("EndOfGUI")) {
            b.setSlot(-2);
        }
        if (!this.plugin.getConfigFile().isAlwaysCloseInventory()) {
            b.dontClose();
        }
        return b;
    }

    public HashMap<String, CommandHandler> getCommands() {
        return this.commands;
    }

    public String getModPerm() {
        return this.modPerm;
    }

    public String getPlayerPerm() {
        return this.playerPerm;
    }

    public boolean hasPermission(Player player, String cmd) {
        if (cmd.startsWith("votingplugin:")) {
            cmd = cmd.substring("votingplugin:".length());
        }
        if (this.commands.containsKey(cmd)) {
            return this.commands.get(cmd).hasPerm((CommandSender)player);
        }
        boolean adminCommand = false;
        if (cmd.startsWith("vote")) {
            cmd = cmd.substring("vote".length());
        } else if (cmd.startsWith("v")) {
            cmd = cmd.substring(1);
        } else if (cmd.startsWith("av")) {
            adminCommand = true;
            cmd = cmd.substring("av".length());
        } else if (cmd.startsWith("adminvote")) {
            adminCommand = true;
            cmd = cmd.substring("adminvote".length());
        }
        if (!adminCommand) {
            for (CommandHandler handle : this.plugin.getVoteCommand()) {
                if (!handle.isCommand(cmd) || !handle.hasPerm((CommandSender)player)) continue;
                return true;
            }
        } else {
            for (CommandHandler handle : this.plugin.getAdminVoteCommand()) {
                if (!handle.isCommand(cmd) || !handle.hasPerm((CommandSender)player)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVotingPluginCommand(Player player, String cmd) {
        if (this.plugin.getCommand(cmd) != null || cmd.startsWith("votingplugin")) {
            return true;
        }
        for (String str : this.commands.keySet()) {
            if (!str.equalsIgnoreCase(cmd)) continue;
            return true;
        }
        return false;
    }

    private void loadAdminVoteCommand() {
        this.plugin.setAdminVoteCommand(new ArrayList<CommandHandler>());
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"CurrentPluginTime"}, "VotingPlugin.Commands.AdminVote.CurrentPluginTime|" + this.adminPerm, "Current plugin time"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(CommandLoader.this.plugin.getConfigFile().getFormatTimeFormat());
                this.sendMessage(sender, CommandLoader.this.plugin.getTimeChecker().getTime().format(formatter));
            }
        });
        this.plugin.getAdminVoteCommand().add(new PlayerCommandHandler(this.plugin, new String[]{"User", "(player)", "SetPoints", "(number)"}, "VotingPlugin.Commands.AdminVote.SetPoints|" + this.adminPerm, "Set players voting points"){

            @Override
            public void executeAll(CommandSender sender, String[] args) {
                int num = Integer.parseInt(args[3]);
                sender.sendMessage(MessageAPI.colorize("&cSetting all players points to " + args[3]));
                for (String uuidStr : CommandLoader.this.plugin.getUserManager().getAllUUIDs()) {
                    UUID uuid = UUID.fromString(uuidStr);
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid);
                    user.dontCache();
                    user.setPoints(num);
                    CommandLoader.this.plugin.getSpecialRewards().checkMilestone(user, null, CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                }
                sender.sendMessage(MessageAPI.colorize("&cDone setting all players points to " + args[3]));
            }

            @Override
            public void executeSinglePlayer(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.setPoints(Integer.parseInt(args[3]));
                sender.sendMessage(MessageAPI.colorize("&cSet " + args[1] + " points to " + args[3]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResyncMilestones"}, "VotingPlugin.Commands.AdminVote.ResyncMilestones|" + this.adminPerm, "Resync Milestones to all time total"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cStarting...");
                CommandLoader.this.plugin.getUserManager().copyColumnData(TopVoter.AllTime.getColumnName(), "MilestoneCount");
                this.sendMessage(sender, "&cFinished sync milestonecount with all time total");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"TopPoints"}, "VotingPlugin.Commands.AdminVote.TopPoints|" + this.adminPerm, "Open the top points GUI", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cLoading top points, please wait...");
                new AdminVoteTopPoints(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender), 1).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PauseRewards"}, "VotingPlugin.Commands.AdminVote.PauseRewards|" + this.adminPerm, "Pause rewards globally"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (!CommandLoader.this.plugin.getOptions().isPauseRewards()) {
                    CommandLoader.this.plugin.getOptions().setPauseRewards(true);
                    this.sendMessage(sender, "&cRewards paused, note server restart will reset pause, resume with /av resumerewards");
                } else {
                    this.sendMessage(sender, "&cRewards already paused, use /av resumerewards to resume");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResumeRewards"}, "VotingPlugin.Commands.AdminVote.ResumeRewards|" + this.adminPerm, "Resume rewards globally"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getOptions().isPauseRewards()) {
                    CommandLoader.this.plugin.getOptions().setPauseRewards(false);
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(p);
                        user.offVote();
                        user.checkOfflineRewards();
                    }
                    CommandLoader.this.plugin.setUpdate(true);
                    this.sendMessage(sender, "&aRewards resumed");
                } else {
                    this.sendMessage(sender, "&aRewards already resumed");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResetMilestoneCount"}, "VotingPlugin.Commands.AdminVote.ResetMilestoneCount|" + this.adminPerm, "Resets milestone count to 0"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cStarting to clear milestonecounts...");
                CommandLoader.this.plugin.getTopVoterHandler().resetMilestoneCount();
                this.sendMessage(sender, "&cFinished");
                CommandLoader.this.plugin.setUpdate(true);
                CommandLoader.this.plugin.getUserManager().getDataManager().updateCacheOnline();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResyncMilestonesAlreadyGiven"}, "VotingPlugin.Commands.AdminVote.ResyncMilestonesGiven|" + this.adminPerm, "Resync Milestones already given"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cStarting...");
                ArrayList<Integer> nums = new ArrayList<Integer>();
                for (String str : CommandLoader.this.plugin.getSpecialRewardsConfig().getMilestoneVotes()) {
                    try {
                        nums.add(Integer.parseInt(str));
                    }
                    catch (Exception e) {
                        CommandLoader.this.plugin.getLogger().warning("Failed to get number from " + str);
                    }
                }
                HashMap<UUID, ArrayList<Column>> cols = CommandLoader.this.plugin.getUserManager().getAllKeys();
                for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                    String uuid = playerData.getKey().toString();
                    if (CommandLoader.this.plugin == null || !CommandLoader.this.plugin.isEnabled() || uuid == null || uuid.isEmpty()) continue;
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid));
                    user.dontCache();
                    user.updateTempCacheWithColumns(playerData.getValue());
                    cols.put(playerData.getKey(), null);
                    int milestoneCount = user.getMilestoneCount();
                    Iterator iterator = nums.iterator();
                    while (iterator.hasNext()) {
                        int num = (Integer)iterator.next();
                        if (milestoneCount >= num) {
                            if (user.hasGottenMilestone(num)) continue;
                            this.sendMessage(sender, "&cMilestone " + num + " for " + user.getPlayerName() + " not already given when it should be, Current AllTimeTotal: " + user.getTotal(TopVoter.AllTime) + ", Current MileStoneCount: " + user.getMilestoneCount());
                            user.setHasGotteMilestone(num, true);
                            continue;
                        }
                        if (!user.hasGottenMilestone(num)) continue;
                        this.sendMessage(sender, "&cMilestone " + num + " for " + user.getPlayerName() + " already given when it shouldn't be, Current AllTimeTotal: " + user.getTotal(TopVoter.AllTime) + ", Current MileStoneCount: " + user.getMilestoneCount());
                        user.setHasGotteMilestone(num, false);
                    }
                    user.clearTempCache();
                }
                cols.clear();
                cols = null;
                this.sendMessage(sender, "&cFinished");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResetPoints"}, "VotingPlugin.Commands.AdminVote.ResetPoints|" + this.adminPerm, "Clears all points of all players", true, false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cStarting...");
                CommandLoader.this.plugin.getUserManager().removeAllKeyValues("Points", DataType.INTEGER);
                CommandLoader.this.plugin.getUserManager().getDataManager().clearCache();
                this.sendMessage(sender, "&cFinished");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResyncMilestones", "(player)"}, "VotingPlugin.Commands.AdminVote.SetResyncMilestones|" + this.adminPerm, "Resync Milestones to alltimetotal for player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.setMilestoneCount(user.getTotal(TopVoter.AllTime));
                this.sendMessage(sender, "&cResynced milestones for " + args[1]);
            }
        });
        this.plugin.getAdminVoteCommand().add(new PlayerCommandHandler(this.plugin, new String[]{"User", "(player)", "AddPoints", "(number)"}, "VotingPlugin.Commands.AdminVote.AddPoints|" + this.adminPerm, "Add to players voting points"){

            @Override
            public void executeAll(CommandSender sender, String[] args) {
                int num = Integer.parseInt(args[3]);
                sender.sendMessage(MessageAPI.colorize("&cGiving all players " + args[3] + " points"));
                for (String uuidStr : CommandLoader.this.plugin.getUserManager().getAllUUIDs()) {
                    UUID uuid = UUID.fromString(uuidStr);
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid);
                    user.dontCache();
                    user.addPoints(num);
                    CommandLoader.this.plugin.getSpecialRewards().checkMilestone(user, null, CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                }
                sender.sendMessage(MessageAPI.colorize("&cGave all players " + args[3] + " points"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeSinglePlayer(CommandSender sender, String[] args) {
                Object object = CommandLoader.this.pointLock;
                synchronized (object) {
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                    user.cache();
                    int newTotal = 0;
                    newTotal = user.addPoints(Integer.parseInt(args[3]));
                    sender.sendMessage(MessageAPI.colorize("&cGave " + args[1] + " " + args[3] + " points, " + args[1] + " now has " + newTotal + " points"));
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "RemovePoints", "(number)"}, "VotingPlugin.Commands.AdminVote.RemovePoints|" + this.adminPerm, "Remove voting points"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.cache();
                user.removePoints(Integer.parseInt(args[3]));
                sender.sendMessage(MessageAPI.colorize("&cRemoved " + args[3] + " points from " + args[1] + ", " + args[1] + " now has " + user.getPoints() + " points"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Help&?"}, "VotingPlugin.Commands.AdminVote.Help|" + this.adminPerm, "See this page"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVoteHelp(CommandLoader.this.plugin, sender, 1).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ServiceSites&Status"}, "VotingPlugin.Commands.AdminVote.ServiceSites|" + this.adminPerm, "See a list of all service sites the server got"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                ArrayList<String> serviceSites = CommandLoader.this.plugin.getServerData().getServiceSites();
                if (!serviceSites.isEmpty()) {
                    this.sendMessage(sender, "&cEvery service site the server has gotten from votifier:");
                    for (String serviceSite : serviceSites) {
                        boolean hasSite = CommandLoader.this.plugin.hasVoteSite(serviceSite);
                        if (hasSite) {
                            String siteName = CommandLoader.this.plugin.getVoteSiteName(true, serviceSite);
                            this.sendMessage(sender, serviceSite + " : Current site = " + siteName);
                            continue;
                        }
                        this.sendMessage(sender, serviceSite + " : No site with this service site, did you do something wrong?");
                    }
                } else {
                    this.sendMessage(sender, "&cNo votes have been received. Please check your votifier settings.");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"CorrectServiceSites"}, "VotingPlugin.Commands.AdminVote.CorrectServiceSites|" + this.adminPerm, "Attempt to correct invalid services sites"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                int invalid = 0;
                int fixed = 0;
                for (VoteSite site : CommandLoader.this.plugin.getVoteSitesEnabled()) {
                    if (site.isVaidServiceSite()) continue;
                    ++invalid;
                    if (CommandLoader.this.plugin.getServiceSiteHandler().contains(site.getServiceSite())) {
                        ++fixed;
                        CommandLoader.this.plugin.getConfigVoteSites().setServiceSite(site.getKey(), CommandLoader.this.plugin.getServiceSiteHandler().match(site.getServiceSite()));
                        this.sendMessage(sender, "&aChanging '" + site.getServiceSite() + "' to '" + CommandLoader.this.plugin.getServiceSiteHandler().match(site.getServiceSite()) + "' on site '" + site.getKey() + "'");
                        continue;
                    }
                    this.sendMessage(sender, "&cCouldn't find an valid service site for '" + site.getServiceSite() + "' on site '" + site.getKey() + "'");
                }
                if (fixed > 0) {
                    CommandLoader.this.plugin.reload();
                }
                this.sendMessage(sender, "&aDetected " + invalid + " service sites possibly invalid, fixed " + fixed);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Help&?", "(number)"}, "VotingPlugin.Commands.AdminVote.Help|" + this.adminPerm, "See this page"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                int page = Integer.parseInt(args[1]);
                new AdminVoteHelp(CommandLoader.this.plugin, sender, page).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Edit", "BungeeSettings"}, "VotingPlugin.Commands.AdminVote.Edit.BungeeSettings", "Edit BungeeSettings.yml", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new ConfigEditor(CommandLoader.this.plugin, CommandLoader.this.plugin.getBungeeSettings()).open((Player)sender);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Edit", "VoteShop"}, "VotingPlugin.Commands.AdminVote.Edit.VoteShop", "Edit VoteShop", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVoteVoteShop(CommandLoader.this.plugin, sender).open(GUIMethod.CHEST);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Edit", "MileStones"}, "VotingPlugin.Commands.AdminVote.Edit.MileStones", "Edit milestones rewards", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVoteMilestones(CommandLoader.this.plugin, sender).open(GUIMethod.CHEST);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Edit", "Cumulative"}, "VotingPlugin.Commands.AdminVote.Edit.Cumulative", "Edit cumulative rewards", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVoteCumulative(CommandLoader.this.plugin, sender).open(GUIMethod.CHEST);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Edit", "VoteParty"}, "VotingPlugin.Commands.AdminVote.Edit.VoteParty", "Edit voteparty", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVoteVoteParty(CommandLoader.this.plugin, sender).open(GUIMethod.CHEST);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Perms"}, "VotingPlugin.Commands.AdminVote.Perms|" + this.adminPerm, "List permissions"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePerms(CommandLoader.this.plugin, sender, 1).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Perms", "(Number)"}, "VotingPlugin.Commands.AdminVote.Perms|" + this.adminPerm, "List permissions"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePerms(CommandLoader.this.plugin, sender, Integer.parseInt(args[1])).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PermsPlayer", "(Player)"}, "VotingPlugin.Commands.AdminVote.Perms.Other|" + this.adminPerm, "List permissions from the plugin the player has"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePerms(CommandLoader.this.plugin, sender, 1, args[1]).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PermsPlayer", "(Player)", "(Number)"}, "VotingPlugin.Commands.AdminVote.Perms.Other|" + this.adminPerm, "List permissions from the plugin the player has"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePerms(CommandLoader.this.plugin, sender, Integer.parseInt(args[2]), args[1]).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Perms", "(Number)", "(Player)"}, "VotingPlugin.Commands.AdminVote.Perms.Other|" + this.adminPerm, "List permissions from the plugin the specificed player has"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePerms(CommandLoader.this.plugin, sender, Integer.parseInt(args[1]), args[2]).open();
            }
        });
        if (this.plugin.getOptions().getDebug().equals((Object)DebugLevel.DEV)) {
            this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PermsDebug"}, "VotingPlugin.Commands.AdminVote.PermsDebug", "Dev permission list, generate this list, requires dev debug"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    this.sendMessage(sender, ArrayUtils.convert(new AdminVotePerms(CommandLoader.this.plugin, sender, 0).listPermsDev(sender)));
                }
            });
        }
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Reload"}, "VotingPlugin.Commands.AdminVote.Reload|" + this.adminPerm, "Reload plugin, will not reload user storage"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&4Reloading " + CommandLoader.this.plugin.getName() + "...");
                CommandLoader.this.plugin.reload();
                if (CommandLoader.this.plugin.isYmlError()) {
                    this.sendMessage(sender, "&3Detected yml error, please check server log for details");
                }
                if (CommandLoader.this.plugin.getProfile().equals("dev")) {
                    this.sendMessage(sender, "&cDetected using dev build, there could be bugs, use at your own risk");
                }
                this.sendMessage(sender, "&4" + CommandLoader.this.plugin.getName() + " v" + CommandLoader.this.plugin.getDescription().getVersion() + " reloaded! Note: User storage has not been reloaded");
                if (CommandLoader.this.plugin.getServerData().getServiceSites().size() == 0) {
                    this.sendMessage(sender, "&cDetected that server hasn't received any votes from votifier, please check votifier connection");
                }
                if (!CommandLoader.this.plugin.getConfigFile().isDisableUpdateChecking() && !CommandLoader.this.plugin.getDescription().getVersion().endsWith("SNAPSHOT") && CommandLoader.this.plugin.getUpdater() != null && CommandLoader.this.plugin.getUpdater().getResult().equals((Object)Updater.UpdateResult.UPDATE_AVAILABLE)) {
                    this.sendMessage(sender, "&3Plugin has update available! https://www.spigotmc.org/resources/votingplugin.15358/");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ReloadAll"}, "VotingPlugin.Commands.AdminVote.Reload|" + this.adminPerm, "Reload plugin, including user storage"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&4Reloading " + CommandLoader.this.plugin.getName() + "...");
                CommandLoader.this.plugin.reloadAll();
                if (CommandLoader.this.plugin.isYmlError()) {
                    this.sendMessage(sender, "&3Detected yml error, please check server log for details");
                }
                if (CommandLoader.this.plugin.getProfile().equals("dev")) {
                    this.sendMessage(sender, "&cDetected using dev build, there could be bugs, use at your own risk");
                }
                this.sendMessage(sender, "&4" + CommandLoader.this.plugin.getName() + " v" + CommandLoader.this.plugin.getDescription().getVersion() + " reloaded!");
                if (CommandLoader.this.plugin.getServerData().getServiceSites().size() == 0) {
                    this.sendMessage(sender, "&cDetected that server hasn't received any votes from votifier, please check votifier connection");
                }
                if (!CommandLoader.this.plugin.getConfigFile().isDisableUpdateChecking() && !CommandLoader.this.plugin.getDescription().getVersion().endsWith("SNAPSHOT") && CommandLoader.this.plugin.getUpdater() != null && CommandLoader.this.plugin.getUpdater().getResult().equals((Object)Updater.UpdateResult.UPDATE_AVAILABLE)) {
                    this.sendMessage(sender, "&3Plugin has update available! https://www.spigotmc.org/resources/votingplugin.15358/");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Version"}, "VotingPlugin.Commands.AdminVote.Version|" + this.adminPerm, "List version info"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (sender instanceof Player) {
                    final Player player = (Player)sender;
                    CommandLoader.this.plugin.getBukkitScheduler().runTask((Plugin)CommandLoader.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            player.performCommand("bukkit:version " + CommandLoader.this.plugin.getName());
                        }
                    });
                } else {
                    CommandLoader.this.plugin.getBukkitScheduler().runTask((Plugin)CommandLoader.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "bukkit:version " + CommandLoader.this.plugin.getName());
                        }
                    });
                }
                this.sendMessage(sender, "Using AdvancedCore " + CommandLoader.this.plugin.getVersion() + "' built on '" + CommandLoader.this.plugin.getBuildTime());
                if (!CommandLoader.this.plugin.getAdvancedCoreBuildNumber().equals("NOTSET")) {
                    this.sendMessage(sender, "AdvancedCore Jenkins build number: " + CommandLoader.this.plugin.getAdvancedCoreBuildNumber());
                }
                if (!CommandLoader.this.plugin.getBuildNumber().equals("NOTSET")) {
                    this.sendMessage(sender, "Using VotingPlugin jenkins build: " + CommandLoader.this.plugin.getBuildNumber());
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Sites"}, "VotingPlugin.Commands.AdminVote.Sites|" + this.adminPerm, "List VoteSites", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminGUI(CommandLoader.this.plugin).openAdminGUIVoteSites((Player)sender);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"GUI"}, "VotingPlugin.Commands.AdminVote.GUI|" + this.adminPerm, "Admin GUI", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                com.bencodez.votingplugin.advancedcore.command.gui.AdminGUI.getInstance().openGUI((Player)sender);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Sites", "(sitename)"}, "VotingPlugin.Commands.AdminVote.Sites.Site|" + this.adminPerm, "View Site Info"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (sender instanceof Player) {
                    new AdminGUI(CommandLoader.this.plugin).openAdminGUIVoteSiteSite((Player)sender, CommandLoader.this.plugin.getVoteSite(args[1], false));
                } else {
                    sender.sendMessage("Must be a player to do this");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"UUID", "(player)"}, "VotingPlugin.Commands.AdminVote.UUID|" + this.adminPerm, "View UUID of player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                sender.sendMessage(ChatColor.GREEN + "UUID of player " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " is: " + PlayerManager.getInstance().getUUID(args[1]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PlayerName", "(uuid)"}, "VotingPlugin.Commands.AdminVote.PlayerName|" + this.adminPerm, "View PlayerName of player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                try {
                    sender.sendMessage(ChatColor.GREEN + "PlayerName of player " + ChatColor.DARK_GREEN + args[1] + ChatColor.GREEN + " is: " + PlayerManager.getInstance().getPlayerName(CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(args[1])), args[1]));
                }
                catch (IllegalArgumentException e) {
                    this.sendMessage(sender, "&cInvalid uuid");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ClearTotal"}, "VotingPlugin.Commands.AdminVote.ClearTotal.All|" + this.adminPerm, "Reset totals for all players"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (sender instanceof Player) {
                    sender.sendMessage(MessageAPI.colorize("&cThis command can not be done from ingame"));
                    return;
                }
                for (TopVoter top : TopVoter.values()) {
                    CommandLoader.this.plugin.getUserManager().removeAllKeyValues(top.getColumnName(), DataType.INTEGER);
                }
                CommandLoader.this.plugin.getUserManager().getDataManager().clearCache();
                CommandLoader.this.plugin.setUpdate(true);
                sender.sendMessage(MessageAPI.colorize("&cCleared totals for everyone"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ResetTotal", "(TopVoter)"}, "VotingPlugin.Commands.AdminVote.ResetTotal.All|" + this.adminPerm, "Reset specific totals for all players (DAY/WEEK/MONTH)"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (sender instanceof Player) {
                    sender.sendMessage(MessageAPI.colorize("&cThis command can not be done from ingame"));
                    return;
                }
                TopVoter top = TopVoter.getTopVoter(args[1]);
                if (top.equals((Object)TopVoter.AllTime)) {
                    this.sendMessage(sender, "&cCan't reset all time total or invalid argument: " + args[1]);
                    return;
                }
                CommandLoader.this.plugin.getUserManager().removeAllKeyValues(top.getColumnName(), DataType.INTEGER);
                CommandLoader.this.plugin.getUserManager().getDataManager().clearCache();
                CommandLoader.this.plugin.setUpdate(true);
                sender.sendMessage(MessageAPI.colorize("&cCleared totals of " + top.getColumnName()));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ClearOfflineVoteRewards"}, "VotingPlugin.Commands.AdminVote.ClearOfflineVoteRewards|" + this.adminPerm, "Reset offline votes/rewards"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (sender instanceof Player) {
                    sender.sendMessage(MessageAPI.colorize("&cThis command can not be done from ingame"));
                    return;
                }
                CommandLoader.this.plugin.getUserManager().removeAllKeyValues("OfflineVotes", DataType.STRING);
                CommandLoader.this.plugin.getUserManager().removeAllKeyValues(CommandLoader.this.plugin.getUserManager().getOfflineRewardsPath(), DataType.STRING);
                CommandLoader.this.plugin.getUserManager().getDataManager().clearCache();
                sender.sendMessage(MessageAPI.colorize("&cCleared offline votes/rewards"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "SetVoteStreak", "DAY", "(number)"}, "VotingPlugin.Commands.AdminVote.SetVoteStreak.Day|" + this.adminPerm, "Set votestreak for player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]).setDayVoteStreak(Integer.parseInt(args[4]));
                sender.sendMessage(MessageAPI.colorize("&cSet votestreak day for '" + args[1] + "' to " + args[4]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "SetVoteStreak", "WEEK", "(number)"}, "VotingPlugin.Commands.AdminVote.SetVoteStreak.Week|" + this.adminPerm, "Set votestreak for player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]).setWeekVoteStreak(Integer.parseInt(args[4]));
                sender.sendMessage(MessageAPI.colorize("&cSet votestreak week for '" + args[1] + "' to " + args[4]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "SetVoteStreak", "MONTH", "(number)"}, "VotingPlugin.Commands.AdminVote.SetVoteStreak.Month|" + this.adminPerm, "Set votestreak for player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]).setMonthVoteStreak(Integer.parseInt(args[4]));
                sender.sendMessage(MessageAPI.colorize("&cSet votestreak month for '" + args[1] + "' to " + args[4]));
            }
        });
        for (final TopVoter top : TopVoter.values()) {
            this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "SetTotal", top.toString(), "(number)"}, "VotingPlugin.Commands.AdminVote.SetTotal." + top.toString() + "|" + this.adminPerm, "Set " + top.toString() + " totals for player"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]).setTotal(top, Integer.parseInt(args[4]));
                    sender.sendMessage(MessageAPI.colorize("&cSet " + top.toString() + " total for '" + args[1] + "' to " + args[4]));
                }
            });
            this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "AddTotal", top.toString(), "(number)"}, "VotingPlugin.Commands.AdminVote.AddTotal." + top.toString() + "|" + this.adminPerm, "Add " + top.toString() + " totals for player"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                    user.setTotal(top, user.getTotal(top) + Integer.parseInt(args[4]));
                    sender.sendMessage(MessageAPI.colorize("&cAdded " + top.toString() + " total for " + args[1]));
                }
            });
        }
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ClearTotal"}, "VotingPlugin.Commands.AdminVote.ClearTotal|" + this.adminPerm, "Clear Totals for player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.clearTotals();
                sender.sendMessage(MessageAPI.colorize("&cCleared totals for '" + args[1] + "'"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ResetAllVotedSites"}, "VotingPlugin.Commands.AdminVote.ResetAllVotedSites|" + this.adminPerm, "Resets all voted"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.resetLastVoted();
                CommandLoader.this.plugin.getCoolDownCheck().check(user);
                CommandLoader.this.plugin.getCoolDownCheck().checkPerSite(user);
                sender.sendMessage(MessageAPI.colorize("&cVoted sites reset for '" + args[1] + "'"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ResetVotedSite", "(Sitename)"}, "VotingPlugin.Commands.AdminVote.ResetVotedSite|" + this.adminPerm, "Resets last voted for specific site"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.resetLastVoted(CommandLoader.this.plugin.getVoteSite(args[3], false));
                CommandLoader.this.plugin.getCoolDownCheck().checkPerSite(user);
                sender.sendMessage(MessageAPI.colorize("&cVoted site reset for '" + args[1] + "' on " + args[3]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new PlayerCommandHandler(this.plugin, new String[]{"User", "(player)", "AddMilestoneCount", "(number)"}, "VotingPlugin.Commands.AdminVote.AddMilestoneCount|" + this.adminPerm, "Add milestonecount"){

            @Override
            public void executeAll(CommandSender sender, String[] args) {
                int toAdd = Integer.parseInt(args[3]);
                sender.sendMessage(MessageAPI.colorize("&cAdding milestonecount for all players..."));
                for (String uuidStr : CommandLoader.this.plugin.getUserManager().getAllUUIDs()) {
                    UUID uuid = UUID.fromString(uuidStr);
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid);
                    user.dontCache();
                    user.setMilestoneCount(user.getMilestoneCount() + toAdd);
                    CommandLoader.this.plugin.getSpecialRewards().checkMilestone(user, null, CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                }
                sender.sendMessage(MessageAPI.colorize("&cFinished adding milestonecount for all players"));
            }

            @Override
            public void executeSinglePlayer(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.setMilestoneCount(user.getMilestoneCount() + Integer.parseInt(args[3]));
                CommandLoader.this.plugin.getSpecialRewards().checkMilestone(user, null, CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                sender.sendMessage(MessageAPI.colorize("&cAdded milestonecount for " + args[1]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "SetMilestoneCount", "(number)"}, "VotingPlugin.Commands.AdminVote.SetMilestoneCount|" + this.adminPerm, "Set milestonecount"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.setMilestoneCount(Integer.parseInt(args[3]));
                sender.sendMessage(MessageAPI.colorize("&cSet milestonecount for " + args[1] + " to " + args[3]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new PlayerCommandHandler(this.plugin, new String[]{"User", "(player)", "ClearGottenMilestones"}, "VotingPlugin.Commands.AdminVote.ClearGottenMilestones|" + this.adminPerm, "Clears received milestones"){

            @Override
            public void executeAll(CommandSender sender, String[] args) {
                String path = "GottenMileStones";
                if (CommandLoader.this.plugin.getBungeeSettings().isPerServerMilestones()) {
                    path = CommandLoader.this.plugin.getBungeeSettings().getServerNameStorage() + "_GottenMilestones";
                }
                sender.sendMessage(MessageAPI.colorize("&cClearing gotten milestones for all players..."));
                CommandLoader.this.plugin.getUserManager().removeAllKeyValues(path, DataType.STRING);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    CommandLoader.this.plugin.getUserManager().getDataManager().cacheUser(p.getUniqueId(), p.getName());
                }
                sender.sendMessage(MessageAPI.colorize("&cFinished clearing gotten milestones for all players"));
            }

            @Override
            public void executeSinglePlayer(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                user.setHasGottenMilestone(new HashMap<String, Boolean>());
                sender.sendMessage(MessageAPI.colorize("&cClearing gotten milestones for " + args[1]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Vote", "(player)", "All"}, "VotingPlugin.Commands.AdminVote.Vote|" + this.adminPerm, "Trigger manual vote"){

            @Override
            public void execute(final CommandSender sender, final String[] args) {
                this.sendMessage(sender, "&cTriggering vote for all voting sites...");
                for (final VoteSite site : CommandLoader.this.plugin.getVoteSitesEnabled()) {
                    CommandLoader.this.plugin.getVoteTimer().submit(new Runnable(){

                        @Override
                        public void run() {
                            PlayerVoteEvent voteEvent = new PlayerVoteEvent(site, args[1], site.getServiceSite(), false);
                            if (voteEvent.getVoteSite() != null && !voteEvent.getVoteSite().isVaidServiceSite() && !CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage()) {
                                this.sendMessage(sender, "&cPossible issue with service site, has the server gotten the vote from " + voteEvent.getServiceSite() + "?");
                            }
                            CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                        }
                    });
                }
                if (CommandLoader.this.plugin.isYmlError()) {
                    this.sendMessage(sender, "&3Detected yml error, please check server log for details");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Vote", "(player)", "(Sitename)"}, "VotingPlugin.Commands.AdminVote.Vote|" + this.adminPerm, "Trigger manual vote"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                final PlayerVoteEvent voteEvent = new PlayerVoteEvent(CommandLoader.this.plugin.getVoteSite(args[2], true), args[1], args[2], false);
                if (voteEvent.getVoteSite() != null) {
                    if (!voteEvent.getVoteSite().isVaidServiceSite() && !CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage()) {
                        this.sendMessage(sender, "&cPossible issue with service site, has the server gotten the vote from " + voteEvent.getServiceSite() + "?");
                    }
                    if (!CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage() && !this.isPlayer(sender)) {
                        this.sendMessage(sender, "&cTriggering vote...");
                    }
                    CommandLoader.this.plugin.getVoteTimer().submit(new Runnable(){

                        @Override
                        public void run() {
                            CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                        }
                    });
                    if (CommandLoader.this.plugin.isYmlError()) {
                        this.sendMessage(sender, "&3Detected yml error, please check server log for details");
                    }
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteExact", "(PlayerExact)", "(Sitename)"}, "VotingPlugin.Commands.AdminVote.VoteExact|" + this.adminPerm, "Trigger manual vote with exact player name"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                final PlayerVoteEvent voteEvent = new PlayerVoteEvent(CommandLoader.this.plugin.getVoteSite(args[2], true), args[1], args[2], false);
                if (!CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage() && !this.isPlayer(sender)) {
                    this.sendMessage(sender, "&cTriggering vote...");
                }
                if (voteEvent.getVoteSite() != null && !voteEvent.getVoteSite().isVaidServiceSite() && !CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage()) {
                    this.sendMessage(sender, "&cPossible issue with service site, has the server gotten the vote from " + voteEvent.getServiceSite() + "?");
                }
                CommandLoader.this.plugin.getVoteTimer().submit(new Runnable(){

                    @Override
                    public void run() {
                        CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                    }
                });
                if (CommandLoader.this.plugin.isYmlError()) {
                    this.sendMessage(sender, "&3Detected yml error, please check server log for details");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Vote", "(player)"}, "VotingPlugin.Commands.AdminVote.Vote|" + this.adminPerm, "Trigger manual vote via GUI", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVoteVotePlayer(CommandLoader.this.plugin, sender, args[1]).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Vote"}, "VotingPlugin.Commands.AdminVote.Vote|" + this.adminPerm, "Manual vote syntax"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&aUse /av vote (player) (site)");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(Player)", "ForceVote", "All"}, "VotingPlugin.Commands.AdminVote.Vote|" + this.adminPerm, "Trigger manual vote"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cTriggering vote for all voting sites...");
                for (VoteSite site : CommandLoader.this.plugin.getVoteSitesEnabled()) {
                    PlayerVoteEvent voteEvent = new PlayerVoteEvent(site, args[1], site.getServiceSite(), false);
                    if (voteEvent.getVoteSite() != null && !voteEvent.getVoteSite().isVaidServiceSite() && !CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage()) {
                        this.sendMessage(sender, "&cPossible issue with service site, has the server gotten the vote from " + voteEvent.getServiceSite() + "?");
                    }
                    CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                }
                if (CommandLoader.this.plugin.isYmlError()) {
                    this.sendMessage(sender, "&3Detected yml error, please check server log for details");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(Player)", "ForceVote", "(Sitename)"}, "VotingPlugin.Commands.AdminVote.Vote|" + this.adminPerm, "Trigger manual vote"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                PlayerVoteEvent voteEvent = new PlayerVoteEvent(CommandLoader.this.plugin.getVoteSite(args[3], true), args[1], args[3], false);
                if (!CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage() && !this.isPlayer(sender)) {
                    this.sendMessage(sender, "&cTriggering vote...");
                }
                if (voteEvent.getVoteSite() != null && !voteEvent.getVoteSite().isVaidServiceSite() && !CommandLoader.this.plugin.getConfigFile().isDisableNoServiceSiteMessage()) {
                    this.sendMessage(sender, "&cPossible issue with service site, has the server gotten the vote from " + voteEvent.getServiceSite() + "?");
                }
                CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(Player)", "ForceCoolDownEndRewards", "(Sitename)"}, "VotingPlugin.Commands.AdminVote.ForceCoolDownEndRewards|" + this.adminPerm, "Trigger CoolDownEndRewards manually"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                PlayerVoteSiteCoolDownEndEvent event = new PlayerVoteSiteCoolDownEndEvent(user, CommandLoader.this.plugin.getVoteSite(args[3], true));
                CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)event);
                this.sendMessage(sender, "&cCoolDownEndRewards forced on votesite " + args[3]);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "Create"}, "VotingPlugin.Commands.AdminVote.VoteSite.Edit|" + this.adminPerm, "Create VoteSite"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                sender.sendMessage(MessageAPI.colorize("&cCreating VoteSite..." + args[1]));
                CommandLoader.this.plugin.getConfigVoteSites().generateVoteSite(args[1]);
                sender.sendMessage(MessageAPI.colorize("&cCreated VoteSite: &c&l" + args[1]));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Config", "TempDebug"}, "VotingPlugin.Commands.AdminVote.Config.Edit|" + this.adminPerm, "Enable debug, effective until reload/restart"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getOptions().setDebug(DebugLevel.INFO);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Config", "TempExtraDebug"}, "VotingPlugin.Commands.AdminVote.Config.Edit|" + this.adminPerm, "Enable extra debug, effective until reload/restart"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getOptions().setDebug(DebugLevel.EXTRA);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "SetServiceSite", "(string)"}, "VotingPlugin.Commands.AdminVote.VoteSite.Edit|" + this.adminPerm, "Set VoteSite SerivceSite"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String voteSite = CommandLoader.this.plugin.getVoteSiteName(true, args[1]);
                String serviceSite = args[3];
                CommandLoader.this.plugin.getConfigVoteSites().setServiceSite(voteSite, serviceSite);
                sender.sendMessage(MessageAPI.colorize("&cSet ServiceSite to &c&l" + serviceSite + "&c on &c&l" + voteSite));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"CheckVoteCoolDownRewards"}, "VotingPlugin.Commands.AdminVote.VoteSite.CheckVoteCoolDownRewards|" + this.adminPerm, "Force check all vote cooldown rewards"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getCoolDownCheck().getTimer().schedule(new Runnable(){

                    @Override
                    public void run() {
                        for (VoteSite site : CommandLoader.this.plugin.getVoteSitesEnabled()) {
                            if (!site.isVoteDelayDaily()) continue;
                            CommandLoader.this.plugin.getCoolDownCheck().checkAllVoteSite(site);
                        }
                    }
                }, 5L, TimeUnit.SECONDS);
                sender.sendMessage(MessageAPI.colorize("&cForce checking on vote cooldown rewards"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "SetVoteURL", "(string)"}, "VotingPlugin.Commands.AdminVote.VoteSite.Edit|" + this.adminPerm, "Set VoteSite VoteURL"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String voteSite = CommandLoader.this.plugin.getVoteSiteName(true, args[1]);
                String url = args[3];
                CommandLoader.this.plugin.getConfigVoteSites().setVoteURL(voteSite, url);
                sender.sendMessage(MessageAPI.colorize("&cSet VoteURL to &c&l" + url + "&c on &c&l" + voteSite));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "SetPriority", "(number)"}, "VotingPlugin.Commands.AdminVote.VoteSite.Edit|" + this.adminPerm, "Set VoteSite Priority"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String voteSite = CommandLoader.this.plugin.getVoteSiteName(true, args[1]);
                int value = Integer.parseInt(args[3]);
                CommandLoader.this.plugin.getConfigVoteSites().setPriority(voteSite, value);
                sender.sendMessage(MessageAPI.colorize("&cSet priortiy to &c&l" + value + "&c on &c&l" + voteSite));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "SetVoteDelay", "(number)"}, "VotingPlugin.Commands.AdminVote.VoteSite.Edit|" + this.adminPerm, "Set VoteSite VoteDelay"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String voteSite = CommandLoader.this.plugin.getVoteSiteName(true, args[1]);
                int delay = Integer.parseInt(args[3]);
                CommandLoader.this.plugin.getConfigVoteSites().setVoteDelay(voteSite, delay);
                sender.sendMessage(MessageAPI.colorize("&cSet VoteDelay to &c&l" + delay + "&c on &c&l" + voteSite));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"UpdateCheck"}, "VotingPlugin.Commands.AdminVote.UpdateCheck|" + this.adminPerm, "Check for update"){

            @Override
            public void execute(final CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)CommandLoader.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        sender.sendMessage(MessageAPI.colorize("&cChecking for update..."));
                        CommandLoader.this.plugin.setUpdater(new Updater(CommandLoader.this.plugin, 15358, false));
                        Updater.UpdateResult result = CommandLoader.this.plugin.getUpdater().getResult();
                        switch (result) {
                            case FAIL_SPIGOT: {
                                sender.sendMessage(MessageAPI.colorize("&cFailed to check for update for &c&l" + CommandLoader.this.plugin.getName() + "&c!"));
                                break;
                            }
                            case NO_UPDATE: {
                                sender.sendMessage(MessageAPI.colorize("&c&l" + CommandLoader.this.plugin.getName() + " &cis up to date! Version: &c&l" + CommandLoader.this.plugin.getUpdater().getVersion()));
                                break;
                            }
                            case UPDATE_AVAILABLE: {
                                sender.sendMessage(MessageAPI.colorize("&c&l" + CommandLoader.this.plugin.getName() + " &chas an update available! Your Version: &c&l" + CommandLoader.this.plugin.getDescription().getVersion() + " &cNew Version: &c&l" + CommandLoader.this.plugin.getUpdater().getVersion()));
                                break;
                            }
                        }
                    }
                });
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "SetEnabled", "(boolean)"}, "VotingPlugin.Commands.AdminVote.VoteSite.Edit|" + this.adminPerm, "Set VoteSite Enabled"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String voteSite = CommandLoader.this.plugin.getVoteSiteName(false, args[1]);
                boolean value = Boolean.parseBoolean(args[3]);
                CommandLoader.this.plugin.getConfigVoteSites().setEnabled(voteSite, value);
                sender.sendMessage(MessageAPI.colorize("&cSet votesite " + voteSite + " enabled to " + value));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteSite", "(sitename)", "Check"}, "VotingPlugin.Commands.AdminVote.VoteSite.Check|" + this.adminPerm, "Check to see if VoteSite is valid"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String siteName = args[1];
                if (!CommandLoader.this.plugin.getConfigVoteSites().isServiceSiteGood(siteName)) {
                    sender.sendMessage(MessageAPI.colorize("&cServiceSite is invalid, votes may not work properly"));
                } else {
                    String service = CommandLoader.this.plugin.getConfigVoteSites().getServiceSite(siteName);
                    if (CommandLoader.this.plugin.getServerData().getServiceSites().contains(service)) {
                        sender.sendMessage(MessageAPI.colorize("&aServiceSite is properly setup"));
                    } else {
                        sender.sendMessage(MessageAPI.colorize("&cService may not be valid, haven't recieved a vote from " + service + ", see /av servicesites"));
                    }
                }
                if (!CommandLoader.this.plugin.getConfigVoteSites().isVoteURLGood(siteName)) {
                    sender.sendMessage(MessageAPI.colorize("&cVoteURL is invalid"));
                } else {
                    sender.sendMessage(MessageAPI.colorize("&aVoteURL is properly setup"));
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"BackgroundUpdate"}, "VotingPlugin.Commands.AdminVote.BackgroundUpdate|" + this.adminPerm, "Force a background update"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.setUpdate(true);
                CommandLoader.this.plugin.update();
                sender.sendMessage(MessageAPI.colorize("&cUpdating..."));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ClearOfflineVotes"}, "VotingPlugin.Commands.AdminVote.ClearOfflineVotes|" + this.adminPerm, "Clear all offline votes"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getUserManager().removeAllKeyValues("OfflineVotes", DataType.STRING);
                CommandLoader.this.plugin.getUserManager().getDataManager().clearCache();
                sender.sendMessage(MessageAPI.colorize("&cOffline votes Cleared"));
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Test", "(Player)", "(sitename)", "(number)"}, "VotingPlugin.Commands.AdminVote.Test|" + this.adminPerm, "Test voting speed, for debug"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVoteTester().testVotes(Integer.parseInt(args[3]), args[1], args[2]);
                if (this.isPlayer(sender)) {
                    this.sendMessage(sender, "&cSee console for details");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"TestSpam", "(Player)", "(sitename)", "(number)"}, "VotingPlugin.Commands.AdminVote.TestSpam|" + this.adminPerm, "Test voting spam speed, for debug"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVoteTester().testSpam(Integer.parseInt(args[3]), args[1], args[2]);
                if (this.isPlayer(sender)) {
                    this.sendMessage(sender, "&cSee console for details");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"TestReward", "(Player)", "(reward)", "(number)"}, "VotingPlugin.Commands.AdminVote.TestReward|" + this.adminPerm, "Test reward speed, for debug"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVoteTester().testRewards(Integer.parseInt(args[3]), args[1], args[2]);
                if (this.isPlayer(sender)) {
                    this.sendMessage(sender, "&cSee console for details");
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Placeholders"}, "VotingPlugin.Commands.AdminVote.Placeholders|" + this.adminPerm, "See possible placeholderapi placeholders"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePlaceholders(CommandLoader.this.plugin, sender).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteParty", "Force"}, "VotingPlugin.Commands.AdminVote.VoteParty.Force|" + this.adminPerm, "Force a voteparty reward, resets vote count"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVoteParty().giveRewards(null, CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteParty", "SetVoteCount", "(Number)"}, "VotingPlugin.Commands.AdminVote.VoteParty.SetVoteCount|" + this.adminPerm, "Set voteparty count"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                int num = Integer.parseInt(args[2]);
                if (num == 0) {
                    CommandLoader.this.plugin.getVoteParty().reset(true);
                    this.sendMessage(sender, "&cVoteparty totals have been set to 0 and all been reset");
                } else {
                    CommandLoader.this.plugin.getVoteParty().setTotalVotes(num);
                    this.sendMessage(sender, "&cVoteparty total votes has been set to " + args[2]);
                }
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteParty", "AddVoteCount", "(Number)"}, "VotingPlugin.Commands.AdminVote.VoteParty.SetVoteCount|" + this.adminPerm, "Add voteparty count"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                int num = CommandLoader.this.plugin.getVoteParty().getTotalVotes() + Integer.parseInt(args[2]);
                CommandLoader.this.plugin.getVoteParty().setTotalVotes(num);
                this.sendMessage(sender, "&cVoteparty total votes has been set to " + num);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"VoteParty", "SetExtraRequired", "(Number)"}, "VotingPlugin.Commands.AdminVote.VoteParty.SetExtraRequired|" + this.adminPerm, "Set VotePartyExtraRequired value"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getServerData().setVotePartyExtraRequired(Integer.parseInt(args[2]));
                this.sendMessage(sender, "&cSet VotePartyExtraRequired to " + args[2]);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceVoteShop", "(VoteShop)"}, "VotingPlugin.Commands.AdminVote.ForceVoteShop|" + this.adminPerm, "Force a voteshop reward"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)CommandLoader.this.plugin.getConfigFile().getData(), CommandLoader.this.plugin.getShopFile().getShopIdentifierRewardsPath(args[3]), new RewardOptions());
                this.sendMessage(sender, "&cVoteShop " + args[3] + " forced");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceMilestone", "(Number)"}, "VotingPlugin.Commands.AdminVote.ForceMilestone|" + this.adminPerm, "Force a milestone"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getSpecialRewards().giveMilestoneVoteReward(user, user.isOnline(), this.parseInt(args[3]), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                this.sendMessage(sender, "&cMilestone " + args[3] + " forced");
            }
        });
        for (final TopVoter top : TopVoter.valuesMinusAllTime()) {
            this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceTopVoter", top.toString(), "(Number)"}, "VotingPlugin.Commands.AdminVote.ForceTopVoter." + top.toString() + "|" + this.adminPerm, "Force a top voter reward"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                    int place = this.parseInt(args[4]);
                    switch (top) {
                        case Daily: {
                            user.giveDailyTopVoterAward(place, args[4]);
                            break;
                        }
                        case Monthly: {
                            user.giveMonthlyTopVoterAward(place, args[4]);
                            break;
                        }
                        case Weekly: {
                            user.giveWeeklyTopVoterAward(place, args[4]);
                            break;
                        }
                    }
                    this.sendMessage(sender, "&cTopVoter " + top.toString() + " " + args[4] + " forced");
                }
            });
            String text = "";
            switch (top) {
                case Daily: {
                    text = "Day";
                    break;
                }
                case Monthly: {
                    text = "Month";
                    break;
                }
                case Weekly: {
                    text = "Week";
                    break;
                }
            }
            final String str = text;
            this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceVoteStreak", str, "(Text)"}, "VotingPlugin.Commands.AdminVote.ForceVoteStreak|" + this.adminPerm, "Force a votestreak reward for " + str){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    String num = args[4];
                    if (num.contains("-")) {
                        num = num.replaceAll("-", "");
                    }
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                    CommandLoader.this.plugin.getSpecialRewards().giveVoteStreakReward(user, user.isOnline(), str, args[4], this.parseInt(num), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                    this.sendMessage(sender, "&cVoteStreak " + str + " " + args[4] + " forced");
                }
            });
        }
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceCumulative", "(Number)"}, "VotingPlugin.Commands.AdminVote.ForceCumulative|" + this.adminPerm, "Force a cumulative reward"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getSpecialRewards().giveCumulativeVoteReward(user, user.isOnline(), this.parseInt(args[3]), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                this.sendMessage(sender, "&cCumulative " + args[3] + " forced");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceAllSites"}, "VotingPlugin.Commands.AdminVote.ForceAllSites|" + this.adminPerm, "Force a allsites reward"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getSpecialRewards().giveAllSitesRewards(user, user.isOnline(), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                this.sendMessage(sender, "&cAllSites forced");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceAlmostAllSites"}, "VotingPlugin.Commands.AdminVote.ForceAllSites|" + this.adminPerm, "Force a almostallsites reward"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getSpecialRewards().giveAlmostAllSitesRewards(user, user.isOnline(), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                this.sendMessage(sender, "&cAlmostAllSites forced");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceFirstVote"}, "VotingPlugin.Commands.AdminVote.ForceFirstVote|" + this.adminPerm, "Force a firstvote reward"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getSpecialRewards().giveFirstVoteRewards(user, user.isOnline(), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                this.sendMessage(sender, "&cFirstVote forced");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"User", "(player)", "ForceFirstVoteToday"}, "VotingPlugin.Commands.AdminVote.ForceFirstVoteToday|" + this.adminPerm, "Force a firstvotetoday reward"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                CommandLoader.this.plugin.getSpecialRewards().giveFirstVoteTodayRewards(user, user.isOnline(), CommandLoader.this.plugin.getBungeeSettings().isUseBungeecoord());
                this.sendMessage(sender, "&cFirstVoteToday forced");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PurgeNoData"}, "VotingPlugin.PurgeNoData", "Purge players from database with no data and haven't been online for a number of days (Set in Config.yml)"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVotingPluginUserManager().purgeOldPlayersNowNoData();
                this.sendMessage(sender, "&cPurged players with no data");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"RemoveOfflineUUIDs"}, "VotingPlugin.Commands.AdminVote.RemoveOfflineUUIDs|" + this.adminPerm, "Purges database of offline UUIDs, keeps online UUIDs", true, true){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (!CommandLoader.this.plugin.getOptions().isOnlineMode()) {
                    this.sendMessage(sender, "&cNot in online mode!");
                    return;
                }
                int amount = 0;
                for (String uuid : CommandLoader.this.plugin.getUserManager().getAllUUIDs()) {
                    if (uuid.charAt(14) != '3') continue;
                    CommandLoader.this.plugin.getUserManager().removeUUID(UUID.fromString(uuid));
                    ++amount;
                }
                this.sendMessage(sender, "&cOffline UUIDs purged: " + amount);
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Placeholders", "(player)"}, "VotingPlugin.Commands.AdminVote.Placeholders.Players|" + this.adminPerm, "See possible placeholderapi placeholders with player values"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new AdminVotePlaceholdersPlayer(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"MergeDataFrom", "(UserStorage)"}, "VotingPlugin.Commands.AdminVote.MergeDataFrom|" + this.adminPerm, "Merge player totals from other storage type", true, true){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.loadUserAPI(UserStorage.value(args[1]));
                if (CommandLoader.this.plugin.getMysql() != null) {
                    CommandLoader.this.plugin.getMysql().clearCacheBasic();
                }
                HashMap<UUID, ArrayList<Column>> cols = CommandLoader.this.plugin.getUserManager().getAllKeys(UserStorage.value(args[1]));
                LinkedList<Map.Entry<UUID, ArrayList<Column>>> players = new LinkedList<Map.Entry<UUID, ArrayList<Column>>>(cols.entrySet());
                ArrayList<String> uuids = CommandLoader.this.plugin.getUserManager().getAllUUIDs();
                while (players.size() > 0) {
                    Map.Entry entry = (Map.Entry)players.poll();
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((UUID)entry.getKey(), false);
                    user.dontCache();
                    if (uuids.contains(((UUID)entry.getKey()).toString())) {
                        user.mergeData(user.getData().convert((List)entry.getValue()));
                    } else {
                        user.getData().setValues(CommandLoader.this.plugin.getStorageType(), user.getData().convert((List)entry.getValue()));
                    }
                    this.sendMessage(sender, "Finished merge for " + user.getUUID() + ", " + players.size() + " more left to go!");
                    if (players.size() % 50 != 0) continue;
                    this.sendMessage(sender, "Working on converting data, about " + players.size() + " left to go!");
                }
                CommandLoader.this.plugin.getUserManager().getDataManager().clearCache();
                this.sendMessage(sender, "Merge finished");
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ClearDiscordMessageID", "(topvoter)"}, "VotingPlugin.Commands.AdminVote.ClearDiscordMessageID", "Clear discord message ID for top voter", true, true){

            @Override
            public void execute(CommandSender sender, String[] args) {
                String topVoter = args[1];
                TopVoter top = TopVoter.getTopVoter(topVoter);
                CommandLoader.this.plugin.getServerData().setTopVoterMessageId(top, 0L);
                CommandLoader.this.plugin.getDiscordHandler().getTopVoterMessageIds().put(top, 0L);
                this.sendMessage(sender, "&cCleared discord message ID for " + top.toString());
            }
        });
        this.plugin.getAdminVoteCommand().add(new CommandHandler(this.plugin, new String[0], "VotingPlugin.Commands.AdminVote|" + this.adminPerm, "Base command"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                this.sendMessage(sender, "&cInvalid command, see /adminvote help");
            }
        });
        ArrayList<CommandHandler> avCommands = com.bencodez.votingplugin.advancedcore.command.CommandLoader.getInstance().getBasicAdminCommands("VotingPlugin");
        for (CommandHandler cmd : avCommands) {
            cmd.setPerm(cmd.getPerm() + "|" + this.adminPerm);
        }
        this.plugin.getAdminVoteCommand().addAll(avCommands);
    }

    public void loadAliases() {
        String currentPerm;
        String[] args;
        Permission p;
        String[] perms;
        String arg0;
        int argLength;
        this.commands = new HashMap();
        if (!this.plugin.getConfigFile().isLoadCommandAliases()) {
            return;
        }
        for (CommandHandler cmdHandle : this.plugin.getVoteCommand()) {
            argLength = cmdHandle.getArgs().length;
            arg0 = "";
            if (argLength > 0) {
                arg0 = cmdHandle.getArgs()[0];
            }
            perms = cmdHandle.getPerm().split(Pattern.quote("|"));
            try {
                if (perms.length > 1) {
                    this.plugin.devDebug("Adding child perm " + perms[0] + " to " + perms[1] + " from /vote" + arg0);
                    p = Bukkit.getPluginManager().getPermission(perms[1]);
                    p.getChildren().put(perms[0], true);
                    p.recalculatePermissibles();
                }
            }
            catch (Exception e) {
                this.plugin.debug("Failed to set permission for /vote" + arg0);
            }
            if (argLength <= 0) continue;
            for (String arg : args = cmdHandle.getArgs()[0].split("&")) {
                this.commands.put("vote" + arg, cmdHandle);
                try {
                    this.plugin.getCommand("vote" + arg).setExecutor((CommandExecutor)new CommandAliases(cmdHandle, false));
                    this.plugin.getCommand("vote" + arg).setTabCompleter((TabCompleter)new AliasesTabCompleter().setCMDHandle(cmdHandle, false));
                    currentPerm = this.plugin.getCommand("vote" + arg).getPermission();
                    if (currentPerm == null || currentPerm.length() > perms[0].length()) {
                        this.plugin.getCommand("vote" + arg).setPermission(perms[0]);
                    }
                    for (String str : this.plugin.getCommand("vote" + arg).getAliases()) {
                        this.commands.put(str, cmdHandle);
                    }
                }
                catch (Exception ex) {
                    this.plugin.devDebug("Failed to load command and tab completer for /vote" + arg);
                }
            }
        }
        for (CommandHandler cmdHandle : this.plugin.getAdminVoteCommand()) {
            argLength = cmdHandle.getArgs().length;
            arg0 = "";
            if (argLength > 0) {
                arg0 = cmdHandle.getArgs()[0];
            }
            perms = cmdHandle.getPerm().split(Pattern.quote("|"));
            try {
                if (perms.length > 1) {
                    this.plugin.devDebug("Adding child perm " + perms[0] + " to " + perms[1] + " from /adminvote" + arg0);
                    p = Bukkit.getPluginManager().getPermission(perms[1]);
                    p.getChildren().put(perms[0], true);
                    p.recalculatePermissibles();
                }
            }
            catch (Exception e) {
                this.plugin.debug("Failed to set permission for /adminvote" + arg0);
            }
            if (argLength <= 0) continue;
            for (String arg : args = cmdHandle.getArgs()[0].split("&")) {
                this.commands.put("adminvote" + arg, cmdHandle);
                try {
                    this.plugin.getCommand("adminvote" + arg).setExecutor((CommandExecutor)new CommandAliases(cmdHandle, true));
                    this.plugin.getCommand("adminvote" + arg).setTabCompleter((TabCompleter)new AliasesTabCompleter().setCMDHandle(cmdHandle, true));
                    currentPerm = this.plugin.getCommand("adminvote" + arg).getPermission();
                    if (currentPerm == null || currentPerm.length() > perms[0].length()) {
                        this.plugin.getCommand("adminvote" + arg).setPermission(perms[0]);
                    }
                    for (String str : this.plugin.getCommand("adminvote" + arg).getAliases()) {
                        this.commands.put(str, cmdHandle);
                    }
                }
                catch (Exception ex) {
                    this.plugin.devDebug("Failed to load command and tab completer for /adminvote" + arg + ": " + ex.getMessage());
                }
            }
        }
    }

    public void loadCommands() {
        this.loadAdminVoteCommand();
        this.loadVoteCommand();
        this.plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                CommandLoader.this.loadTabComplete();
                UserGUI.getInstance().addPluginButton((Plugin)CommandLoader.this.plugin, new BInventoryButton("Force Vote", new String[0], new ItemStack(Material.STONE)){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        Player player = clickEvent.getPlayer();
                        ArrayList<String> voteSites = new ArrayList<String>();
                        for (VoteSite voteSite : CommandLoader.this.plugin.getVoteSitesEnabled()) {
                            voteSites.add(voteSite.getKey());
                        }
                        new ValueRequest().requestString(player, "", ArrayUtils.convert(voteSites), true, new StringListener(){

                            @Override
                            public void onInput(Player player, String value) {
                                PlayerVoteEvent voteEvent = new PlayerVoteEvent(CommandLoader.this.plugin.getVoteSite(value, true), UserGUI.getInstance().getCurrentPlayer(player), CommandLoader.this.plugin.getVoteSiteServiceSite(value), false);
                                CommandLoader.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                                player.sendMessage("Forced vote for " + UserGUI.getInstance().getCurrentPlayer(player) + " on " + value);
                            }
                        });
                    }
                });
                UserGUI.getInstance().addPluginButton((Plugin)CommandLoader.this.plugin, new BInventoryButton("MileStones", new String[0], new ItemStack(Material.STONE)){

                    @Override
                    public void onClick(final BInventory.ClickEvent event) {
                        Player player = event.getWhoClicked();
                        String playerName = (String)event.getMeta(player, "Player");
                        BInventory inv = new BInventory("MileStones: " + playerName);
                        for (String mileStoneName : CommandLoader.this.plugin.getSpecialRewardsConfig().getMilestoneVotes()) {
                            if (!MessageAPI.isInt(mileStoneName)) continue;
                            int mileStone = Integer.parseInt(mileStoneName);
                            inv.addButton(inv.getNextSlot(), new BInventoryButton("" + mileStone, new String[]{"Enabled: " + CommandLoader.this.plugin.getSpecialRewardsConfig().getMilestoneRewardEnabled(mileStone), "&cClick to set wether this has been completed or not"}, new ItemStack(Material.STONE)){

                                @Override
                                public void onClick(BInventory.ClickEvent clickEvent) {
                                    if (MessageAPI.isInt(clickEvent.getClickedItem().getItemMeta().getDisplayName())) {
                                        Player player = clickEvent.getPlayer();
                                        final int mileStone = Integer.parseInt(clickEvent.getClickedItem().getItemMeta().getDisplayName());
                                        String playerName = (String)event.getMeta(player, "Player");
                                        VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(playerName);
                                        new ValueRequest().requestBoolean(player, "" + user.hasGottenMilestone(mileStone), new BooleanListener(){

                                            @Override
                                            public void onInput(Player player, boolean value) {
                                                String playerName = UserGUI.getInstance().getCurrentPlayer(player);
                                                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(playerName);
                                                user.setHasGotteMilestone(mileStone, value);
                                                player.sendMessage("Set milestone completetion to " + value + " on " + mileStone);
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public void loadTabComplete() {
        ArrayList<String> sites = new ArrayList<String>();
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            sites.add(site.getKey());
        }
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(Sitename)", sites){

            @Override
            public void reload() {
                ArrayList<String> sites = new ArrayList<String>();
                for (VoteSite site : CommandLoader.this.plugin.getVoteSitesEnabled()) {
                    sites.add(site.getKey());
                }
                this.setReplace(sites);
            }

            @Override
            public void updateReplacements() {
            }
        });
        ArrayList<String> topVoter = new ArrayList<String>();
        for (TopVoter top : TopVoter.values()) {
            topVoter.add(top.toString());
        }
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(topvoter)", topVoter){

            @Override
            public void reload() {
                ArrayList<String> topVoter = new ArrayList<String>();
                for (TopVoter top : TopVoter.values()) {
                    topVoter.add(top.toString());
                }
                this.setReplace(topVoter);
            }

            @Override
            public void updateReplacements() {
            }
        });
        TabCompleteHandler.getInstance().addTabCompleteOption(new TabCompleteHandle("(VoteShop)", sites){

            @Override
            public void reload() {
                ArrayList<String> sites = new ArrayList<String>();
                for (String str : CommandLoader.this.plugin.getShopFile().getShopIdentifiers()) {
                    sites.add(str);
                }
                this.setReplace(sites);
            }

            @Override
            public void updateReplacements() {
            }
        });
    }

    private void loadVoteCommand() {
        this.plugin.setVoteCommand(new ArrayList<CommandHandler>());
        if (this.plugin.getConfigFile().isUsePrimaryAccountForPlaceholders()) {
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"SetPrimaryAccount", "(player)"}, "VotingPlugin.Commands.Vote.SetPrimaryAccount|" + this.modPerm, "Set primary account", false){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(sender.getName());
                    if (args[1].equals("none")) {
                        user.setPrimaryAccount(null);
                        this.sendMessage(sender, "&cRemoved primary account");
                    } else {
                        try {
                            user.setPrimaryAccount(UUID.fromString(PlayerManager.getInstance().getUUID(args[1])));
                            this.sendMessage(sender, "&cPrimary account set");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.sendMessage(sender, "Failed to set primary account: " + e.getMessage());
                        }
                    }
                }
            });
        }
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Help&?"}, "VotingPlugin.Commands.Vote.Help|" + this.playerPerm, "View help page"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteHelp(CommandLoader.this.plugin, sender, 1).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Help&?", "(number)"}, "VotingPlugin.Commands.Vote.Help|" + this.playerPerm, "View help page"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteHelp(CommandLoader.this.plugin, sender, Integer.parseInt(args[1])).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ToggleReminders"}, "VotingPlugin.Commands.Vote.ToggleReminders", "Enable/disable vote reminders", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                Player p = (Player)sender;
                boolean value = false;
                if (CommandLoader.this.plugin.getVoteReminding().getRemindersEnabled().containsKey(p.getUniqueId())) {
                    value = CommandLoader.this.plugin.getVoteReminding().getRemindersEnabled().get(p.getUniqueId()) == false;
                }
                CommandLoader.this.plugin.getVoteReminding().getRemindersEnabled().put(p.getUniqueId(), value);
                CommandLoader.this.plugin.getPlaceholders().onUpdate(CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(p.getUniqueId(), p.getName()), true);
                CommandLoader.this.plugin.getVoteReminding().saveReminds();
                if (value) {
                    this.sendMessage(sender, CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteToggleRemindersEnabled());
                } else {
                    this.sendMessage(sender, CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteToggleRemindersDisabled());
                }
            }
        });
        if (this.plugin.getShopFile().isVoteShopEnabled()) {
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Shop"}, "VotingPlugin.Commands.Vote.Shop|" + this.playerPerm, "Open VoteShop GUI", false){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    new VoteShop(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
                }
            });
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Shop", "(Text)"}, "VotingPlugin.Commands.Vote.Shop|" + this.playerPerm, "Open VoteShop GUI", false){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    if (!CommandLoader.this.plugin.getShopFile().isVoteShopEnabled()) {
                        sender.sendMessage(MessageAPI.colorize("&cVote shop disabled"));
                        return;
                    }
                    String identifier = args[1];
                    Set<String> identifiers = CommandLoader.this.plugin.getShopFile().getShopIdentifiers();
                    if (ArrayUtils.containsIgnoreCase(identifiers, identifier)) {
                        for (String ident : identifiers) {
                            if (!ident.equalsIgnoreCase(args[1])) continue;
                            identifier = ident;
                        }
                        String perm = CommandLoader.this.plugin.getShopFile().getVoteShopPermission(identifier);
                        boolean hasPerm = false;
                        hasPerm = perm.isEmpty() ? true : sender.hasPermission(perm);
                        int limit = CommandLoader.this.plugin.getShopFile().getShopIdentifierLimit(identifier);
                        VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(sender.getName());
                        boolean limitPass = true;
                        if (limit > 0 && user.getVoteShopIdentifierLimit(identifier) >= limit) {
                            limitPass = false;
                        }
                        if (!CommandLoader.this.plugin.getShopFile().getVoteShopNotBuyable(identifier) && hasPerm) {
                            if (CommandLoader.this.plugin.getConfigFile().isExtraVoteShopCheck()) {
                                user.cache();
                            }
                            int points = CommandLoader.this.plugin.getShopFile().getShopIdentifierCost(identifier);
                            if (identifier != null) {
                                if (limitPass) {
                                    HashMap<String, String> placeholders = new HashMap<String, String>();
                                    placeholders.put("identifier", identifier);
                                    placeholders.put("points", "" + points);
                                    placeholders.put("limit", "" + limit);
                                    if (user.removePoints(points, true)) {
                                        CommandLoader.this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)CommandLoader.this.plugin.getShopFile().getData(), CommandLoader.this.plugin.getShopFile().getShopIdentifierRewardsPath(identifier), new RewardOptions().setPlaceholders(placeholders));
                                        user.sendMessage(PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatShopPurchaseMsg(), placeholders));
                                        if (limit > 0) {
                                            user.setVoteShopIdentifierLimit(identifier, user.getVoteShopIdentifierLimit(identifier) + 1);
                                        }
                                    } else {
                                        user.sendMessage(PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatShopFailedMsg(), placeholders));
                                    }
                                } else {
                                    user.sendMessage(CommandLoader.this.plugin.getShopFile().getVoteShopLimitReached());
                                }
                            }
                        }
                    } else {
                        this.sendMessage(sender, "&cWrong voteshop item");
                    }
                }
            });
        }
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"URL", "(SiteName)"}, "VotingPlugin.Commands.Vote.URL.VoteSite", "Open VoteURL GUI for VoteSite", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteURLVoteSite(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender), args[1]).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"URL"}, "VotingPlugin.Commands.Vote.URL|" + this.playerPerm, "Open VoteURL GUI", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteURL(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender), true).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Last", "(player)"}, "VotingPlugin.Commands.Vote.Last.Other|" + this.modPerm, "See other players last votes"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    new VoteLast(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Last"}, "VotingPlugin.Commands.Vote.Last|" + this.playerPerm, "See your last votes", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteLast(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"ToggleBroadcast"}, "VotingPlugin.Commands.Vote.ToggleBroadcast|" + this.playerPerm, "Toggle whether or not you will recieve vote broadcasts", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender);
                boolean value = !user.getDisableBroadcast();
                user.setDisableBroadcast(value);
                if (!value) {
                    this.sendMessage(sender, CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteToggleBroadcastEnabled());
                } else {
                    this.sendMessage(sender, CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteToggleBroadcastDisabled());
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Next", "(player)"}, "VotingPlugin.Commands.Vote.Next.Other|" + this.modPerm, "See other players next votes"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    new VoteNext(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Points", "(player)"}, "VotingPlugin.Commands.Vote.Points.Other|" + this.modPerm, "View pints of other player"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                    String msg = CommandLoader.this.plugin.getConfigFile().getFormatCommandsVotePoints().replace("%Player%", user.getPlayerName()).replace("%Points%", "" + user.getPoints());
                    if (sender instanceof Player) {
                        CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender).sendMessage(msg);
                    } else {
                        sender.sendMessage(MessageAPI.colorize(msg));
                    }
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Points"}, "VotingPlugin.Commands.Vote.Points|" + this.playerPerm, "View your points", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender);
                String msg = CommandLoader.this.plugin.getConfigFile().getFormatCommandsVotePoints().replace("%Player%", user.getPlayerName()).replace("%Points%", "" + user.getPoints());
                user.sendMessage(msg);
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Next"}, "VotingPlugin.Commands.Vote.Next|" + this.playerPerm, "See your next votes", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteNext(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"GUI", "(player)"}, "VotingPlugin.Commands.Vote.GUI.Other|" + this.modPerm, "Open VoteGUI", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    new VoteGUI(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"GUI"}, "VotingPlugin.Commands.Vote.GUI|" + this.playerPerm, "Open VoteGUI", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteGUI(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
            }
        });
        if (this.plugin.getGui().isLastMonthGUI() || this.plugin.getOptions().getDebug().equals((Object)DebugLevel.DEV)) {
            this.plugin.debug("Loading last month top");
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"LastMonthTop"}, "VotingPlugin.Commands.Vote.LastMonthTop|" + this.playerPerm, "Open list of Top Voters from last month"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    new VoteTopVoterLastMonth(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
                }
            });
        }
        if (this.plugin.getConfigFile().isStoreMonthTotalsWithDate() || this.plugin.getOptions().getDebug().equals((Object)DebugLevel.DEV)) {
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"PreviousMonthsTotals"}, "VotingPlugin.Commands.Vote.PreviousMonthsTotals", "Open list of Top Voters from all known previous months"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    new VoteTopVoterPreviousMonths(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender), 0).open();
                }
            });
        }
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Top"}, "VotingPlugin.Commands.Vote.Top|" + this.playerPerm, "Open list of Top Voters"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteTopVoter(CommandLoader.this.plugin, sender, null, TopVoter.getDefault(), 1).open(GUIMethod.valueOf(CommandLoader.this.plugin.getGui().getGuiMethodTopVoter().toUpperCase()));
            }
        });
        for (final TopVoter top : TopVoter.values()) {
            String argName = top.toString();
            Object perm = top.toString();
            if (argName.equals(TopVoter.AllTime.toString())) {
                argName = "All";
                perm = "All";
            }
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Top", argName}, "VotingPlugin.Commands.Vote.Top." + (String)perm + "|" + this.playerPerm, "Open page of Top Voters"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    new VoteTopVoter(CommandLoader.this.plugin, sender, null, top, 1).open(GUIMethod.valueOf(CommandLoader.this.plugin.getGui().getGuiMethodTopVoter().toUpperCase()));
                }
            });
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Top", argName, "(number)"}, "VotingPlugin.Commands.Vote.Top." + (String)perm + "|" + this.playerPerm, "Open page of Top Voters"){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    int page = Integer.parseInt(args[2]);
                    new VoteTopVoter(CommandLoader.this.plugin, sender, null, top, page).open(GUIMethod.valueOf(CommandLoader.this.plugin.getGui().getGuiMethodTopVoter().toUpperCase()));
                }
            });
        }
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Top", "(number)"}, "VotingPlugin.Commands.Vote.Top|" + this.playerPerm, "Open page of Top Voters"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                int page = Integer.parseInt(args[1]);
                new VoteTopVoter(CommandLoader.this.plugin, sender, null, TopVoter.getDefault(), page).open(GUIMethod.valueOf(CommandLoader.this.plugin.getGui().getGuiMethodTopVoter().toUpperCase()));
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Party"}, "VotingPlugin.Commands.Vote.Party|" + this.playerPerm, "View current amount of votes and how many more needed"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                CommandLoader.this.plugin.getVoteParty().commandVoteParty(sender);
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Today", "(number)"}, "VotingPlugin.Commands.Vote.Today|" + this.playerPerm, "Open page of who Voted Today"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                int page = Integer.parseInt(args[1]);
                new VoteToday(CommandLoader.this.plugin, sender, null, page).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Today"}, "VotingPlugin.Commands.Vote.Today|" + this.playerPerm, "View who list of who voted today"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteToday(CommandLoader.this.plugin, sender, null, 1).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Total", "All"}, "VotingPlugin.Commands.Vote.Total.All|" + this.playerPerm, "View server total votes"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                ArrayList<String> msg = new ArrayList<String>();
                int daily = 0;
                int weekly = 0;
                int month = 0;
                int all = 0;
                block6: for (TopVoter top : TopVoter.values()) {
                    int cTotal = 0;
                    ArrayList<Integer> nums = CommandLoader.this.plugin.getUserManager().getNumbersInColumn(top.getColumnName());
                    for (Integer num : nums) {
                        cTotal += num.intValue();
                    }
                    switch (top) {
                        case AllTime: {
                            all = cTotal;
                            continue block6;
                        }
                        case Daily: {
                            daily = cTotal;
                            continue block6;
                        }
                        case Monthly: {
                            month = cTotal;
                            continue block6;
                        }
                        case Weekly: {
                            weekly = cTotal;
                            continue block6;
                        }
                    }
                }
                for (String s : CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteTotalAll()) {
                    String str = MessageAPI.replaceIgnoreCase(s, "%DailyTotal%", "" + daily);
                    str = MessageAPI.replaceIgnoreCase(str, "%WeeklyTotal%", "" + weekly);
                    str = MessageAPI.replaceIgnoreCase(str, "%MonthlyTotal%", "" + month);
                    str = MessageAPI.replaceIgnoreCase(str, "%AllTimeTotal%", "" + all);
                    msg.add(str);
                }
                msg = ArrayUtils.colorize(msg);
                this.sendMessage(sender, msg);
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Total", "(player)"}, "VotingPlugin.Commands.Vote.Total.Other|" + this.modPerm, "View other players total votes"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    new VoteTotal(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Total"}, "VotingPlugin.Commands.Vote.Total|" + this.playerPerm, "View your total votes", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteTotal(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Best"}, "VotingPlugin.Commands.Vote.Best|" + this.playerPerm, "View your best voting", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteBest(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Best", "(player)"}, "VotingPlugin.Commands.Vote.Best.Other|" + this.modPerm, "View someone's best voting"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    new VoteBest(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Streak"}, "VotingPlugin.Commands.Vote.Streak|" + this.playerPerm, "View your voting streak", false){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteStreak(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender)).open();
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"Streak", "(player)"}, "VotingPlugin.Commands.Vote.Streak.Other|" + this.modPerm, "View someone's voting streak"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                    new VoteStreak(CommandLoader.this.plugin, sender, CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1])).open();
                } else {
                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatUserNotExist(), "player", args[1]));
                }
            }
        });
        if (this.plugin.getConfigFile().isAllowVotePointTransfers()) {
            this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"GivePoints", "(player)", "(number)"}, "VotingPlugin.Commands.Vote.GivePoints", "Give someone points from your points", false){

                @Override
                public void execute(CommandSender sender, String[] args) {
                    if (CommandLoader.this.plugin.getConfigFile().isAllowVotePointTransfers()) {
                        VotingPluginUser cPlayer = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender);
                        cPlayer.cache();
                        if (CommandLoader.this.plugin.getUserManager().userExist(args[1])) {
                            int pointsToGive;
                            VotingPluginUser user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser(args[1]);
                            if (!user.isOnline()) {
                                user.dontCache();
                            }
                            if ((pointsToGive = Integer.parseInt(args[2])) > 0) {
                                if (cPlayer.getPoints() >= pointsToGive) {
                                    user.addPoints(pointsToGive);
                                    cPlayer.removePoints(pointsToGive);
                                    HashMap<String, String> placeholders = new HashMap<String, String>();
                                    placeholders.put("transfer", "" + pointsToGive);
                                    placeholders.put("touser", "" + user.getPlayerName());
                                    placeholders.put("fromuser", "" + cPlayer.getPlayerName());
                                    this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteGivePointsTransferFrom(), placeholders));
                                    user.sendMessage(PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteGivePointsTransferTo(), placeholders));
                                } else {
                                    this.sendMessage(sender, CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteGivePointsNotEnoughPoints());
                                }
                            } else {
                                this.sendMessage(sender, CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteGivePointsNumberLowerThanZero());
                            }
                        } else {
                            this.sendMessage(sender, PlaceholderUtils.replacePlaceHolder(CommandLoader.this.plugin.getConfigFile().getFormatCommandsVoteGivePointsNotJoinedServer(), "player", args[1]));
                        }
                    }
                }
            });
        }
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[0], "VotingPlugin.Commands.Vote|" + this.playerPerm, "See voting URLs"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                VotingPluginUser user = null;
                if (sender instanceof Player) {
                    user = CommandLoader.this.plugin.getVotingPluginUserManager().getVotingPluginUser((Player)sender);
                }
                if (CommandLoader.this.plugin.getConfigFile().isUseVoteGUIMainCommand() && sender instanceof Player) {
                    new VoteGUI(CommandLoader.this.plugin, sender, user).open();
                } else {
                    new VoteURL(CommandLoader.this.plugin, sender, user, true).open();
                }
            }
        });
        this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, new String[]{"List&All"}, "VotingPlugin.Commands.Vote.List|" + this.playerPerm, "See voting URLs"){

            @Override
            public void execute(CommandSender sender, String[] args) {
                new VoteURL(CommandLoader.this.plugin, sender, null, true).open(GUIMethod.CHAT);
            }
        });
        if (this.plugin.getConfigFile().isAddCustomCommands()) {
            for (String ident : this.plugin.getConfigFile().getCustomCommands()) {
                final ConfigurationSection section = this.plugin.getConfigFile().getCustomCommands(ident);
                String[] args = ArrayUtils.convert((ArrayList)section.getList("Args", new ArrayList()));
                this.plugin.getVoteCommand().add(new CommandHandler(this.plugin, args, section.getString("Permission", ""), section.getString("HelpMessage", "")){

                    @Override
                    public void execute(final CommandSender sender, String[] args) {
                        this.sendMessage(sender, section.getString("Message", ""));
                        for (final String str : (ArrayList)section.getList("Commands", new ArrayList())) {
                            CommandLoader.this.plugin.getBukkitScheduler().runTask((Plugin)CommandLoader.this.plugin, new Runnable(){

                                @Override
                                public void run() {
                                    Bukkit.getServer().dispatchCommand(sender, str);
                                }
                            });
                        }
                    }
                });
            }
        }
        ArrayList<CommandHandler> avCommands = com.bencodez.votingplugin.advancedcore.command.CommandLoader.getInstance().getBasicCommands("VotingPlugin");
        for (CommandHandler cmd : avCommands) {
            cmd.setPerm(cmd.getPerm() + "|" + this.playerPerm);
        }
        this.plugin.getVoteCommand().addAll(avCommands);
        ArrayList<CommandHandler> list = this.plugin.getVoteCommand();
        ArrayList<String> disabledCommands = this.plugin.getConfigFile().getDisabledCommands();
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean remove = false;
            for (String disabled : disabledCommands) {
                CommandHandler handle = list.get(i);
                if (!handle.getPerm().contains(disabled)) continue;
                remove = true;
            }
            if (!remove) continue;
            this.plugin.debug("Disabling: " + ArrayUtils.makeStringList(ArrayUtils.convert(list.get(i).getArgs())));
            list.remove(i);
        }
        ArrayList<String> disabledDefaultPerms = this.plugin.getConfigFile().getDisabledDefaultPermissions();
        for (CommandHandler cmd : list) {
            boolean contains = false;
            for (String dis : disabledDefaultPerms) {
                if (!cmd.getPerm().contains(dis + "|")) continue;
                contains = true;
            }
            if (!contains) continue;
            cmd.setPerm(cmd.getPerm().replace("|" + this.playerPerm, ""));
            this.plugin.debug("Disabling VotingPlugin.Player permission on " + cmd.getPerm());
        }
    }

    public void processSlotClick(Player player, VotingPluginUser user, String slot) {
        if (MessageAPI.startsWithIgnoreCase(slot, "url")) {
            new VoteURL(this.plugin, (CommandSender)player, user, true).open();
        } else if (MessageAPI.startsWithIgnoreCase(slot, "next")) {
            new VoteNext(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "last")) {
            new VoteLast(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "total")) {
            new VoteTotal(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "top")) {
            new VoteTopVoter(this.plugin, (CommandSender)player, user, TopVoter.getDefault(), 1).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "today")) {
            new VoteToday(this.plugin, (CommandSender)player, user, 1).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "help")) {
            player.performCommand("vote help");
        } else if (MessageAPI.startsWithIgnoreCase(slot, "shop")) {
            new VoteShop(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "lastmonth")) {
            new VoteTopVoterLastMonth(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "best")) {
            new VoteBest(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        } else if (MessageAPI.startsWithIgnoreCase(slot, "streak")) {
            new VoteStreak(this.plugin, (CommandSender)player, user).open(GUIMethod.CHEST);
        }
    }

    public void setCommands(HashMap<String, CommandHandler> commands) {
        this.commands = commands;
    }
}

