/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.broadcast;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BroadcastHandler {
    private VotingPluginMain plugin;
    private ScheduledExecutorService timer;
    ConcurrentLinkedQueue<String> votedPlayers = new ConcurrentLinkedQueue();

    public BroadcastHandler(VotingPluginMain plugin, int delay) {
        this.plugin = plugin;
        this.schedule(delay);
    }

    public void check() {
        int size = this.votedPlayers.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.votedPlayers.poll();
            }
            String bc = MessageAPI.colorize(this.plugin.getConfigFile().getFormatAlternateBroadcastBroadcast());
            String playersText = "";
            while (!this.votedPlayers.isEmpty()) {
                playersText = playersText + (String)this.votedPlayers.remove();
                if (this.votedPlayers.isEmpty()) continue;
                playersText = playersText + ", ";
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("numberofplayers", "" + size);
            placeholders.put("players", playersText);
            bc = PlaceholderUtils.replacePlaceHolder(bc, placeholders);
            ArrayList<Player> players = new ArrayList<Player>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.plugin.getVotingPluginUserManager().getVotingPluginUser(p).getDisableBroadcast()) continue;
                players.add(p);
            }
            MiscUtils.getInstance().broadcast(bc, players);
        }
    }

    public void onVote(String player) {
        this.votedPlayers.add(player);
    }

    public void schedule(int delay) {
        if (this.timer != null) {
            this.timer.shutdownNow();
            this.timer = Executors.newScheduledThreadPool(1);
        } else {
            this.timer = Executors.newScheduledThreadPool(1);
        }
        this.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                BroadcastHandler.this.check();
            }
        }, 60L, 60 * delay, TimeUnit.SECONDS);
    }
}

