/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.listeners;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;

public class WorldChangeEvent
implements Listener {
    private AdvancedCorePlugin plugin;

    public WorldChangeEvent(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (this.plugin != null && this.plugin.isEnabled() && this.plugin.isLoadUserData()) {
            final Player player = event.getPlayer();
            this.plugin.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (WorldChangeEvent.this.plugin.getOptions().isDisableCheckOnWorldChange() || player == null || !WorldChangeEvent.this.plugin.isLoadUserData()) {
                        return;
                    }
                    AdvancedCoreUser user = WorldChangeEvent.this.plugin.getUserManager().getUser(player);
                    if (user.isCheckWorld()) {
                        user.checkOfflineRewards();
                    }
                }
            }, 10L);
        }
    }
}

