/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.listeners;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.listeners.AdvancedCoreLoginEvent;
import com.bencodez.votingplugin.simpleapi.command.TabCompleteHandler;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;

public class PlayerJoinEvent
implements Listener {
    private AdvancedCorePlugin plugin;

    public PlayerJoinEvent(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onJoin(AdvancedCoreLoginEvent event) {
        if (event.isUserInStorage() && this.plugin.isLoadUserData()) {
            Player player = event.getPlayer();
            this.plugin.getBedrockHandle().learn(player);
            boolean userExist = this.plugin.getUserManager().userExist(event.getPlayer().getUniqueId());
            if (player.getName().startsWith(this.plugin.getOptions().getBedrockPlayerPrefix())) {
                userExist = true;
                if (this.plugin.getOptions().isOnlineMode()) {
                    this.plugin.getUuidNameCache().put(player.getUniqueId().toString(), player.getName());
                } else {
                    this.plugin.getUuidNameCache().put(PlayerManager.getInstance().getUUID(player.getName()), player.getName());
                }
                this.plugin.extraDebug("Detected Geyser Player, Forcing player data to load");
            }
            this.plugin.getUserManager().getDataManager().cacheUser(player.getUniqueId(), player.getName());
            if (userExist) {
                AdvancedCoreUser user = this.plugin.getUserManager().getUser(player);
                user.checkOfflineRewards();
                user.setLastOnline(System.currentTimeMillis());
                user.updateName(false);
            }
            if (this.plugin.getOptions().isOnlineMode()) {
                this.plugin.getUuidNameCache().put(player.getUniqueId().toString(), player.getName());
            } else {
                this.plugin.getUuidNameCache().put(PlayerManager.getInstance().getUUID(player.getName()), player.getName());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerLogin(final org.bukkit.event.player.PlayerJoinEvent event) {
        if (this.plugin != null && this.plugin.isEnabled() && this.plugin.isLoadUserData()) {
            this.plugin.getLogger().info("Login: " + event.getPlayer().getName() + " (" + event.getPlayer().getUniqueId() + ")");
            this.plugin.getLoginTimer().schedule(new Runnable(){

                @Override
                public void run() {
                    block10: {
                        try {
                            if (PlayerJoinEvent.this.plugin == null || !PlayerJoinEvent.this.plugin.isEnabled()) break block10;
                            TabCompleteHandler.getInstance().onLogin();
                            if ((PlayerJoinEvent.this.plugin.isAuthMeLoaded() || PlayerJoinEvent.this.plugin.isLoginSecurityLoaded() || PlayerJoinEvent.this.plugin.isNLoginLoaded()) && PlayerJoinEvent.this.plugin.getOptions().isWaitUntilLoggedIn()) {
                                return;
                            }
                            Player player = event.getPlayer();
                            if (player == null) break block10;
                            for (MetadataValue meta : player.getMetadata("vanished")) {
                                if (!meta.asBoolean()) continue;
                                PlayerJoinEvent.this.plugin.debug("Player " + player.getName() + " joined vanished");
                                if (!PlayerJoinEvent.this.plugin.getOptions().isTreatVanishAsOffline()) continue;
                                return;
                            }
                            try {
                                if (PlayerJoinEvent.this.plugin.getCmiHandle() != null && PlayerJoinEvent.this.plugin.getCmiHandle().isVanished(player)) {
                                    PlayerJoinEvent.this.plugin.debug("Player " + player.getName() + " joined vanished");
                                    if (PlayerJoinEvent.this.plugin.getOptions().isTreatVanishAsOffline()) {
                                        return;
                                    }
                                }
                            }
                            catch (Exception e) {
                                PlayerJoinEvent.this.plugin.debug(e);
                            }
                            PlayerJoinEvent.this.plugin.debug("Login: " + event.getPlayer().getName() + " (" + event.getPlayer().getUniqueId() + ")");
                            if (PlayerJoinEvent.this.plugin.getPermissionHandler() != null) {
                                PlayerJoinEvent.this.plugin.getPermissionHandler().login(player);
                            }
                            AdvancedCoreLoginEvent login = new AdvancedCoreLoginEvent(player);
                            Bukkit.getPluginManager().callEvent((Event)login);
                            if (login.isCancelled()) {
                                return;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, (long)(1500 + this.plugin.getOptions().getDelayLoginEvent()), TimeUnit.MILLISECONDS);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin != null && this.plugin.isEnabled()) {
            final Player player = event.getPlayer();
            this.plugin.debug("Logout: " + event.getPlayer().getName() + " (" + player.getUniqueId() + ")");
            this.plugin.getLoginTimer().execute(new Runnable(){

                @Override
                public void run() {
                    if (PlayerJoinEvent.this.plugin != null && PlayerJoinEvent.this.plugin.isEnabled()) {
                        TabCompleteHandler.getInstance().onLogin();
                        PlayerJoinEvent.this.plugin.getUserManager().getDataManager().removeCache(player.getUniqueId(), player.getName());
                    }
                }
            });
        }
    }
}

