/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.data;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.simpleapi.file.YMLFile;
import java.io.File;
import org.bukkit.plugin.Plugin;

public class ServerData
extends YMLFile {
    public ServerData(AdvancedCorePlugin plugin) {
        super(plugin, new File(plugin.getDataFolder(), "ServerData.yml"));
    }

    public long getLastUpdated() {
        return this.getData().getLong("LastUpdated", -1L);
    }

    public String getPluginVersion(Plugin plugin) {
        return this.getData().getString("PluginVersions." + plugin.getName(), "");
    }

    public int getPrevDay() {
        return this.getData().getInt("PrevDay", -1);
    }

    public String getPrevMonth() {
        return this.getData().getString("Month", "");
    }

    public int getPrevWeekDay() {
        return this.getData().getInt("PrevWeek", -1);
    }

    public boolean isIgnoreTime() {
        return this.getData().getBoolean("IgnoreTime", false);
    }

    @Override
    public void onFileCreation() {
    }

    public void setData(String path, Object value) {
        this.getData().set(path, value);
        this.saveData();
    }

    public void setIgnoreTime(boolean value) {
        this.getData().set("IgnoreTime", (Object)value);
        this.saveData();
    }

    public void setLastUpdated() {
        this.getData().set("LastUpdated", (Object)System.currentTimeMillis());
        this.saveData();
    }

    public void setPluginVersion(Plugin plugin) {
        this.getData().set("PluginVersions." + plugin.getName(), (Object)plugin.getDescription().getVersion());
        this.saveData();
    }

    public void setPrevDay(int day) {
        this.getData().set("PrevDay", (Object)day);
        this.saveData();
    }

    public void setPrevMonth(String month) {
        this.getData().set("Month", (Object)month);
        this.saveData();
    }

    public void setPrevWeekDay(int week) {
        this.getData().set("PrevWeek", (Object)week);
        this.saveData();
    }
}

