/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.command.gui;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUI;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueString;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequest;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.StringListener;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class UserGUI {
    static UserGUI instance = new UserGUI();
    private HashMap<Plugin, BInventoryButton> extraButtons = new HashMap();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static UserGUI getInstance() {
        return instance;
    }

    private UserGUI() {
    }

    public synchronized void addPluginButton(Plugin plugin, BInventoryButton inv) {
        this.extraButtons.put(plugin, inv);
    }

    public String getCurrentPlayer(Player player) {
        return (String)PlayerUtils.getPlayerMeta(this.plugin, player, "UserGUI");
    }

    public void openUserGUI(Player player, final String playerName) {
        if (!player.hasPermission("AdvancedCore.UserEdit")) {
            player.sendMessage("Not enough permissions");
            return;
        }
        BInventory inv = new BInventory("UserGUI: " + playerName);
        inv.addData("player", playerName);
        inv.addButton(new BInventoryButton("Give Reward File", new String[0], new ItemStack(Material.STONE)){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                ArrayList<String> rewards = new ArrayList<String>();
                for (Reward reward : UserGUI.this.plugin.getRewardHandler().getRewards()) {
                    rewards.add(reward.getRewardName());
                }
                new ValueRequest().requestString(clickEvent.getPlayer(), "", ArrayUtils.convert(rewards), true, new StringListener(){

                    @Override
                    public void onInput(Player player, String value) {
                        AdvancedCoreUser user = UserGUI.this.plugin.getUserManager().getUser(UserGUI.getInstance().getCurrentPlayer(player));
                        UserGUI.this.plugin.getRewardHandler().giveReward(user, value, new RewardOptions());
                        player.sendMessage("Given " + user.getPlayerName() + " reward file " + value);
                    }
                });
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder("WRITABLE_BOOK").setName("Edit Data")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                Player player = clickEvent.getPlayer();
                EditGUI inv = new EditGUI("Edit Data, click to change");
                final AdvancedCoreUser user = UserGUI.this.plugin.getUserManager().getUser(playerName);
                for (final String key : user.getData().getKeys()) {
                    String value = user.getData().getValue(key);
                    inv.addButton(new EditGUIButton(new ItemBuilder(Material.STONE).setName(key + " = " + value), new EditGUIValueString(key, value){

                        @Override
                        public void setValue(Player player, String value) {
                            if (value.equals("\"\"")) {
                                value = "";
                            }
                            user.getData().setString(key, value);
                            UserGUI.this.openUserGUI(player, playerName);
                        }
                    }));
                }
                inv.openInventory(player);
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.PAPER).setName("&cView player data")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                AdvancedCoreUser user = UserGUI.this.plugin.getUserManager().getUser(playerName);
                for (String key : user.getData().getKeys()) {
                    String str = user.getData().getValue(key);
                    user.sendMessage("&c&l" + key + " &c" + str);
                }
            }
        });
        for (BInventoryButton button : this.extraButtons.values()) {
            inv.addButton(button);
        }
        inv.openInventory(player);
    }

    public void openUsersGUI(Player player) {
        if (!player.hasPermission("AdvancedCore.UserEdit")) {
            player.sendMessage("Not enough permissions");
            return;
        }
        ArrayList<String> players = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            players.add(p.getName());
        }
        new ValueRequest().requestString(player, "", ArrayUtils.convert(players), true, new StringListener(){

            @Override
            public void onInput(Player player, String value) {
                UserGUI.this.setCurrentPlayer(player, value);
                UserGUI.this.openUserGUI(player, value);
            }
        });
    }

    private void setCurrentPlayer(Player player, String playerName) {
        PlayerUtils.setPlayerMeta(this.plugin, player, "UserGUI", playerName);
    }
}

