/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.command.gui;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUI;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.EditGUIButton;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueBoolean;
import com.bencodez.votingplugin.advancedcore.api.inventory.editgui.valuetypes.EditGUIValueInventory;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.DirectlyDefinedReward;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardEditData;
import com.bencodez.votingplugin.advancedcore.api.rewards.editbuttons.RewardEditDelayed;
import com.bencodez.votingplugin.advancedcore.api.rewards.editbuttons.RewardEditTimed;
import com.bencodez.votingplugin.advancedcore.api.rewards.injected.RewardInject;
import com.bencodez.votingplugin.advancedcore.api.rewards.injectedrequirement.RequirementInject;
import com.bencodez.votingplugin.advancedcore.command.gui.RewardGUIConfirmation;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RewardEditGUI {
    static RewardEditGUI instance = new RewardEditGUI();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static RewardEditGUI getInstance() {
        return instance;
    }

    private RewardEditGUI() {
    }

    public HashMap<String, Object> getAllValues(ConfigurationSection data) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String key : data.getKeys(false)) {
            if (data.isConfigurationSection(key)) {
                HashMap<String, Object> valuesc = this.getAllValues(data.getConfigurationSection(key));
                for (Map.Entry<String, Object> entry : valuesc.entrySet()) {
                    values.put(key + "." + entry.getKey(), entry.getValue());
                }
                continue;
            }
            values.put(key, data.get(key));
        }
        return values;
    }

    public Reward getCurrentReward(Player player) {
        return (Reward)PlayerUtils.getPlayerMeta(this.plugin, player, "Reward");
    }

    public void openRewardGUI(Player player, DirectlyDefinedReward directlyDefinedReward) {
        if (!player.hasPermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit")) {
            player.sendMessage("You do not have enough permission to do this");
            return;
        }
        if (directlyDefinedReward == null) {
            player.sendMessage("DirectlyDefinedReward not found");
            return;
        }
        if (!directlyDefinedReward.isDirectlyDefined()) {
            player.sendMessage("Reward " + directlyDefinedReward.getPath() + " is not directly defined or isn't set");
            return;
        }
        this.openRewardGUI(player, new RewardEditData(directlyDefinedReward), directlyDefinedReward.getPath());
    }

    public void openRewardGUI(Player player, Reward reward) {
        if (!player.hasPermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit")) {
            player.sendMessage("You do not have enough permission to do this");
            return;
        }
        this.openRewardGUI(player, new RewardEditData(reward), reward.getName());
    }

    public void openRewardGUI(Player player, final RewardEditData rewardEditData, final String rewardName) {
        EditGUI inv = new EditGUI("Reward: " + rewardName);
        inv.requirePermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit");
        inv.addData("Reward", rewardEditData);
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.REDSTONE).setName("&cRequirements")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.this.openRewardGUIRequirements(clickEvent.getPlayer(), rewardEditData, rewardName);
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.DIAMOND).setName("&cRewards").addLoreLine("&cOnly shows current set values for Rewards")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.this.openRewardGUIRewards(clickEvent.getPlayer(), rewardEditData, rewardName, false);
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.DIAMOND).setName("&cAll Rewards").addLoreLine("&cShows all possible settings")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.this.openRewardGUIRewards(clickEvent.getPlayer(), rewardEditData, rewardName, true);
            }
        });
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.ANVIL).setName("&cCopy from existing reward").addLoreLine("&cDoes not remove existing rewards currently set, unless they overlap")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.this.openRewardsGUICopy(clickEvent.getPlayer(), rewardEditData, rewardName);
            }
        });
        if (rewardEditData.getParent() != null) {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.BARRIER).setName("&cOpen parent reward edit GUI")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditData rewardEditData = (RewardEditData)this.getInv().getData("Reward");
                    rewardEditData.getParent().reOpenEditGUI(clickEvent.getPlayer());
                }
            }.setSlot(-2));
        }
        inv.openInventory(player);
    }

    public void openRewardGUIRequirements(Player player, final RewardEditData rewardEditData, final String rewardName) {
        EditGUI inv = new EditGUI("Requirements: " + rewardName);
        inv.requirePermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit");
        inv.addData("Reward", rewardEditData);
        inv.addButton(new EditGUIButton(new ItemBuilder(Material.PAPER), new EditGUIValueBoolean("ForceOffline", rewardEditData.getValue("ForceOffline")){

            @Override
            public void setValue(Player player, boolean value) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                reward.setValue(this.getKey(), value);
                RewardEditGUI.this.plugin.reloadAdvancedCore(false);
            }
        }.addLore("Force reward to execute to run while player is offline")));
        inv.addButton(new EditGUIButton(new ItemBuilder(Material.PAPER), new EditGUIValueInventory("Delayed"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                new RewardEditDelayed(){

                    @Override
                    public void setVal(String key, Object value) {
                        RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                        reward.setValue(key, value);
                        RewardEditGUI.this.plugin.reloadAdvancedCore(false);
                    }
                }.open(clickEvent.getPlayer(), reward);
            }
        }.addLore("Delay reward from being executed")));
        inv.addButton(new EditGUIButton(new ItemBuilder(Material.PAPER), new EditGUIValueInventory("Timed"){

            @Override
            public void openInventory(BInventory.ClickEvent clickEvent) {
                RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                new RewardEditTimed(){

                    @Override
                    public void setVal(String key, Object value) {
                        RewardEditData reward = (RewardEditData)this.getInv().getData("Reward");
                        reward.setValue(key, value);
                        RewardEditGUI.this.plugin.reloadAdvancedCore(false);
                    }
                }.open(clickEvent.getPlayer(), reward);
            }
        }.addLore("Execute reward at certain time")));
        for (RequirementInject injectReward : this.plugin.getRewardHandler().getInjectedRequirements()) {
            if (!injectReward.isEditable()) continue;
            for (BInventoryButton b : injectReward.getEditButtons()) {
                if (b instanceof EditGUIButton) {
                    EditGUIButton eb = (EditGUIButton)b;
                    if (eb.getEditor().isCanGetValue()) {
                        eb.getEditor().setCurrentValue(rewardEditData.getValue(eb.getEditor().getKey()));
                    }
                    inv.addButton(eb);
                    continue;
                }
                inv.addButton(b);
            }
        }
        inv.sort();
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.BARRIER).setName("&cGo back")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.this.openRewardGUI(clickEvent.getPlayer(), rewardEditData, rewardName);
            }
        });
        inv.openInventory(player);
    }

    public void openRewardGUIRewards(final Player player, final RewardEditData rewardEditData, final String rewardName, boolean unsetValuesShown) {
        EditGUI inv = new EditGUI("Rewards: " + rewardName);
        inv.requirePermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit");
        inv.addData("Reward", rewardEditData);
        for (RewardInject injectReward : this.plugin.getRewardHandler().getInjectedRewards()) {
            if (!injectReward.isEditable()) continue;
            for (BInventoryButton b : injectReward.getEditButtons()) {
                if (b instanceof EditGUIButton) {
                    EditGUIButton eb = (EditGUIButton)b;
                    if (!unsetValuesShown && !eb.getEditor().containsKey(rewardEditData)) continue;
                    if (eb.getEditor().isCanGetValue()) {
                        eb.getEditor().setCurrentValue(rewardEditData.getValue(eb.getEditor().getKey()));
                    }
                    inv.addButton(eb);
                    continue;
                }
                inv.addButton(b);
            }
        }
        inv.sort();
        if (!unsetValuesShown) {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.CHEST).setName("&cUnset Values")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    RewardEditGUI.this.openRewardGUIRewards(player, rewardEditData, rewardName, true);
                }
            });
        } else {
            inv.addButton(new BInventoryButton(new ItemBuilder(Material.BOOK).setName("&cValues not setable in GUI yet:").setLore("&aRandom, Item, Items(WIP), RandomItem", "&bThese will eventually be aded to edit gui", "&3Also looking for feedback on GUI")){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                }
            });
        }
        inv.addButton(new BInventoryButton(new ItemBuilder(Material.BARRIER).setName("&cGo back")){

            @Override
            public void onClick(BInventory.ClickEvent clickEvent) {
                RewardEditGUI.this.openRewardGUI(clickEvent.getPlayer(), rewardEditData, rewardName);
            }
        });
        inv.openInventory(player);
    }

    public void openRewardsGUI(Player player) {
        ArrayList<String> lore;
        if (!player.hasPermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit")) {
            player.sendMessage("You do not have enough permission to do this");
            return;
        }
        BInventory inv = new BInventory("Rewards");
        for (Reward reward : this.plugin.getRewardHandler().getRewards()) {
            if (reward.getConfig().isDirectlyDefinedReward()) continue;
            lore = new ArrayList<String>();
            if (reward.getConfig().isDirectlyDefinedReward()) {
                lore.add("&cReward is not directly defined, can not edit in GUI");
            }
            inv.addButton(new BInventoryButton(reward.getRewardName(), ArrayUtils.convert(lore), new ItemStack(Material.STONE)){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    Player player = event.getWhoClicked();
                    Reward reward = (Reward)this.getData("Reward");
                    if (!reward.getConfig().isDirectlyDefinedReward()) {
                        RewardEditGUI.this.openRewardGUI(player, new RewardEditData(reward), reward.getRewardName());
                    } else {
                        player.sendMessage("Can't edit this reward, directly defined reward");
                    }
                }
            }.addData("Reward", reward));
        }
        for (DirectlyDefinedReward directlyDefinedReward : this.plugin.getRewardHandler().getDirectlyDefinedRewards()) {
            if (directlyDefinedReward.isDirectlyDefined()) continue;
            lore = new ArrayList();
            lore.add("DirectlyDefined reward handle");
            inv.addButton(new BInventoryButton(directlyDefinedReward.getFullPath(), ArrayUtils.convert(lore), new ItemStack(Material.COBBLESTONE)){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    Player player = event.getWhoClicked();
                    DirectlyDefinedReward reward = (DirectlyDefinedReward)this.getData("Reward");
                    RewardEditGUI.this.openRewardGUI(player, reward);
                }
            }.addData("Reward", directlyDefinedReward));
        }
        inv.openInventory(player);
    }

    public void openRewardsGUICopy(final Player player, RewardEditData rewardEditData, String rewardName) {
        ArrayList<String> lore;
        if (!player.hasPermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".RewardEdit")) {
            player.sendMessage("You do not have enough permission to do this");
            return;
        }
        BInventory inv = new BInventory("CopyRewards");
        inv.addData("masterreward", rewardEditData);
        for (Reward reward : this.plugin.getRewardHandler().getRewards()) {
            if (reward.getConfig().isDirectlyDefinedReward()) continue;
            lore = new ArrayList<String>();
            if (reward.getConfig().isDirectlyDefinedReward()) {
                lore.add("&cReward is directly defined");
            }
            inv.addButton(new BInventoryButton(reward.getRewardName(), ArrayUtils.convert(lore), new ItemStack(Material.STONE)){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    new RewardGUIConfirmation(RewardEditGUI.this.plugin, (CommandSender)player, "Confirm copy reward?"){

                        @Override
                        public void onConfirm(Player p) {
                            Reward reward = (Reward)this.getButton().getData("Reward");
                            RewardEditData rewardEditData = (RewardEditData)this.getInv().getData("masterreward");
                            for (Map.Entry<String, Object> entry : RewardEditGUI.this.getAllValues(reward.getConfig().getConfigData()).entrySet()) {
                                rewardEditData.setValue(entry.getKey(), entry.getValue());
                            }
                        }

                        @Override
                        public void onDeny(Player p) {
                            RewardEditData rewardEditData = (RewardEditData)this.getInv().getData("masterreward");
                            rewardEditData.reOpenEditGUI(player);
                        }
                    }.open();
                }
            }.addData("Reward", reward));
        }
        for (DirectlyDefinedReward directlyDefinedReward : this.plugin.getRewardHandler().getDirectlyDefinedRewards()) {
            if (!directlyDefinedReward.isDirectlyDefined()) continue;
            lore = new ArrayList();
            inv.addButton(new BInventoryButton(directlyDefinedReward.getFullPath(), ArrayUtils.convert(lore), new ItemStack(Material.COBBLESTONE)){

                @Override
                public void onClick(BInventory.ClickEvent event) {
                    new RewardGUIConfirmation(RewardEditGUI.this.plugin, (CommandSender)player, "Confirm copy reward?"){

                        @Override
                        public void onConfirm(Player p) {
                            DirectlyDefinedReward reward = (DirectlyDefinedReward)this.getButton().getData("Reward");
                            RewardEditData rewardEditData = (RewardEditData)this.getInv().getData("masterreward");
                            for (Map.Entry<String, Object> entry : RewardEditGUI.this.getAllValues(reward.getFileData().getConfigurationSection(reward.getPath())).entrySet()) {
                                rewardEditData.setValue(entry.getKey(), entry.getValue());
                            }
                        }

                        @Override
                        public void onDeny(Player p) {
                            RewardEditData rewardEditData = (RewardEditData)this.getInv().getData("masterreward");
                            rewardEditData.reOpenEditGUI(player);
                        }
                    }.open();
                }
            }.addData("Reward", directlyDefinedReward));
        }
        inv.openInventory(player);
    }
}

