/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.command.gui;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChoiceGUI {
    static ChoiceGUI instance = new ChoiceGUI();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();

    public static ChoiceGUI getInstance() {
        return instance;
    }

    private ChoiceGUI() {
    }

    public void openClaimChoices(Player player) {
        AdvancedCoreUser user = this.plugin.getUserManager().getUser(player);
        BInventory inv = new BInventory("UnClaimed Choices");
        inv.dontClose();
        ArrayList<String> choices = user.getUnClaimedChoices();
        HashSet<String> unClaimedChoices = new HashSet<String>();
        for (String str : choices) {
            unClaimedChoices.add(str);
        }
        for (String rewardName : unClaimedChoices) {
            Reward reward = this.plugin.getRewardHandler().getReward(rewardName);
            if (!reward.getConfig().getEnableChoices()) continue;
            inv.addButton(new BInventoryButton(new ItemBuilder(reward.getConfig().getDisplayItem())){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    ChoiceGUI.this.openClaimChoices(clickEvent.getPlayer(), (Reward)this.getData("Reward"));
                }
            }.addData("Reward", reward));
        }
        inv.openInventory(player);
    }

    public void openClaimChoices(Player player, Reward reward) {
        if (!reward.getConfig().getEnableChoices()) {
            player.sendMessage("Choice rewards not enabled");
            return;
        }
        AdvancedCoreUser user = this.plugin.getUserManager().getUser(player);
        BInventory inv = new BInventory("Pick reward");
        inv.dontClose();
        for (String choice : reward.getConfig().getChoices()) {
            ItemBuilder builder = new ItemBuilder(reward.getConfig().getChoicesItem(choice)).setNameIfNotExist("&a" + choice);
            inv.addButton(new BInventoryButton(builder){

                @Override
                public void onClick(final BInventory.ClickEvent clickEvent) {
                    Reward reward = (Reward)this.getInv().getData("Reward");
                    AdvancedCoreUser user = (AdvancedCoreUser)this.getInv().getData("User");
                    String choice = (String)this.getData("Choice");
                    user.removeUnClaimedChoiceReward(reward.getName());
                    ChoiceGUI.this.plugin.getRewardHandler().giveChoicesReward(reward, user, choice);
                    if (user.getUnClaimedChoices().size() > 0) {
                        ChoiceGUI.this.openClaimChoices(clickEvent.getPlayer());
                    } else {
                        ChoiceGUI.this.plugin.getBukkitScheduler().runTask((Plugin)ChoiceGUI.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                clickEvent.getPlayer().closeInventory();
                            }
                        }, (Entity)clickEvent.getWhoClicked());
                    }
                }
            }.addData("Choice", choice));
        }
        inv.addData("User", user);
        inv.addData("Reward", reward);
        inv.openInventory(player);
    }

    public void openPreferenceReward(Player player, String rewardName) {
        Reward reward = this.plugin.getRewardHandler().getReward(rewardName);
        if (!reward.getConfig().getEnableChoices()) {
            player.sendMessage("Choice rewards not enabled");
            return;
        }
        AdvancedCoreUser user = this.plugin.getUserManager().getUser(player);
        BInventory inv = new BInventory("Select Preference");
        for (String choice : reward.getConfig().getChoices()) {
            ItemBuilder builder = new ItemBuilder(reward.getConfig().getChoicesItem(choice));
            if (user.getChoicePreference(rewardName).equalsIgnoreCase(choice)) {
                builder.addLoreLine("&cCurrent preference");
                builder.addLoreLine("&c&lClick to remove");
            } else {
                builder.addLoreLine("&aClick to set as preference");
            }
            builder.setName("&a" + choice);
            inv.addButton(new BInventoryButton(builder){

                @Override
                public void onClick(BInventory.ClickEvent clickEvent) {
                    AdvancedCoreUser user = (AdvancedCoreUser)this.getInv().getData("User");
                    String rewardName = (String)this.getInv().getData("Reward");
                    String choice = (String)this.getData("Choice");
                    if (user.getChoicePreference(rewardName).equals(choice)) {
                        choice = "none";
                    }
                    user.setChoicePreference(rewardName, choice);
                    user.sendMessage(ChoiceGUI.this.plugin.getOptions().getFormatChoiceRewardsPreferenceSet(), "choice", choice);
                }
            }.addData("Choice", choice));
        }
        inv.addData("User", user);
        inv.addData("Reward", rewardName);
        inv.openInventory(player);
    }
}

