/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.command.gui;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequest;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.StringListener;
import com.bencodez.votingplugin.advancedcore.command.gui.RewardEditGUI;
import com.bencodez.votingplugin.advancedcore.command.gui.UserGUI;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class AdminGUI {
    static AdminGUI instance = new AdminGUI();
    AdvancedCorePlugin plugin = AdvancedCorePlugin.getInstance();
    private ArrayList<BInventoryButton> pluginGUIs;

    public static AdminGUI getInstance() {
        return instance;
    }

    private AdminGUI() {
    }

    public void addButton(BInventoryButton b) {
        if (this.pluginGUIs == null) {
            this.pluginGUIs = new ArrayList();
        }
        this.pluginGUIs.add(b);
    }

    public void openGUI(Player player) {
        if (!player.hasPermission(AdvancedCorePlugin.getInstance().getOptions().getPermPrefix() + ".Admin")) {
            player.sendMessage("Not enough permissions");
            return;
        }
        BInventory inv = new BInventory("AdminGUI");
        inv.addButton(inv.getNextSlot(), new BInventoryButton("&cRewards", new String[]{"&cMiddle click to create"}, new ItemStack(Material.DIAMOND)){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                Player player = event.getWhoClicked();
                if (event.getClick().equals((Object)ClickType.MIDDLE)) {
                    new ValueRequest().requestString(player, new StringListener(){

                        @Override
                        public void onInput(Player player, String value) {
                            Reward reward = AdminGUI.this.plugin.getRewardHandler().getReward(value);
                            player.sendMessage("Reward file created");
                            AdminGUI.this.plugin.reloadAdvancedCore(false);
                            RewardEditGUI.getInstance().openRewardGUI(player, reward);
                        }
                    });
                } else {
                    RewardEditGUI.getInstance().openRewardsGUI(player);
                }
            }
        });
        inv.addButton(inv.getNextSlot(), new BInventoryButton(new ItemBuilder("PLAYER_HEAD").setName("&cUsers")){

            @Override
            public void onClick(BInventory.ClickEvent event) {
                Player player = event.getWhoClicked();
                UserGUI.getInstance().openUsersGUI(player);
            }
        });
        if (this.pluginGUIs != null) {
            for (BInventoryButton b : this.pluginGUIs) {
                inv.addButton(inv.getNextSlot(), b);
            }
        }
        inv.openInventory(player);
    }
}

