/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.bungeeapi.time;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public abstract class BungeeTimeChecker {
    private boolean processing = false;
    private ScheduledExecutorService timer;
    private boolean timerLoaded = false;
    private boolean timeChangeFailSafeBypass = false;
    private int timeOffSet;
    private int timeWeekOffSet = 0;
    private String timeZone;

    public BungeeTimeChecker(String timeZone, int timeOffSet, int weekOffSet) {
        this.timeOffSet = timeOffSet;
        this.timeZone = timeZone;
        this.timeWeekOffSet = weekOffSet;
    }

    public abstract void debug(String var1);

    public void forceChanged(final TimeType time) {
        this.timer.execute(new Runnable(){

            @Override
            public void run() {
                BungeeTimeChecker.this.forceChanged(time, true, true, true);
            }
        });
    }

    public void forceChanged(TimeType time, boolean fake, boolean preDate, boolean postDate) {
        this.processing = true;
        try {
            this.debug("Executing time change events: " + time.toString());
            this.info("Time change event: " + time.toString() + ", Fake: " + fake);
            if (preDate) {
                // empty if block
            }
            if (time.equals((Object)TimeType.DAY)) {
                this.timeChanged(time, fake, false, false);
            } else if (time.equals((Object)TimeType.WEEK)) {
                this.timeChanged(time, fake, false, false);
            } else if (time.equals((Object)TimeType.MONTH)) {
                this.timeChanged(time, fake, false, false);
            }
            if (postDate) {
                // empty if block
            }
            this.debug("Finished executing time change events: " + time.toString());
            this.processing = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract long getLastUpdated();

    public abstract int getPrevDay();

    public abstract String getPrevMonth();

    public abstract int getPrevWeek();

    public LocalDateTime getTime() {
        LocalDateTime localNow = LocalDateTime.now();
        if (!this.timeZone.isEmpty()) {
            try {
                ZonedDateTime zonedTime = localNow.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of(this.getTimeZone()));
                localNow = zonedTime.toLocalDateTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return localNow.plusHours(this.timeOffSet);
    }

    public boolean hasDayChanged(boolean set) {
        int day;
        int prevDay = this.getPrevDay();
        if (prevDay == (day = this.getTime().getDayOfMonth())) {
            return false;
        }
        if (set) {
            this.setPrevDay(day);
        }
        return true;
    }

    public boolean hasMonthChanged(boolean set) {
        String month;
        String prevMonth = this.getPrevMonth();
        if (prevMonth.equals(month = this.getTime().getMonth().toString())) {
            return false;
        }
        if (set) {
            this.setPrevMonth(month);
        }
        if (!this.timeChangeFailSafeBypass && this.getTime().getDayOfMonth() > 3) {
            this.warning("Detected a month change, but current day is not near end of a month, ignoring month change, " + this.getTime().getDayOfMonth());
            this.setPrevMonth(month);
            return false;
        }
        return true;
    }

    public boolean hasTimeOffSet() {
        return this.getTimeOffSet() != 0;
    }

    public boolean hasWeekChanged(boolean set) {
        TemporalField woy;
        int prevDate = this.getPrevWeek();
        LocalDateTime date = this.getTime().plusDays(this.timeWeekOffSet);
        int weekNumber = date.get(woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear());
        if (weekNumber == prevDate) {
            return false;
        }
        if (set) {
            this.setPrevWeek(weekNumber);
        }
        return true;
    }

    public abstract void info(String var1);

    public abstract boolean isEnabled();

    public abstract boolean isIgnoreTime();

    public void loadTimer() {
        if (!this.timerLoaded) {
            this.timerLoaded = true;
            this.timer = Executors.newScheduledThreadPool(1);
            if (this.getLastUpdated() > 0L && System.currentTimeMillis() - this.getLastUpdated() > 345600000L) {
                this.setIgnoreTime(true);
                this.warning("Skipping time change events, since server has been offline for awhile, use /votingpluginbungee forcetimechanged to force them if needed");
            }
            this.setLastUpdated();
            this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (BungeeTimeChecker.this.isEnabled()) {
                        if (!BungeeTimeChecker.this.processing) {
                            BungeeTimeChecker.this.update();
                        }
                    } else {
                        BungeeTimeChecker.this.timer.shutdown();
                        BungeeTimeChecker.this.timerLoaded = false;
                    }
                }
            }, 60L, 5L, TimeUnit.SECONDS);
            this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    BungeeTimeChecker.this.setLastUpdated();
                }
            }, 60L, 60L, TimeUnit.MINUTES);
        } else {
            AdvancedCorePlugin.getInstance().debug("Timer is already loaded");
        }
    }

    public abstract void setIgnoreTime(boolean var1);

    public abstract void setLastUpdated();

    public abstract void setPrevDay(int var1);

    public abstract void setPrevMonth(String var1);

    public abstract void setPrevWeek(int var1);

    public abstract void timeChanged(TimeType var1, boolean var2, boolean var3, boolean var4);

    public void shutdown() {
        this.timer.shutdownNow();
    }

    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.hasTimeOffSet()) {
            this.debug("TimeHourOffSet: " + this.getTime().getHour() + ":" + this.getTime().getMinute());
        }
        if (this.isIgnoreTime()) {
            this.hasDayChanged(true);
            this.hasMonthChanged(true);
            this.hasWeekChanged(true);
            this.setIgnoreTime(false);
            this.info("Ignoring time change events for one time only");
        }
        if (!this.processing) {
            if (this.hasMonthChanged(false)) {
                this.info("Detected month changed, processing...");
                this.forceChanged(TimeType.MONTH, false, true, true);
                this.hasMonthChanged(true);
                this.info("Finished processing month changes");
            } else if (this.hasWeekChanged(false)) {
                this.info("Detected week changed, processing...");
                this.forceChanged(TimeType.WEEK, false, true, true);
                this.hasWeekChanged(true);
                this.info("Finished processing week changes");
            } else if (this.hasDayChanged(false)) {
                this.info("Detected day changed, processing...");
                this.forceChanged(TimeType.DAY, false, true, true);
                this.hasDayChanged(true);
                this.info("Finished processing day changes");
            }
        }
    }

    public abstract void warning(String var1);

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public boolean isTimeChangeFailSafeBypass() {
        return this.timeChangeFailSafeBypass;
    }

    @Generated
    public void setTimeChangeFailSafeBypass(boolean timeChangeFailSafeBypass) {
        this.timeChangeFailSafeBypass = timeChangeFailSafeBypass;
    }

    @Generated
    public int getTimeOffSet() {
        return this.timeOffSet;
    }

    @Generated
    public int getTimeWeekOffSet() {
        return this.timeWeekOffSet;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }
}

