/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata;

import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfig;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Query;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GlobalMySQL {
    private List<String> columns = Collections.synchronizedList(new ArrayList());
    private MySQL mysql;
    private String name;
    private Object object2 = new Object();
    private Object object3 = new Object();
    private Object object4 = new Object();
    private List<String> intColumns = new ArrayList<String>();
    private boolean useBatchUpdates = true;
    private Set<String> servers = ConcurrentHashMap.newKeySet();

    public GlobalMySQL(String tableName, MySQL mysql) {
        this.mysql = mysql;
        this.name = tableName;
        String sql = "CREATE TABLE IF NOT EXISTS " + this.getName() + " (";
        sql = sql + "server VARCHAR(50), ";
        sql = sql + "PRIMARY KEY ( server ));";
        try {
            Query query = new Query(mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.loadData();
    }

    public GlobalMySQL(String tableName, MysqlConfig config) {
        if (config.hasTableNameSet()) {
            tableName = config.getTableName();
        }
        this.name = tableName;
        if (config.getTablePrefix() != null) {
            this.name = config.getTablePrefix() + tableName;
        }
        if (config.getPoolName().isEmpty()) {
            config.setPoolName("VotingPlugin-" + tableName);
        }
        this.mysql = new MySQL(config.getMaxThreads()){

            @Override
            public void debug(SQLException e) {
                GlobalMySQL.this.debugEx(e);
            }

            @Override
            public void severe(String string) {
                GlobalMySQL.this.logSevere(string);
            }

            @Override
            public void debug(String msg) {
                GlobalMySQL.this.debugLog(msg);
            }
        };
        if (!this.mysql.connect(config)) {
            this.warning("Failed to connect to MySQL");
        }
        try {
            Query q = new Query(this.mysql, "USE `" + config.getDatabase() + "`;");
            q.executeUpdate();
        }
        catch (SQLException e) {
            this.logSevere("Failed to send use database query: " + config.getDatabase() + " Error: " + e.getMessage() + ", MySQL might still work");
            this.debugEx(e);
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + this.getName() + " (";
        sql = sql + "server VARCHAR(50), ";
        sql = sql + "PRIMARY KEY ( server ));";
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(String column, DataType dataType) {
        Object object = this.object3;
        synchronized (object) {
            String sql = "ALTER TABLE " + this.getName() + " ADD COLUMN `" + column + "` text;";
            this.debugLog("Adding column: " + column + " Current columns: " + ArrayUtils.makeStringList((ArrayList)this.getColumns()));
            try {
                Query query = new Query(this.mysql, sql);
                query.executeUpdate();
                this.getColumns().add(column);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void alterColumnType(String column, String newType) {
        this.checkColumn(column, DataType.STRING);
        this.debugLog("Altering column `" + column + "` to " + newType);
        if (newType.contains("INT")) {
            try {
                Query query = new Query(this.mysql, "UPDATE " + this.getName() + " SET `" + column + "` = '0' where trim(coalesce(" + column + ", '')) = '';");
                query.executeUpdateAsync();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Query query = new Query(this.mysql, "ALTER TABLE " + this.getName() + " MODIFY `" + column + "` " + newType + ";");
                query.executeUpdateAsync();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkColumn(String column, DataType dataType) {
        Object object = this.object4;
        synchronized (object) {
            if (!ArrayUtils.containsIgnoreCase((ArrayList)this.getColumns(), column) && !ArrayUtils.containsIgnoreCase(this.getColumnsQueury(), column)) {
                this.addColumn(column, dataType);
            }
        }
    }

    public void clearCacheBasic() {
        this.debugLog("Clearing cache basic");
        this.columns.clear();
        this.columns.addAll(this.getColumnsQueury());
        this.servers.clear();
        this.servers.addAll(this.getServersQuery());
    }

    public void close() {
        this.mysql.disconnect();
    }

    public boolean containsKey(String server) {
        return this.servers.contains(server) || this.containsKeyQuery(server);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsKeyQuery(String index) {
        String sqlStr = "SELECT server FROM " + this.getName() + ";";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                if (!rs.getString("server").equals(index)) continue;
                rs.close();
                boolean bl = true;
                return bl;
            }
            rs.close();
            return false;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean containsServer(String server) {
        return this.servers.contains(server);
    }

    public abstract void debugEx(Exception var1);

    public abstract void debugLog(String var1);

    public void deleteServer(String server) {
        String q = "DELETE FROM " + this.getName() + " WHERE server='" + server + "';";
        try {
            Query query = new Query(this.mysql, q);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.servers.remove(server);
        this.clearCacheBasic();
    }

    public void executeQuery(String str) {
        try {
            Query q = new Query(this.mysql, PlaceholderUtils.replacePlaceHolder(str, "tablename", this.getName()));
            q.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<String> getColumns() {
        if (this.columns == null || this.columns.size() == 0) {
            this.loadData();
        }
        return this.columns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<String> getColumnsQueury() {
        ArrayList<String> columns = new ArrayList<String>();
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement("SELECT * FROM " + this.getName() + ";");){
            ResultSet rs = sql.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = 0;
            if (metadata != null) {
                columnCount = metadata.getColumnCount();
                int i = 1;
                while (true) {
                    if (i > columnCount) {
                        sql.close();
                        rs.close();
                        conn.close();
                        ArrayList<String> arrayList = columns;
                        return arrayList;
                    }
                    String columnName = metadata.getColumnName(i);
                    columns.add(columnName);
                    ++i;
                }
            }
            rs.close();
            return columns;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public ArrayList<Column> getExact(String server) {
        return this.getExactQuery(new Column("server", new DataValueString(server)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Column> getExactQuery(Column column) {
        ArrayList<Column> result = new ArrayList<Column>();
        String query = "SELECT * FROM " + this.getName() + " WHERE `" + column.getName() + "`='" + column.getValue().getString() + "';";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();){
            ArrayList<Column> throwable2;
            block20: {
                PreparedStatement sql222 = conn.prepareStatement(query);
                try {
                    ResultSet rs = sql222.executeQuery();
                    if (rs.next()) {
                        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                            String columnName = rs.getMetaData().getColumnLabel(i);
                            Column rCol = null;
                            if (this.intColumns.contains(columnName)) {
                                rCol = new Column(columnName, DataType.INTEGER);
                                rCol.setValue(new DataValueInt(rs.getInt(i)));
                            } else {
                                rCol = new Column(columnName, DataType.STRING);
                                rCol.setValue(new DataValueString(rs.getString(i)));
                            }
                            result.add(rCol);
                        }
                    }
                    rs.close();
                    throwable2 = result;
                    if (sql222 == null) break block20;
                }
                catch (Throwable throwable3) {
                    if (sql222 != null) {
                        try {
                            sql222.close();
                        }
                        catch (Throwable throwable) {
                            throwable3.addSuppressed(throwable);
                        }
                    }
                    throw throwable3;
                }
                sql222.close();
            }
            return throwable2;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        for (String col : this.getColumns()) {
            result.add(new Column(col, DataType.STRING));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Column> getRowsQuery() {
        ArrayList<Column> result = new ArrayList<Column>();
        String sqlStr = "SELECT server FROM " + this.getName() + ";";
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                Column rCol = new Column("server", new DataValueString(rs.getString("server")));
                result.add(rCol);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public Set<String> getServers() {
        if (this.servers == null || this.servers.size() == 0) {
            this.servers.clear();
            this.servers.addAll(this.getServersQuery());
            return this.servers;
        }
        return this.servers;
    }

    public ArrayList<String> getServersQuery() {
        ArrayList<String> uuids = new ArrayList<String>();
        ArrayList<Column> rows = this.getRowsQuery();
        if (rows != null) {
            for (Column c : rows) {
                if (c.getValue() == null || !c.getValue().isString()) continue;
                uuids.add(c.getValue().getString());
            }
        } else {
            this.logSevere("Failed to fetch servers");
        }
        return uuids;
    }

    public abstract void info(String var1);

    public void insert(String index, String column, DataValue value) {
        this.insertQuery(index, Arrays.asList(new Column(column, value)));
    }

    public void insertQuery(String index, List<Column> cols) {
        String query = "INSERT IGNORE " + this.getName() + " ";
        query = query + "set server='" + index + "', ";
        for (int i = 0; i < cols.size(); ++i) {
            Column col = cols.get(i);
            if (i == cols.size() - 1) {
                if (col.getValue().isString()) {
                    query = query + col.getName() + "='" + col.getValue().getString() + "';";
                    continue;
                }
                if (col.getValue().isBoolean()) {
                    query = query + col.getName() + "='" + col.getValue().getBoolean() + "';";
                    continue;
                }
                if (!col.getValue().isInt()) continue;
                query = query + col.getName() + "='" + col.getValue().getInt() + "';";
                continue;
            }
            if (col.getValue().isString()) {
                query = query + col.getName() + "='" + col.getValue().getString() + "', ";
                continue;
            }
            if (col.getValue().isBoolean()) {
                query = query + col.getName() + "='" + col.getValue().getBoolean() + "', ";
                continue;
            }
            if (!col.getValue().isInt()) continue;
            query = query + col.getName() + "='" + col.getValue().getInt() + "', ";
        }
        try {
            new Query(this.mysql, query).executeUpdate();
            this.servers.add(index);
            this.debugLog("Inserting " + index + " into database");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debugLog("Failed to insert server " + index);
        }
    }

    public boolean isIntColumn(String key) {
        return this.intColumns.contains(key);
    }

    public boolean isUseBatchUpdates() {
        return this.useBatchUpdates;
    }

    public void loadData() {
        this.columns = this.getColumnsQueury();
        try (Connection con = this.mysql.getConnectionManager().getConnection();){
            this.useBatchUpdates = con.getMetaData().supportsBatchUpdates();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public abstract void logSevere(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String index, List<Column> cols, boolean runAsync) {
        for (Column col : cols) {
            this.checkColumn(col.getName(), col.getDataType());
        }
        Object object = this.object2;
        synchronized (object) {
            block15: {
                if (this.getServers().contains(index) || this.containsKeyQuery(index)) {
                    String query = "UPDATE " + this.getName() + " SET ";
                    for (int i = 0; i < cols.size(); ++i) {
                        Column col = cols.get(i);
                        if (i == cols.size() - 1) {
                            if (col.getValue().isString()) {
                                query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "'";
                                continue;
                            }
                            if (col.getValue().isBoolean()) {
                                query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "'";
                                continue;
                            }
                            if (!col.getValue().isInt()) continue;
                            query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "'";
                            continue;
                        }
                        if (col.getValue().isString()) {
                            query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "', ";
                            continue;
                        }
                        if (col.getValue().isBoolean()) {
                            query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "', ";
                            continue;
                        }
                        if (!col.getValue().isInt()) continue;
                        query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "', ";
                    }
                    query = query + " WHERE server=";
                    query = query + "'" + index + "';";
                    this.debugLog("Batch query: " + query);
                    try {
                        Query q = new Query(this.mysql, query);
                        if (runAsync) {
                            q.executeUpdateAsync();
                            break block15;
                        }
                        q.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.insertQuery(index, cols);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String index, String column, DataValue value) {
        if (value == null) {
            this.debugLog("Mysql value null: " + column);
            return;
        }
        this.checkColumn(column, value.getType());
        Object object = this.object2;
        synchronized (object) {
            if (this.getServers().contains(index) || this.containsKeyQuery(index)) {
                String query = "UPDATE " + this.getName() + " SET ";
                if (value.isString()) {
                    query = query + column + "='" + value.getString() + "'";
                } else if (value.isBoolean()) {
                    query = query + column + "='" + value.getBoolean() + "'";
                } else if (value.isInt()) {
                    query = query + column + "='" + value.getInt() + "'";
                }
                query = query + " WHERE server=";
                query = query + "'" + index + "';";
                try {
                    Query q = new Query(this.mysql, query);
                    q.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                this.insert(index, column, value);
            }
        }
    }

    public abstract void warning(String var1);

    public void wipeColumnData(String columnName) {
        this.checkColumn(columnName, DataType.STRING);
        String sql = "UPDATE " + this.getName() + " SET " + columnName + " = NULL;";
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

