/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata;

import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalDataHandler;
import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalMySQL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public abstract class GlobalDataHandlerProxy
extends GlobalDataHandler {
    private boolean timeChangedHappened = false;
    private ArrayList<TimeType> timeChanges = new ArrayList();
    private ScheduledExecutorService timeChangedTimer = Executors.newScheduledThreadPool(1);
    private ArrayList<String> servers;
    private GlobalMySQL globalMysql;

    public GlobalDataHandlerProxy(final GlobalMySQL globalMysql, final ArrayList<String> servers) {
        super(globalMysql);
        this.servers = servers;
        this.globalMysql = globalMysql;
        this.timeChangedTimer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!GlobalDataHandlerProxy.this.timeChangedHappened) {
                    for (String server : servers) {
                        boolean processing = GlobalDataHandlerProxy.this.getBoolean(server, "Processing");
                        boolean day = GlobalDataHandlerProxy.this.getBoolean(server, "DAY");
                        boolean week = GlobalDataHandlerProxy.this.getBoolean(server, "WEEK");
                        boolean month = GlobalDataHandlerProxy.this.getBoolean(server, "MONTH");
                        if (!processing) continue;
                        if (day) {
                            GlobalDataHandlerProxy.this.timeChanges.add(TimeType.DAY);
                        }
                        if (week) {
                            GlobalDataHandlerProxy.this.timeChanges.add(TimeType.WEEK);
                        }
                        if (month) {
                            GlobalDataHandlerProxy.this.timeChanges.add(TimeType.MONTH);
                        }
                        globalMysql.debugLog("Detected time change that may have been before server start, finishing...");
                        GlobalDataHandlerProxy.this.timeChangedHappened = true;
                        return;
                    }
                }
            }
        }, 30L, TimeUnit.SECONDS);
        this.timeChangedTimer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                GlobalDataHandlerProxy.this.checkForFinishedTimeChanges();
            }
        }, 60L, 10L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.timeChangedTimer.shutdownNow();
    }

    public void checkForFinishedTimeChanges() {
        block11: {
            try {
                if (!this.timeChangedHappened) break block11;
                this.globalMysql.info("Checking if backend servers completed time change...");
                for (String server : this.servers) {
                    boolean b = this.getBoolean(server, "FinishedProcessing");
                    if (b) continue;
                    boolean processing = this.getBoolean(server, "Processing");
                    this.globalMysql.debugLog("Server " + server + " hasn't finished processing time change yet, processing: " + processing);
                    try {
                        String str = this.getString(server, "LastUpdated");
                        long lastUpdated = 0L;
                        if (!str.isEmpty()) {
                            lastUpdated = Long.valueOf(str);
                        }
                        if (processing) {
                            if (LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli() - lastUpdated <= 0x6DDD00L) {
                                return;
                            }
                            this.globalMysql.warning("Been too long, either something happened or server is offline finishing time change anyway, server: " + server);
                            this.failedProcess(server);
                        } else {
                            if (LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli() - lastUpdated <= 1800000L) {
                                return;
                            }
                            this.globalMysql.warning("Server must be offline, skipping time change on this specific server: " + server);
                            this.failedProcess(server);
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return;
                    }
                    return;
                }
                this.globalMysql.debugLog("Finishing up time change processing...");
                this.timeChangedHappened = false;
                for (TimeType time : this.timeChanges) {
                    this.globalMysql.debugLog("Time changed finished on all servers: " + time.toString());
                    this.onTimeChangedFinished(time);
                }
                this.timeChanges.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void failedProcess(String server) {
        for (TimeType time : this.timeChanges) {
            this.onTimeChangedFailed(server, time);
        }
    }

    public void onTimeChange(TimeType type) {
        this.timeChangedHappened = true;
        this.timeChanges.add(type);
    }

    public abstract void onTimeChangedFailed(String var1, TimeType var2);

    public abstract void onTimeChangedFinished(TimeType var1);

    @Generated
    public boolean isTimeChangedHappened() {
        return this.timeChangedHappened;
    }

    @Generated
    public void setTimeChangedHappened(boolean timeChangedHappened) {
        this.timeChangedHappened = timeChangedHappened;
    }

    @Generated
    public ArrayList<TimeType> getTimeChanges() {
        return this.timeChanges;
    }

    @Generated
    public ScheduledExecutorService getTimeChangedTimer() {
        return this.timeChangedTimer;
    }
}

