/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata;

import com.bencodez.votingplugin.advancedcore.bungeeapi.globaldata.GlobalMySQL;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueBoolean;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class GlobalDataHandler {
    private GlobalMySQL globalMysql;

    public GlobalDataHandler(GlobalMySQL globalMysql) {
        this.globalMysql = globalMysql;
    }

    public boolean getBoolean(String server, String key) {
        HashMap<String, DataValue> data = this.getExact(server);
        if (data.containsKey(key)) {
            DataValue value = data.get(key);
            if (value.isBoolean()) {
                return value.getBoolean();
            }
            return Boolean.valueOf(value.getString());
        }
        return false;
    }

    public HashMap<String, DataValue> getExact(String server) {
        HashMap<String, DataValue> data = new HashMap<String, DataValue>();
        for (Column entry : this.globalMysql.getExact(server)) {
            data.put(entry.getName(), entry.getValue());
        }
        return data;
    }

    public int getInt(String server, String key) {
        DataValue value;
        HashMap<String, DataValue> data = this.getExact(server);
        if (data.containsKey(key) && (value = data.get(key)).isInt()) {
            return value.getInt();
        }
        return 0;
    }

    public String getString(String server, String key) {
        DataValue value;
        HashMap<String, DataValue> data = this.getExact(server);
        if (data.containsKey(key) && (value = data.get(key)).isString()) {
            return value.getString();
        }
        return "";
    }

    public void setBoolean(String server, String key, boolean data) {
        this.globalMysql.update(server, key, new DataValueBoolean(data));
    }

    public void setData(String server, HashMap<String, DataValue> data) {
        ArrayList<Column> cols = new ArrayList<Column>();
        for (Map.Entry<String, DataValue> entry : data.entrySet()) {
            cols.add(new Column(entry.getKey(), entry.getValue()));
        }
        this.globalMysql.update(server, cols, false);
    }

    public void setInt(String server, String key, int data) {
        this.globalMysql.update(server, key, new DataValueInt(data));
    }

    public void setString(String server, String key, String data) {
        this.globalMysql.update(server, key, new DataValueString(data));
    }

    @Generated
    public GlobalMySQL getGlobalMysql() {
        return this.globalMysql;
    }
}

