/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.valuerequest.requesters;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventory;
import com.bencodez.votingplugin.advancedcore.api.inventory.BInventoryButton;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.InputMethod;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequest;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.book.BookManager;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.book.BookSign;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.NumberListener;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.prompt.PromptManager;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.prompt.PromptReturnString;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NumberRequester {
    public void request(Player player, InputMethod method, String currentValue, LinkedHashMap<Number, ItemStack> options, String promptText, boolean allowCustomOption, final NumberListener listener) {
        if (method.equals((Object)InputMethod.SIGN)) {
            method = InputMethod.INVENTORY;
        }
        if ((options == null || options.size() == 0) && method.equals((Object)InputMethod.INVENTORY) && allowCustomOption) {
            method = InputMethod.CHAT;
        }
        if (AdvancedCorePlugin.getInstance().getOptions().getDisabledRequestMethods().contains(method.toString())) {
            player.sendMessage("Disabled method: " + method.toString());
        }
        if (method.equals((Object)InputMethod.INVENTORY)) {
            if (options == null) {
                player.sendMessage("There are no choices to choice from to use this method");
                return;
            }
            BInventory inv = new BInventory("Click one of the following:");
            for (Map.Entry<Number, ItemStack> entry : options.entrySet()) {
                inv.addButton(inv.getNextSlot(), new BInventoryButton(entry.getKey().toString(), new String[0], entry.getValue()){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        String num = clickEvent.getClickedItem().getItemMeta().getDisplayName();
                        try {
                            Double number = Double.valueOf(num);
                            listener.onInput(clickEvent.getPlayer(), number);
                        }
                        catch (NumberFormatException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            if (allowCustomOption) {
                inv.addButton(inv.getNextSlot(), new BInventoryButton("&cClick to enter custom value", new String[0], new ItemStack(Material.ANVIL)){

                    @Override
                    public void onClick(BInventory.ClickEvent clickEvent) {
                        new ValueRequest().requestNumber(clickEvent.getPlayer(), listener);
                    }
                });
            }
            inv.openInventory(player);
        } else if (method.equals((Object)InputMethod.CHAT)) {
            if (options != null && options.size() != 0) {
                AdvancedCoreUser user = AdvancedCorePlugin.getInstance().getUserManager().getUser(player);
                user.sendMessage("&cClick one of the following options below:");
                PlayerUtils.setPlayerMeta(AdvancedCorePlugin.getInstance(), player, "ValueRequestNumber", listener);
                for (Number num : options.keySet()) {
                    String option = num.toString();
                    TextComponent comp = new TextComponent(option);
                    comp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + AdvancedCorePlugin.getInstance().getName().toLowerCase() + "valuerequestinput Number " + option));
                    user.sendJson(comp);
                }
                if (allowCustomOption) {
                    String option = "CustomValue";
                    TextComponent comp = new TextComponent(option);
                    comp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + AdvancedCorePlugin.getInstance().getName().toLowerCase() + "valuerequestinput Number " + option));
                    user.sendJson(comp);
                }
            } else {
                ConversationFactory convoFactory = new ConversationFactory((Plugin)AdvancedCorePlugin.getInstance()).withModality(true).withEscapeSequence("cancel").withTimeout(60);
                PromptManager prompt = new PromptManager(promptText + " Current value: " + currentValue, convoFactory);
                prompt.stringPrompt((Conversable)player, new PromptReturnString(){

                    @Override
                    public void onInput(ConversationContext context, final Conversable conversable, String input) {
                        String num = input;
                        try {
                            final Double number = Double.valueOf(num);
                            AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                                @Override
                                public void run() {
                                    listener.onInput((Player)conversable, number);
                                }
                            });
                        }
                        catch (NumberFormatException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        } else if (method.equals((Object)InputMethod.BOOK)) {
            new BookManager(player, currentValue.toString(), new BookSign(){

                @Override
                public void onBookSign(Player player, String input) {
                    String num = input;
                    try {
                        Double number = Double.valueOf(num);
                        listener.onInput(player, number);
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        } else {
            player.sendMessage("Invalid method/disabled method, change your request method");
        }
    }

    public void request(Player player, InputMethod method, String currentValue, String promptText, Number[] options, boolean allowCustomOption, NumberListener listener) {
        LinkedHashMap<Number, ItemStack> items = new LinkedHashMap<Number, ItemStack>();
        if (options != null) {
            for (Number option : options) {
                items.put(option, new ItemStack(Material.STONE, 1));
            }
        }
        this.request(player, method, currentValue, items, promptText, allowCustomOption, listener);
    }
}

