/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.valuerequest;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.InputMethod;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.ValueRequest;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.BooleanListener;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.Listener;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.NumberListener;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.listeners.StringListener;
import java.util.LinkedHashMap;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ValueRequestBuilder {
    private boolean allowCustomOption = false;
    private BooleanListener booleanListener;
    private String currentValue = "";
    private InputMethod method = null;
    private LinkedHashMap<Number, ItemStack> numberItemOptions;
    private NumberListener numberListener;
    private Number[] numberOptions;
    private LinkedHashMap<String, ItemStack> stringItemOptions;
    private StringListener stringListener;
    private String[] stringOptions;

    public ValueRequestBuilder(BooleanListener listener) {
        this.booleanListener = listener;
    }

    public ValueRequestBuilder(LinkedHashMap<String, ItemStack> options, final Listener<String> listener) {
        this.stringListener = new StringListener(){

            @Override
            public void onInput(final Player player, final String value) {
                AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        listener.onInput(player, value);
                    }
                });
            }
        };
        this.stringItemOptions = options;
    }

    public ValueRequestBuilder(final Listener<Boolean> listener) {
        this.booleanListener = new BooleanListener(){

            @Override
            public void onInput(final Player player, final boolean value) {
                AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        listener.onInput(player, value);
                    }
                });
            }
        };
    }

    public ValueRequestBuilder(final Listener<Number> listener, LinkedHashMap<Number, ItemStack> options) {
        this.numberListener = new NumberListener(){

            @Override
            public void onInput(final Player player, final Number value) {
                AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        listener.onInput(player, value);
                    }
                });
            }
        };
        this.numberItemOptions = options;
    }

    public ValueRequestBuilder(final Listener<Number> listener, Number[] options) {
        this.numberListener = new NumberListener(){

            @Override
            public void onInput(final Player player, final Number value) {
                AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        listener.onInput(player, value);
                    }
                });
            }
        };
        this.numberOptions = options;
    }

    public ValueRequestBuilder(final Listener<String> listener, String[] options) {
        this.stringListener = new StringListener(){

            @Override
            public void onInput(final Player player, final String value) {
                AdvancedCorePlugin.getInstance().getBukkitScheduler().runTaskAsynchronously((Plugin)AdvancedCorePlugin.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        listener.onInput(player, value);
                    }
                });
            }
        };
        this.stringOptions = options;
    }

    public ValueRequestBuilder(NumberListener listener, LinkedHashMap<Number, ItemStack> options) {
        this.numberListener = listener;
        this.numberItemOptions = options;
    }

    public ValueRequestBuilder(NumberListener listener, Number[] options) {
        this.numberListener = listener;
        this.numberOptions = options;
    }

    public ValueRequestBuilder(StringListener listener, LinkedHashMap<String, ItemStack> options) {
        this.stringListener = listener;
        this.stringItemOptions = options;
    }

    public ValueRequestBuilder(StringListener listener, String[] options) {
        this.stringListener = listener;
        this.stringOptions = options;
    }

    public ValueRequestBuilder allowCustomOption(boolean allowCustomOption) {
        this.allowCustomOption = allowCustomOption;
        return this;
    }

    public ValueRequestBuilder currentValue(String currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public void request(Player player) {
        if (this.numberListener != null) {
            if (this.numberItemOptions == null) {
                new ValueRequest(this.method).requestNumber(player, this.currentValue, this.numberOptions, this.allowCustomOption, this.numberListener);
            } else {
                new ValueRequest(this.method).requestNumber(player, this.numberItemOptions, this.currentValue, this.allowCustomOption, this.numberListener);
            }
        } else if (this.stringListener != null) {
            if (this.stringItemOptions == null) {
                new ValueRequest(this.method).requestString(player, this.currentValue, this.stringOptions, this.allowCustomOption, this.stringListener);
            } else {
                new ValueRequest(this.method).requestString(player, this.stringItemOptions, this.currentValue, this.allowCustomOption, this.stringListener);
            }
        } else if (this.booleanListener != null) {
            new ValueRequest(this.method).requestBoolean(player, this.currentValue, this.booleanListener);
        }
    }

    public ValueRequestBuilder usingMethod(InputMethod method) {
        if (method != null) {
            this.method = method;
        }
        return this;
    }
}

