/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user.userstorage.sql;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKey;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyInt;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueBoolean;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import com.bencodez.votingplugin.simpleapi.sql.sqlite.Table;
import com.bencodez.votingplugin.simpleapi.sql.sqlite.db.SQLite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class UserTable
extends Table {
    private List<Column> columns = new ArrayList<Column>();
    private String name;
    private Object object = new Object();
    private Column primaryKey;
    private SQLite sqLite;
    private AdvancedCorePlugin plugin;

    public UserTable(AdvancedCorePlugin plugin, String name, Collection<Column> columns) {
        this.name = name;
        this.columns.addAll(columns);
        this.primaryKey = this.columns.get(0);
        this.plugin = plugin;
    }

    public UserTable(AdvancedCorePlugin plugin, String name, Collection<Column> columns, Column primaryKey) {
        this.name = name;
        this.primaryKey = primaryKey;
        this.columns.addAll(columns);
        this.plugin = plugin;
    }

    public UserTable(AdvancedCorePlugin plugin, String name, Column ... columns) {
        this.name = name;
        for (Column column : columns) {
            this.columns.add(column);
        }
        this.primaryKey = this.columns.get(0);
        this.plugin = plugin;
    }

    public UserTable(AdvancedCorePlugin plugin, String name, Column primaryKey, Column ... columns) {
        this.name = name;
        this.primaryKey = primaryKey;
        for (Column column : columns) {
            this.columns.add(column);
        }
        this.plugin = plugin;
    }

    public void addColoumn(Column column) {
        if (this.hasColumn(column)) {
            return;
        }
        try {
            String query = "ALTER TABLE " + this.getName() + " ADD COLUMN `" + column.getName() + "` " + column.getDataType().toString();
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            s.executeUpdate();
            s.close();
            this.columns.add(column);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addColoumn(UserDataKey column) {
        if (this.getTableColumns().contains(column.getKey())) {
            return;
        }
        try {
            String query = "ALTER TABLE " + this.getName() + " ADD COLUMN `" + column.getKey() + "` " + column.getColumnType();
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            s.executeUpdate();
            s.close();
            if (column instanceof UserDataKeyInt) {
                this.columns.add(new Column(column.getKey(), DataType.INTEGER));
            } else {
                this.columns.add(new Column(column.getKey(), DataType.STRING));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addCustomColumns() {
        for (UserDataKey key : this.plugin.getUserManager().getDataManager().getKeys()) {
            this.addColoumn(key);
        }
    }

    public void checkColumn(Column c) {
        if (!this.hasColumn(c)) {
            Column col = new Column(c.getName(), c.getDataType());
            this.addColoumn(col);
        }
    }

    public void checkColumns() {
        for (String col : this.getTableColumns()) {
            boolean has = false;
            for (Column column : this.columns) {
                if (col == null || !col.equals(column.getName())) continue;
                has = true;
            }
            if (has) continue;
            this.columns.add(new Column(col, DataType.STRING));
        }
    }

    public boolean containsKey(String index) {
        String query = "SELECT uuid FROM " + this.getName();
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                String str = rs.getString("uuid");
                if (str == null || !str.equals(index)) continue;
                rs.close();
                s.close();
                return true;
            }
            rs.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void copyColumnData(String columnFromName, String columnToName, DataType dataType) {
        this.checkColumn(new Column(columnToName, dataType));
        this.checkColumn(new Column(columnFromName, dataType));
        String sql = "UPDATE `" + this.getName() + "` SET `" + columnToName + "` = `" + columnFromName + "`;";
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(sql);
            s.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Column column) {
        if (column.getName().equalsIgnoreCase(this.primaryKey.getName())) {
            String query = "DELETE FROM " + this.getName() + " WHERE `" + column.getName() + "`=?";
            try {
                PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
                if (column.getValue().isString()) {
                    s.setString(1, column.getValue().getString());
                } else if (column.getValue().isInt()) {
                    s.setInt(1, column.getValue().getInt());
                } else {
                    s.setBoolean(1, column.getValue().getBoolean());
                }
                s.executeUpdate();
                s.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Primary key must be used!");
        }
    }

    public void executeQuery(String str) {
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(PlaceholderUtils.replacePlaceHolder(str, "tablename", this.getName()));
            s.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<List<Column>> getAll() {
        ArrayList<List<Column>> results = new ArrayList<List<Column>>();
        String query = "SELECT * FROM " + this.getName();
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                ArrayList<Column> result = new ArrayList<Column>();
                for (int i = 0; i < this.getColumns().size(); ++i) {
                    Column rCol = new Column(this.getColumns().get(i).getName(), this.getColumns().get(i).getDataType(), this.getColumns().get(i).getLimit());
                    if (this.getColumns().get(i).getValue().isString()) {
                        s.setString(1, this.getColumns().get(i).getValue().getString());
                    } else if (this.getColumns().get(i).getValue().isInt()) {
                        s.setInt(1, this.getColumns().get(i).getValue().getInt());
                    } else {
                        s.setBoolean(1, this.getColumns().get(i).getValue().getBoolean());
                    }
                    result.add(rCol);
                }
                results.add(result);
            }
            this.sqLite.close(s, rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public HashMap<UUID, ArrayList<Column>> getAllQuery() {
        HashMap<UUID, ArrayList<Column>> result = new HashMap<UUID, ArrayList<Column>>();
        String query = "SELECT * FROM " + this.getName() + ";";
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                ArrayList<Column> cols = new ArrayList<Column>();
                UUID uuid = null;
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    Column rCol;
                    block15: {
                        String columnName = rs.getMetaData().getColumnLabel(i);
                        rCol = null;
                        if (this.plugin.getUserManager().getDataManager().isInt(columnName)) {
                            try {
                                rCol = new Column(columnName, DataType.INTEGER);
                                rCol.setValue(new DataValueInt(rs.getInt(i)));
                            }
                            catch (Exception e) {
                                rCol = new Column(columnName, DataType.INTEGER);
                                String data = rs.getString(i);
                                if (data != null) {
                                    try {
                                        rCol.setValue(new DataValueInt(Integer.parseInt(data)));
                                    }
                                    catch (NumberFormatException ex) {
                                        rCol.setValue(new DataValueInt(0));
                                    }
                                    break block15;
                                }
                                rCol.setValue(new DataValueInt(0));
                            }
                        } else if (this.plugin.getUserManager().getDataManager().isBoolean(columnName)) {
                            rCol = new Column(columnName, DataType.BOOLEAN);
                            rCol.setValue(new DataValueBoolean(Boolean.valueOf(rs.getString(i))));
                        } else {
                            rCol = new Column(columnName, DataType.STRING);
                            rCol.setValue(new DataValueString(rs.getString(i)));
                            if (columnName.equals("uuid")) {
                                uuid = UUID.fromString(rs.getString(i));
                            }
                        }
                    }
                    cols.add(rCol);
                }
                result.put(uuid, cols);
            }
            rs.close();
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getColumnsString() {
        List<Column> column = this.getColumns();
        ArrayList<String> list = new ArrayList<String>();
        for (Column col : column) {
            list.add(col.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Column> getExact(Column column) {
        ArrayList<Column> result = new ArrayList<Column>();
        String query = "SELECT * FROM " + this.getName() + " WHERE `" + column.getName() + "`=?";
        try {
            Object object = this.object;
            synchronized (object) {
                PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
                if (column.getValue().isString()) {
                    s.setString(1, column.getValue().getString());
                } else if (column.getValue().isInt()) {
                    s.setInt(1, column.getValue().getInt());
                } else {
                    s.setBoolean(1, column.getValue().getBoolean());
                }
                ResultSet rs = s.executeQuery();
                if (rs.next()) {
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        String columnName = rs.getMetaData().getColumnLabel(i);
                        Column rCol = null;
                        if (this.plugin.getUserManager().getDataManager().isInt(columnName)) {
                            rCol = new Column(columnName, DataType.INTEGER);
                            rCol.setValue(new DataValueInt(rs.getInt(i)));
                        } else if (this.plugin.getUserManager().getDataManager().isBoolean(columnName)) {
                            rCol = new Column(columnName, DataType.BOOLEAN);
                            rCol.setValue(new DataValueBoolean(Boolean.valueOf(rs.getString(i))));
                        } else {
                            rCol = new Column(columnName, DataType.STRING);
                            rCol.setValue(new DataValueString(rs.getString(i)));
                        }
                        result.add(rCol);
                    }
                }
                rs.close();
                s.close();
                return result;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        for (Column col : this.getColumns()) {
            result.add(new Column(col.getName(), col.getDataType()));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Column col : this.getRowsNames()) {
            if (col.getValue() == null || !col.getValue().isString()) continue;
            names.add(col.getValue().getString());
        }
        return names;
    }

    public ArrayList<Integer> getNumbersInColumn(String column) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String sqlStr = "SELECT " + column + " FROM " + this.getName() + ";";
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(sqlStr);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(column));
            }
            this.sqLite.close(s, rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Column getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getQuery() {
        String sql = "CREATE TABLE IF NOT EXISTS " + this.getName() + " (";
        sql = sql + "uuid VARCHAR(37), ";
        for (UserDataKey key : AdvancedCorePlugin.getInstance().getUserManager().getDataManager().getKeys()) {
            sql = sql + key.getKey() + " " + key.getColumnType() + ", ";
        }
        sql = sql + "PRIMARY KEY ( uuid ));";
        return sql;
    }

    public List<Column> getRows() {
        ArrayList<Column> result = new ArrayList<Column>();
        String query = "SELECT uuid FROM " + this.getName();
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            ResultSet rs = s.executeQuery();
            try {
                while (rs.next()) {
                    Column rCol = new Column("uuid", new DataValueString(rs.getString("uuid")));
                    result.add(rCol);
                }
                this.sqLite.close(s, rs);
            }
            catch (SQLException e) {
                s.close();
                rs.close();
                e.printStackTrace();
                return null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Column> getRowsNames() {
        this.checkColumn(new Column("PlayerName", DataType.STRING));
        ArrayList<Column> result = new ArrayList<Column>();
        String query = "SELECT PlayerName FROM " + this.getName();
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            ResultSet rs = s.executeQuery();
            try {
                while (rs.next()) {
                    Column rCol = new Column("PlayerName", new DataValueString(rs.getString("PlayerName")));
                    result.add(rCol);
                }
                this.sqLite.close(s, rs);
            }
            catch (SQLException e) {
                s.close();
                return null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getTableColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        String query = "SELECT * FROM " + this.getName();
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            ResultSet rs = s.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metadata.getColumnName(i);
                columns.add(columnName);
            }
            this.sqLite.close(s, rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUUID(String playerName) {
        String query = "SELECT uuid FROM " + this.getName() + " WHERE PlayerName='" + playerName + "';";
        try (PreparedStatement sql = this.sqLite.getSQLConnection().prepareStatement(query);){
            String uuid;
            ResultSet rs = sql.executeQuery();
            if (rs.next() && (uuid = rs.getString("uuid")) != null && !uuid.isEmpty()) {
                rs.close();
                String string = uuid;
                return string;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasColumn(Column column) {
        return this.getTableColumns().contains(column.getName());
    }

    /*
     * WARNING - void declaration
     */
    public void insert(List<Column> columns) {
        void var3_6;
        for (Column column : columns) {
            this.checkColumn(column);
        }
        String query = "INSERT OR REPLACE INTO " + this.getName() + " (";
        for (Column column : columns) {
            if (columns.indexOf(column) < columns.size() - 1) {
                query = query + "`" + column.getName() + "`, ";
                continue;
            }
            query = query + "`" + column.getName() + "`) ";
        }
        query = query + "VALUES (";
        boolean bl = false;
        while (var3_6 < columns.size()) {
            query = var3_6 < columns.size() - 1 ? query + "?, " : query + "?)";
            ++var3_6;
        }
        query = query + ";";
        try {
            PreparedStatement preparedStatement = this.sqLite.getSQLConnection().prepareStatement(query);
            for (int i = 0; i < columns.size(); ++i) {
                if (columns.get(i).getValue() != null) {
                    if (columns.get(i).getValue().isString()) {
                        preparedStatement.setString(i + 1, columns.get(i).getValue().getString());
                        continue;
                    }
                    if (columns.get(i).getValue().isInt()) {
                        preparedStatement.setInt(i + 1, columns.get(i).getValue().getInt());
                        continue;
                    }
                    preparedStatement.setBoolean(i + 1, columns.get(i).getValue().getBoolean());
                    continue;
                }
                preparedStatement.setString(i + 1, "");
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public List<List<Column>> search(Column column) {
        ArrayList<List<Column>> results = new ArrayList<List<Column>>();
        if (column.getName().equalsIgnoreCase(this.primaryKey.getName())) {
            return null;
        }
        String query = "SELECT * FROM " + this.getName() + " WHERE `" + column.getName() + "`=?";
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
            if (column.getValue().isString()) {
                s.setString(1, column.getValue().getString());
            } else if (column.getValue().isInt()) {
                s.setInt(1, column.getValue().getInt());
            } else {
                s.setBoolean(1, column.getValue().getBoolean());
            }
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                ArrayList<Column> result = new ArrayList<Column>();
                for (int i = 0; i < this.getColumns().size(); ++i) {
                    Column rCol = new Column(this.getColumns().get(i).getName(), this.getColumns().get(i).getDataType(), this.getColumns().get(i).getLimit());
                    if (this.getColumns().get(i).getValue().isString()) {
                        rCol.setValue(new DataValueString(rs.getString(i + 1)));
                    } else if (this.getColumns().get(i).getValue().isInt()) {
                        rCol.setValue(new DataValueInt(rs.getInt(i + 1)));
                    } else if (this.getColumns().get(i).getValue().isBoolean()) {
                        rCol.setValue(new DataValueBoolean(rs.getBoolean(i + 1)));
                    }
                    result.add(rCol);
                }
                results.add(result);
            }
            this.sqLite.close(s, rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryKey(Column primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public void setSqLite(SQLite sqLite) {
        this.sqLite = sqLite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Column primaryKey, List<Column> columns) {
        for (Column c : columns) {
            this.checkColumn(c);
        }
        if (this.containsKey(primaryKey.getValue().toString())) {
            Object object = this.object;
            synchronized (object) {
                String query = "UPDATE " + this.getName() + " SET ";
                for (Column column : columns) {
                    if (column.getValue().isString()) {
                        query = query + "`" + column.getName() + "`='" + column.getValue().getString() + "'";
                    } else if (column.getValue().isBoolean()) {
                        query = query + "`" + column.getName() + "`=" + column.getValue().getBoolean();
                    } else if (column.getValue().isInt()) {
                        query = query + "`" + column.getName() + "`=" + column.getValue().getInt();
                    }
                    if (columns.indexOf(column) == columns.size() - 1) {
                        query = query + " ";
                        continue;
                    }
                    query = query + ", ";
                }
                query = query + "WHERE `" + primaryKey.getName() + "`=";
                query = query + "'" + primaryKey.getValue().getString() + "'";
                try {
                    PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(query);
                    s.executeUpdate();
                    s.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        boolean addPrimary = true;
        for (Column col : columns) {
            if (!col.getName().equals("uuid")) continue;
            addPrimary = false;
        }
        if (addPrimary) {
            columns.add(primaryKey);
        }
        this.insert(columns);
    }

    public void wipeColumnData(String columnName, DataType dataType) {
        this.checkColumn(new Column(columnName, dataType));
        String sql = "UPDATE " + this.getName() + " SET " + columnName + " = " + dataType.getNoValue() + ";";
        try {
            PreparedStatement s = this.sqLite.getSQLConnection().prepareStatement(sql);
            s.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SQLite getSqLite() {
        return this.sqLite;
    }
}

