/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user.userstorage.mysql;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKey;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueBoolean;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import com.bencodez.votingplugin.simpleapi.sql.mysql.config.MysqlConfigSpigot;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Query;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class MySQL {
    private List<String> columns = Collections.synchronizedList(new ArrayList());
    private long lastBackgroundCheck = 0L;
    private com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL mysql;
    private String name;
    private Set<String> names = ConcurrentHashMap.newKeySet();
    private Object object2 = new Object();
    private Object object3 = new Object();
    private Object object4 = new Object();
    private AdvancedCorePlugin plugin;
    private boolean useBatchUpdates = true;
    private Set<String> uuids = ConcurrentHashMap.newKeySet();

    public MySQL(final AdvancedCorePlugin plugin, String tableName, ConfigurationSection section) {
        this.plugin = plugin;
        MysqlConfigSpigot config = new MysqlConfigSpigot(section);
        if (config.hasTableNameSet()) {
            tableName = config.getTableName();
        }
        this.name = tableName;
        if (config.getTablePrefix() != null) {
            this.name = config.getTablePrefix() + tableName;
        }
        if (config.getPoolName().isEmpty()) {
            config.setPoolName(plugin.getName() + "-" + tableName);
        }
        this.mysql = new com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL(config.getMaxThreads()){

            @Override
            public void debug(SQLException e) {
                plugin.debug(e);
            }

            @Override
            public void severe(String string) {
                plugin.getLogger().severe(string);
            }

            @Override
            public void debug(String msg) {
                plugin.debug(msg);
            }
        };
        if (!this.mysql.connect(config)) {
            plugin.getLogger().warning("Failed to connect to MySQL");
        }
        try {
            Query q = new Query(this.mysql, "USE `" + config.getDatabase() + "`;");
            q.executeUpdate();
        }
        catch (SQLException e) {
            plugin.getLogger().severe("Failed to send use database query: " + config.getDatabase() + " Error: " + e.getMessage() + ", MySQL might still work");
            plugin.debug(e);
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + this.getName() + " (";
        sql = sql + "uuid VARCHAR(37), ";
        for (UserDataKey key : plugin.getUserManager().getDataManager().getKeys()) {
            sql = sql + "`" + key.getKey() + "` " + key.getColumnType() + ", ";
        }
        sql = sql + "PRIMARY KEY ( uuid ));";
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.loadData();
        plugin.debug("UseBatchUpdates: " + this.isUseBatchUpdates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(String column, DataType dataType) {
        Object object = this.object3;
        synchronized (object) {
            String sql = "ALTER TABLE " + this.getName() + " ADD COLUMN `" + column + "` text;";
            this.plugin.debug("Adding column: " + column + " Current columns: " + ArrayUtils.makeStringList((ArrayList)this.getColumns()));
            try {
                Query query = new Query(this.mysql, sql);
                query.executeUpdate();
                this.getColumns().add(column);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void alterColumnType(String column, String newType) {
        this.checkColumn(column, DataType.STRING);
        this.plugin.debug("MYSQL QUERY: Altering column `" + column + "` to " + newType);
        try {
            Query query = new Query(this.mysql, "ALTER TABLE " + this.getName() + " MODIFY `" + column + "` " + newType + ";");
            query.executeUpdateAsync();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkColumn(String column, DataType dataType) {
        Object object = this.object4;
        synchronized (object) {
            if (!ArrayUtils.containsIgnoreCase((ArrayList)this.getColumns(), column) && !ArrayUtils.containsIgnoreCase(this.getColumnsQueury(), column)) {
                this.addColumn(column, dataType);
            }
        }
    }

    public void clearCacheBasic() {
        this.plugin.debug("Clearing cache basic");
        this.columns.clear();
        this.columns.addAll(this.getColumnsQueury());
        this.uuids.clear();
        this.uuids.addAll(this.getUuidsQuery());
        this.names.clear();
        this.names.addAll(this.getNamesQuery());
    }

    public void close() {
        this.mysql.disconnect();
    }

    public boolean containsKey(String uuid) {
        return this.getUuids().contains(uuid) || this.containsKeyQuery(uuid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsKeyQuery(String index) {
        String sqlStr = "SELECT uuid FROM " + this.getName() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + sqlStr);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(index)) continue;
                rs.close();
                boolean bl = true;
                return bl;
            }
            rs.close();
            return false;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean containsUUID(String uuid) {
        return this.uuids.contains(uuid);
    }

    public void copyColumnData(String columnFromName, String columnToName, DataType dataType) {
        this.checkColumn(columnFromName, dataType);
        this.checkColumn(columnToName, dataType);
        String sql = "UPDATE `" + this.getName() + "` SET `" + columnToName + "` = `" + columnFromName + "`;";
        this.plugin.devDebug("MYSQL QUERY: " + sql);
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deletePlayer(String uuid) {
        String q = "DELETE FROM " + this.getName() + " WHERE uuid='" + uuid + "';";
        this.plugin.devDebug("MYSQL QUERY: " + q);
        try {
            Query query = new Query(this.mysql, q);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.uuids.remove(uuid);
        this.names.remove(PlayerManager.getInstance().getPlayerName(this.plugin.getUserManager().getUser(UUID.fromString(uuid)), uuid));
        this.clearCacheBasic();
    }

    public void executeQuery(String str) {
        try {
            Query q = new Query(this.mysql, PlaceholderUtils.replacePlaceHolder(str, "tablename", this.getName()));
            this.plugin.devDebug("MYSQL QUERY: " + str);
            q.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void executeQueryReturn(String str) {
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(str);){
            this.plugin.devDebug("MYSQL QUERY: " + str);
            ResultSet rs = sql.executeQuery();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HashMap<UUID, ArrayList<Column>> getAllQuery() {
        HashMap<UUID, ArrayList<Column>> result = new HashMap<UUID, ArrayList<Column>>();
        String query = "SELECT * FROM " + this.getName() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + query);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();){
            HashMap<UUID, ArrayList<Column>> hashMap;
            block28: {
                PreparedStatement sql = conn.prepareStatement(query);
                try {
                    ResultSet rs = sql.executeQuery();
                    while (rs.next()) {
                        ArrayList<Column> cols = new ArrayList<Column>();
                        UUID uuid = null;
                        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                            Column rCol;
                            block27: {
                                String columnName = rs.getMetaData().getColumnLabel(i);
                                rCol = null;
                                if (this.plugin.getUserManager().getDataManager().isInt(columnName)) {
                                    try {
                                        rCol = new Column(columnName, DataType.INTEGER);
                                        rCol.setValue(new DataValueInt(rs.getInt(i)));
                                    }
                                    catch (Exception e) {
                                        rCol = new Column(columnName, DataType.INTEGER);
                                        String data = rs.getString(i);
                                        if (data != null) {
                                            try {
                                                rCol.setValue(new DataValueInt(Integer.parseInt(data)));
                                            }
                                            catch (NumberFormatException ex) {
                                                rCol.setValue(new DataValueInt(0));
                                            }
                                            break block27;
                                        }
                                        rCol.setValue(new DataValueInt(0));
                                    }
                                } else if (this.plugin.getUserManager().getDataManager().isBoolean(columnName)) {
                                    rCol = new Column(columnName, DataType.BOOLEAN);
                                    rCol.setValue(new DataValueBoolean(Boolean.valueOf(rs.getString(i))));
                                } else {
                                    rCol = new Column(columnName, DataType.STRING);
                                    rCol.setValue(new DataValueString(rs.getString(i)));
                                    if (columnName.equals("uuid")) {
                                        uuid = UUID.fromString(rs.getString(i));
                                    }
                                }
                            }
                            cols.add(rCol);
                        }
                        result.put(uuid, cols);
                    }
                    rs.close();
                    hashMap = result;
                    if (sql == null) break block28;
                }
                catch (Throwable throwable) {
                    if (sql != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sql.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<String> getColumns() {
        if (this.columns == null || this.columns.size() == 0) {
            this.loadData();
        }
        return this.columns;
    }

    public ArrayList<String> getColumnsQueury() {
        ArrayList<String> columns = new ArrayList<String>();
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement("SHOW COLUMNS FROM `" + this.getName() + "`;");){
            this.plugin.devDebug("MYSQL QUERY: SHOW COLUMNS FROM `" + this.getName() + "`;");
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                columns.add(columnName);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public ArrayList<Column> getExact(String uuid) {
        return this.getExactQuery(new Column("uuid", new DataValueString(uuid)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Column> getExactQuery(Column column) {
        ArrayList<Column> result = new ArrayList<Column>();
        String query = "SELECT * FROM " + this.getName() + " WHERE `" + column.getName() + "`='" + column.getValue().getString() + "';";
        this.plugin.devDebug("MYSQL QUERY: " + query);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();){
            ArrayList<Column> throwable2;
            block28: {
                PreparedStatement sql222 = conn.prepareStatement(query);
                try {
                    ResultSet rs = sql222.executeQuery();
                    if (rs.next()) {
                        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                            Column rCol;
                            block27: {
                                String columnName = rs.getMetaData().getColumnLabel(i);
                                rCol = null;
                                if (this.plugin.getUserManager().getDataManager().isInt(columnName)) {
                                    try {
                                        rCol = new Column(columnName, DataType.INTEGER);
                                        rCol.setValue(new DataValueInt(rs.getInt(i)));
                                    }
                                    catch (Exception e) {
                                        rCol = new Column(columnName, DataType.INTEGER);
                                        String data = rs.getString(i);
                                        if (data != null) {
                                            try {
                                                rCol.setValue(new DataValueInt(Integer.parseInt(data)));
                                            }
                                            catch (NumberFormatException ex) {
                                                rCol.setValue(new DataValueInt(0));
                                            }
                                            break block27;
                                        }
                                        rCol.setValue(new DataValueInt(0));
                                    }
                                } else if (this.plugin.getUserManager().getDataManager().isBoolean(columnName)) {
                                    rCol = new Column(columnName, DataType.BOOLEAN);
                                    rCol.setValue(new DataValueBoolean(Boolean.valueOf(rs.getString(i))));
                                } else {
                                    rCol = new Column(columnName, DataType.STRING);
                                    rCol.setValue(new DataValueString(rs.getString(i)));
                                }
                            }
                            result.add(rCol);
                        }
                    }
                    rs.close();
                    throwable2 = result;
                    if (sql222 == null) break block28;
                }
                catch (Throwable throwable3) {
                    if (sql222 != null) {
                        try {
                            sql222.close();
                        }
                        catch (Throwable throwable) {
                            throwable3.addSuppressed(throwable);
                        }
                    }
                    throw throwable3;
                }
                sql222.close();
            }
            return throwable2;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        for (String col : this.getColumns()) {
            result.add(new Column(col, DataType.STRING));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getNames() {
        if (this.names == null || this.names.size() == 0) {
            this.names.clear();
            this.names.addAll(this.getNamesQuery());
            return this.names;
        }
        return this.names;
    }

    public ArrayList<String> getNamesQuery() {
        ArrayList<String> uuids = new ArrayList<String>();
        this.checkColumn("PlayerName", DataType.STRING);
        ArrayList<Column> rows = this.getRowsNameQuery();
        if (rows != null) {
            for (Column c : rows) {
                String value;
                if (c.getValue() == null || !c.getValue().isString() || (value = c.getValue().getString()) == null) continue;
                uuids.add(value);
            }
        }
        return uuids;
    }

    public ArrayList<Integer> getNumbersInColumn(String column) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String sqlStr = "SELECT " + column + " FROM " + this.getName() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + sqlStr);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(column));
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<Column> getRowsNameQuery() {
        ArrayList<Column> result = new ArrayList<Column>();
        String sqlStr = "SELECT PlayerName FROM " + this.getName() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + sqlStr);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                Column rCol = new Column("PlayerName", new DataValueString(rs.getString("PlayerName")));
                result.add(rCol);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<Column> getRowsQuery() {
        ArrayList<Column> result = new ArrayList<Column>();
        String sqlStr = "SELECT uuid FROM " + this.getName() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + sqlStr);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                Column rCol = new Column("uuid", new DataValueString(rs.getString("uuid")));
                result.add(rCol);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public ConcurrentHashMap<UUID, String> getRowsUUIDNameQuery() {
        ConcurrentHashMap<UUID, String> uuidNames = new ConcurrentHashMap<UUID, String>();
        String sqlStr = "SELECT UUID, PlayerName FROM " + this.getName() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + sqlStr);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(sqlStr);){
            ResultSet rs = sql.executeQuery();
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String playerName = rs.getString("PlayerName");
                if (uuid == null || uuid.isEmpty() || uuid.equals("null") || playerName == null || playerName.isEmpty()) continue;
                uuidNames.put(UUID.fromString(uuid), playerName);
            }
            sql.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return uuidNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUUID(String playerName) {
        String query = "SELECT uuid FROM " + this.getName() + " WHERE PlayerName='" + playerName + "';";
        this.plugin.devDebug("MYSQL QUERY: " + query);
        try (Connection conn = this.mysql.getConnectionManager().getConnection();
             PreparedStatement sql = conn.prepareStatement(query);){
            String uuid;
            ResultSet rs = sql.executeQuery();
            if (rs.next() && (uuid = rs.getString("uuid")) != null && !uuid.isEmpty()) {
                rs.close();
                String string = uuid;
                return string;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public Set<String> getUuids() {
        if (this.uuids == null || this.uuids.size() == 0) {
            this.uuids.clear();
            this.uuids.addAll(this.getUuidsQuery());
            return this.uuids;
        }
        return this.uuids;
    }

    public ArrayList<String> getUuidsQuery() {
        ArrayList<String> uuids = new ArrayList<String>();
        ArrayList<Column> rows = this.getRowsQuery();
        if (rows != null) {
            for (Column c : rows) {
                if (c.getValue() == null || !c.getValue().isString()) continue;
                uuids.add(c.getValue().getString());
            }
        } else {
            this.plugin.getLogger().severe("Failed to fetch uuids");
        }
        return uuids;
    }

    public void insert(String index, String column, DataValue value) {
        this.insertQuery(index, Arrays.asList(new Column(column, value)));
    }

    public void insertQuery(String index, List<Column> cols) {
        String query = "INSERT IGNORE " + this.getName() + " ";
        query = query + "set uuid='" + index + "', ";
        for (int i = 0; i < cols.size(); ++i) {
            Column col = cols.get(i);
            if (i == cols.size() - 1) {
                if (col.getValue().isString()) {
                    query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "';";
                    continue;
                }
                if (col.getValue().isBoolean()) {
                    query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "';";
                    continue;
                }
                if (!col.getValue().isInt()) continue;
                query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "';";
                continue;
            }
            if (col.getValue().isString()) {
                query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "', ";
                continue;
            }
            if (col.getValue().isBoolean()) {
                query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "', ";
                continue;
            }
            if (!col.getValue().isInt()) continue;
            query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "', ";
        }
        this.plugin.devDebug("MYSQL QUERY: " + query);
        try {
            new Query(this.mysql, query).executeUpdate();
            String playerName = "";
            for (Column col : cols) {
                if (!col.getName().equalsIgnoreCase("playername")) continue;
                playerName = col.getValue().toString();
            }
            if (playerName == null || playerName.isEmpty()) {
                this.names.add(PlayerManager.getInstance().getPlayerName(this.plugin.getUserManager().getUser(UUID.fromString(index), false), index));
            } else {
                this.names.add(playerName);
            }
            this.uuids.add(index);
            this.plugin.devDebug("Inserting " + index + " into database");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plugin.debug("Failed to insert player " + index);
        }
    }

    public boolean isUseBatchUpdates() {
        return this.useBatchUpdates;
    }

    public void loadData() {
        this.columns = this.getColumnsQueury();
        try (Connection con = this.mysql.getConnectionManager().getConnection();){
            this.useBatchUpdates = con.getMetaData().supportsBatchUpdates();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String index, List<Column> cols, boolean runAsync) {
        for (Column col : cols) {
            this.checkColumn(col.getName(), col.getDataType());
        }
        Object object = this.object2;
        synchronized (object) {
            block15: {
                if (this.getUuids().contains(index) || this.containsKeyQuery(index)) {
                    String query = "UPDATE " + this.getName() + " SET ";
                    for (int i = 0; i < cols.size(); ++i) {
                        Column col = cols.get(i);
                        if (i == cols.size() - 1) {
                            if (col.getValue().isString()) {
                                query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "'";
                                continue;
                            }
                            if (col.getValue().isBoolean()) {
                                query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "'";
                                continue;
                            }
                            if (!col.getValue().isInt()) continue;
                            query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "'";
                            continue;
                        }
                        if (col.getValue().isString()) {
                            query = query + "`" + col.getName() + "`='" + col.getValue().getString() + "', ";
                            continue;
                        }
                        if (col.getValue().isBoolean()) {
                            query = query + "`" + col.getName() + "`='" + col.getValue().getBoolean() + "', ";
                            continue;
                        }
                        if (!col.getValue().isInt()) continue;
                        query = query + "`" + col.getName() + "`='" + col.getValue().getInt() + "', ";
                    }
                    query = query + " WHERE uuid=";
                    query = query + "'" + index + "';";
                    this.plugin.devDebug("MYSQL QUERY: " + query);
                    try {
                        Query q = new Query(this.mysql, query);
                        if (runAsync) {
                            q.executeUpdateAsync();
                            break block15;
                        }
                        q.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.insertQuery(index, cols);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String index, String column, DataValue value) {
        if (value == null) {
            this.plugin.extraDebug("Mysql value null: " + column);
            return;
        }
        this.checkColumn(column, value.getType());
        Object object = this.object2;
        synchronized (object) {
            if (this.getUuids().contains(index) || this.containsKeyQuery(index)) {
                String query = "UPDATE " + this.getName() + " SET ";
                if (value.isString()) {
                    query = query + column + "='" + value.getString() + "'";
                } else if (value.isBoolean()) {
                    query = query + column + "='" + value.getBoolean() + "'";
                } else if (value.isInt()) {
                    query = query + column + "='" + value.getInt() + "'";
                }
                query = query + " WHERE uuid=";
                query = query + "'" + index + "';";
                this.plugin.devDebug("MYSQL QUERY: " + query);
                try {
                    Query q = new Query(this.mysql, query);
                    q.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                this.insert(index, column, value);
            }
        }
    }

    public void wipeColumnData(String columnName, DataType dataType) {
        this.checkColumn(columnName, dataType);
        String sql = "UPDATE " + this.getName() + " SET " + columnName + " = " + dataType.getNoValue() + ";";
        this.plugin.devDebug("MYSQL QUERY: " + sql);
        try {
            Query query = new Query(this.mysql, sql);
            query.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public long getLastBackgroundCheck() {
        return this.lastBackgroundCheck;
    }

    @Generated
    public com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL getMysql() {
        return this.mysql;
    }
}

