/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user.usercache;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.UserDataCache;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKey;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyBoolean;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyInt;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyString;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class UserDataManager {
    private ArrayList<UserDataKey> keys;
    private ArrayList<String> intColumns;
    private ArrayList<String> booleanColumns;
    private AdvancedCorePlugin plugin;
    private ScheduledExecutorService timer;
    private ConcurrentHashMap<UUID, UserDataCache> userDataCache;

    public UserDataManager(final AdvancedCorePlugin plugin) {
        this.plugin = plugin;
        this.userDataCache = new ConcurrentHashMap();
        this.keys = new ArrayList();
        this.intColumns = new ArrayList();
        this.booleanColumns = new ArrayList();
        this.timer = Executors.newScheduledThreadPool(1);
        this.loadKeys();
        this.timer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (plugin != null && plugin.isEnabled()) {
                    UserDataManager.this.clearNonNeededCachedUsers();
                }
            }
        }, 180L, 3600L, TimeUnit.SECONDS);
    }

    public void addKey(UserDataKey userDataKey) {
        this.keys.add(userDataKey);
        if (userDataKey instanceof UserDataKeyInt) {
            this.intColumns.add(userDataKey.getKey());
        } else if (userDataKey instanceof UserDataKeyBoolean) {
            this.booleanColumns.add(userDataKey.getKey());
        }
    }

    @Deprecated
    public void cacheUser(UUID uuid) {
        this.plugin.devDebug("Caching " + uuid.toString());
        if (this.userDataCache.containsKey(uuid)) {
            UserDataCache data = this.userDataCache.get(uuid);
            data.clearChanges();
            data.cache();
        } else {
            UserDataCache data = new UserDataCache(this, uuid).cache();
            if (data.hasCache()) {
                this.userDataCache.put(uuid, data);
            }
        }
    }

    public void cacheUser(UUID uuid, String playerName) {
        if (playerName != null && !playerName.isEmpty() && !this.plugin.getOptions().isOnlineMode()) {
            uuid = UUID.fromString(PlayerManager.getInstance().getUUID(playerName));
        }
        this.plugin.devDebug("Caching " + uuid.toString());
        if (this.userDataCache.containsKey(uuid)) {
            UserDataCache data = this.userDataCache.get(uuid);
            data.clearChanges();
            data.cache();
        } else {
            UserDataCache data = new UserDataCache(this, uuid).cache();
            if (data.hasCache()) {
                this.userDataCache.put(uuid, data);
            }
        }
    }

    public void cacheUserIfNeeded(UUID uuid) {
        if (!this.userDataCache.containsKey(uuid)) {
            this.cacheUser(uuid);
        }
    }

    public void clearCache() {
        this.plugin.debug("Clearing cache: " + ((ConcurrentHashMap.CollectionView)((Object)this.userDataCache.keySet())).size());
        for (UserDataCache c : this.userDataCache.values()) {
            c.clearCache();
            c.dump();
        }
        this.userDataCache.clear();
    }

    public void clearCacheBasic() {
        if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.plugin.getMysql().clearCacheBasic();
        }
    }

    public void clearNonNeededCachedUsers() {
        this.plugin.devDebug("Clearing cache for non online players (if any)");
        ArrayList<UUID> onlineUUIDS = new ArrayList<UUID>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            onlineUUIDS.add(p.getUniqueId());
        }
        int removed = 0;
        for (UUID uuid : this.userDataCache.keySet()) {
            if (onlineUUIDS.contains(uuid)) continue;
            this.removeCache(uuid, null);
            ++removed;
        }
        if (removed > 0) {
            this.plugin.devDebug("Removed " + removed + " cached users who are no longer online");
        }
    }

    public boolean containsKey(UUID fromString) {
        return this.userDataCache.containsKey(fromString);
    }

    public UserDataCache getCache(UUID uuid) {
        this.cacheUserIfNeeded(uuid);
        return this.userDataCache.get(uuid);
    }

    public boolean isBoolean(String str) {
        return this.booleanColumns.contains(str);
    }

    public boolean isCached(UUID uuid) {
        if (this.userDataCache.containsKey(uuid)) {
            return this.userDataCache.get(uuid).hasCache();
        }
        return false;
    }

    public boolean isInt(String str) {
        return this.intColumns.contains(str);
    }

    private void loadKeys() {
        this.addKey(new UserDataKeyString("PlayerName").setColumnType("VARCHAR(30)"));
        this.addKey(new UserDataKeyString("OfflineRewards").setColumnType("MEDIUMTEXT"));
        this.addKey(new UserDataKeyString("UnClaimedChoices"));
        this.addKey(new UserDataKeyString("TimedRewards"));
        this.addKey(new UserDataKeyString("LastOnline").setColumnType("VARCHAR(20)"));
        this.addKey(new UserDataKeyString("InputMethod"));
        this.addKey(new UserDataKeyString("ChoicePreference"));
        this.addKey(new UserDataKeyBoolean("CheckWorld"));
    }

    public void removeCache(UUID uuid, String playerName) {
        UserDataCache cache;
        if (playerName != null && !playerName.isEmpty() && !this.plugin.getOptions().isOnlineMode()) {
            uuid = UUID.fromString(PlayerManager.getInstance().getUUID(playerName));
        }
        if ((cache = this.getCache(uuid)) != null) {
            cache.clearCache();
        }
        this.userDataCache.remove(uuid);
    }

    public void updateCacheOnline() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.isCached(p.getUniqueId())) continue;
            this.cacheUser(p.getUniqueId());
        }
    }

    @Generated
    public ArrayList<UserDataKey> getKeys() {
        return this.keys;
    }

    @Generated
    public ArrayList<String> getIntColumns() {
        return this.intColumns;
    }

    @Generated
    public ArrayList<String> getBooleanColumns() {
        return this.booleanColumns;
    }

    @Generated
    public AdvancedCorePlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public ScheduledExecutorService getTimer() {
        return this.timer;
    }

    @Generated
    public ConcurrentHashMap<UUID, UserDataCache> getUserDataCache() {
        return this.userDataCache;
    }
}

