/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user.usercache;

import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.UserDataManager;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.change.UserDataChange;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKey;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class UserDataCache {
    private HashMap<String, DataValue> cache;
    private Queue<UserDataChange> cachedChanges;
    private UserDataManager manager;
    private boolean scheduled = false;
    private UUID uuid;

    public UserDataCache(UserDataManager manager, UUID uuid) {
        this.uuid = uuid;
        this.manager = manager;
        this.cachedChanges = new ConcurrentLinkedQueue<UserDataChange>();
        this.cache = new HashMap();
    }

    public synchronized void addChange(UserDataChange change, boolean queue) {
        this.cache.put(change.getKey(), change.toUserDataValue());
        if (queue) {
            this.cachedChanges.add(change);
            if (!this.scheduled) {
                this.scheduleChanges();
            }
        }
    }

    public UserDataCache cache() {
        if (this.uuid != null) {
            AdvancedCoreUser user = this.getUser();
            ArrayList<String> keys = user.getUserData().getKeys();
            HashMap<String, DataValue> data = user.getUserData().getValues();
            ArrayList<String> changedKeys = new ArrayList<String>();
            for (UserDataKey dataKey : this.manager.getKeys()) {
                String key = dataKey.getKey();
                keys.remove(key);
                if (data.containsKey(key)) {
                    DataValue dataValue = data.get(key);
                    this.manager.getPlugin().devDebug("Caching " + dataValue.getTypeName() + " " + key + " for " + this.uuid.toString() + ", value: " + dataValue.toString());
                    try {
                        if (this.cache.containsKey(key) && !this.cache.get(key).toString().equals(dataValue.toString())) {
                            changedKeys.add(key);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.cache.put(key, dataValue);
                    continue;
                }
                this.manager.getPlugin().devDebug("Loading default cache value for " + key + " for " + this.uuid.toString());
                this.cache.put(key, dataKey.getDefault());
            }
            if (!changedKeys.isEmpty()) {
                this.manager.getPlugin().getUserManager().onChange(user, ArrayUtils.convert(changedKeys));
            }
            if (keys.size() > 0) {
                this.manager.getPlugin().devDebug("Keys not cached: " + ArrayUtils.makeStringList(keys));
            }
        }
        return this;
    }

    public void clearCache() {
        if (this.hasChangesToProcess()) {
            this.processChanges();
        }
        this.cache.clear();
    }

    public void clearChanges() {
        if (this.hasChangesToProcess()) {
            this.processChanges();
        }
    }

    public void displayCache() {
        this.manager.getPlugin().devDebug(this.displayCacheStringList().toString());
    }

    public ArrayList<String> displayCacheStringList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Current cache for " + this.uuid + ": ");
        for (Map.Entry<String, DataValue> entry : this.getCache().entrySet()) {
            if (entry.getValue().isBoolean()) {
                list.add(entry.getKey() + "=" + entry.getValue().getBoolean());
                continue;
            }
            if (entry.getValue().isString()) {
                list.add(entry.getKey() + "=" + entry.getValue().getString());
                continue;
            }
            if (!entry.getValue().isInt()) continue;
            list.add(entry.getKey() + "=" + entry.getValue().getInt());
        }
        return list;
    }

    public void dump() {
        if (this.hasChangesToProcess()) {
            this.processChanges();
        }
        this.cache = null;
        this.cachedChanges = null;
        this.uuid = null;
    }

    public AdvancedCoreUser getUser() {
        return this.manager.getPlugin().getUserManager().getUser(this.uuid, false);
    }

    public boolean hasCache() {
        return !this.cache.isEmpty();
    }

    public boolean hasChangesToProcess() {
        return !this.cachedChanges.isEmpty();
    }

    public boolean isCached(String key) {
        if (this.cache != null) {
            return this.cache.containsKey(key);
        }
        return false;
    }

    public void processChanges() {
        if (this.uuid != null && this.cachedChanges.size() > 0) {
            this.manager.getPlugin().extraDebug("Processing changes for " + this.uuid.toString() + ", Changes: " + this.cachedChanges.size());
            AdvancedCoreUser user = this.getUser();
            HashMap<String, DataValue> values = new HashMap<String, DataValue>();
            ArrayList<String> keys = new ArrayList<String>();
            while (!this.cachedChanges.isEmpty()) {
                UserDataChange change = this.cachedChanges.poll();
                values.put(change.getKey(), change.toUserDataValue());
                keys.add(change.getKey());
                change.dump();
            }
            if (!values.isEmpty()) {
                user.getUserData().setValues(values);
            }
            this.manager.getPlugin().getUserManager().onChange(user, ArrayUtils.convert(keys));
        }
    }

    public void processChangesAsync() {
        if (this.uuid != null && this.cachedChanges.size() > 0) {
            this.manager.getPlugin().getTimer().execute(new Runnable(){

                @Override
                public void run() {
                    UserDataCache.this.processChanges();
                }
            });
        }
    }

    private void scheduleChanges() {
        this.manager.getPlugin().debug("Schedule changes");
        this.scheduled = true;
        this.manager.getTimer().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    UserDataCache.this.processChanges();
                    UserDataCache.this.scheduled = false;
                }
                catch (Exception e) {
                    UserDataCache.this.manager.getPlugin().debug(e);
                }
            }
        }, 3L, TimeUnit.SECONDS);
    }

    public void updateCache(HashMap<String, DataValue> tempCache) {
        this.cache = tempCache;
    }

    @Generated
    public HashMap<String, DataValue> getCache() {
        return this.cache;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }
}

