/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserDataChanged;
import com.bencodez.votingplugin.advancedcore.api.user.UserStartup;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.UserDataManager;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class UserManager {
    private UserDataManager dataManager;
    private Object obj = new Object();
    private AdvancedCorePlugin plugin;
    private ArrayList<UserDataChanged> userDataChange = new ArrayList();

    public UserManager(AdvancedCorePlugin plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void copyColumnData(String columnFromName, String columnToName) {
        if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.plugin.getMysql().copyColumnData(columnFromName, columnToName, DataType.STRING);
        } else if (this.plugin.getStorageType().equals((Object)UserStorage.SQLITE)) {
            this.plugin.getSQLiteUserTable().copyColumnData(columnFromName, columnToName, DataType.STRING);
        } else if (this.plugin.getStorageType().equals((Object)UserStorage.FLAT)) {
            for (String uuid : this.getAllUUIDs()) {
                AdvancedCoreUser user = this.getUser(UUID.fromString(uuid));
                user.dontCache();
                DataValue data = user.getData().getDataValue(columnFromName);
                user.getData().setValues(columnToName, data);
            }
        }
    }

    public List<String> getAllColumns() {
        UserStorage storage = this.plugin.getStorageType();
        if (storage.equals((Object)UserStorage.SQLITE)) {
            return this.plugin.getSQLiteUserTable().getColumnsString();
        }
        if (storage.equals((Object)UserStorage.MYSQL)) {
            return this.plugin.getMysql().getColumns();
        }
        AdvancedCoreUser user = this.getRandomUser();
        user.dontCache();
        return new ArrayList<String>(user.getData().getData(user.getUUID()).getConfigurationSection("").getKeys(false));
    }

    public HashMap<UUID, ArrayList<Column>> getAllKeys() {
        return this.getAllKeys(this.plugin.getStorageType());
    }

    public HashMap<UUID, ArrayList<Column>> getAllKeys(UserStorage storage) {
        if (storage.equals((Object)UserStorage.SQLITE)) {
            return this.plugin.getSQLiteUserTable().getAllQuery();
        }
        if (storage.equals((Object)UserStorage.MYSQL)) {
            return this.plugin.getMysql().getAllQuery();
        }
        HashMap<UUID, ArrayList<Column>> cols = new HashMap<UUID, ArrayList<Column>>();
        for (String uuid : this.getAllUUIDs()) {
            AdvancedCoreUser user = this.getUser(UUID.fromString(uuid));
            user.dontCache();
            ArrayList<Column> col = new ArrayList<Column>();
            for (Map.Entry<String, DataValue> entry : user.getData().getValues().entrySet()) {
                col.add(new Column(entry.getKey(), entry.getValue()));
            }
            cols.put(UUID.fromString(uuid), col);
        }
        return cols;
    }

    public ArrayList<String> getAllPlayerNames() {
        if (this.plugin.isLoadUserData()) {
            ArrayList<String> names = new ArrayList<String>();
            if (AdvancedCorePlugin.getInstance().getStorageType().equals((Object)UserStorage.FLAT)) {
                for (String uuid : this.getAllUUIDs()) {
                    AdvancedCoreUser user = this.getUser(UUID.fromString(uuid));
                    String name = user.getPlayerName();
                    if (name == null || name.isEmpty() || name.equalsIgnoreCase("Error getting name")) continue;
                    names.add(name);
                }
            } else if (AdvancedCorePlugin.getInstance().getStorageType().equals((Object)UserStorage.SQLITE)) {
                ArrayList<String> data = this.plugin.getSQLiteUserTable().getNames();
                for (String name : data) {
                    if (name == null || name.isEmpty() || name.equalsIgnoreCase("Error getting name")) continue;
                    names.add(name);
                }
            } else if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
                ArrayList<String> data = ArrayUtils.convert(this.plugin.getMysql().getNames());
                for (String name : data) {
                    if (name == null || name.isEmpty() || name.equalsIgnoreCase("Error getting name")) continue;
                    names.add(name);
                }
            }
            return ArrayUtils.removeDuplicates(names);
        }
        return new ArrayList<String>();
    }

    public ArrayList<String> getAllUUIDs() {
        return ArrayUtils.removeDuplicates(this.getAllUUIDs(this.plugin.getStorageType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllUUIDs(UserStorage storage) {
        if (this.plugin.isLoadUserData()) {
            if (storage.equals((Object)UserStorage.FLAT)) {
                File folder = new File(this.plugin.getDataFolder() + File.separator + "Data");
                String[] fileNames = folder.list();
                ArrayList<String> uuids = new ArrayList<String>();
                if (fileNames != null) {
                    for (String playerFile : fileNames) {
                        if (playerFile.equals("null") || playerFile.equals("")) continue;
                        String uuid = playerFile.replace(".yml", "");
                        uuids.add(uuid);
                    }
                }
                return uuids;
            }
            if (storage.equals((Object)UserStorage.SQLITE)) {
                List<Column> cols = this.plugin.getSQLiteUserTable().getRows();
                ArrayList<String> uuids = new ArrayList<String>();
                for (Column col : cols) {
                    if (!col.getValue().isString()) continue;
                    uuids.add(col.getValue().getString());
                }
                return uuids;
            }
            if (storage.equals((Object)UserStorage.MYSQL)) {
                Object object = this.obj;
                synchronized (object) {
                    ArrayList<String> uuids = new ArrayList<String>();
                    try {
                        for (String uuid : this.plugin.getMysql().getUuids()) {
                            uuids.add(uuid);
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                    return uuids;
                }
            }
        }
        return new ArrayList<String>();
    }

    public ArrayList<Integer> getNumbersInColumn(String columnName) {
        if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            return this.plugin.getMysql().getNumbersInColumn(columnName);
        }
        if (this.plugin.getStorageType().equals((Object)UserStorage.SQLITE)) {
            return this.plugin.getSQLiteUserTable().getNumbersInColumn(columnName);
        }
        if (this.plugin.getStorageType().equals((Object)UserStorage.FLAT)) {
            ArrayList<Integer> nums = new ArrayList<Integer>();
            for (String uuid : this.getAllUUIDs()) {
                AdvancedCoreUser user = this.getUser(UUID.fromString(uuid));
                user.dontCache();
                int num = user.getData().getInt(columnName, 0, true, true);
                nums.add(num);
            }
            return nums;
        }
        return new ArrayList<Integer>();
    }

    public String getOfflineRewardsPath() {
        if (this.plugin.getOptions().isPerServerRewards()) {
            return "OfflineRewards" + this.plugin.getOptions().getServer().replace("-", "_");
        }
        return "OfflineRewards";
    }

    public String getProperName(String name) {
        for (String s : this.plugin.getUuidNameCache().values()) {
            if (!s.equalsIgnoreCase(name)) continue;
            return s;
        }
        for (String s : this.getAllPlayerNames()) {
            if (!s.equalsIgnoreCase(name)) continue;
            return s;
        }
        return name;
    }

    public AdvancedCoreUser getRandomUser() {
        if (this.getAllUUIDs().size() > 0) {
            this.getUser(this.getAllUUIDs().get(0));
        }
        return null;
    }

    public AdvancedCoreUser getUser(OfflinePlayer player) {
        return this.getUser(player.getUniqueId(), player.getName());
    }

    public AdvancedCoreUser getUser(Player player) {
        return this.getUser(player.getUniqueId(), player.getName());
    }

    public AdvancedCoreUser getUser(String playerName) {
        return new AdvancedCoreUser(this.plugin, this.getProperName(playerName));
    }

    public AdvancedCoreUser getUser(UUID uuid) {
        return new AdvancedCoreUser(this.plugin, uuid);
    }

    public AdvancedCoreUser getUser(UUID uuid, boolean loadName) {
        return new AdvancedCoreUser(this.plugin, uuid, loadName);
    }

    public AdvancedCoreUser getUser(UUID uuid, String playerName) {
        return new AdvancedCoreUser(this.plugin, uuid, playerName);
    }

    public void load() {
        this.dataManager = new UserDataManager(AdvancedCorePlugin.getInstance());
    }

    public void onChange(AdvancedCoreUser user, String ... keys) {
        for (UserDataChanged change : this.userDataChange) {
            change.onChange(user, keys);
        }
    }

    public void purgeOldPlayersNow() {
        if (this.plugin.getOptions().isPurgeOldData()) {
            HashMap<UUID, ArrayList<Column>> cols = this.getAllKeys();
            for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                AdvancedCoreUser user;
                String uuid = playerData.getKey().toString();
                if (!this.plugin.isEnabled() || uuid == null || (user = this.getUser(UUID.fromString(uuid), false)) == null) continue;
                user.dontCache();
                user.updateTempCacheWithColumns(playerData.getValue());
                int daysOld = this.plugin.getOptions().getPurgeMinimumDays();
                int days = user.getNumberOfDaysSinceLogin();
                if (days == -1) {
                    user.setLastOnline(System.currentTimeMillis());
                } else if (days > daysOld) {
                    this.plugin.debug("Removing " + user.getUUID() + " because of purge");
                    user.remove();
                }
                user.clearTempCache();
                cols.put(playerData.getKey(), null);
                user = null;
            }
            cols.clear();
            Object var1_1 = null;
        }
        this.getDataManager().clearCache();
    }

    public void purgeOldPlayersStartup() {
        if (this.plugin.getOptions().isPurgeOldData() && this.plugin.getOptions().isPurgeDataOnStartup()) {
            this.plugin.addUserStartup(new UserStartup(){

                @Override
                public void onFinish() {
                    UserManager.this.plugin.debug("Finished purging");
                }

                @Override
                public void onStart() {
                }

                @Override
                public void onStartUp(AdvancedCoreUser user) {
                    int daysOld = UserManager.this.plugin.getOptions().getPurgeMinimumDays();
                    int days = user.getNumberOfDaysSinceLogin();
                    if (days == -1) {
                        user.setLastOnline(System.currentTimeMillis());
                    } else if (days > daysOld) {
                        UserManager.this.plugin.debug("Removing " + user.getUUID() + " because of purge");
                        user.remove();
                    }
                }
            });
        }
        this.getDataManager().clearCache();
    }

    public void removeAllKeyValues(String key, DataType type) {
        if (this.plugin.getStorageType().equals((Object)UserStorage.SQLITE)) {
            this.plugin.getSQLiteUserTable().wipeColumnData(key, type);
        } else if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.plugin.getMysql().wipeColumnData(key, type);
        } else {
            for (String uuid : this.getAllUUIDs()) {
                AdvancedCoreUser user = this.getUser(UUID.fromString(uuid));
                user.dontCache();
                switch (type) {
                    case INTEGER: {
                        user.getData().setInt(key, 0);
                        break;
                    }
                    case STRING: {
                        user.getData().setString(key, "");
                        break;
                    }
                }
            }
        }
    }

    public void removeUUID(UUID key) {
        if (this.plugin.getStorageType().equals((Object)UserStorage.SQLITE)) {
            this.plugin.getSQLiteUserTable().delete(new Column("uuid", new DataValueString(key.toString())));
        } else if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.plugin.getMysql().deletePlayer(key.toString());
        }
    }

    public boolean userExist(String name) {
        boolean exist = ArrayUtils.containsIgnoreCase(this.getAllPlayerNames(), name);
        if (exist) {
            return exist;
        }
        for (String s : this.plugin.getUuidNameCache().values()) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean userExist(UUID uuid) {
        return uuid != null && this.getAllUUIDs().contains(uuid.toString());
    }

    @Generated
    public UserDataManager getDataManager() {
        return this.dataManager;
    }

    @Generated
    public ArrayList<UserDataChanged> getUserDataChange() {
        return this.userDataChange;
    }
}

