/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user;

import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.UserDataCache;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.change.UserDataChangeInt;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.change.UserDataChangeString;
import com.bencodez.votingplugin.advancedcore.thread.FileThread;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;

public class UserData {
    private HashMap<String, DataValue> tempCache;
    private AdvancedCoreUser user;

    public UserData(AdvancedCoreUser user) {
        this.user = user;
    }

    public void clearTempCache() {
        this.tempCache.clear();
        this.tempCache = null;
    }

    public HashMap<String, DataValue> convert(List<Column> cols) {
        HashMap<String, DataValue> data = new HashMap<String, DataValue>();
        if (cols != null) {
            for (Column col : cols) {
                data.put(col.getName(), col.getValue());
            }
        }
        return data;
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getString(key));
    }

    public boolean getBoolean(String key, boolean useCache, boolean waitForCache) {
        return Boolean.valueOf(this.getString(key, useCache, waitForCache));
    }

    @Deprecated
    public FileConfiguration getData(String uuid) {
        return FileThread.getInstance().getThread().getData(this, uuid);
    }

    public DataValue getDataValue(String key) {
        boolean isInt = this.user.getPlugin().getUserManager().getDataManager().isInt(key);
        if (isInt) {
            return new DataValueInt(this.getInt(key));
        }
        return new DataValueString(this.getString(key));
    }

    @Deprecated
    public int getInt(String key) {
        return this.getInt(key, 0, true, true);
    }

    public int getInt(String key, boolean waitForCache) {
        return this.getInt(key, 0, true, waitForCache);
    }

    public int getInt(String key, boolean useCache, boolean waitForCache) {
        return this.getInt(key, 0, useCache, waitForCache);
    }

    public int getInt(String key, int def, boolean waitForCache) {
        return this.getInt(this.user.getPlugin().getStorageType(), key, def, true, waitForCache);
    }

    public int getInt(String key, int def, boolean useCache, boolean waitForCache) {
        return this.getInt(this.user.getPlugin().getStorageType(), key, def, useCache, waitForCache);
    }

    public int getInt(UserStorage storage, String key, int def, boolean useCache, boolean waitForCache) {
        if (!key.equals("")) {
            List<Column> row;
            if (this.user.isTempCache() && this.tempCache != null) {
                if (this.tempCache.get(key) == null) {
                    return def;
                }
                if (this.tempCache.get(key).isInt()) {
                    return this.tempCache.get(key).getInt();
                }
            }
            if (useCache) {
                UserDataCache cache = this.user.getCache();
                if (cache != null) {
                    this.user.cacheIfNeeded();
                    if (cache.isCached(key)) {
                        if (cache.getCache().get(key).isInt()) {
                            return cache.getCache().get(key).getInt();
                        }
                        String str = cache.getCache().get(key).getString();
                        if (str != null && !str.equals("null")) {
                            try {
                                return Integer.parseInt(str);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    this.user.cache();
                }
            }
            if (storage.equals((Object)UserStorage.SQLITE)) {
                row = this.getSQLiteRow();
                if (row != null) {
                    for (Column element : row) {
                        if (!element.getName().equals(key)) continue;
                        DataValue value = element.getValue();
                        if (value.isInt()) {
                            return value.getInt();
                        }
                        if (!value.isString()) continue;
                        String str = value.getString();
                        if (str != null) {
                            try {
                                return Integer.parseInt(str);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return def;
                    }
                }
            } else if (storage.equals((Object)UserStorage.MYSQL) && (row = this.getMySqlRow()) != null) {
                for (Column element : row) {
                    if (!element.getName().equals(key)) continue;
                    DataValue value = element.getValue();
                    if (value.isInt()) {
                        return value.getInt();
                    }
                    if (!value.isString()) continue;
                    String str = value.getString();
                    if (str != null) {
                        try {
                            return Integer.parseInt(str);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return def;
                }
            }
        } else if (storage.equals((Object)UserStorage.FLAT)) {
            try {
                return this.getData(this.user.getUUID()).getInt(key, def);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public ArrayList<String> getKeys() {
        return this.getKeys(true);
    }

    public ArrayList<String> getKeys(boolean waitForCache) {
        ArrayList<String> keys;
        block4: {
            List<Column> col;
            block5: {
                block3: {
                    keys = new ArrayList<String>();
                    if (!this.user.getPlugin().getStorageType().equals((Object)UserStorage.FLAT)) break block3;
                    keys = new ArrayList(this.getData(this.user.getUUID()).getConfigurationSection("").getKeys(false));
                    break block4;
                }
                if (!this.user.getPlugin().getStorageType().equals((Object)UserStorage.MYSQL)) break block5;
                List<Column> col2 = this.getMySqlRow();
                if (col2 == null || col2.isEmpty()) break block4;
                for (Column c : col2) {
                    keys.add(c.getName());
                }
                break block4;
            }
            if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.SQLITE) && (col = this.getSQLiteRow()) != null && !col.isEmpty()) {
                for (Column c : col) {
                    keys.add(c.getName());
                }
            }
        }
        return keys;
    }

    public ArrayList<String> getKeys(UserStorage storage, boolean waitForCache) {
        ArrayList<String> keys;
        block4: {
            List<Column> col;
            block5: {
                block3: {
                    keys = new ArrayList<String>();
                    if (!storage.equals((Object)UserStorage.FLAT)) break block3;
                    keys = new ArrayList(this.getData(this.user.getUUID()).getConfigurationSection("").getKeys(false));
                    break block4;
                }
                if (!storage.equals((Object)UserStorage.MYSQL)) break block5;
                List<Column> col2 = this.getMySqlRow();
                if (col2 == null || col2.isEmpty()) break block4;
                for (Column c : col2) {
                    keys.add(c.getName());
                }
                break block4;
            }
            if (storage.equals((Object)UserStorage.SQLITE) && (col = this.getSQLiteRow()) != null && !col.isEmpty()) {
                for (Column c : col) {
                    keys.add(c.getName());
                }
            }
        }
        return keys;
    }

    public List<Column> getMySqlRow() {
        return this.user.getPlugin().getMysql().getExact(this.user.getUUID());
    }

    public List<Column> getSQLiteRow() {
        return this.user.getPlugin().getSQLiteUserTable().getExact(new Column("uuid", new DataValueString(this.user.getUUID())));
    }

    @Deprecated
    public String getString(String key) {
        return this.getString(key, true, true);
    }

    public String getString(String key, boolean waitForCache) {
        return this.getString(this.user.getPlugin().getStorageType(), key, true, waitForCache);
    }

    public String getString(String key, boolean useCache, boolean waitForCache) {
        return this.getString(this.user.getPlugin().getStorageType(), key, useCache, waitForCache);
    }

    public String getString(UserStorage storage, String key, boolean useCache, boolean waitForCache) {
        if (!key.equals("")) {
            List<Column> row;
            if (this.user.isTempCache() && this.tempCache != null) {
                if (this.tempCache.get(key) == null) {
                    return "";
                }
                if (this.tempCache.get(key).isString() || this.tempCache.get(key).isBoolean()) {
                    String str = this.tempCache.get(key).getString();
                    if (str != null) {
                        return str;
                    }
                    return "";
                }
            }
            if (useCache) {
                UserDataCache cache = this.user.getCache();
                if (cache != null) {
                    if (cache.isCached(key)) {
                        String str = cache.getCache().get(key).getString();
                        if (str != null) {
                            return str;
                        }
                        return "";
                    }
                } else {
                    this.user.cache();
                }
            }
            if (storage.equals((Object)UserStorage.SQLITE)) {
                row = this.getSQLiteRow();
                if (row != null) {
                    for (Column element : row) {
                        if (!element.getName().equals(key) || !element.getValue().isString() && !element.getValue().isBoolean()) continue;
                        String st = element.getValue().getString();
                        if (st != null && !st.equals("null")) {
                            return st;
                        }
                        return "";
                    }
                }
            } else if (storage.equals((Object)UserStorage.MYSQL)) {
                row = this.getMySqlRow();
                if (row != null) {
                    for (Column element : row) {
                        if (!element.getName().equals(key) || !element.getValue().isString() && !element.getValue().isBoolean()) continue;
                        String st = element.getValue().getString();
                        if (st != null && !st.equals("null")) {
                            return st;
                        }
                        return "";
                    }
                }
            } else if (storage.equals((Object)UserStorage.FLAT)) {
                try {
                    return this.getData(this.user.getUUID()).getString(key, "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public ArrayList<String> getStringList(String key) {
        return this.getStringList(key, true, true);
    }

    public ArrayList<String> getStringList(String key, boolean cache, boolean waitForCache) {
        String str = this.getString(key, cache, waitForCache);
        if (str == null || str.equals("")) {
            return new ArrayList<String>();
        }
        String[] list = str.split("%line%");
        return ArrayUtils.convert(list);
    }

    public String getValue(String key) {
        boolean isInt = this.user.getPlugin().getUserManager().getDataManager().isInt(key);
        if (isInt) {
            return "" + this.getInt(key);
        }
        return this.getString(key);
    }

    public HashMap<String, DataValue> getValues() {
        return this.getValues(this.user.getPlugin().getStorageType());
    }

    public HashMap<String, DataValue> getValues(UserStorage storage) {
        if (storage.equals((Object)UserStorage.MYSQL)) {
            return this.convert(this.getMySqlRow());
        }
        if (storage.equals((Object)UserStorage.SQLITE)) {
            return this.convert(this.getSQLiteRow());
        }
        if (storage.equals((Object)UserStorage.FLAT)) {
            HashMap<String, DataValue> list = new HashMap<String, DataValue>();
            FileConfiguration data = this.getData(this.user.getUUID());
            for (String str : data.getKeys(false)) {
                if (data.isInt(str)) {
                    list.put(str, new DataValueInt(data.getInt(str)));
                    continue;
                }
                list.put(str, new DataValueString(data.getString(str, "")));
            }
            return list;
        }
        return null;
    }

    public boolean hasData() {
        if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.MYSQL)) {
            return this.user.getPlugin().getMysql().containsKey(this.user.getUUID());
        }
        if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.SQLITE)) {
            return this.user.getPlugin().getSQLiteUserTable().containsKey(this.user.getUUID());
        }
        if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.FLAT)) {
            return FileThread.getInstance().getThread().hasPlayerFile(this.user.getUUID());
        }
        return false;
    }

    public void remove() {
        if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.user.getPlugin().getMysql().deletePlayer(this.user.getUUID());
        } else if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.SQLITE)) {
            this.user.getPlugin().getSQLiteUserTable().delete(new Column("uuid", new DataValueString(this.user.getUUID())));
        } else if (this.user.getPlugin().getStorageType().equals((Object)UserStorage.FLAT)) {
            FileThread.getInstance().getThread().deletePlayerFile(this.user.getUUID());
        }
        this.user.clearCache();
    }

    public void setBoolean(String key, boolean value) {
        this.setString(key, "" + value);
    }

    public void setBoolean(String key, boolean value, boolean queue) {
        this.setString(key, "" + value, queue);
    }

    @Deprecated
    private void setData(String uuid, String path, Object value) {
        FileThread.getInstance().getThread().setData(this, uuid, path, value);
    }

    public void setInt(String key, int value) {
        this.setInt(key, value, true);
    }

    public void setInt(String key, int value, boolean queue) {
        this.setInt(this.user.getPlugin().getStorageType(), key, value, queue);
    }

    public void setInt(String key, int value, boolean queue, boolean async) {
        this.setInt(this.user.getPlugin().getStorageType(), key, value, queue, async);
    }

    public void setInt(UserStorage storage, String key, int value, boolean queue) {
        this.setInt(storage, key, value, queue, false);
    }

    public void setInt(final UserStorage storage, final String key, final int value, boolean queue, boolean async) {
        if (key.equals("")) {
            this.user.getPlugin().debug("No key: " + key + " to " + value);
            return;
        }
        if (key.contains(" ")) {
            this.user.getPlugin().getLogger().severe("Keys cannot contain spaces " + key);
        }
        this.user.getPlugin().extraDebug("PlayerData " + storage.toString() + ": Setting " + key + " to '" + value + "' for '" + this.user.getPlayerName() + "/" + this.user.getUUID() + "' Queue: " + queue);
        if (this.user.isCached()) {
            this.user.getCache().addChange(new UserDataChangeInt(key, value), queue);
            this.user.getPlugin().getUserManager().onChange(this.user, key);
            if (queue) {
                return;
            }
        }
        if (async) {
            this.user.getPlugin().getTimer().execute(new Runnable(){

                @Override
                public void run() {
                    if (storage.equals((Object)UserStorage.SQLITE)) {
                        ArrayList<Column> columns = new ArrayList<Column>();
                        Column primary = new Column("uuid", new DataValueString(UserData.this.user.getUUID()));
                        Column column = new Column(key, new DataValueInt(value));
                        columns.add(primary);
                        columns.add(column);
                        UserData.this.user.getPlugin().getSQLiteUserTable().update(primary, columns);
                    } else if (storage.equals((Object)UserStorage.MYSQL)) {
                        UserData.this.user.getPlugin().getMysql().update(UserData.this.user.getUUID(), key, new DataValueInt(value));
                    } else if (storage.equals((Object)UserStorage.FLAT)) {
                        UserData.this.setData(UserData.this.user.getUUID(), key, value);
                    }
                    if (!UserData.this.user.isCached()) {
                        UserData.this.user.getPlugin().getUserManager().onChange(UserData.this.user, key);
                    }
                }
            });
        } else {
            if (storage.equals((Object)UserStorage.SQLITE)) {
                ArrayList<Column> columns = new ArrayList<Column>();
                Column primary = new Column("uuid", new DataValueString(this.user.getUUID()));
                Column column = new Column(key, new DataValueInt(value));
                columns.add(primary);
                columns.add(column);
                this.user.getPlugin().getSQLiteUserTable().update(primary, columns);
            } else if (storage.equals((Object)UserStorage.MYSQL)) {
                this.user.getPlugin().getMysql().update(this.user.getUUID(), key, new DataValueInt(value));
            } else if (storage.equals((Object)UserStorage.FLAT)) {
                this.setData(this.user.getUUID(), key, value);
            }
            if (!this.user.isCached()) {
                this.user.getPlugin().getUserManager().onChange(this.user, key);
            }
        }
    }

    public void setString(String key, String value) {
        this.setString(key, value, true);
    }

    public void setString(String key, String value, boolean queue) {
        this.setString(this.user.getPlugin().getStorageType(), key, value, queue);
    }

    public void setString(String key, String value, boolean queue, boolean async) {
        this.setString(this.user.getPlugin().getStorageType(), key, value, queue, async);
    }

    public void setString(UserStorage storage, String key, String value, boolean queue) {
        this.setString(storage, key, value, queue, false);
    }

    public void setString(final UserStorage storage, final String key, final String value, boolean queue, boolean async) {
        if (key.equals("") && value != null) {
            this.user.getPlugin().debug("No key/value: " + key + " to " + value);
            return;
        }
        if (key.contains(" ")) {
            this.user.getPlugin().getLogger().severe("Keys cannot contain spaces " + key);
        }
        this.user.getPlugin().extraDebug("PlayerData " + storage.toString() + ": Setting " + key + " to '" + value + "' for '" + this.user.getPlayerName() + "/" + this.user.getUUID() + "' Queue: " + queue);
        if (this.user.isCached()) {
            this.user.getCache().addChange(new UserDataChangeString(key, value), queue);
            this.user.getPlugin().getUserManager().onChange(this.user, key);
            if (queue) {
                return;
            }
        }
        if (async) {
            this.user.getPlugin().getTimer().execute(new Runnable(){

                @Override
                public void run() {
                    if (storage.equals((Object)UserStorage.SQLITE)) {
                        ArrayList<Column> columns = new ArrayList<Column>();
                        Column primary = new Column("uuid", new DataValueString(UserData.this.user.getUUID()));
                        Column column = new Column(key, new DataValueString(value));
                        columns.add(primary);
                        columns.add(column);
                        UserData.this.user.getPlugin().getSQLiteUserTable().update(primary, columns);
                    } else if (storage.equals((Object)UserStorage.MYSQL)) {
                        UserData.this.user.getPlugin().getMysql().update(UserData.this.user.getUUID(), key, new DataValueString(value));
                    } else if (storage.equals((Object)UserStorage.FLAT)) {
                        UserData.this.setData(UserData.this.user.getUUID(), key, value);
                    }
                    if (!UserData.this.user.isCached()) {
                        UserData.this.user.getPlugin().getUserManager().onChange(UserData.this.user, key);
                    }
                }
            });
        } else {
            if (storage.equals((Object)UserStorage.SQLITE)) {
                ArrayList<Column> columns = new ArrayList<Column>();
                Column primary = new Column("uuid", new DataValueString(this.user.getUUID()));
                Column column = new Column(key, new DataValueString(value));
                columns.add(primary);
                columns.add(column);
                this.user.getPlugin().getSQLiteUserTable().update(primary, columns);
            } else if (storage.equals((Object)UserStorage.MYSQL)) {
                this.user.getPlugin().getMysql().update(this.user.getUUID(), key, new DataValueString(value));
            } else if (storage.equals((Object)UserStorage.FLAT)) {
                this.setData(this.user.getUUID(), key, value);
            }
            if (!this.user.isCached()) {
                this.user.getPlugin().getUserManager().onChange(this.user, key);
            }
        }
    }

    public void setStringList(String key, ArrayList<String> value) {
        this.setStringList(key, value, true);
    }

    public void setStringList(String key, ArrayList<String> value, boolean queue) {
        String str = "";
        for (int i = 0; i < value.size(); ++i) {
            if (i != 0) {
                str = str + "%line%";
            }
            str = str + value.get(i);
        }
        this.setString(key, str, queue);
    }

    public void setValues(HashMap<String, DataValue> values) {
        this.setValues(this.user.getPlugin().getStorageType(), values);
    }

    public void setValues(String key, DataValue value) {
        HashMap<String, DataValue> values = new HashMap<String, DataValue>();
        values.put(key, value);
        this.setValues(this.user.getPlugin().getStorageType(), values);
    }

    public void setValues(UserStorage storage, HashMap<String, DataValue> values) {
        block9: {
            block8: {
                if (!storage.equals((Object)UserStorage.MYSQL)) break block8;
                if (this.user.getPlugin().getMysql() == null) break block9;
                ArrayList<Column> cols = new ArrayList<Column>();
                for (Map.Entry<String, DataValue> entry : values.entrySet()) {
                    if (entry.getKey().equals("uuid")) continue;
                    cols.add(new Column(entry.getKey(), entry.getValue()));
                }
                this.user.getPlugin().getMysql().update(this.user.getUUID(), cols, false);
                break block9;
            }
            if (storage.equals((Object)UserStorage.SQLITE)) {
                ArrayList<Column> cols = new ArrayList<Column>();
                for (Map.Entry<String, DataValue> entry : values.entrySet()) {
                    if (!entry.getKey().equals("uuid")) {
                        cols.add(new Column(entry.getKey(), entry.getValue()));
                    }
                    this.user.getPlugin().getSQLiteUserTable().update(new Column("uuid", new DataValueString(this.user.getUUID())), cols);
                }
            } else if (storage.equals((Object)UserStorage.FLAT)) {
                for (Map.Entry<String, DataValue> entry : values.entrySet()) {
                    if (entry.getValue() instanceof DataValueString) {
                        this.setData(this.user.getUUID(), entry.getKey(), entry.getValue().getString());
                        continue;
                    }
                    if (!(entry.getValue() instanceof DataValueInt)) continue;
                    this.setData(this.user.getUUID(), entry.getKey(), entry.getValue().getInt());
                }
            }
        }
    }

    public void tempCache() {
        this.tempCache = this.getValues();
    }

    public void updateCacheWithTemp() {
        if (this.user.isCached()) {
            this.user.getCache().updateCache(this.tempCache);
        }
    }

    public void updateTempCacheWithColumns(ArrayList<Column> cols) {
        this.tempCache = this.convert(cols);
    }

    @Generated
    public HashMap<String, DataValue> getTempCache() {
        return this.tempCache;
    }

    @Generated
    public void setTempCache(HashMap<String, DataValue> tempCache) {
        this.tempCache = tempCache;
    }
}

