/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.advancedcore.api.user;

import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.item.ItemBuilder;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.PlayerManager;
import com.bencodez.votingplugin.advancedcore.api.misc.effects.ActionBar;
import com.bencodez.votingplugin.advancedcore.api.misc.effects.BossBar;
import com.bencodez.votingplugin.advancedcore.api.misc.effects.Title;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardHandler;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.UserData;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.UserDataCache;
import com.bencodez.votingplugin.advancedcore.api.valuerequest.InputMethod;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.player.PlayerUtils;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AdvancedCoreUser {
    private boolean cacheData = true;
    private UserData data;
    private boolean loadName = true;
    private String playerName;
    private AdvancedCorePlugin plugin = null;
    private boolean tempCache = false;
    private String uuid;
    private boolean waitForCache = true;

    public AdvancedCoreUser(AdvancedCorePlugin plugin, AdvancedCoreUser user) {
        this.waitForCache = user.waitForCache;
        this.cacheData = user.cacheData;
        this.tempCache = user.tempCache;
        this.data = user.getUserData();
        this.uuid = user.getUUID();
        this.playerName = user.getPlayerName();
        this.loadName = user.loadName;
        this.plugin = plugin;
        this.loadData();
        this.getUserData().setTempCache(user.getUserData().getTempCache());
    }

    @Deprecated
    public AdvancedCoreUser(AdvancedCorePlugin plugin, Player player) {
        this.plugin = plugin;
        this.loadData();
        this.uuid = player.getUniqueId().toString();
        this.setPlayerName(player.getName());
    }

    @Deprecated
    public AdvancedCoreUser(AdvancedCorePlugin plugin, String playerName) {
        this.plugin = plugin;
        this.loadData();
        this.uuid = PlayerManager.getInstance().getUUID(playerName);
        this.setPlayerName(playerName);
    }

    @Deprecated
    public AdvancedCoreUser(AdvancedCorePlugin plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid.toString();
        this.loadData();
        this.setPlayerName(PlayerManager.getInstance().getPlayerName(this, this.uuid, false));
    }

    @Deprecated
    public AdvancedCoreUser(AdvancedCorePlugin plugin, UUID uuid, boolean loadName) {
        this.plugin = plugin;
        this.uuid = uuid.toString();
        this.loadName = loadName;
        this.loadData();
        if (this.loadName) {
            this.setPlayerName(PlayerManager.getInstance().getPlayerName(this, this.uuid));
        }
    }

    @Deprecated
    public AdvancedCoreUser(AdvancedCorePlugin plugin, UUID uuid, boolean loadName, boolean loadData) {
        this.plugin = plugin;
        this.uuid = uuid.toString();
        this.loadName = loadName;
        if (loadData) {
            this.loadData();
        }
        if (this.loadName) {
            this.setPlayerName(PlayerManager.getInstance().getPlayerName(this, this.uuid));
        }
    }

    @Deprecated
    public AdvancedCoreUser(AdvancedCorePlugin plugin, UUID uuid, String playerName) {
        this.plugin = plugin;
        this.uuid = uuid.toString();
        if (!plugin.getOptions().isOnlineMode()) {
            this.uuid = PlayerManager.getInstance().getUUID(playerName);
        }
        this.loadData();
        this.setPlayerName(playerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOfflineRewards(Reward reward, HashMap<String, String> placeholders) {
        AdvancedCorePlugin advancedCorePlugin = this.plugin;
        synchronized (advancedCorePlugin) {
            ArrayList<String> offlineRewards = this.getOfflineRewards();
            offlineRewards.add(reward.getRewardName() + "%placeholders%" + ArrayUtils.makeString(placeholders));
            this.setOfflineRewards(offlineRewards);
        }
    }

    public void addPermission(String permission) {
        this.plugin.getPermissionHandler().addPermission(this.getPlayer(), permission);
    }

    public void addPermission(String permission, long delay) {
        this.plugin.getPermissionHandler().addPermission(this.getPlayer(), permission, delay);
    }

    public synchronized void addTimedReward(Reward reward, HashMap<String, String> placeholders, long epochMilli) {
        HashMap<String, Long> timed = this.getTimedRewards();
        String rewardName = reward.getRewardName();
        rewardName = rewardName + "%extime%" + System.currentTimeMillis();
        timed.put(rewardName + "%placeholders%" + ArrayUtils.makeString(placeholders), epochMilli);
        this.setTimedRewards(timed);
        this.loadTimedDelayedTimer(epochMilli);
    }

    public void addUnClaimedChoiceReward(String name) {
        ArrayList<String> choices = this.getUnClaimedChoices();
        choices.add(name);
        this.setUnClaimedChoice(choices);
    }

    public void cache() {
        this.plugin.getUserManager().getDataManager().cacheUser(UUID.fromString(this.uuid), this.getPlayerName());
    }

    public void cacheAsync() {
        this.getPlugin().getBukkitScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                AdvancedCoreUser.this.cache();
            }
        });
    }

    public AdvancedCoreUser cacheData() {
        this.cacheData = true;
        return this;
    }

    public void cacheIfNeeded() {
        this.plugin.getUserManager().getDataManager().cacheUserIfNeeded(UUID.fromString(this.uuid));
    }

    public void checkDelayedTimedRewards() {
        this.plugin.debug("Checking timed/delayed for " + this.getPlayerName());
        HashMap<String, Long> timed = this.getTimedRewards();
        HashMap<String, Long> newTimed = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : timed.entrySet()) {
            long time = entry.getValue();
            if (time == 0L) continue;
            Date timeDate = new Date(time);
            if (new Date().after(timeDate)) {
                String[] data = entry.getKey().split("%placeholders%");
                String rewardName = data[0];
                rewardName = rewardName.split("%extime%")[0];
                String placeholders = "";
                if (data.length > 1) {
                    placeholders = data[1];
                }
                new RewardBuilder(this.plugin.getRewardHandler().getReward(rewardName)).setCheckTimed(false).withPlaceHolder(ArrayUtils.fromString(placeholders)).withPlaceHolder("date", "" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm").format(new Date(time))).send(this);
                this.plugin.debug("Giving timed/delayed reward " + rewardName + " for " + this.getPlayerName() + " with placeholders " + ArrayUtils.fromString(placeholders));
                continue;
            }
            newTimed.put(entry.getKey(), time);
        }
        this.setTimedRewards(newTimed);
    }

    public void checkOfflineRewards() {
        ArrayList<String> rewards;
        if (!this.plugin.getOptions().isProcessRewards()) {
            this.plugin.debug("Processing rewards is disabled");
            return;
        }
        if (this.isCheckWorld()) {
            this.setCheckWorld(false);
        }
        if ((rewards = this.getOfflineRewards()).isEmpty()) {
            return;
        }
        this.setOfflineRewards(new ArrayList<String>());
        RewardHandler rewardHandler = this.plugin.getRewardHandler();
        AdvancedCoreUser user = this;
        for (String rewardEntry : rewards) {
            if (rewardEntry == null || rewardEntry.equals("null")) continue;
            String[] parts = rewardEntry.split("%placeholders%", 2);
            String rewardName = parts[0];
            String placeholderStr = parts.length > 1 ? parts[1] : "";
            RewardOptions options = new RewardOptions().setOnline(false).setGiveOffline(false).forceOffline().setCheckTimed(false).withPlaceHolder(ArrayUtils.fromString(placeholderStr));
            rewardHandler.giveReward(user, rewardName, options);
        }
    }

    public void clearCache() {
        if (this.isCached()) {
            this.getCache().clearCache();
        }
    }

    public void clearTempCache() {
        this.getUserData().clearTempCache();
    }

    public void closeInv() {
        if (this.plugin.isEnabled()) {
            this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Player player = AdvancedCoreUser.this.getPlayer();
                    if (player != null) {
                        player.closeInventory();
                    }
                }
            }, (Entity)this.getPlayer());
        }
    }

    public AdvancedCoreUser dontCache() {
        this.cacheData = false;
        return this;
    }

    public void forceRunOfflineRewards() {
        if (!this.plugin.getOptions().isProcessRewards()) {
            this.plugin.debug("Processing rewards is disabled");
            return;
        }
        this.setCheckWorld(false);
        ArrayList<String> rewards = this.getOfflineRewards();
        if (rewards.isEmpty()) {
            return;
        }
        this.setOfflineRewards(new ArrayList<String>());
        RewardHandler rewardHandler = this.plugin.getRewardHandler();
        AdvancedCoreUser user = this;
        for (String rewardEntry : rewards) {
            if (rewardEntry == null || rewardEntry.equals("null")) continue;
            String[] parts = rewardEntry.split("%placeholders%", 2);
            String rewardName = parts[0];
            String placeholderStr = parts.length > 1 ? parts[1] : "";
            RewardOptions options = new RewardOptions().setOnline(false).setGiveOffline(false).forceOffline().setCheckTimed(false).withPlaceHolder(ArrayUtils.fromString(placeholderStr));
            rewardHandler.giveReward(user, rewardName, options);
        }
    }

    public UserDataCache getCache() {
        return this.plugin.getUserManager().getDataManager().getCache(UUID.fromString(this.getUUID()));
    }

    public String getChoicePreference(String rewardName) {
        ArrayList<String> data = this.getChoicePreferenceData();
        for (String str : data) {
            String[] data1 = str.split(":");
            if (data1.length <= 1 || !data1[0].equals(rewardName)) continue;
            return data1[1];
        }
        return "";
    }

    public ArrayList<String> getChoicePreferenceData() {
        return this.getData().getStringList("ChoicePreference", this.cacheData, this.waitForCache);
    }

    public UserData getData() {
        if (this.data == null) {
            this.loadData();
        }
        return this.data;
    }

    public String getInputMethod() {
        return this.getUserData().getString("InputMethod", this.cacheData, this.waitForCache);
    }

    public UUID getJavaUUID() {
        return UUID.fromString(this.uuid);
    }

    public long getLastOnline() {
        String d = this.getData().getString("LastOnline", this.cacheData, this.waitForCache);
        long time = 0L;
        if (d != null && !d.equals("") && !d.equals("null")) {
            time = Long.valueOf(d);
        }
        if (time == 0L && (time = this.getOfflinePlayer().getLastPlayed()) > 0L) {
            this.setLastOnline(time);
        }
        return time;
    }

    public int getNumberOfDaysSinceLogin() {
        long time = this.getLastOnline();
        if (time > 0L) {
            LocalDateTime online = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
            LocalDateTime now = LocalDateTime.now();
            Duration dur = Duration.between(online, now);
            return (int)dur.toDays();
        }
        return -1;
    }

    public OfflinePlayer getOfflinePlayer() {
        if (this.uuid != null && !this.uuid.equals("")) {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.uuid));
        }
        return null;
    }

    public ArrayList<String> getOfflineRewards() {
        return this.getUserData().getStringList(this.plugin.getUserManager().getOfflineRewardsPath(), this.cacheData, this.waitForCache);
    }

    public Player getPlayer() {
        if (this.uuid != null && !this.uuid.isEmpty()) {
            return Bukkit.getPlayer((UUID)UUID.fromString(this.uuid));
        }
        return null;
    }

    public ItemStack getPlayerHead() {
        return PlayerManager.getInstance().getPlayerSkull(this.getJavaUUID(), this.getPlayerName(), false);
    }

    public String getPlayerName() {
        if (this.playerName != null) {
            return this.playerName;
        }
        if (this.isTempCache()) {
            return this.getUserData().getString("PlayerName", false, false);
        }
        return "";
    }

    public int getRepeatAmount(Reward reward) {
        return this.getData().getInt("Repeat" + reward.getName(), this.cacheData, this.waitForCache);
    }

    public HashMap<String, Long> getTimedRewards() {
        ArrayList<String> timedReward = this.getUserData().getStringList("TimedRewards", this.cacheData, this.waitForCache);
        HashMap<String, Long> timedRewards = new HashMap<String, Long>();
        for (String str : timedReward) {
            if (str == null || str.equals("null")) continue;
            String[] data = str.split("%ExecutionTime/%");
            this.plugin.extraDebug("TimedReward: " + str);
            if (data.length <= 1) continue;
            String name = data[0];
            String timeStr = data[1];
            timedRewards.put(name, Long.valueOf(timeStr));
        }
        return timedRewards;
    }

    public ArrayList<String> getUnClaimedChoices() {
        return this.getData().getStringList("UnClaimedChoices", this.cacheData, this.waitForCache);
    }

    public UserData getUserData() {
        if (this.data == null) {
            this.loadData();
        }
        return this.data;
    }

    public InputMethod getUserInputMethod() {
        String inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            return InputMethod.getMethod(this.plugin.getOptions().getDefaultRequestMethod());
        }
        return InputMethod.getMethod(inputMethod);
    }

    public String getUUID() {
        return this.uuid;
    }

    public void giveExp(int exp) {
        Player player = this.getPlayer();
        if (player != null) {
            player.giveExp(exp);
        }
    }

    public void giveExpLevels(int num) {
        Player p = this.getPlayer();
        if (p != null) {
            p.setLevel(p.getLevel() + num);
        }
    }

    public void giveItem(ItemBuilder builder) {
        this.giveItem(builder.toItemStack(this.getPlayer()));
    }

    public void giveItem(final ItemStack item) {
        if (item == null || item.getAmount() == 0) {
            return;
        }
        final Player player = this.getPlayer();
        if (this.plugin.isEnabled()) {
            this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (player != null) {
                        AdvancedCoreUser.this.plugin.getFullInventoryHandler().giveItem(player, item);
                    }
                }
            }, (Entity)player);
        }
    }

    public void giveItem(ItemStack itemStack, HashMap<String, String> placeholders) {
        this.giveItem(new ItemBuilder(itemStack).setPlaceholders(placeholders).toItemStack(this.getPlayer()));
    }

    public void giveItems(final ItemStack ... item) {
        if (item == null) {
            return;
        }
        final Player player = this.getPlayer();
        if (this.plugin.isEnabled()) {
            this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (player != null) {
                        AdvancedCoreUser.this.plugin.getFullInventoryHandler().giveItem(player, item);
                    }
                }
            }, (Entity)player);
        }
    }

    public void giveMoney(double m) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (this.plugin.getVaultHandler() != null && this.plugin.getVaultHandler().getEcon() != null) {
            try {
                if (m > 0.0) {
                    final double money = m;
                    this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            AdvancedCoreUser.this.plugin.getVaultHandler().getEcon().depositPlayer(AdvancedCoreUser.this.getOfflinePlayer(), money);
                        }
                    });
                } else if (m < 0.0) {
                    final double money = m *= -1.0;
                    this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            AdvancedCoreUser.this.plugin.getVaultHandler().getEcon().withdrawPlayer(AdvancedCoreUser.this.getOfflinePlayer(), money);
                        }
                    });
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    public void giveMoney(int money) {
        this.giveMoney((double)money);
    }

    public void givePotionEffect(final String potionName, final int duration, final int amplifier) {
        final Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.getUUID()));
        if (player != null && this.plugin.isEnabled()) {
            this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)potionName), 20 * duration, amplifier));
                }
            }, (Entity)player);
        }
    }

    public void giveReward(FileConfiguration data, String path, RewardOptions rewardOptions) {
        this.plugin.getRewardHandler().giveReward(this, (ConfigurationSection)data, path, rewardOptions);
    }

    public void giveReward(Reward reward, RewardOptions rewardOptions) {
        reward.giveReward(this, rewardOptions);
    }

    public boolean hasChoices() {
        return this.getUnClaimedChoices().size() > 0;
    }

    public boolean hasLoggedOnBefore() {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.uuid));
        if (player != null && (player.hasPlayedBefore() || player.isOnline())) {
            return true;
        }
        ArrayList<String> uuids = this.plugin.getUserManager().getAllUUIDs();
        return uuids.contains(this.getUUID());
    }

    public boolean hasPermission(String perm) {
        Player player = this.getPlayer();
        if (!this.plugin.getOptions().isOnlineMode() && player == null) {
            player = Bukkit.getPlayer((String)this.getPlayerName());
        }
        if (player == null) {
            this.plugin.debug("Unable to get player for " + this.getPlayerName() + "/" + this.getUUID());
            return false;
        }
        if (perm.startsWith("!")) {
            return !player.hasPermission(perm = perm.substring(1));
        }
        return player.hasPermission(perm);
    }

    public boolean isBanned() {
        return this.plugin.getBannedPlayers().contains(this.getUUID());
    }

    public boolean isBedrockUser() {
        return this.getData().getBoolean("isBedrock", this.cacheData, this.waitForCache);
    }

    public void setBedrockUser(boolean isBedrock) {
        this.getData().setBoolean("isBedrock", isBedrock);
    }

    public boolean isCached() {
        return this.plugin.getUserManager().getDataManager().isCached(UUID.fromString(this.uuid));
    }

    public boolean isCheckWorld() {
        if (!this.plugin.isLoadUserData()) {
            return false;
        }
        return Boolean.valueOf(this.getData().getString("CheckWorld", true));
    }

    public boolean isInWorld(ArrayList<String> worlds) {
        Player p = this.getPlayer();
        if (p != null) {
            for (String world : worlds) {
                if (!p.getWorld().getName().equalsIgnoreCase(world)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInWorld(String world) {
        Player p = this.getPlayer();
        if (p != null) {
            return p.getWorld().getName().equalsIgnoreCase(world);
        }
        return false;
    }

    public boolean isOnline() {
        boolean online = PlayerUtils.isPlayerOnline(this.getPlayerName());
        if (!online) {
            return false;
        }
        return !this.plugin.getOptions().isTreatVanishAsOffline() || !this.isVanished();
    }

    public boolean isVanished() {
        Player player = this.getPlayer();
        if (player != null) {
            for (MetadataValue meta : player.getMetadata("vanished")) {
                if (!meta.asBoolean()) continue;
                return true;
            }
            try {
                try {
                    if (this.plugin.getCmiHandle() != null) {
                        return this.plugin.getCmiHandle().isVanished(player);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.plugin.debug(e);
            }
        }
        return false;
    }

    public void loadCache() {
        this.plugin.getUserManager().getDataManager().cacheUser(UUID.fromString(this.uuid), this.getPlayerName());
    }

    public void loadData() {
        this.data = new UserData(this);
    }

    public void loadTimedDelayedTimer(long time) {
        long delay = time - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        this.plugin.getRewardHandler().getDelayedTimer().schedule(new Runnable(){

            @Override
            public void run() {
                AdvancedCoreUser.this.checkDelayedTimedRewards();
            }
        }, delay += 500L, TimeUnit.MILLISECONDS);
    }

    public void playEffect(String effectName, int data, int particles, int radius) {
        Player player = this.getPlayer();
        if (player != null && effectName != null) {
            try {
                Effect effect = Effect.valueOf((String)effectName);
                for (int i = 0; i < particles; ++i) {
                    player.getWorld().playEffect(player.getLocation(), effect, data, radius);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playParticle(String effectName, int data, int particles, int radius) {
        Player player = this.getPlayer();
        if (player != null && effectName != null) {
            try {
                Particle effect = Particle.valueOf((String)effectName);
                for (int i = 0; i < particles; ++i) {
                    player.getWorld().spawnParticle(effect, player.getLocation(), particles, (double)radius, (double)radius, (double)radius, (double)data);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to create particle: " + effectName + ", " + data + ", " + particles + ", " + radius);
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public void playParticleEffect(String effectName, int data, int particles, int radius) {
        this.playParticle(effectName, data, particles, radius);
    }

    public void playSound(String soundName, float volume, float pitch) {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.uuid));
        if (player != null) {
            Sound sound = null;
            try {
                sound = (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)soundName));
            }
            catch (Exception e) {
                this.plugin.debug(e);
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, volume, pitch);
            } else {
                this.plugin.debug("Invalid sound: " + soundName);
            }
        }
    }

    public void preformCommand(ArrayList<String> commands, HashMap<String, String> placeholders) {
        if (commands != null && !commands.isEmpty()) {
            ArrayList<String> cmds = PlaceholderUtils.replaceJavascript(this.getPlayer(), PlaceholderUtils.replacePlaceHolder(commands, placeholders));
            final Player player = this.getPlayer();
            if (player != null && this.plugin.isEnabled()) {
                for (final String cmd : cmds) {
                    this.plugin.debug("Executing player command for " + this.getPlayerName() + ": " + cmd);
                    this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            player.chat("/" + cmd);
                        }
                    });
                }
            }
        }
    }

    public void preformCommand(String command, HashMap<String, String> placeholders) {
        if (command != null && !command.isEmpty()) {
            final String cmd = PlaceholderUtils.replaceJavascript(this.getPlayer(), PlaceholderUtils.replacePlaceHolder(command, placeholders));
            this.plugin.debug("Executing player command for " + this.getPlayerName() + ": " + command);
            if (this.plugin.isEnabled()) {
                this.getPlugin().getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Player player = AdvancedCoreUser.this.getPlayer();
                        if (player != null) {
                            player.chat("/" + cmd);
                        }
                    }
                });
            }
        }
    }

    public void remove() {
        this.plugin.debug("Removing " + this.getUUID() + " (" + this.getPlayerName() + ") from storage...");
        this.getData().remove();
    }

    public void removePermission(String permission) {
        this.plugin.getPermissionHandler().removePermission(UUID.fromString(this.getUUID()), this.getPlayerName(), permission);
    }

    public void removeUnClaimedChoiceReward(String name) {
        ArrayList<String> choices = this.getUnClaimedChoices();
        choices.remove(name);
        this.setUnClaimedChoice(choices);
    }

    public void sendActionBar(String msg, int delay) {
        Player player;
        if (msg != null && msg != "" && (player = this.getPlayer()) != null) {
            try {
                ActionBar actionBar = new ActionBar(PlaceholderUtils.replaceJavascript(this.getPlayer(), msg), delay);
                actionBar.send(player);
            }
            catch (Exception ex) {
                this.plugin.debug("Failed to send ActionBar, turn debug on to see stack trace");
                this.plugin.debug(ex);
            }
        }
    }

    public void sendBossBar(String msg, String color, String style, double progress, int delay) {
        Player player;
        if (msg != null && msg != "" && (player = this.getPlayer()) != null) {
            try {
                BossBar bossBar = new BossBar(PlaceholderUtils.replaceJavascript(this.getPlayer(), msg), color, style, progress);
                bossBar.send(player, delay);
            }
            catch (Exception ex) {
                this.plugin.debug("Failed to send BossBar");
                this.plugin.debug(ex);
            }
        }
    }

    public void sendJson(ArrayList<TextComponent> messages) {
        this.sendJson(messages, true);
    }

    public void sendJson(ArrayList<TextComponent> messages, boolean javascript) {
        Player player = this.getPlayer();
        if (player != null && messages != null) {
            ArrayList<BaseComponent> texts = new ArrayList<BaseComponent>();
            TextComponent newLine = new TextComponent(ComponentSerializer.parse((String)"{text: \"\n\"}"));
            for (int i = 0; i < messages.size(); ++i) {
                TextComponent txt = messages.get(i);
                if (javascript) {
                    txt.setText(PlaceholderUtils.replaceJavascript(this.getPlayer(), txt.getText()));
                }
                texts.add((BaseComponent)txt);
                if (i + 1 >= messages.size()) continue;
                texts.add((BaseComponent)newLine);
            }
            PlayerUtils.getServerHandle().sendMessage(player, ArrayUtils.convertBaseComponent(texts));
        }
    }

    public void sendJson(TextComponent message) {
        Player player = this.getPlayer();
        if (player != null && message != null) {
            message.setText(PlaceholderUtils.replaceJavascript(this.getPlayer(), message.getText()));
            PlayerUtils.getServerHandle().sendMessage(player, (BaseComponent)message);
        }
    }

    public void sendMessage(ArrayList<String> msg) {
        this.sendMessage(ArrayUtils.convert(msg));
    }

    public void sendMessage(ArrayList<String> msg, HashMap<String, String> placeholders) {
        this.sendMessage(ArrayUtils.convert(PlaceholderUtils.replacePlaceHolder(msg, placeholders)));
    }

    public void sendMessage(String msg) {
        Player player = this.getPlayer();
        if (player != null && msg != null && !msg.equals("")) {
            for (String str : msg.split("%NewLine%")) {
                PlayerUtils.getServerHandle().sendMessage(player, (BaseComponent)PlaceholderUtils.parseJson(PlaceholderUtils.parseText(player, str)));
            }
        }
    }

    public void sendMessage(String msg, HashMap<String, String> placeholders) {
        this.sendMessage(PlaceholderUtils.replacePlaceHolder(msg, placeholders));
    }

    public void sendMessage(String msg, String toReplace, String replace) {
        this.sendMessage(PlaceholderUtils.replacePlaceHolder(msg, toReplace, replace));
    }

    public void sendMessage(String[] msg) {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.uuid));
        if (player != null && msg != null) {
            ArrayList<TextComponent> texts = new ArrayList<TextComponent>();
            for (String str : msg) {
                if (player == null || msg == null || str.equals("")) continue;
                for (String str1 : str.split("%NewLine%")) {
                    TextComponent text = PlaceholderUtils.parseJson(PlaceholderUtils.parseText(player, str1));
                    text.setText(PlaceholderUtils.replaceJavascript(this.getPlayer(), text.getText()));
                    texts.add(text);
                }
            }
            if (texts.size() > 0) {
                this.sendJson(texts, false);
            }
        }
    }

    public void sendTitle(String title, String subTitle, int fadeIn, int showTime, int fadeOut) {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.uuid));
        if (player != null) {
            try {
                Title titleObject = new Title(PlaceholderUtils.replaceJavascript(this.getPlayer(), title), PlaceholderUtils.replaceJavascript(this.getPlayer(), subTitle), fadeIn, showTime, fadeOut);
                titleObject.send(player);
            }
            catch (Exception ex) {
                this.plugin.getLogger().info("Failed to send Title, turn debug on to see stack trace");
                this.plugin.debug(ex);
            }
        }
    }

    public void setCheckWorld(boolean b) {
        this.getData().setString("CheckWorld", "" + b);
    }

    public void setChoicePreference(String reward, String preference) {
        ArrayList<String> data = this.getChoicePreferenceData();
        ArrayList<String> choices = new ArrayList<String>();
        boolean added = false;
        for (String str : data) {
            String[] data1 = str.split(":");
            if (data1.length <= 1) continue;
            if (data1[0].equals(reward)) {
                choices.add(reward + ":" + preference);
                added = true;
                continue;
            }
            choices.add(str);
        }
        if (!added) {
            choices.add(reward + ":" + preference);
        }
        this.getData().setStringList("ChoicePreference", choices);
    }

    public void setInputMethod(String inputMethod) {
        this.data.setString("InputMethod", inputMethod);
    }

    public void setLastOnline(long online) {
        this.getData().setString("LastOnline", "" + online);
    }

    public void setOfflineRewards(ArrayList<String> offlineRewards) {
        int maxLength = 65535;
        String str = String.join((CharSequence)"%line%", offlineRewards);
        while (str.getBytes().length > maxLength && !offlineRewards.isEmpty()) {
            offlineRewards.remove(0);
            str = String.join((CharSequence)"%line%", offlineRewards);
        }
        this.data.setStringList(this.plugin.getUserManager().getOfflineRewardsPath(), offlineRewards);
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public void setRepeatAmount(Reward reward, int amount) {
        this.getData().setInt("Repeat" + reward.getName(), amount);
    }

    public void setTimedRewards(HashMap<String, Long> timed) {
        ArrayList<String> timedRewards = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : timed.entrySet()) {
            String str = "";
            str = str + entry.getKey() + "%ExecutionTime/%";
            str = str + entry.getValue();
            timedRewards.add(str);
        }
        this.data.setStringList("TimedRewards", timedRewards);
    }

    public void setUnClaimedChoice(ArrayList<String> rewards) {
        this.getData().setStringList("UnClaimedChoices", rewards);
    }

    public void setUserInputMethod(InputMethod method) {
        this.setInputMethod(method.toString());
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setWaitForCache(boolean b) {
        this.waitForCache = b;
    }

    public AdvancedCoreUser tempCache() {
        this.tempCache = true;
        this.getUserData().tempCache();
        return this;
    }

    public void updateName(boolean force) {
        String playerName;
        if (!(!this.getData().hasData() && !force || (playerName = this.getData().getString("PlayerName", true)) != null && playerName.equals(this.getPlayerName()))) {
            this.getData().setString("PlayerName", this.getPlayerName(), true);
        }
    }

    public void updateTempCacheWithColumns(ArrayList<Column> cols) {
        this.tempCache = true;
        this.getUserData().updateTempCacheWithColumns(cols);
    }

    @Generated
    public boolean isCacheData() {
        return this.cacheData;
    }

    @Generated
    public void setData(UserData data) {
        this.data = data;
    }

    @Generated
    public AdvancedCorePlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public boolean isTempCache() {
        return this.tempCache;
    }

    @Generated
    public boolean isWaitForCache() {
        return this.waitForCache;
    }
}

